/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.declare.service.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.declare.dto.DclRecordDTO;
import kd.sit.hcsi.business.declare.helper.DclRecordHelper;
import kd.sit.hcsi.business.declare.service.type.IDclRecordType;
import kd.sit.sitbp.common.entity.declare.DclRecordCalDTO;
import kd.sit.sitbp.common.util.SITDateTimeUtils;

public class DclRecordValidator
implements Serializable {
    private static final long serialVersionUID = 1684357835423287450L;
    private static final Log log = LogFactory.getLog(DclRecordValidator.class);
    private IDclRecordType iDclRecordType;

    public DclRecordValidator(IDclRecordType iDclRecordFactory) {
        this.iDclRecordType = iDclRecordFactory;
    }

    public void checkPeriodValid() {
        Set<Long> periodIds = this.iDclRecordType.getDclRecordDTOS().stream().map(DclRecordCalDTO::getCurrPeriodId).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<Long, DynamicObject> periodDyGrpByPkId = this.getEntityDyGroupByPkId("sitbs_sinsurperiod", periodIds);
        for (DclRecordDTO dclRecordDTO : this.iDclRecordType.getDclRecordDTOS()) {
            Long currPeriodId = dclRecordDTO.getCurrPeriodId();
            DynamicObject periodDy = periodDyGrpByPkId.get(currPeriodId);
            if (periodDy == null) {
                dclRecordDTO.getErrMsg().setPeriodMsg(HCSIErrInfoEnum.DCL_RECORD_PERIOD_NOT_EXISTS.getErrInfo());
                continue;
            }
            dclRecordDTO.setCurrPeriodDy(periodDy);
            dclRecordDTO.setPeriodEndDate(periodDy.getDate("enddate"));
            Date lastPeriodEndDate = SITDateTimeUtils.addDay((Date)periodDy.getDate("startdate"), (long)-1L);
            dclRecordDTO.setLastPeriodEndDate(lastPeriodEndDate);
        }
    }

    public void checkCompanyValid() {
        Set<Long> companyIds = this.iDclRecordType.getDclRecordDTOS().stream().map(DclRecordCalDTO::getCompanyId).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<Long, DynamicObject> companyDyGrpByPkId = this.getEntityDyGroupByPkId("sitbs_welfarepayer", companyIds);
        for (DclRecordDTO dclRecordDTO : this.iDclRecordType.getDclRecordDTOS()) {
            Long companyId = dclRecordDTO.getCompanyId();
            DynamicObject companyDy = companyDyGrpByPkId.get(companyId);
            if (companyDy == null) {
                dclRecordDTO.getErrMsg().setCompanyMsg(HCSIErrInfoEnum.DCL_RECORD_COMPANY_NOT_EXISTS.getErrInfo());
                continue;
            }
            dclRecordDTO.setCompanyDy(companyDy);
            dclRecordDTO.setOrgId(companyDy.getLong("org.id"));
            dclRecordDTO.setInsuredAreaId(companyDy.getLong("placeofwelfare.id"));
        }
    }

    public void checkCurrDclRuleValid() {
        List resDclRecordDTOs = this.iDclRecordType.getDclRecordDTOS().stream().filter(dclRecordDTO -> dclRecordDTO.getCompanyDy() != null).collect(Collectors.toList());
        for (DclRecordDTO dclRecordDTO2 : resDclRecordDTOs) {
            boolean isInvalid;
            DynamicObject companyDy = dclRecordDTO2.getCompanyDy();
            DynamicObject dclRuleDy = companyDy.getDynamicObject("sinsurdclrule");
            if (!this.iDclRecordType.isUpdateDclRecordList()) continue;
            boolean bl = isInvalid = dclRuleDy == null || !"C".equals(dclRuleDy.getString("status")) || !"1".equals(dclRuleDy.getString("enable")) || dclRuleDy.getLong("sourcevid") == 0L;
            if (isInvalid) {
                dclRecordDTO2.getErrMsg().setDclRuleMsg(HCSIErrInfoEnum.DCL_RECORD_DCL_RULE_NOT_EXISTS.getErrInfo(companyDy.getString("name")));
                continue;
            }
            dclRecordDTO2.setDclRecordRuleId(dclRuleDy.getLong("id"));
            dclRecordDTO2.setDclRecordRuleVId(dclRuleDy.getLong("sourcevid"));
        }
    }

    public void checkPeriodAndCompanyValid() {
        if (this.iDclRecordType.isUpdateDclPersonList()) {
            return;
        }
        List resDclRecordDTOs = this.iDclRecordType.getDclRecordDTOS().stream().filter(dclRecordDTO -> !dclRecordDTO.getErrMsg().isInvalid()).collect(Collectors.toList());
        HashSet<Long> periodIds = new HashSet<Long>(resDclRecordDTOs.size());
        HashSet<Long> companyIds = new HashSet<Long>(resDclRecordDTOs.size());
        for (DclRecordDTO resDclRecordDTO : resDclRecordDTOs) {
            periodIds.add(resDclRecordDTO.getCurrPeriodId());
            companyIds.add(resDclRecordDTO.getCompanyId());
        }
        QFilter filter = new QFilter("period.id", "in", periodIds);
        filter.and("insuredcompany.id", "in", companyIds);
        List<DynamicObject> dclRecordDys = DclRecordHelper.queryNormalDclRecordsByQFilter(filter);
        HashMap periodCompanyAndDclRuleBoIdMap = new HashMap(resDclRecordDTOs.size());
        for (DynamicObject dclRecordDy : dclRecordDys) {
            String periodAndCompany = dclRecordDy.getString("period.id") + "," + dclRecordDy.getString("insuredcompany.id");
            periodCompanyAndDclRuleBoIdMap.computeIfAbsent(periodAndCompany, key -> new HashSet(16)).add(dclRecordDy.getLong("sinsurdclrule.id"));
        }
        for (DclRecordDTO resDclRecordDTO : resDclRecordDTOs) {
            String key2 = resDclRecordDTO.getCurrPeriodId() + "," + resDclRecordDTO.getCompanyId();
            HashSet existedDclRuleIds = new HashSet(periodCompanyAndDclRuleBoIdMap.getOrDefault(key2, Collections.emptySet()));
            existedDclRuleIds.remove(resDclRecordDTO.getDclRecordRuleId());
            if (existedDclRuleIds.isEmpty()) continue;
            resDclRecordDTO.getErrMsg().setExistOtherDclRuleForSamePeriodAndCompanyMsg(HCSIErrInfoEnum.DCL_RECORD_EXIST_OTHER_DCL_RULE.getErrInfo(resDclRecordDTO.getCompanyDy().getString("name")));
        }
    }

    public void checkStdRefCompanyValid() {
        List dclRecordDTOs = this.iDclRecordType.getDclRecordDTOS().stream().filter(dclRecordDTO -> dclRecordDTO.getCompanyDy() != null && dclRecordDTO.getCurrPeriodDy() != null).collect(Collectors.toList());
        ArrayList<DynamicObject> periodDys = new ArrayList<DynamicObject>(10);
        HashSet<Long> companyIds = new HashSet<Long>(16);
        for (DclRecordDTO dclRecordDTO2 : this.iDclRecordType.getDclRecordDTOS()) {
            if (dclRecordDTO2.getCompanyDy() == null || dclRecordDTO2.getCurrPeriodDy() == null) continue;
            companyIds.add(dclRecordDTO2.getCompanyDy().getLong("id"));
            periodDys.add(dclRecordDTO2.getCurrPeriodDy());
        }
        HashMap<String, List<Long>> companyPeriodAndRefStdVIdsMap = new HashMap<String, List<Long>>(companyIds.size());
        HashMap<String, List<Long>> companyPeriodAndRefStdBoIdsMap = new HashMap<String, List<Long>>(companyIds.size());
        for (DynamicObject periodDy : periodDys) {
            Map<String, List<Long>> tmpCompanyPeriodAndRefStdBoIdsMap = this.getCompanyPeriodAndRefStdBoIdsMap(companyIds, periodDy);
            Map<String, List<Long>> tmpCompanyPeriodAndRefStdVIdsMap = this.getCompanyPeriodAndRefStdVIdsMap(tmpCompanyPeriodAndRefStdBoIdsMap, periodDy.getDate("enddate"));
            companyPeriodAndRefStdBoIdsMap.putAll(tmpCompanyPeriodAndRefStdBoIdsMap);
            companyPeriodAndRefStdVIdsMap.putAll(tmpCompanyPeriodAndRefStdVIdsMap);
        }
        for (DclRecordDTO dclRecordDTO3 : dclRecordDTOs) {
            String key = dclRecordDTO3.getCompanyId() + "," + dclRecordDTO3.getCurrPeriodId();
            List stdBoIds = companyPeriodAndRefStdBoIdsMap.getOrDefault(key, Collections.emptyList());
            List<Long> stdVIds = companyPeriodAndRefStdVIdsMap.getOrDefault(key, Collections.emptyList());
            if (stdBoIds.isEmpty() || stdVIds.isEmpty()) {
                dclRecordDTO3.getErrMsg().setStandardMsg(HCSIErrInfoEnum.DCL_RECORD_STANDARD_NOT_EXISTS.getErrInfo(dclRecordDTO3.getCompanyDy().getString("name")));
                continue;
            }
            dclRecordDTO3.setStandardVIds(stdVIds);
            dclRecordDTO3.setStandardBoIds(stdBoIds);
        }
    }

    private Map<String, List<Long>> getCompanyPeriodAndRefStdBoIdsMap(Set<Long> companyIds, DynamicObject periodDy) {
        HashMap<String, List<Long>> companyPeriodAndRefStdIdsMap = new HashMap<String, List<Long>>(companyIds.size());
        Date periodEndDate = periodDy.getDate("enddate");
        Map<Long, List<Long>> companyIdAndRefStdIdsMap = this.getStdIdOfRefCompanyId(companyIds, periodEndDate);
        for (Map.Entry<Long, List<Long>> entry : companyIdAndRefStdIdsMap.entrySet()) {
            List<Long> stdBoIds = entry.getValue();
            if (stdBoIds == null || stdBoIds.isEmpty()) continue;
            String companyPeriod = entry.getKey() + "," + periodDy.getLong("id");
            companyPeriodAndRefStdIdsMap.put(companyPeriod, stdBoIds);
        }
        return companyPeriodAndRefStdIdsMap;
    }

    private Map<String, List<Long>> getCompanyPeriodAndRefStdVIdsMap(Map<String, List<Long>> companyPeriodAndRefStdIdsMap, Date periodEndDate) {
        Set<Long> sumStdBoIds = companyPeriodAndRefStdIdsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        DynamicObject[] stdVDys = SocialInsuranceCalHelper.getStdVDys(sumStdBoIds, periodEndDate);
        Map<Object, Object> stdBoIdAndStdVIdMap = stdVDys == null || stdVDys.length == 0 ? Collections.emptyMap() : Arrays.stream(stdVDys).collect(Collectors.toMap(stdVDy -> stdVDy.getLong("boid"), stdVDy -> stdVDy.getLong("id"), (oldVal, newVal) -> oldVal));
        HashMap<String, List<Long>> companyPeriodAndRefStdVIdsMap = new HashMap<String, List<Long>>(companyPeriodAndRefStdIdsMap.size());
        for (Map.Entry<String, List<Long>> entry : companyPeriodAndRefStdIdsMap.entrySet()) {
            List<Long> stdIds = entry.getValue();
            if (stdIds == null || stdIds.isEmpty()) continue;
            stdIds.removeIf(stdId -> stdBoIdAndStdVIdMap.get(stdId) == null);
            List stdVIds = stdIds.stream().map(stdBoIdAndStdVIdMap::get).collect(Collectors.toList());
            if (stdIds.isEmpty()) continue;
            companyPeriodAndRefStdVIdsMap.put(entry.getKey(), stdVIds);
        }
        return companyPeriodAndRefStdVIdsMap;
    }

    private Map<Long, List<Long>> getStdIdOfRefCompanyId(Set<Long> companyIds, Date periodEndDate) {
        DynamicObject[] companyRefStdDys = SocialInsuranceCalHelper.getCompanyRefStdDy(companyIds, periodEndDate);
        if (companyRefStdDys == null || companyRefStdDys.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(companyRefStdDys).collect(Collectors.toMap(companyRefStdDy -> companyRefStdDy.getLong("welfarepayer.id"), companyRefStdDy -> companyRefStdDy.getDynamicObjectCollection("mulsinsurstd").stream().map(baseData -> baseData.getLong("fbasedataid.id")).collect(Collectors.toList()), (oldVal, newVal) -> oldVal));
    }

    public void checkDclRecordExists() {
        List<DclRecordDTO> resDclRecordDTOs = this.iDclRecordType.getDclRecordDTOS().stream().filter(dclRecordDTO -> !dclRecordDTO.getErrMsg().isInvalid()).collect(Collectors.toList());
        this.rePackageRecordDTOs(resDclRecordDTOs);
        Map<String, DynamicObject> dclRecordDyGroupByIndexKey = this.getExistsDclRecords(resDclRecordDTOs);
        long[] newDclRecordIds = new long[]{};
        if (dclRecordDyGroupByIndexKey.size() < resDclRecordDTOs.size()) {
            newDclRecordIds = DB.genLongIds((String)"hcsi_dclrecord", (int)resDclRecordDTOs.size());
        }
        int index = 0;
        for (DclRecordDTO resDclRecordDTO : resDclRecordDTOs) {
            String indexKey = resDclRecordDTO.getCurrPeriodId() + "," + resDclRecordDTO.getCompanyId() + "," + resDclRecordDTO.getDclRecordRuleId() + "," + resDclRecordDTO.getDclBizName();
            DynamicObject dclRecordDy = dclRecordDyGroupByIndexKey.get(indexKey);
            if (dclRecordDy != null) {
                boolean isInvalid = dclRecordDy.getBoolean("lockstatus");
                if (isInvalid) {
                    if (this.iDclRecordType.isUpdateDclPersonList()) {
                        resDclRecordDTO.getErrMsg().setDclRecordMsg(HCSIErrInfoEnum.DCL_PERSON_IS_LOCKED_OR_ABANDONMENT.getErrInfo());
                        continue;
                    }
                    resDclRecordDTO.getErrMsg().setDclRecordMsg(HCSIErrInfoEnum.DCL_RECORD_IS_LOCKED.getErrInfo(resDclRecordDTO.getCompanyDy().getString("name")));
                    continue;
                }
                resDclRecordDTO.setDclRecordDy(dclRecordDy);
                resDclRecordDTO.setUpdate(Boolean.TRUE);
                resDclRecordDTO.setDclRecordId(dclRecordDy.getLong("id"));
                this.iDclRecordType.setDclRecordExists(true);
                continue;
            }
            if (newDclRecordIds.length <= 0) continue;
            resDclRecordDTO.setDclRecordId(newDclRecordIds[index++]);
        }
    }

    private void rePackageRecordDTOs(List<DclRecordDTO> resDclRecordDTOs) {
        Set<Long> dclRuleVIds = resDclRecordDTOs.stream().map(DclRecordCalDTO::getDclRecordRuleVId).collect(Collectors.toSet());
        List<DynamicObject> dclRuleVDys = DclRecordHelper.queryEntityDy("hcsi_sinsurdclrule", dclRuleVIds, false);
        Map<Long, DynamicObject> dclRuleVDyGrpByBoId = dclRuleVDys.stream().collect(Collectors.toMap(dclRuleVDy -> dclRuleVDy.getLong("boid"), dclRuleVDy -> dclRuleVDy, (oldVal, newVal) -> oldVal));
        ArrayList<DclRecordDTO> tmpDclRecordDTOs = new ArrayList<DclRecordDTO>(resDclRecordDTOs.size());
        for (DclRecordDTO dclRecordDTO : resDclRecordDTOs) {
            DynamicObject dclRuleVDy2 = dclRuleVDyGrpByBoId.get(dclRecordDTO.getDclRecordRuleId());
            if (dclRuleVDy2 == null || dclRuleVDy2.getDynamicObjectCollection("entryentity").size() == 0) continue;
            DynamicObjectCollection entryEntity = dclRuleVDy2.getDynamicObjectCollection("entryentity");
            int index = 0;
            boolean dclRuleVIdValid = false;
            for (DynamicObject entryDy : entryEntity) {
                String dclBizName = entryDy.getString("dclbusinessname");
                if (dclBizName == null || dclBizName.trim().length() == 0) continue;
                DclRecordDTO tmpDclRecordDTO = dclRecordDTO;
                if (this.iDclRecordType.isUpdateDclRecordList() && index > 0) {
                    tmpDclRecordDTO = dclRecordDTO.clone();
                    this.iDclRecordType.getDclRecordDTOS().add(tmpDclRecordDTO);
                }
                dclBizName = dclBizName.trim();
                if (this.iDclRecordType.isUpdateDclPersonList() && !dclBizName.equals(tmpDclRecordDTO.getDclBizName())) continue;
                dclRuleVIdValid = true;
                tmpDclRecordDTO.setDclBizName(dclBizName);
                tmpDclRecordDTO.setModifyType(entryDy.getString("modifytype"));
                tmpDclRecordDTO.setHasInsurType("1".equals(entryDy.getString("haswelfaretype")));
                List insurTypeIds = entryDy.getDynamicObjectCollection("welfaretypemul").stream().map(type -> type.getLong("fbasedataid.id")).collect(Collectors.toList());
                tmpDclRecordDTO.setInsurTypes(insurTypeIds);
                tmpDclRecordDTO.setDclDisplayScmId(entryDy.getLong("dcldisplayscm.id"));
                tmpDclRecordDTO.setDclDisplayScmVId(entryDy.getLong("dcldisplayscm.sourcevid"));
                tmpDclRecordDTOs.add(tmpDclRecordDTO);
                ++index;
            }
            if (dclRuleVIdValid || !this.iDclRecordType.isUpdateDclPersonList()) continue;
            dclRecordDTO.getErrMsg().setDclPersonRuleVIdInvalidMsg(HCSIErrInfoEnum.DCL_PERSON_RULE_VERSION_INVALID.getErrInfo());
        }
        resDclRecordDTOs.clear();
        resDclRecordDTOs.addAll(tmpDclRecordDTOs);
    }

    private Map<String, DynamicObject> getExistsDclRecords(List<DclRecordDTO> resDclRecordDTOs) {
        if (resDclRecordDTOs.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet<Long> periodIds = new HashSet<Long>(resDclRecordDTOs.size());
        HashSet<Long> companyIds = new HashSet<Long>(resDclRecordDTOs.size());
        HashSet<Long> dclRuleIds = new HashSet<Long>(resDclRecordDTOs.size());
        HashSet<String> dclRuleBizNames = new HashSet<String>(resDclRecordDTOs.size());
        for (DclRecordDTO resDclRecordDTO : resDclRecordDTOs) {
            periodIds.add(resDclRecordDTO.getCurrPeriodId());
            companyIds.add(resDclRecordDTO.getCompanyId());
            dclRuleIds.add(resDclRecordDTO.getDclRecordRuleId());
            dclRuleBizNames.add(resDclRecordDTO.getDclBizName());
        }
        QFilter filter = new QFilter("period.id", "in", periodIds);
        filter.and("insuredcompany.id", "in", companyIds);
        filter.and("sinsurdclrule.id", "in", dclRuleIds);
        filter.and("dclbusinessname", "in", dclRuleBizNames);
        List<DynamicObject> dclRecordDys = DclRecordHelper.queryNormalDclRecordsByQFilter(filter);
        HashMap<String, DynamicObject> dclRecordDyGroupByIndexKey = new HashMap<String, DynamicObject>(dclRecordDys.size());
        for (DynamicObject dclRecordDy : dclRecordDys) {
            StringJoiner indexKey = new StringJoiner(",");
            indexKey.add(dclRecordDy.getString("period.id")).add(dclRecordDy.getString("insuredcompany.id")).add(dclRecordDy.getString("sinsurdclrule.id")).add(dclRecordDy.getString("dclbusinessname"));
            dclRecordDyGroupByIndexKey.put(indexKey.toString(), dclRecordDy);
        }
        return dclRecordDyGroupByIndexKey;
    }

    private Map<Long, DynamicObject> getEntityDyGroupByPkId(String entityNumber, Set<Long> pkIds) {
        List<DynamicObject> entityDys = DclRecordHelper.queryEntityDy(entityNumber, pkIds, this.iDclRecordType.isUpdateDclRecordList());
        return entityDys.stream().collect(Collectors.toMap(entityDy -> entityDy.getLong("id"), entityDy -> entityDy, (oldVal, newVal) -> oldVal));
    }

    public void checkDclRecordLockedAndLockIt(DclRecordDTO dclRecordDTO) {
        if (dclRecordDTO.getUpdate().booleanValue()) {
            String errInfo = DclRecordHelper.getLockInfo(dclRecordDTO.getDclRecordId(), dclRecordDTO.getDclRecordDy().getString("number"), dclRecordDTO.getOpKey(), this.iDclRecordType.isUpdateDclPersonList());
            if (errInfo != null) {
                dclRecordDTO.getErrMsg().setMutexLockMsg(errInfo);
            } else {
                this.addDclRecordMutexLock(dclRecordDTO);
            }
        }
    }

    public boolean checkNameRepeated(DclRecordDTO dclRecordDTO) {
        boolean isNameRepeated;
        String name = dclRecordDTO.getCurrPeriodDy().getString("number") + dclRecordDTO.getCompanyDy().getString("name") + dclRecordDTO.getDclBizName();
        if (name.length() > 56) {
            name = name.substring(56);
        }
        if (isNameRepeated = DclRecordHelper.isNameRepeated(name)) {
            dclRecordDTO.getErrMsg().setNameRepeatedMsg(HCSIErrInfoEnum.DCL_RECORD_NAME_REPEATED.getErrInfo(name));
        }
        dclRecordDTO.setDclRecordName(name);
        return isNameRepeated;
    }

    public void addDclRecordMutexLock(DclRecordDTO dclRecordDTO) {
        DclRecordHelper.mutexLockOperateKey(dclRecordDTO.getDclRecordId(), dclRecordDTO.getOpKey());
    }
}

