/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.file.attach.SinSurFileBaseHelper;
import kd.sit.hcsi.common.vo.SinFilePersonVo;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.SITStringUtils;
import org.apache.commons.lang3.StringUtils;

public class ExtFileApiService {
    private static final Log LOGGER = LogFactory.getLog(ExtFileApiService.class);
    private boolean isNewInterface = false;
    private Map<String, List<DynamicObject>> empNumberEmployeeMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<Long, DynamicObject> employeeMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, Map<String, List<DynamicObject>>> personWelNumberFileMap = new HashMap<Long, Map<String, List<DynamicObject>>>(16);
    private Map<Long, Map<String, List<DynamicObject>>> personPlacenumberPersonMap = new HashMap<Long, Map<String, List<DynamicObject>>>(16);
    private Map<String, DynamicObject> numberCategoryMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> numberRegistertypeMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> numberorgMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> numberManageregionMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> numberEmpgroupMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> numberWelfarepayerMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> welnumberPlaceofwelfareMap = new HashMap<String, DynamicObject>(16);
    private Map<String, SinFilePersonVo> fileKeyVoMap = new HashMap<String, SinFilePersonVo>(16);
    private Map<String, List<String>> palceNunberWelNumberMap = new HashMap<String, List<String>>(16);
    private Map<String, DynamicObject> filesSave = new HashMap<String, DynamicObject>(10);
    private Map<String, DynamicObject> filesUpdate = new HashMap<String, DynamicObject>(10);
    private Map<String, DynamicObject> newFilesAduit = new HashMap<String, DynamicObject>(10);
    private Map<String, DynamicObject> oldFiles = new HashMap<String, DynamicObject>(10);
    private Map<String, DynamicObject> personSave = new HashMap<String, DynamicObject>(10);
    private Map<String, DynamicObject> personUpdate = new HashMap<String, DynamicObject>(10);
    private Map<String, DynamicObject> oldPserson = new HashMap<String, DynamicObject>(10);
    private Map<Long, DynamicObject> fileIdFileMap = new HashMap<Long, DynamicObject>(10);
    private Map<Long, DynamicObject> personIdpersonMap = new HashMap<Long, DynamicObject>(10);
    private Set<SinFilePersonVo> failVos = new HashSet<SinFilePersonVo>(16);
    private List<Map<String, Object>> saveBaseStdParams = new ArrayList<Map<String, Object>>(10);
    private List<Map<String, Object>> changeBaseStdParams = new ArrayList<Map<String, Object>>(10);
    private List<Map<String, Object>> baseParams = new ArrayList<Map<String, Object>>(10);
    private List<Map<String, Object>> stdParams = new ArrayList<Map<String, Object>>(10);

    public void setNewInterface(boolean newInterface) {
        this.isNewInterface = newInterface;
    }

    public Map<String, Object> syncFileAndPersonInfo(List<SinFilePersonVo> vos) {
        try {
            this.queryBaseData(vos);
            this.groupFile(vos);
            this.updateFile();
            Map<String, String> failMap = this.failVos.stream().collect(Collectors.toMap(SinFilePersonVo::getEmpNumber, SinFilePersonVo::getReason, (k1, k2) -> k2));
            Map resultMap = BaseResult.packageResult((boolean)this.failVos.isEmpty(), (int)ResultStatusEnum.INFO.getCode(), (String)(this.failVos.isEmpty() ? "success" : "fail"), failMap);
            this.addResultInfos(vos, resultMap);
            return resultMap;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return BaseResult.packageResult((boolean)false, (int)ResultStatusEnum.ERROR.getCode(), (String)e.getMessage(), null);
        }
    }

    public static OperationResult executeOp(String opName, DynamicObject[] dys) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        operateOption.setVariableValue("isimport", "1");
        operateOption.setVariableValue("dataSrc", "API");
        OperationServiceImpl opImpl = new OperationServiceImpl();
        return opImpl.localInvokeOperation(opName, dys, operateOption);
    }

    private void addResultInfos(List<SinFilePersonVo> vos, Map<String, Object> resultMap) {
        ArrayList successInfos = new ArrayList(10);
        for (SinFilePersonVo vo : vos) {
            if (!SITStringUtils.isEmpty((String)vo.getReason())) continue;
            HashMap<String, Object> successInfo = new HashMap<String, Object>(16);
            successInfo.put("fileId", vo.getFileId());
            if (this.isNewInterface) {
                successInfo.put("employeeId", vo.getEmployeeId());
            } else {
                successInfo.put("empNumber", vo.getEmpNumber());
            }
            successInfo.put("welfarepayerNumber", vo.getWelfarepayerNumber());
            successInfos.add(successInfo);
        }
        resultMap.put("successInfos", successInfos);
        ArrayList errorInfos = new ArrayList(10);
        for (SinFilePersonVo failVo : this.failVos) {
            HashMap<String, Object> errorInfo = new HashMap<String, Object>(16);
            errorInfo.put("errorCode", failVo.getErrorCode());
            errorInfo.put("reason", failVo.getReason());
            errorInfo.put("isStdOrBaseErr", failVo.isStdOrBaseErr());
            if (this.isNewInterface) {
                errorInfo.put("employeeId", failVo.getEmployeeId());
            } else {
                errorInfo.put("empNumber", failVo.getEmpNumber());
            }
            errorInfo.put("welfarepayerNumber", failVo.getWelfarepayerNumber());
            errorInfos.add(errorInfo);
        }
        resultMap.put("errorInfos", errorInfos);
    }

    private void updateFile() {
        try (TXHandle txHandle = TX.required();){
            this.doPersonOp(this.personSave.values().toArray(new DynamicObject[0]), "donothing_savevalidator");
            this.doPersonOp(this.oldPserson.values().toArray(new DynamicObject[0]), "donothing_saveafterauditvalidator");
            this.doFileOp(this.filesSave.values().toArray(new DynamicObject[0]), "donothing_savevalidator");
            this.doFileOp(this.oldFiles.values().toArray(new DynamicObject[0]), "donothing_saveafterauditvalidator");
            this.doFileOp(this.filesUpdate.values().toArray(new DynamicObject[0]), "save");
            List<DynamicObject> newFiles = this.getNewFile();
            this.doFileOp(newFiles.toArray(new DynamicObject[0]), "save");
            this.doPersonOp(this.personUpdate.values().toArray(new DynamicObject[0]), "save");
            List<DynamicObject> newPersons = this.getNewPersons();
            this.doPersonOp(newPersons.toArray(new DynamicObject[0]), "save");
            this.doFileOp(this.oldFiles.values().toArray(new DynamicObject[0]), "saveafteraudit");
            this.doPersonOp(this.oldPserson.values().toArray(new DynamicObject[0]), "saveafteraudit");
            this.saveBaseStd();
            this.changeBaseStd();
            this.changeBase();
            this.changeStd();
            this.auditFile();
        }
    }

    private List<DynamicObject> getNewPersons() {
        ArrayList<DynamicObject> newPersons = new ArrayList<DynamicObject>();
        for (Map.Entry<String, DynamicObject> entry : this.personSave.entrySet()) {
            if (this.personUpdate.containsKey(entry.getKey())) continue;
            newPersons.add(entry.getValue());
        }
        return newPersons;
    }

    private List<DynamicObject> getNewFile() {
        ArrayList<DynamicObject> newFiles = new ArrayList<DynamicObject>();
        for (Map.Entry<String, DynamicObject> entry : this.filesSave.entrySet()) {
            if (this.filesUpdate.containsKey(entry.getKey())) continue;
            newFiles.add(entry.getValue());
        }
        return newFiles;
    }

    private void changeStd() {
        for (Map.Entry<String, DynamicObject> entry : this.oldFiles.entrySet()) {
            String key = entry.getKey();
            SinFilePersonVo sinFilePersonVo = this.fileKeyVoMap.get(key);
            if (sinFilePersonVo.getStdParams() == null) continue;
            this.stdParams.add(sinFilePersonVo.getStdParams());
        }
        if (this.stdParams.size() > 0) {
            Map<String, Object> result = SinSurFileBaseHelper.hisChangeSinSurFileStds(this.stdParams);
            this.delBaseResult(result);
        }
    }

    private void changeBase() {
        Map<String, Object> result;
        Object data;
        String jsonstr;
        List results;
        for (Map.Entry<String, DynamicObject> entry : this.oldFiles.entrySet()) {
            String key = entry.getKey();
            SinFilePersonVo sinFilePersonVo = this.fileKeyVoMap.get(key);
            if (sinFilePersonVo.getBaseParams() == null) continue;
            this.baseParams.addAll(sinFilePersonVo.getBaseParams());
        }
        if (!this.baseParams.isEmpty() && (results = (List)JSON.parseObject((String)(jsonstr = JSON.toJSONString((Object)(data = (result = SinSurFileBaseHelper.hisChangeSinSurBases(this.baseParams)).get("data")))), (TypeReference)new TypeReference<List<Map<Object, Object>>>(){}, (Feature[])new Feature[0])) != null) {
            for (Map result1 : results) {
                String uniqueCode = String.valueOf(result1.get("uniqueCode"));
                Long fileId = Long.valueOf(uniqueCode.substring(0, uniqueCode.lastIndexOf(35)));
                DynamicObject file = this.fileIdFileMap.get(fileId);
                String reason = (String)result1.get("message");
                String errCode = String.valueOf(result1.get("errorCode"));
                String personId = file.getString("person.id");
                String welNumber = file.getString("welfarepayer.number");
                this.setFileFail(personId, welNumber, reason, errCode, true);
            }
        }
    }

    private void saveBaseStd() {
        for (Map.Entry<String, DynamicObject> entry : this.filesSave.entrySet()) {
            String key = entry.getKey();
            SinFilePersonVo sinFilePersonVo = this.fileKeyVoMap.get(key);
            if (sinFilePersonVo.getBaseStdParams() == null) continue;
            this.saveBaseStdParams.add(sinFilePersonVo.getBaseStdParams());
        }
        if (!this.saveBaseStdParams.isEmpty()) {
            Map<String, Object> result = SinSurFileBaseHelper.saveSinSurFileStdAndBases(this.saveBaseStdParams);
            this.delBaseResult(result);
        }
    }

    private void changeBaseStd() {
        for (Map.Entry<String, DynamicObject> entry : this.oldFiles.entrySet()) {
            String key = entry.getKey();
            SinFilePersonVo sinFilePersonVo = this.fileKeyVoMap.get(key);
            if (sinFilePersonVo.getBaseStdParams() == null) continue;
            this.changeBaseStdParams.add(sinFilePersonVo.getBaseStdParams());
        }
        if (this.changeBaseStdParams.size() > 0) {
            Map<String, Object> result = SinSurFileBaseHelper.hisChangeSinSurFileStdAndBases(this.changeBaseStdParams);
            this.delBaseResult(result);
        }
    }

    private void auditFile() {
        this.doFileOp(this.newFilesAduit.values().toArray(new DynamicObject[0]), "submit");
        ArrayList<Long> fileIds = new ArrayList<Long>(this.newFilesAduit.size());
        for (Map.Entry<String, DynamicObject> filesAduitEntry : this.newFilesAduit.entrySet()) {
            fileIds.add(filesAduitEntry.getValue().getLong("id"));
        }
        HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
        DynamicObject[] auditFiles = fileHelper.query(BaseDataHisHelper.getSelectProperties((String)"hcsi_sinsurfile"), new QFilter("id", "in", fileIds).toArray());
        this.doFileOp(auditFiles, "audit");
    }

    private void delBaseResult(Map<String, Object> result) {
        Object data = result.get("data");
        String jsonstr = JSON.toJSONString((Object)data);
        List results = (List)JSON.parseObject((String)jsonstr, (TypeReference)new TypeReference<List<Map<Object, Object>>>(){}, (Feature[])new Feature[0]);
        if (results != null) {
            for (Map result1 : results) {
                Long fileId = Long.valueOf(String.valueOf(result1.get("uniqueCode")));
                DynamicObject file = this.fileIdFileMap.get(fileId);
                String reason = (String)result1.get("message");
                String personId = file.getString("person.id");
                String welNumber = file.getString("welfarepayer.number");
                String errCode = String.valueOf(result1.get("errorCode"));
                this.setFileFail(personId, welNumber, reason, errCode, true);
            }
        }
    }

    private void doPersonOp(DynamicObject[] persons, String opName) {
        if (persons.length == 0) {
            return;
        }
        OperationResult operationResult = ExtFileApiService.executeOp(opName, persons);
        if (!operationResult.isSuccess()) {
            List operateInfos = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo operateInfo : operateInfos) {
                long pkId = Long.parseLong(String.valueOf(operateInfo.getPkValue()));
                String message = operateInfo.getMessage();
                this.setPersonFail(message, pkId);
            }
            String msg = operationResult.getMessage();
            if (CollectionUtils.isEmpty((Collection)operateInfos) && StringUtils.isNotEmpty((CharSequence)msg)) {
                for (DynamicObject dy : persons) {
                    this.setPersonFail(msg, dy.getLong("id"));
                }
            }
        }
    }

    private void doFileOp(DynamicObject[] files, String opName) {
        if (files == null || files.length == 0) {
            return;
        }
        LOGGER.info("Trace By Quinn: before doFileOp {}", (Object)opName);
        for (DynamicObject file : files) {
            LOGGER.info("Trace By Quinn: doFileOp - data {} - {}", (Object)file.getLong("id"), (Object)file.getLong("employee.id"));
        }
        OperationResult operationResult = ExtFileApiService.executeOp(opName, files);
        if (!operationResult.isSuccess()) {
            List operateInfos = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo operateInfo : operateInfos) {
                String message = operateInfo.getMessage();
                long pkId = Long.parseLong(String.valueOf(operateInfo.getPkValue()));
                this.setFileOpErr(message, pkId);
                LOGGER.info("Trace By Quinn: doFileOp - operationResult {} - {}", (Object)pkId, (Object)message);
            }
            String msg = operationResult.getMessage();
            if (CollectionUtils.isEmpty((Collection)operateInfos) && StringUtils.isNotEmpty((CharSequence)msg)) {
                LOGGER.info("Trace By Quinn: doFileOp - operationResult.getMessage() {}", (Object)msg);
                for (DynamicObject dy : files) {
                    this.setFileOpErr(msg, dy.getLong("id"));
                }
            }
        }
    }

    private void setFileOpErr(String message, long pkId) {
        DynamicObject file = this.fileIdFileMap.get(pkId);
        String personId = file.getString("person.id");
        String welNumber = file.getString("welfarepayer.number");
        String palceNuber = this.welnumberPlaceofwelfareMap.get(welNumber).getString("number");
        String personKey = personId + '|' + palceNuber;
        DynamicObject person = this.personSave.get(personKey);
        if (person == null) {
            this.oldPserson.get(personKey);
        }
        if (person != null) {
            this.setPersonFail(message, person.getLong("id"));
        } else {
            this.setFileFail(personId, welNumber, message, "F000", false);
        }
    }

    private void setFileFail(String personId, String welNumber, String message, String errCode, boolean isBaseErr) {
        String fileKey = personId + '|' + welNumber;
        this.filesSave.remove(fileKey);
        this.filesUpdate.remove(fileKey);
        this.oldFiles.remove(fileKey);
        this.newFilesAduit.remove(fileKey);
        SinFilePersonVo sinFilePersonVo = this.fileKeyVoMap.get(fileKey);
        if (sinFilePersonVo != null) {
            sinFilePersonVo.setReason(message);
            sinFilePersonVo.setErrorCode(errCode);
            sinFilePersonVo.setStdOrBaseErr(isBaseErr);
            this.failVos.add(sinFilePersonVo);
        }
    }

    private void setPersonFail(String message, long pkId) {
        DynamicObject person = this.personIdpersonMap.get(pkId);
        String personId = person.getString("person.id");
        String palceNumber = person.getString("placeofwelfare.number");
        List<String> welNumbers = this.palceNunberWelNumberMap.get(palceNumber);
        this.personSave.remove(this.getPersonKey(null, person));
        this.personUpdate.remove(this.getPersonKey(null, person));
        this.oldPserson.remove(this.getPersonKey(null, person));
        for (String welNumber : welNumbers) {
            this.setFileFail(personId, welNumber, message, "F000", false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void groupFile(List<SinFilePersonVo> vos) {
        long[] personIds = ID.genLongIds((int)(vos.size() * 2));
        int index = 0;
        Iterator<SinFilePersonVo> iterator = vos.iterator();
        while (true) {
            DynamicObject file;
            Map<String, List<DynamicObject>> placeNumberPersonMap;
            String welfarepayerNumber;
            SinFilePersonVo vo;
            block12: {
                boolean isFileOK;
                block13: {
                    if (!iterator.hasNext()) {
                        this.repackageMapData();
                        return;
                    }
                    vo = iterator.next();
                    welfarepayerNumber = vo.getWelfarepayerNumber();
                    Long personId = vo.getPersonId();
                    Map<String, List<DynamicObject>> welnumberFileMap = this.personWelNumberFileMap.get(personId);
                    placeNumberPersonMap = this.personPlacenumberPersonMap.get(personId);
                    file = this.getSInsurFile(welfarepayerNumber, welnumberFileMap);
                    if (file == null) break block13;
                    String fileStatus = file.getString("status");
                    isFileOK = this.setFileFyProp(this.failVos, iterator, vo, file, false);
                    if (!isFileOK) continue;
                    if (SITStringUtils.equals((String)fileStatus, (String)"C")) {
                        this.oldFiles.putIfAbsent(this.getFileKey(vo), file);
                        break block12;
                    } else if (SITStringUtils.equals((String)fileStatus, (String)"A")) {
                        if (vo.isGenerateAudit()) {
                            this.newFilesAduit.putIfAbsent(this.getFileKey(vo), file);
                        }
                        this.filesSave.putIfAbsent(this.getFileKey(vo), file);
                        this.filesUpdate.putIfAbsent(this.getFileKey(vo), file);
                        break block12;
                    } else {
                        vo.setReason(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6863\u6848\uff0c\u4e14\u4e3a\u5df2\u63d0\u4ea4", (String)"ExtFileApiService_3", (String)"sit-hcsi-business", (Object[])new Object[0]));
                        vo.setErrorCode("F003");
                        this.failVos.add(vo);
                        iterator.remove();
                        continue;
                    }
                }
                HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
                file = fileHelper.generateEmptyDynamicObject();
                file.set("id", (Object)personIds[index++]);
                isFileOK = this.setFileFyProp(this.failVos, iterator, vo, file, true);
                if (!isFileOK) continue;
                file.set("status", (Object)"A");
                if (vo.isGenerateAudit()) {
                    this.newFilesAduit.putIfAbsent(this.getFileKey(vo), file);
                    this.filesSave.putIfAbsent(this.getFileKey(vo), file);
                } else {
                    this.filesSave.putIfAbsent(this.getFileKey(vo), file);
                }
            }
            this.delBaseData(vo, file);
            DynamicObject person = this.getSInsurPerson(welfarepayerNumber, placeNumberPersonMap);
            if (vo.isDealPerson()) {
                if (person != null) {
                    String personStatus = person.getString("status");
                    if (!this.setPersonDyProp(vo, person, iterator)) continue;
                    if (SITStringUtils.equals((String)personStatus, (String)"C")) {
                        person.set("bsled", (Object)vo.getBsledp());
                        this.oldPserson.putIfAbsent(this.getPersonKey(vo, null), person);
                        continue;
                    }
                    if (!SITStringUtils.equals((String)personStatus, (String)"A")) continue;
                    person.set("status", (Object)"A");
                    this.personSave.putIfAbsent(this.getPersonKey(vo, null), person);
                    this.personUpdate.putIfAbsent(this.getPersonKey(vo, null), person);
                    continue;
                }
                person = new HRBaseServiceHelper("hcsi_sinsurperson").generateEmptyDynamicObject();
                person.set("id", (Object)personIds[index++]);
                Long employeeId = vo.getEmployeeId();
                DynamicObject employee = this.employeeMap.get(employeeId);
                person.set("employee", (Object)employee);
                if (!this.setPersonDyProp(vo, person, iterator)) continue;
                person.set("status", (Object)"A");
                this.personSave.putIfAbsent(this.getPersonKey(vo, null), person);
                continue;
            }
            if (vo.isDealPerson() || person != null) continue;
            this.setPersonFail(iterator, vo, ResManager.loadKDString((String)"\u4e0d\u5904\u7406\u4eba\u5458\uff0c\u4f46\u662f\u7cfb\u7edf\u4e0d\u5b58\u5728\u4eba\u5458", (String)"ExtFileApiService_8", (String)"sit-hcsi-business", (Object[])new Object[0]), "F008");
        }
    }

    private DynamicObject getSInsurPerson(String welfarepayerNumber, Map<String, List<DynamicObject>> placeNumberPersonMap) {
        List<DynamicObject> persons;
        DynamicObject place;
        DynamicObject person = null;
        if (placeNumberPersonMap != null && (place = this.welnumberPlaceofwelfareMap.get(welfarepayerNumber)) != null && (persons = placeNumberPersonMap.get(place.getString("number"))) != null && persons.size() > 0) {
            person = persons.get(0);
        }
        return person;
    }

    private DynamicObject getSInsurFile(String welfarepayerNumber, Map<String, List<DynamicObject>> welnumberFileMap) {
        List<DynamicObject> files;
        DynamicObject file = null;
        if (welnumberFileMap != null && (files = welnumberFileMap.get(welfarepayerNumber)) != null && !files.isEmpty()) {
            file = files.get(0);
        }
        return file;
    }

    private boolean handelPart(Iterator<SinFilePersonVo> iterator, SinFilePersonVo vo, DynamicObject file, String fileStatus) {
        if (SITStringUtils.equals((String)fileStatus, (String)"C")) {
            this.oldFiles.putIfAbsent(this.getFileKey(vo), file);
        } else if (SITStringUtils.equals((String)fileStatus, (String)"A")) {
            if (vo.isGenerateAudit()) {
                this.newFilesAduit.putIfAbsent(this.getFileKey(vo), file);
            }
            this.filesSave.putIfAbsent(this.getFileKey(vo), file);
            this.filesUpdate.putIfAbsent(this.getFileKey(vo), file);
        } else {
            vo.setReason(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6863\u6848\uff0c\u4e14\u4e3a\u5df2\u63d0\u4ea4", (String)"ExtFileApiService_3", (String)"sit-hcsi-business", (Object[])new Object[0]));
            vo.setErrorCode("F003");
            this.failVos.add(vo);
            iterator.remove();
            return true;
        }
        return false;
    }

    private void repackageMapData() {
        for (Map.Entry<String, DynamicObject> personEntry : this.personSave.entrySet()) {
            this.personIdpersonMap.put(personEntry.getValue().getLong("id"), personEntry.getValue());
        }
        for (Map.Entry<String, DynamicObject> personEntry : this.oldPserson.entrySet()) {
            this.personIdpersonMap.put(personEntry.getValue().getLong("id"), personEntry.getValue());
        }
        for (Map.Entry<String, DynamicObject> fileEntry : this.filesSave.entrySet()) {
            this.fileIdFileMap.put(fileEntry.getValue().getLong("id"), fileEntry.getValue());
        }
        for (Map.Entry<String, DynamicObject> fileEntry : this.oldFiles.entrySet()) {
            this.fileIdFileMap.put(fileEntry.getValue().getLong("id"), fileEntry.getValue());
        }
    }

    private void setPersonFail(Iterator<SinFilePersonVo> iterator, SinFilePersonVo vo, String reason, String errCode) {
        vo.setReason(reason);
        vo.setErrorCode(errCode);
        this.failVos.add(vo);
        iterator.remove();
        String fileKey = this.getFileKey(vo);
        this.filesSave.remove(fileKey);
        this.filesUpdate.remove(fileKey);
        this.newFilesAduit.remove(fileKey);
        this.oldFiles.remove(fileKey);
    }

    private void delBaseData(SinFilePersonVo vo, DynamicObject file) {
        if (vo.getBaseStdParams() != null) {
            Map baseStdParams = vo.getBaseStdParams();
            baseStdParams.put("uniqueCode", file.getLong("id"));
            Map sinSurFileStd = (Map)baseStdParams.get("sinSurFileStd");
            if (sinSurFileStd != null) {
                sinSurFileStd.put("sinSurFileId", file.getLong("id"));
            }
        }
        if (vo.getStdParams() != null) {
            Map stdParams = vo.getStdParams();
            stdParams.put("sinSurFileId", file.getLong("id"));
            stdParams.put("uniqueCode", file.getLong("id"));
        }
        if (vo.getBaseParams() != null) {
            List baseParams = vo.getBaseParams();
            for (Map baseParam : baseParams) {
                Map sinSurFileBase = (Map)baseParam.get("sinSurFileBase");
                if (sinSurFileBase == null) continue;
                sinSurFileBase.put("sinSurFileId", file.getLong("id"));
                baseParam.put("uniqueCode", file.getLong("id") + "#" + sinSurFileBase.get("welfareTypeId"));
            }
        }
    }

    private String getFileKey(SinFilePersonVo vo) {
        return vo.getPersonId().toString() + '|' + vo.getWelfarepayerNumber();
    }

    private String getPersonKey(SinFilePersonVo vo, DynamicObject person) {
        if (vo != null) {
            DynamicObject palce = this.welnumberPlaceofwelfareMap.get(vo.getWelfarepayerNumber());
            if (palce == null) {
                return "";
            }
            return vo.getPersonId().toString() + '|' + palce.getString("number");
        }
        return person.getString("person.id") + '|' + person.getString("placeofwelfare.number");
    }

    private boolean setFileFyProp(Set<SinFilePersonVo> failVos, Iterator<SinFilePersonVo> iterator, SinFilePersonVo vo, DynamicObject file, boolean isNew) {
        String manageregionNumber;
        DynamicObject manageregion;
        String empgroupNumber;
        DynamicObject empgroup;
        Long employeeId;
        DynamicObject employee;
        vo.setFileId(Long.valueOf(file.getLong("id")));
        String orgNumber = vo.getOrgNumber();
        DynamicObject org = this.numberorgMap.get(orgNumber);
        if (org == null) {
            vo.setReason(ResManager.loadKDString((String)"\u793e\u4fdd\u516c\u79ef\u91d1\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"ExtFileApiService_4", (String)"sit-hcsi-business", (Object[])new Object[0]));
            vo.setErrorCode("F004");
            failVos.add(vo);
            iterator.remove();
            return false;
        }
        if (isNew) {
            file.set("org", (Object)org);
        }
        if ((employee = this.employeeMap.get(employeeId = vo.getEmployeeId())) == null) {
            vo.setReason(ResManager.loadKDString((String)"\u5de5\u53f7\u5bf9\u5e94\u7684\u4f01\u4e1a\u4eba\u4e0d\u5b58\u5728", (String)"ExtFileApiService_5", (String)"sit-hcsi-business", (Object[])new Object[0]));
            vo.setErrorCode("F005");
            failVos.add(vo);
            iterator.remove();
            return false;
        }
        if (isNew) {
            file.set("person", (Object)employee.getDynamicObject("person"));
        }
        file.set("employee", (Object)employee);
        String fileNumber = vo.getFileNumber();
        String objnumber = file.getString("number");
        if (SITStringUtils.isEmpty((String)objnumber) && SITStringUtils.isNotEmpty((String)fileNumber)) {
            file.set("number", (Object)fileNumber);
        }
        if ((empgroup = this.numberEmpgroupMap.get(empgroupNumber = vo.getEmpgroupNumber())) == null) {
            vo.setReason(ResManager.loadKDString((String)"\u4eba\u5458\u7ec4\u4e0d\u5b58\u5728", (String)"ExtFileApiService_6", (String)"sit-hcsi-business", (Object[])new Object[0]));
            vo.setErrorCode("F006");
            failVos.add(vo);
            iterator.remove();
            return false;
        }
        file.set("empgroup", (Object)empgroup);
        String welfarepayerNumber = vo.getWelfarepayerNumber();
        DynamicObject welfarepayer = this.numberWelfarepayerMap.get(welfarepayerNumber);
        if (welfarepayer == null) {
            vo.setReason(ResManager.loadKDString((String)"\u53c2\u4fdd\u5355\u4f4d\u4e0d\u5b58\u5728", (String)"ExtFileApiService_7", (String)"sit-hcsi-business", (Object[])new Object[0]));
            vo.setErrorCode("F007");
            failVos.add(vo);
            iterator.remove();
            return false;
        }
        if (isNew) {
            file.set("welfarepayer", (Object)welfarepayer);
        }
        if ((manageregion = this.numberManageregionMap.get(manageregionNumber = vo.getManageregionNumber())) == null) {
            vo.setReason(ResManager.loadKDString((String)"\u793e\u4fdd\u7ba1\u7406\u5c5e\u5730\u4e0d\u5b58\u5728", (String)"ExtFileApiService_9", (String)"sit-hcsi-business", (Object[])new Object[0]));
            vo.setErrorCode("F009");
            failVos.add(vo);
            iterator.remove();
            return false;
        }
        file.set("manageregion", (Object)manageregion);
        String sinsurstatus = vo.getSinsurstatus();
        if (SITStringUtils.isEmpty((String)sinsurstatus)) {
            vo.setReason(ResManager.loadKDString((String)"\u53c2\u4fdd\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (String)"ExtFileApiService_12", (String)"sit-hcsi-business", (Object[])new Object[0]));
            vo.setErrorCode("F012");
            failVos.add(vo);
            iterator.remove();
            return false;
        }
        file.set("sinsurstatus", (Object)sinsurstatus);
        Date bsed = vo.getBsed();
        if (bsed == null) {
            vo.setReason(ResManager.loadKDString((String)"\u6863\u6848\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"ExtFileApiService_14", (String)"sit-hcsi-business", (Object[])new Object[0]));
            vo.setErrorCode("F014");
            failVos.add(vo);
            iterator.remove();
            return false;
        }
        file.set("bsed", (Object)bsed);
        file.set("isescrowstaff", (Object)vo.getIsescrowstaff());
        String welfarepayertheoryNumber = vo.getWelfarepayertheoryNumber();
        DynamicObject welfarepayertheory = this.numberWelfarepayerMap.get(welfarepayertheoryNumber);
        file.set("welfarepayertheory", (Object)welfarepayertheory);
        file.set("comment", (Object)vo.getFileComment());
        file.set("bsled", null);
        if (!isNew && SITStringUtils.equals((String)file.getString("status"), (String)"C")) {
            file.set("bsled", (Object)vo.getBsled());
        }
        Map fileExtparams = vo.getFileExtparams();
        MainEntityType dataEntityType = (MainEntityType)file.getDataEntityType();
        if (fileExtparams != null) {
            for (Map.Entry extParamEntry : fileExtparams.entrySet()) {
                String key = (String)extParamEntry.getKey();
                DynamicProperty property = dataEntityType.getProperty(key);
                if (property instanceof BasedataProp) {
                    if (extParamEntry.getValue() instanceof DynamicObject) {
                        file.set(key, extParamEntry.getValue());
                        continue;
                    }
                    DynamicObject baseObj = HRBaseServiceHelper.create((String)((BasedataProp)property).getBaseEntityId()).generateEmptyDynamicObject();
                    baseObj.set("id", extParamEntry.getValue());
                    file.set(key, (Object)baseObj);
                    continue;
                }
                file.set(key, extParamEntry.getValue());
            }
        }
        return true;
    }

    private boolean setPersonDyProp(SinFilePersonVo vo, DynamicObject person, Iterator<SinFilePersonVo> iterator) {
        Long employeeId = vo.getEmployeeId();
        DynamicObject employee = this.employeeMap.get(employeeId);
        person.set("person", (Object)employee.getDynamicObject("person"));
        if (SITStringUtils.isNotEmpty((String)vo.getRegistertypeNumber()) && this.numberRegistertypeMap.get(vo.getRegistertypeNumber()) == null) {
            this.setPersonFail(iterator, vo, ResManager.loadKDString((String)"\u6237\u7c4d\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"ExtFileApiService_10", (String)"sit-hcsi-business", (Object[])new Object[0]), "F010");
            return false;
        }
        if (SITStringUtils.isNotEmpty((String)vo.getCategoryNumber()) && this.numberCategoryMap.get(vo.getCategoryNumber()) == null) {
            this.setPersonFail(iterator, vo, ResManager.loadKDString((String)"\u6237\u53e3\u6027\u8d28\u4e0d\u5b58\u5728\u3002", (String)"ExtFileApiService_11", (String)"sit-hcsi-business", (Object[])new Object[0]), "F011");
            return false;
        }
        person.set("registertype", (Object)this.numberRegistertypeMap.get(vo.getRegistertypeNumber()));
        person.set("placeofwelfare", (Object)this.welnumberPlaceofwelfareMap.get(vo.getWelfarepayerNumber()));
        person.set("category", (Object)this.numberCategoryMap.get(vo.getCategoryNumber()));
        person.set("sinsuraccount", (Object)vo.getSinsuraccount());
        person.set("housingfundac", (Object)vo.getHousingfundac());
        Date bsed = vo.getBsedp();
        if (bsed == null) {
            this.setPersonFail(iterator, vo, ResManager.loadKDString((String)"\u4eba\u5458\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"ExtFileApiService_13", (String)"sit-hcsi-business", (Object[])new Object[0]), "F013");
            return false;
        }
        person.set("bsed", (Object)vo.getBsedp());
        person.set("comment", (Object)vo.getPersonComment());
        person.set("bsled", null);
        Map personExtparams = vo.getPersonExtparams();
        MainEntityType dataEntityType = (MainEntityType)person.getDataEntityType();
        if (personExtparams != null) {
            for (Map.Entry extParamEntry : personExtparams.entrySet()) {
                String key = (String)extParamEntry.getKey();
                DynamicProperty property = dataEntityType.getProperty(key);
                if (property instanceof BasedataProp) {
                    if (extParamEntry.getValue() instanceof DynamicObject) {
                        person.set(key, extParamEntry.getValue());
                        continue;
                    }
                    DynamicObject baseObj = HRBaseServiceHelper.create((String)((BasedataProp)property).getBaseEntityId()).generateEmptyDynamicObject();
                    baseObj.set("id", extParamEntry.getValue());
                    person.set(key, (Object)baseObj);
                    continue;
                }
                person.set(key, extParamEntry.getValue());
            }
        }
        return true;
    }

    private void queryBaseData(List<SinFilePersonVo> vos) {
        QFilter manageregionFilter;
        HRBaseServiceHelper manageregionHelper;
        DynamicObject[] manageregions;
        QFilter categoryFilter;
        HRBaseServiceHelper categoryHelper;
        DynamicObject[] categorys;
        QFilter registertypeFilter;
        HRBaseServiceHelper registertypeHelper;
        DynamicObject[] registertypes;
        QFilter empgroupFilter;
        HRBaseServiceHelper empgroupHelper;
        DynamicObject[] empgroups;
        QFilter orgFilter;
        HRBaseServiceHelper orgHelper;
        DynamicObject[] orgs;
        DynamicObject[] employees;
        HashSet<String> orgNumbers = new HashSet<String>(16);
        HashSet<String> empgroupNumbers = new HashSet<String>(16);
        HashSet<String> empNumbers = new HashSet<String>(vos.size());
        HashSet<Long> employeeIds = new HashSet<Long>(vos.size());
        HashSet<String> welfarepayerNumbers = new HashSet<String>(16);
        HashSet<String> welfarepayertheoryNumbers = new HashSet<String>(16);
        HashSet<String> registertypeNumbers = new HashSet<String>(16);
        HashSet<String> categoryNumbers = new HashSet<String>(16);
        HashSet<String> manageregionNumbers = new HashSet<String>(16);
        this.checkSinFilePersonVo(vos, orgNumbers, empgroupNumbers, empNumbers, employeeIds, welfarepayerNumbers, welfarepayertheoryNumbers, registertypeNumbers, categoryNumbers, manageregionNumbers);
        HRBaseServiceHelper employeeHelper = new HRBaseServiceHelper("hrpi_employee");
        if (this.isNewInterface) {
            QFilter empFilter = new QFilter("id", "in", employeeIds);
            BaseDataHisHelper.addHisCurrFilter((QFilter)empFilter);
            employees = employeeHelper.query(BaseDataHisHelper.getSelectProperties((String)"hrpi_employee"), new QFilter[]{empFilter});
            this.setEmployMap(employees);
        } else {
            QFilter empnumberFilter = new QFilter("empnumber", "in", empNumbers);
            BaseDataHisHelper.addHisCurrFilter((QFilter)empnumberFilter);
            employees = employeeHelper.query(BaseDataHisHelper.getSelectProperties((String)"hrpi_employee"), new QFilter[]{empnumberFilter});
            if (employees != null) {
                for (DynamicObject employee : employees) {
                    List emps = this.empNumberEmployeeMap.computeIfAbsent(employee.getString("empNumber"), ky -> new ArrayList(10));
                    emps.add(employee);
                    this.employeeMap.put(employee.getLong("id"), employee);
                }
            }
            Iterator<SinFilePersonVo> iterator1 = vos.iterator();
            while (iterator1.hasNext()) {
                SinFilePersonVo vo2 = iterator1.next();
                String empNumber = vo2.getEmpNumber();
                List<DynamicObject> emps = this.empNumberEmployeeMap.get(empNumber);
                if (emps == null) {
                    vo2.setReason(ResManager.loadKDString((String)"\u4f01\u4e1a\u4eba\u4e0d\u5b58\u5728", (String)"ExtFileApiService_5", (String)"sit-hcsi-business", (Object[])new Object[0]));
                    vo2.setErrorCode("F005");
                    this.failVos.add(vo2);
                    iterator1.remove();
                    continue;
                }
                if (emps.size() == 1) {
                    vo2.setEmployeeId(Long.valueOf(emps.get(0).getLong("id")));
                    continue;
                }
                if (emps.size() <= 1) continue;
                Date bsed = vo2.getBsed();
                this.setEmployeeIdForVo(vo2, emps, bsed);
                if (vo2.getEmployeeId() != null) continue;
                vo2.setReason(ResManager.loadKDString((String)"\u5de5\u53f7\u5bf9\u5e94\u7684\u4f01\u4e1a\u4eba\u4e0d\u5b58\u5728", (String)"ExtFileApiService_5", (String)"sit-hcsi-business", (Object[])new Object[0]));
                vo2.setErrorCode("F005");
                this.failVos.add(vo2);
                iterator1.remove();
            }
        }
        ArrayList<Long> personIds = new ArrayList<Long>(this.employeeMap.size());
        this.getPersonIds(vos, personIds);
        HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
        QFilter personFilter = new QFilter("person", "in", personIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)personFilter);
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hcsi_sinsurperson");
        DynamicObject[] persons = personHelper.query(BaseDataHisHelper.getSelectProperties((String)"hcsi_sinsurperson"), personFilter.toArray());
        if (persons != null) {
            this.personPlacenumberPersonMap = Arrays.stream(persons).collect(Collectors.groupingBy(ele -> ele.getLong("person.id"), Collectors.groupingBy(ele -> ele.getString("placeofwelfare.number"))));
        }
        personFilter.and("status", "!=", (Object)"E");
        DynamicObject[] files = fileHelper.query(BaseDataHisHelper.getSelectProperties((String)"hcsi_sinsurfile"), personFilter.toArray());
        if (files != null) {
            this.personWelNumberFileMap = Arrays.stream(files).collect(Collectors.groupingBy(ele -> ele.getLong("person.id"), Collectors.groupingBy(ele -> ele.getString("welfarepayer.number"))));
        }
        HRBaseServiceHelper welfarepayerHelper = new HRBaseServiceHelper("sitbs_welfarepayer");
        welfarepayerNumbers.addAll(welfarepayertheoryNumbers);
        QFilter welfarepayerFilter = new QFilter("number", "in", welfarepayerNumbers);
        DynamicObject[] welfarepayers = welfarepayerHelper.query(BaseDataHisHelper.getSelectProperties((String)"sitbs_welfarepayer"), welfarepayerFilter.toArray());
        if (welfarepayers != null) {
            for (DynamicObject welfarepayer : welfarepayers) {
                this.numberWelfarepayerMap.put(welfarepayer.getString("number"), welfarepayer);
                this.welnumberPlaceofwelfareMap.put(welfarepayer.getString("number"), welfarepayer.getDynamicObject("placeofwelfare"));
                List welnumbers = this.palceNunberWelNumberMap.computeIfAbsent(welfarepayer.getString("placeofwelfare.number"), ky -> new ArrayList(10));
                welnumbers.add(welfarepayer.getString("number"));
            }
        }
        if ((orgs = (orgHelper = new HRBaseServiceHelper("bos_org")).query("id,name,number", (orgFilter = new QFilter("number", "in", orgNumbers)).toArray())) != null) {
            this.numberorgMap = Arrays.stream(orgs).collect(Collectors.toMap(ele -> ele.getString("number"), ele -> ele, (k1, k2) -> k1));
        }
        if ((empgroups = (empgroupHelper = new HRBaseServiceHelper("hbss_empgroup")).query("id,number", (empgroupFilter = new QFilter("number", "in", empgroupNumbers)).toArray())) != null) {
            this.numberEmpgroupMap = Arrays.stream(empgroups).collect(Collectors.toMap(ele -> ele.getString("number"), ele -> ele, (k1, k2) -> k1));
        }
        if ((registertypes = (registertypeHelper = new HRBaseServiceHelper("sitbs_registertype")).query("id,number", (registertypeFilter = new QFilter("number", "in", registertypeNumbers)).toArray())) != null) {
            this.numberRegistertypeMap = Arrays.stream(registertypes).collect(Collectors.toMap(ele -> ele.getString("number"), ele -> ele, (k1, k2) -> k1));
        }
        if ((categorys = (categoryHelper = new HRBaseServiceHelper("hbss_category")).query("id,number", (categoryFilter = new QFilter("number", "in", categoryNumbers)).toArray())) != null) {
            this.numberCategoryMap = Arrays.stream(categorys).collect(Collectors.toMap(ele -> ele.getString("number"), ele -> ele, (k1, k2) -> k1));
        }
        if ((manageregions = (manageregionHelper = new HRBaseServiceHelper("bd_country")).query("id,number", (manageregionFilter = new QFilter("number", "in", manageregionNumbers)).toArray())) != null) {
            this.numberManageregionMap = Arrays.stream(manageregions).collect(Collectors.toMap(ele -> ele.getString("number"), ele -> ele, (k1, k2) -> k1));
        }
        vos.forEach(vo -> this.fileKeyVoMap.put(this.getFileKey((SinFilePersonVo)vo), (SinFilePersonVo)vo));
    }

    private void setEmployeeIdForVo(SinFilePersonVo vo, List<DynamicObject> emps, Date bsed) {
        for (DynamicObject emp : emps) {
            boolean endDataMatch;
            Date startdate = emp.getDate("startdate");
            Date enddate = emp.getDate("enddate");
            boolean bl = endDataMatch = enddate == null || bsed != null && !bsed.after(enddate);
            if (bsed == null || startdate == null || bsed.before(startdate) || !endDataMatch) continue;
            vo.setEmployeeId(Long.valueOf(emp.getLong("id")));
            break;
        }
    }

    private void getPersonIds(List<SinFilePersonVo> vos, List<Long> personIds) {
        for (SinFilePersonVo vo : vos) {
            DynamicObject employee = this.employeeMap.get(vo.getEmployeeId());
            if (employee == null) continue;
            long personId = employee.getLong("person.id");
            vo.setPersonId(Long.valueOf(personId));
            personIds.add(personId);
        }
    }

    private void setEmployMap(DynamicObject[] employees) {
        if (employees != null) {
            for (DynamicObject employee : employees) {
                this.employeeMap.put(employee.getLong("id"), employee);
            }
        }
    }

    private void checkSinFilePersonVo(List<SinFilePersonVo> vos, Set<String> orgNumbers, Set<String> empgroupNumbers, Set<String> empNumbers, Set<Long> employeeIds, Set<String> welfarepayerNumbers, Set<String> welfarepayertheoryNumbers, Set<String> registertypeNumbers, Set<String> categoryNumbers, Set<String> manageregionNumbers) {
        Iterator<SinFilePersonVo> iterator = vos.iterator();
        while (iterator.hasNext()) {
            SinFilePersonVo vo = iterator.next();
            if (this.isNewInterface) {
                Long employeeId = vo.getEmployeeId();
                if (employeeId == null || employeeId == 0L) {
                    vo.setReason(ResManager.loadKDString((String)"\u4f01\u4e1a\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a", (String)"ExtFileApiService_15", (String)"sit-hcsi-business", (Object[])new Object[0]));
                    vo.setErrorCode("F015");
                    this.failVos.add(vo);
                    iterator.remove();
                    continue;
                }
                employeeIds.add(employeeId);
            } else {
                String empNumber = vo.getEmpNumber();
                if (SITStringUtils.isEmpty((String)empNumber)) {
                    vo.setReason(ResManager.loadKDString((String)"\u5de5\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"ExtFileApiService_1", (String)"sit-hcsi-business", (Object[])new Object[0]));
                    vo.setErrorCode("F001");
                    this.failVos.add(vo);
                    iterator.remove();
                    continue;
                }
                empNumbers.add(empNumber);
            }
            String welfarepayerNumber = vo.getWelfarepayerNumber();
            if (SITStringUtils.isEmpty((String)welfarepayerNumber)) {
                vo.setReason(ResManager.loadKDString((String)"\u5b9e\u9645\u53c2\u4fdd\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (String)"ExtFileApiService_2", (String)"sit-hcsi-business", (Object[])new Object[0]));
                vo.setErrorCode("F002");
                this.failVos.add(vo);
                iterator.remove();
                continue;
            }
            Date bsed = vo.getBsed();
            if (bsed == null) {
                vo.setReason(ResManager.loadKDString((String)"\u6863\u6848\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"ExtFileApiService_16", (String)"sit-hcsi-business", (Object[])new Object[0]));
                vo.setErrorCode("F002");
                this.failVos.add(vo);
                iterator.remove();
                continue;
            }
            welfarepayerNumbers.add(welfarepayerNumber);
            if (SITStringUtils.isNotEmpty((String)vo.getOrgNumber())) {
                orgNumbers.add(vo.getOrgNumber());
            }
            if (SITStringUtils.isNotEmpty((String)vo.getWelfarepayertheoryNumber())) {
                welfarepayertheoryNumbers.add(vo.getWelfarepayertheoryNumber());
            }
            if (SITStringUtils.isNotEmpty((String)vo.getRegistertypeNumber())) {
                registertypeNumbers.add(vo.getRegistertypeNumber());
            }
            if (SITStringUtils.isNotEmpty((String)vo.getCategoryNumber())) {
                categoryNumbers.add(vo.getCategoryNumber());
            }
            if (SITStringUtils.isNotEmpty((String)vo.getEmpgroupNumber())) {
                empgroupNumbers.add(vo.getEmpgroupNumber());
            }
            if (!SITStringUtils.isNotEmpty((String)vo.getManageregionNumber())) continue;
            manageregionNumbers.add(vo.getManageregionNumber());
        }
    }
}

