/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.file.ImportRowEntity;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITStringUtils;

public class ImportDataConvert2DyObjHelper {
    private static final Log LOGGER = LogFactory.getLog(ImportDataConvert2DyObjHelper.class);
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static final String SALARYFILE = "salaryfile";
    private static final String EMPLOYEE = "employee";
    private static final String BASE_DATA_SELECT_PROPS = "id,name,number,status,enable";
    private static final String BASE_DATA_SELECT_PROPS_WELFARE = "id,name,number,status,enable, placeofwelfare.id";
    private static final String BASE_DATA_SELECT_PROPS_EMPLOYEE = "id,name,number,status,enable, startdate,enddate,person.name";
    private static final String BASE_DATA_SELECT_PROPS_PERSON = "id,name,number,status,enable,personindexid";
    private static final String HSAS_SINSURFILE_BASE_DATA_SELECT_PROPS = "id,number,bsed,bsled,enable,status,org, org.id, org.name,manageregion,manageregion.id,manageregion.name,empgroup.id,employee.id,welfarepayer,welfarepayer.id,welfarepayer.name";

    public static void assembleImportData(MainEntityType mainEntityType, List<ImportRowEntity> rowInfos, ImportLogger logger, Map<String, QFilter> permissionFilterMap) {
        LOGGER.info("ImportDataConvert2DyObjHelper assembleImportData begin 1-1");
        HashMap<String, Map<String, List<String>>> baseDataValMap = new HashMap<String, Map<String, List<String>>>(16);
        HashMap<String, String> basedataAndPropRls = new HashMap<String, String>(16);
        for (ImportRowEntity rowInfo : rowInfos) {
            ImportDataConvert2DyObjHelper.assemblyDynamicObject(mainEntityType, rowInfo, baseDataValMap, logger, basedataAndPropRls);
        }
        LOGGER.info("ImportDataConvert2DyObjHelper getBasedataRel begin 1-2");
        LOGGER.info("ImportDataConvert2DyObjHelper getBasedataRel begin 1-2,basedataAndPropRls={}", (Object)((Object)basedataAndPropRls).toString());
        LOGGER.info("ImportDataConvert2DyObjHelper getBasedataRel begin 1-2,permissionFilterMap={}", (Object)permissionFilterMap.toString());
        Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels = ImportDataConvert2DyObjHelper.getBasedataRel(baseDataValMap, permissionFilterMap, basedataAndPropRls);
        LOGGER.info("ImportDataConvert2DyObjHelper fillBasedata2DynamicObject begin 1-3");
        ImportDataConvert2DyObjHelper.fillBasedata2DynamicObject(mainEntityType, rowInfos, logger, basedataValRels);
        LOGGER.info("ImportDataConvert2DyObjHelper fillBasedata2DynamicObject end 1-4");
    }

    private static void fillBasedata2DynamicObject(MainEntityType mainEntityType, List<ImportRowEntity> rowInfos, ImportLogger logger, Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels) {
        String entityId = mainEntityType.getName();
        for (ImportRowEntity rowInfo : rowInfos) {
            int rowIndex = rowInfo.getRowIndex();
            JSONObject importJsonData = rowInfo.getData();
            DynamicObject entityDyObj = rowInfo.getEntityDyobj(entityId);
            ImportDataConvert2DyObjHelper.prepareFillBasedata(importJsonData, entityDyObj, rowIndex, logger, basedataValRels);
            rowInfo.putEntityDyobj(entityId, entityDyObj);
        }
    }

    private static void prepareFillBasedata(JSONObject entityJson, DynamicObject entityDyObj, int rowIndex, ImportLogger logger, Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels) {
        DynamicObjectType dyObjType = entityDyObj.getDynamicObjectType();
        HashSet propertSet = new HashSet(16);
        propertSet.addAll(entityJson.keySet());
        propertSet.remove("person");
        propertSet.remove(EMPLOYEE);
        for (String fieldKey : propertSet) {
            String valStr;
            DynamicProperty basedataDP = dyObjType.getProperty(fieldKey);
            if (basedataDP instanceof BasedataProp) {
                ImportDataConvert2DyObjHelper.fillBasedataToEntity(fieldKey, entityJson, entityDyObj, rowIndex, logger, basedataValRels, (BasedataProp)basedataDP, 0);
                continue;
            }
            if (basedataDP instanceof MulBasedataProp) {
                ImportDataConvert2DyObjHelper.fillMulBasedataToEntity(fieldKey, entityJson, entityDyObj, rowIndex, logger, basedataValRels, (MulBasedataProp)basedataDP, 0);
                continue;
            }
            if (basedataDP instanceof EntryProp) {
                JSONArray entryJsonArr = entityJson.getJSONArray(fieldKey);
                DynamicObjectCollection entryEntityColl = entityDyObj.getDynamicObjectCollection(fieldKey);
                int size = entryJsonArr.size();
                for (int i = 0; i < size; ++i) {
                    ImportDataConvert2DyObjHelper.fillBasedataToEntryEntity(rowIndex, logger, basedataValRels, entryJsonArr, entryEntityColl, i);
                }
                continue;
            }
            if (!(basedataDP instanceof TextProp) || StringUtils.isEmpty((String)(valStr = entityJson.getString(fieldKey))) || valStr.length() >= ((TextProp)basedataDP).getMinLenth() && valStr.length() <= ((TextProp)basedataDP).getMaxLenth()) continue;
            ImportDataConvert2DyObjHelper.log(rowIndex, ImportDataConvert2DyObjHelper.getOverLengthErrorMsg((TextProp)basedataDP), logger);
        }
    }

    private static void fillBasedataToEntryEntity(int rowIndex, ImportLogger logger, Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels, JSONArray entryJsonArr, DynamicObjectCollection entryEntityColl, int index) {
        JSONObject entryEntityJson = entryJsonArr.getJSONObject(index);
        for (String entryFieldKey : entryEntityJson.keySet()) {
            ImportDataConvert2DyObjHelper.fillBasedataToEntryEntity(entryFieldKey, entryEntityColl, entryEntityJson, basedataValRels, rowIndex, logger, index);
        }
    }

    private static void fillBasedataToEntity(String fieldKey, JSONObject entityJson, DynamicObject entityDyObj, int rowIndex, ImportLogger logger, Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels, BasedataProp basedataDP, int index) {
        JSONObject basedataJson = entityJson.getJSONObject(fieldKey);
        if (basedataJson == null) {
            return;
        }
        HashSet<String> notLogFiledSet = new HashSet<String>(1);
        notLogFiledSet.add(EMPLOYEE);
        notLogFiledSet.add("person");
        String importPropKey = basedataJson.getString("importprop");
        BasedataProp basedataProp = basedataDP;
        String basedataEntityId = basedataProp.getBaseEntityId();
        Map<String, Map<String, List<DynamicObject>>> importPropVals = basedataValRels.get(basedataEntityId);
        if (null != importPropVals) {
            Map<String, List<DynamicObject>> basedataValsMap = importPropVals.get(importPropKey);
            if (null != basedataValsMap) {
                List<DynamicObject> basedataDyobjs = basedataValsMap.get(basedataJson.get((Object)importPropKey));
                if (null == basedataDyobjs) {
                    if (!notLogFiledSet.contains(fieldKey)) {
                        ImportDataConvert2DyObjHelper.log(rowIndex + index, ImportDataConvert2DyObjHelper.getBasedNoMatchMsg(rowIndex + index, (DynamicProperty)basedataDP, importPropKey, entityDyObj, fieldKey), logger);
                    }
                    entityDyObj.set(fieldKey, null);
                } else if (basedataDyobjs.size() != 1) {
                    if (!notLogFiledSet.contains(fieldKey)) {
                        ImportDataConvert2DyObjHelper.log(rowIndex + index, ImportDataConvert2DyObjHelper.getDuplicateDataErrorMsg(rowIndex + index, (DynamicProperty)basedataDP, importPropKey, basedataDyobjs), logger);
                    }
                    entityDyObj.set(fieldKey, null);
                } else {
                    DynamicObject basedata = basedataDyobjs.get(0);
                    if (!(SALARYFILE.equals(fieldKey) || EMPLOYEE.equals(fieldKey) || "person".equals(fieldKey))) {
                        if (ImportDataConvert2DyObjHelper.isUseStatusQualified(basedata)) {
                            entityDyObj.set(fieldKey, (Object)basedata);
                        } else if (!notLogFiledSet.contains(fieldKey)) {
                            ImportDataConvert2DyObjHelper.log(rowIndex + index, ImportDataConvert2DyObjHelper.getBasedataStatusUnqualifiedMsg(rowIndex + index, (DynamicProperty)basedataDP, importPropKey, entityDyObj, fieldKey), logger);
                        }
                    } else {
                        entityDyObj.set(fieldKey, (Object)basedata);
                    }
                }
            }
        } else if (basedataProp.isMustInput()) {
            if (!notLogFiledSet.contains(fieldKey)) {
                ImportDataConvert2DyObjHelper.log(rowIndex + index, ImportDataConvert2DyObjHelper.getBasedNoMatchMsg(rowIndex + index, (DynamicProperty)basedataDP, importPropKey, entityDyObj, fieldKey), logger);
            }
            entityDyObj.set(fieldKey, null);
        }
    }

    private static void fillMulBasedataToEntity(String fieldKey, JSONObject entityJson, DynamicObject entityDyObj, int rowIndex, ImportLogger logger, Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels, MulBasedataProp basedataDP, int index) {
        JSONObject basedataJson = entityJson.getJSONObject(fieldKey);
        if (basedataJson == null) {
            return;
        }
        String importPropKey = basedataJson.getString("importprop");
        MulBasedataProp basedataProp = basedataDP;
        String basedataEntityId = basedataProp.getBaseEntityId();
        Map<String, Map<String, List<DynamicObject>>> importPropVals = basedataValRels.get(basedataEntityId);
        if (null != importPropVals) {
            Map<String, List<DynamicObject>> basedataValsMap = importPropVals.get(importPropKey);
            if (null != basedataValsMap) {
                String basedataVal = basedataJson.getString(importPropKey);
                List<String> list = Arrays.asList(basedataVal.split(","));
                DynamicObjectCollection basedataDyobjs = new DynamicObjectCollection();
                basedataValsMap.forEach((key, val) -> {
                    if (list.contains(key)) {
                        basedataDyobjs.addAll((Collection)val);
                    }
                });
                if (list.size() != basedataDyobjs.size()) {
                    ImportDataConvert2DyObjHelper.log(rowIndex + index, ImportDataConvert2DyObjHelper.getBasedNoMatchMsg(rowIndex + index, (DynamicProperty)basedataDP, importPropKey, entityDyObj, fieldKey), logger);
                    entityDyObj.set(fieldKey, null);
                } else {
                    boolean isMatch = basedataDyobjs.stream().anyMatch(basedata -> !ImportDataConvert2DyObjHelper.isUseStatusQualified(basedata));
                    if (isMatch) {
                        ImportDataConvert2DyObjHelper.log(rowIndex + index, ImportDataConvert2DyObjHelper.getBasedataStatusUnqualifiedMsg(rowIndex + index, (DynamicProperty)basedataDP, importPropKey, entityDyObj, fieldKey), logger);
                        entityDyObj.set(fieldKey, null);
                    } else {
                        entityDyObj.set(fieldKey, (Object)basedataDyobjs);
                    }
                }
            }
        } else if (basedataProp.isMustInput()) {
            ImportDataConvert2DyObjHelper.log(rowIndex + index, ImportDataConvert2DyObjHelper.getBasedNoMatchMsg(rowIndex + index, (DynamicProperty)basedataDP, importPropKey, entityDyObj, fieldKey), logger);
            entityDyObj.set(fieldKey, null);
        }
    }

    private static void fillBasedataToEntryEntity(String entryFieldKey, DynamicObjectCollection entryEntityColl, JSONObject entryEntityJson, Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels, int rowIndex, ImportLogger logger, int index) {
        for (DynamicObject entryDyObj : entryEntityColl) {
            String valStr;
            DynamicObjectType dyObjType = entryDyObj.getDynamicObjectType();
            DynamicProperty basedataDP = dyObjType.getProperty(entryFieldKey);
            if (basedataDP instanceof BasedataProp) {
                String importPropVal;
                String basedataVal;
                JSONObject basedataJson = entryEntityJson.getJSONObject(entryFieldKey);
                String entryBasedataVal = entryDyObj.getString(entryFieldKey);
                if (basedataJson == null || !(basedataVal = basedataJson.getString(importPropVal = basedataJson.getString("importprop"))).equals(entryBasedataVal)) continue;
                ImportDataConvert2DyObjHelper.fillBasedataToEntity(entryFieldKey, entryEntityJson, entryDyObj, rowIndex, logger, basedataValRels, (BasedataProp)basedataDP, index);
                break;
            }
            if (!(basedataDP instanceof TextProp) || StringUtils.isEmpty((String)(valStr = entryEntityJson.getString(entryFieldKey))) || valStr.length() >= ((TextProp)basedataDP).getMinLenth() && valStr.length() <= ((TextProp)basedataDP).getMaxLenth()) continue;
            ImportDataConvert2DyObjHelper.log(rowIndex, ImportDataConvert2DyObjHelper.getOverLengthErrorMsg((TextProp)basedataDP), logger);
        }
    }

    private static void assemblyDynamicObject(MainEntityType mainEntityType, ImportRowEntity rowInfo, Map<String, Map<String, List<String>>> baseDataValMap, ImportLogger logger, Map<String, String> basedataAndPropRls) {
        DynamicObject dynamicObj = (DynamicObject)mainEntityType.createInstance();
        JSONObject importJsonData = rowInfo.getData();
        int rowIndex = rowInfo.getRowIndex();
        DataEntityPropertyCollection allProps = mainEntityType.getProperties();
        for (IDataEntityProperty dp : allProps) {
            ImportDataConvert2DyObjHelper.fillVal2DynamicObj(importJsonData, rowIndex, dynamicObj, dp, baseDataValMap, logger, basedataAndPropRls);
        }
        Long pkId = ORM.create().genLongId((IDataEntityType)mainEntityType);
        dynamicObj.set("id", (Object)pkId);
        rowInfo.putEntityDyobj(mainEntityType.getName(), dynamicObj);
    }

    private static Map<String, Map<String, Map<String, List<DynamicObject>>>> getBasedataRel(Map<String, Map<String, List<String>>> baseDataValMap, Map<String, QFilter> permissionFilterMap, Map<String, String> basedataAndPropRls) {
        HashMap<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels = new HashMap<String, Map<String, Map<String, List<DynamicObject>>>>();
        for (Map.Entry<String, Map<String, List<String>>> basedataEntityMap : baseDataValMap.entrySet()) {
            String basedataEntityId = basedataEntityMap.getKey();
            Map<String, List<String>> importPropValMap = basedataEntityMap.getValue();
            ImportDataConvert2DyObjHelper.checkBaseDataVal(permissionFilterMap, basedataValRels, basedataEntityId, importPropValMap);
        }
        return basedataValRels;
    }

    private static void checkBaseDataVal(Map<String, QFilter> permissionFilterMap, Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels, String basedataEntityId, Map<String, List<String>> importPropValMap) {
        if (null == importPropValMap) {
            return;
        }
        for (Map.Entry<String, List<String>> importPropKeyMap : importPropValMap.entrySet()) {
            DynamicObject[] basedataDyObjs;
            QFilter perm;
            String importPropKey = importPropKeyMap.getKey();
            List<String> basedataValList = importPropKeyMap.getValue();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(basedataEntityId);
            QFilter qFilter = new QFilter(importPropKey, "in", basedataValList);
            String selectProperties = BASE_DATA_SELECT_PROPS;
            if ("hcsi_sinsurfile".equals(basedataEntityId)) {
                BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
                selectProperties = HSAS_SINSURFILE_BASE_DATA_SELECT_PROPS;
            }
            if ("hrpi_employee".equals(basedataEntityId)) {
                BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
                selectProperties = BASE_DATA_SELECT_PROPS_EMPLOYEE;
                continue;
            }
            if ("hrpi_person".equals(basedataEntityId)) {
                BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
                selectProperties = BASE_DATA_SELECT_PROPS_PERSON;
                continue;
            }
            if ("sitbs_welfarepayer".equals(basedataEntityId)) {
                selectProperties = BASE_DATA_SELECT_PROPS_WELFARE;
            }
            if ((perm = permissionFilterMap.get(basedataEntityId)) != null) {
                LOGGER.info("ImportDataConvert2DyObjHelper getBasedataRel begin 1-2,perm={}", (Object)perm.toString());
                qFilter.and(perm);
            }
            HashMap<String, List<DynamicObject>> basedataRelMap = new HashMap<String, List<DynamicObject>>(16);
            for (DynamicObject dyObj : basedataDyObjs = serviceHelper.query(selectProperties, new QFilter[]{qFilter})) {
                ImportDataConvert2DyObjHelper.fillBaseDataRel(basedataRelMap, dyObj, importPropKey);
            }
            HashMap<String, HashMap<String, List<DynamicObject>>> importPropVals = new HashMap<String, HashMap<String, List<DynamicObject>>>(16);
            importPropVals.put(importPropKey, basedataRelMap);
            basedataValRels.put(basedataEntityId, importPropVals);
            if (!"hrpi_person".equals(basedataEntityId)) continue;
            ImportDataConvert2DyObjHelper.queryEmployee(basedataValRels, basedataDyObjs);
        }
    }

    private static void queryEmployee(Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels, DynamicObject[] basedataDyObjs) {
        Set personIds = Arrays.stream(basedataDyObjs).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        HRBaseServiceHelper employeeHelper = new HRBaseServiceHelper("hrpi_employee");
        QFilter employeeFilter = new QFilter("person.id", "in", personIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)employeeFilter);
        DynamicObject[] employeeDyObjs = employeeHelper.query(BASE_DATA_SELECT_PROPS_EMPLOYEE, new QFilter[]{employeeFilter});
        HashMap<String, List<DynamicObject>> employeeRelMap = new HashMap<String, List<DynamicObject>>(16);
        String empImportPropKey = "empnumber";
        for (DynamicObject dyObj : employeeDyObjs) {
            ImportDataConvert2DyObjHelper.fillBaseDataRel(employeeRelMap, dyObj, empImportPropKey);
        }
        HashMap<String, HashMap<String, List<DynamicObject>>> empImportPropVals = new HashMap<String, HashMap<String, List<DynamicObject>>>(16);
        empImportPropVals.put(empImportPropKey, employeeRelMap);
        basedataValRels.put("hrpi_employee", empImportPropVals);
    }

    private static void fillBaseDataRel(Map<String, List<DynamicObject>> basedataRelMap, DynamicObject dyObj, String importPropKey) {
        List<DynamicObject> exsitDyObjList = basedataRelMap.get(dyObj.getString(importPropKey));
        if (null == exsitDyObjList) {
            exsitDyObjList = new ArrayList<DynamicObject>();
            exsitDyObjList.add(dyObj);
        } else {
            exsitDyObjList.add(dyObj);
        }
        basedataRelMap.put(dyObj.getString(importPropKey), exsitDyObjList);
    }

    private static void fillVal2DynamicObj(JSONObject importJsonData, int rowIndex, DynamicObject dynamicObj, IDataEntityProperty dp, Map<String, Map<String, List<String>>> baseDataValMap, ImportLogger logger, Map<String, String> basedataAndPropRls) {
        String fieldKey = dp.getName();
        String fieldVal = importJsonData.getString(fieldKey);
        if (SITStringUtils.isNotEmpty((String)fieldVal)) {
            if (dp instanceof LargeTextProp || dp instanceof VarcharProp || dp instanceof MuliLangTextProp || dp instanceof TextProp || dp instanceof ComboProp) {
                if (dp instanceof MuliLangTextProp) {
                    Map muliLangTextMap = (Map)JSONObject.parseObject((String)importJsonData.getJSONObject(fieldKey).toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                    dynamicObj.set(fieldKey, (Object)LocaleString.fromMap((Map)muliLangTextMap));
                } else {
                    dynamicObj.set(fieldKey, (Object)fieldVal);
                }
            } else if (dp instanceof DecimalProp) {
                ImportDataConvert2DyObjHelper.fillDecimalProp(fieldKey, fieldVal, dynamicObj, rowIndex, logger, dp);
            } else if (dp instanceof DateProp) {
                ImportDataConvert2DyObjHelper.fillDateProp(fieldKey, fieldVal, dynamicObj, rowIndex, logger, YYYY_MM_DD, dp);
            } else if (dp instanceof DateTimeProp) {
                ImportDataConvert2DyObjHelper.fillDateProp(fieldKey, fieldVal, dynamicObj, rowIndex, logger, YYYY_MM_DD_HH_MM_SS, dp);
            } else if (dp instanceof BooleanProp) {
                if (SITStringUtils.equals((String)fieldVal, (String)"true")) {
                    dynamicObj.set(fieldKey, (Object)Boolean.TRUE);
                } else {
                    dynamicObj.set(fieldKey, (Object)Boolean.FALSE);
                }
            } else if (dp instanceof BasedataProp) {
                ImportDataConvert2DyObjHelper.fillBasedataProp(fieldKey, importJsonData, dynamicObj, dp, baseDataValMap);
                if (basedataAndPropRls != null) {
                    basedataAndPropRls.put(((BasedataProp)dp).getBaseEntityId(), fieldKey);
                }
            } else if (dp instanceof MulBasedataProp) {
                ImportDataConvert2DyObjHelper.fillMulBasedataProp(fieldKey, importJsonData, dynamicObj, dp, baseDataValMap);
            } else if (dp instanceof EntryProp) {
                ImportDataConvert2DyObjHelper.fillEntryProp(fieldVal, rowIndex, dynamicObj, fieldKey, baseDataValMap, logger);
            } else if (dp instanceof LongProp) {
                dynamicObj.set(fieldKey, (Object)Long.valueOf(fieldVal));
            }
        } else if (dp instanceof CreateDateProp || dp instanceof ModifyDateProp) {
            dynamicObj.set(fieldKey, (Object)new Date());
        } else if (dp instanceof CreaterProp || dp instanceof ModifierProp) {
            dynamicObj.set(fieldKey, (Object)RequestContext.get().getCurrUserId());
        } else if (dp instanceof FieldProp) {
            dynamicObj.set(fieldKey, ((FieldProp)dp).getDefValue());
        }
    }

    private static void fillBasedataProp(String fieldKey, JSONObject importJsonData, DynamicObject dynamicObj, IDataEntityProperty dp, Map<String, Map<String, List<String>>> baseDataValMap) {
        JSONObject basedataJson = importJsonData.getJSONObject(fieldKey);
        String importProp = basedataJson.getString("importprop");
        String basedataVal = basedataJson.getString(importProp);
        String basedataEntityId = ((BasedataProp)dp).getBaseEntityId();
        Map importPropValMap = baseDataValMap.computeIfAbsent(basedataEntityId, k1 -> new HashMap());
        List basedataValList = importPropValMap.computeIfAbsent(importProp, k1 -> new ArrayList());
        basedataValList.add(basedataVal);
        dynamicObj.set(fieldKey, (Object)basedataVal);
    }

    private static void fillMulBasedataProp(String fieldKey, JSONObject importJsonData, DynamicObject dynamicObj, IDataEntityProperty dp, Map<String, Map<String, List<String>>> baseDataValMap) {
        JSONObject basedataJson = importJsonData.getJSONObject(fieldKey);
        String importProp = basedataJson.getString("importprop");
        String basedataVal = basedataJson.getString(importProp);
        String basedataEntityId = ((MulBasedataProp)dp).getBaseEntityId();
        Map importPropValMap = baseDataValMap.computeIfAbsent(basedataEntityId, key -> new HashMap());
        List basedataValList = importPropValMap.computeIfAbsent(importProp, key -> new ArrayList());
        List<String> list = Arrays.asList(basedataVal.split(","));
        basedataValList.addAll(list);
        dynamicObj.set(fieldKey, list);
    }

    private static void fillEntryProp(String fieldVal, int rowIndex, DynamicObject dynamicObj, String fieldKey, Map<String, Map<String, List<String>>> baseDataValMap, ImportLogger logger) {
        JSONArray entryJsonArr = JSONArray.parseArray((String)fieldVal);
        DynamicObjectCollection entryEntityColl = dynamicObj.getDynamicObjectCollection(fieldKey);
        DynamicObjectType entryType = null;
        DynamicObject entryDyObj = null;
        int size = entryJsonArr.size();
        for (int i = 0; i < size; ++i) {
            JSONObject entryJson = entryJsonArr.getJSONObject(i);
            entryType = entryEntityColl.getDynamicObjectType();
            entryDyObj = new DynamicObject(entryType);
            for (IDataEntityProperty idp : entryType.getProperties()) {
                if ("id".equals(idp.getName())) continue;
                ImportDataConvert2DyObjHelper.fillVal2DynamicObj(entryJson, rowIndex, entryDyObj, idp, baseDataValMap, logger, null);
            }
            entryDyObj.set("seq", (Object)(i + 1));
            entryEntityColl.add((Object)entryDyObj);
        }
    }

    private static void fillDecimalProp(String fieldKey, String fieldVal, DynamicObject dynamicObj, int rowIndex, ImportLogger logger, IDataEntityProperty dp) {
        try {
            dynamicObj.set(fieldKey, (Object)new BigDecimal(fieldVal));
        }
        catch (NumberFormatException e) {
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff1a{0}", (String)"ImportDataConvert2DyObjHelper_6", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
            ImportDataConvert2DyObjHelper.log(rowIndex, MessageFormat.format(msg, dp.getDisplayName().getLocaleValue()), logger);
        }
    }

    private static void fillDateProp(String fieldKey, String fieldVal, DynamicObject dynamicObj, int rowIndex, ImportLogger logger, String fmt, IDataEntityProperty dp) {
        try {
            dynamicObj.set(fieldKey, (Object)SITDateTimeUtils.parseDate((String)fieldVal, (String)fmt));
        }
        catch (ParseException e) {
            String msg = ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff1a{0}", (String)"ImportDataConvert2DyObjHelper_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
            ImportDataConvert2DyObjHelper.log(rowIndex, MessageFormat.format(msg, dp.getDisplayName().getLocaleValue()), logger);
        }
    }

    public static String getBasedNoMatchMsg(int rowIndex, DynamicProperty dp, String importProp, DynamicObject dyobj, String fieldId) {
        return MessageFormat.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599({0})\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\uff1a{1}\"{2}\"", (String)"ImportDataConvert2DyObjHelper_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), dp.getDisplayName(), ImportDataConvert2DyObjHelper.getImportPropDisName(importProp), dyobj.getString(fieldId));
    }

    public static String getBasedataStatusUnqualifiedMsg(int rowIndex, DynamicProperty dp, String importProp, DynamicObject dyobj, String fieldId) {
        return MessageFormat.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599({0}\u5bf9\u5e94{1}\u662f:{2})\u6570\u636e\u72b6\u6001\u2260\u5df2\u5ba1\u6838 \u6216\u8005 \u4f7f\u7528\u72b6\u6001\u2260\u53ef\u7528", (String)"ImportDataConvert2DyObjHelper_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), dp.getDisplayName(), ImportDataConvert2DyObjHelper.getImportPropDisName(importProp), dyobj.getString(fieldId));
    }

    public static String getDuplicateDataErrorMsg(int rowIndex, DynamicProperty dp, String importProp, List<DynamicObject> basedataDyObjs) {
        return MessageFormat.format(ResManager.loadKDString((String)"{0}\u7684\u503c\u5728\u7cfb\u7edf\u4e2d\u4e0d\u552f\u4e00\uff1a{1}", (String)"ImportDataConvert2DyObjHelper_3", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), dp.getDisplayName(), basedataDyObjs.get(0).getString(importProp));
    }

    public static String getOverLengthErrorMsg(TextProp dp) {
        return MessageFormat.format(ResManager.loadKDString((String)"{0}\u7684\u503c\u8d85\u8fc7\u957f\u5ea6\u9650\u5236[{1}-{2}]", (String)"ImportDataConvert2DyObjHelper_9", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), dp.getDisplayName(), dp.getMinLenth(), dp.getMaxLenth());
    }

    public static String getFixedFieldModifiedErrorMsg(String propName, String value) {
        return MessageFormat.format(ResManager.loadKDString((String)"{0}\u7684\u503c\u4e0d\u652f\u6301\u4fee\u6539\uff1a{1}", (String)"ImportDataConvert2DyObjHelper_7", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), propName, value == null ? "" : value);
    }

    public static String getFieldCanNotModifiedErrorMsg(String statusName) {
        return MessageFormat.format(ResManager.loadKDString((String)"{0}\u7684\u6570\u636e\u4e0d\u80fd\u4fee\u6539", (String)"ImportDataConvert2DyObjHelper_10", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), statusName);
    }

    public static String getMustFieldEmptyErrorMsg(String propName) {
        return MessageFormat.format(ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u672a\u5f55\u5165\uff1a{0}", (String)"ImportDataConvert2DyObjHelper_8", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), propName);
    }

    public static String getImportPropDisName(String importProp) {
        if (SITStringUtils.equals((String)importProp, (String)"number")) {
            return ResManager.loadKDString((String)"\u7f16\u7801", (String)"ImportDataConvert2DyObjHelper_4", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        }
        if (SITStringUtils.equals((String)importProp, (String)"empnumber")) {
            return ResManager.loadKDString((String)"\u5de5\u53f7", (String)"ImportDataConvert2DyObjHelper_10", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        }
        if (SITStringUtils.equals((String)importProp, (String)"name")) {
            return ResManager.loadKDString((String)"\u540d\u79f0", (String)"ImportDataConvert2DyObjHelper_5", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public static boolean isUseStatusQualified(DynamicObject basedata) {
        boolean isQualified = true;
        if (!SITStringUtils.equals((String)basedata.getString("status"), (String)"C") || !SITStringUtils.equals((String)basedata.getString("enable"), (String)"1")) {
            isQualified = false;
        }
        return isQualified;
    }

    public static void log(int rowIndex, String errorMsg, ImportLogger logger) {
        if (logger == null) {
            return;
        }
        Map logCache = logger.getLogCache();
        if (logCache.get(rowIndex) != null) {
            ((List)logCache.get(rowIndex)).add(new ImportLogger.ImportLog(errorMsg));
            logger.setLogCache(logCache);
        } else {
            logger.log(Integer.valueOf(rowIndex), errorMsg).fail();
        }
    }
}

