/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.common.constants.SITBaseConstants;

public class SinSurFileStdImportServiceHelper
implements SITBaseConstants {
    private static final Log LOGGER = LogFactory.getLog(SinSurFileStdImportServiceHelper.class);

    public static DynamicObject querySinSurFileBases(Date bsed, Long welfaretypeId, DynamicObject sinSurFile) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hcsi_sinsurbase");
        QFilter welfarePayerFilter = new QFilter("welfaretype", "=", (Object)welfaretypeId);
        QFilter fileIdFilter = new QFilter("sinsurfile", "=", (Object)sinSurFile.getLong("id"));
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)bsed);
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)bsed);
        QFilter dataStatusFilter = new QFilter("datastatus", "!=", (Object)"-2");
        fileIdFilter.and(currentVersionFilter);
        fileIdFilter.and(welfarePayerFilter);
        fileIdFilter.and(bsedFilter);
        fileIdFilter.and(bsledFilter);
        fileIdFilter.and(dataStatusFilter);
        String selectProperties = "boid,description,status,datastatus,iscurrentversion,modifier,modifytime,bsed,bsled,sinsurfilestd,sinsurfile,welfaretype,sinsurstd,insured,entryentity.insuranceitem,entryentity.insuranceprop,entryentity.numvalue,entryentity.entryboid";
        return hrBaseServiceHelper.queryOne(selectProperties, new QFilter[]{fileIdFilter});
    }

    public static DynamicObject querySinSurFileBase(Long welfaretypeId, DynamicObject sinSurFile) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hcsi_sinsurbase");
        QFilter welfarePayerFilter = new QFilter("welfaretype", "=", (Object)welfaretypeId);
        QFilter fileIdFilter = new QFilter("sinsurfile", "=", (Object)sinSurFile.getLong("id"));
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        fileIdFilter.and(currentVersionFilter);
        fileIdFilter.and(welfarePayerFilter);
        return hrBaseServiceHelper.queryOne(BaseDataHisHelper.getSelectProperties((String)"hcsi_sinsurbase"), new QFilter[]{fileIdFilter});
    }

    public static Map<String, Map<Boolean, List<DynamicObject>>> querySinSurFileStds(Collection<DynamicObject> sinSurFiles) {
        return SinSurFileStdImportServiceHelper.querySinSurFileAttach(sinSurFiles, "hcsi_sinsurfilestd", BaseDataHisHelper.getSelectProperties((String)"hcsi_sinsurfilestd"));
    }

    public static List<DynamicObject> querySinSurFileStds(DynamicObject sinSurFile) {
        ArrayList<DynamicObject> sinSurFiles = new ArrayList<DynamicObject>(10);
        sinSurFiles.add(sinSurFile);
        Map<String, Map<Boolean, List<DynamicObject>>> result = SinSurFileStdImportServiceHelper.querySinSurFileAttach(sinSurFiles, "hcsi_sinsurfilestd", BaseDataHisHelper.getSelectProperties((String)"hcsi_sinsurfilestd"));
        Map<Boolean, List<DynamicObject>> listSinSurFiles = result.get(sinSurFile.getString("number"));
        if (listSinSurFiles == null) {
            return null;
        }
        return listSinSurFiles.get(Boolean.FALSE);
    }

    public static Map<String, Map<Boolean, List<DynamicObject>>> querySinSurFileBases(Collection<DynamicObject> sinSurFiles) {
        return SinSurFileStdImportServiceHelper.querySinSurFileAttach(sinSurFiles, "hcsi_sinsurbase", BaseDataHisHelper.getSelectProperties((String)"hcsi_sinsurbase") + ",sinsurfile.empgroup");
    }

    private static Map<String, Map<Boolean, List<DynamicObject>>> querySinSurFileAttach(Collection<DynamicObject> sinSurFiles, String entityName, String selectProperties) {
        List sinSurFileAttachTemps;
        HashMap<String, Map<Boolean, List<DynamicObject>>> result = new HashMap<String, Map<Boolean, List<DynamicObject>>>(sinSurFiles.size());
        HashMap<String, DynamicObject> sinSurFileMapNumber = new HashMap<String, DynamicObject>(sinSurFiles.size());
        ArrayList<Long> sinSurFileIds = new ArrayList<Long>(sinSurFiles.size());
        for (DynamicObject sinSurFile : sinSurFiles) {
            sinSurFileMapNumber.put(sinSurFile.getString("number"), sinSurFile);
            sinSurFileIds.add(sinSurFile.getLong("id"));
            HashMap isCurrentVersionMap = new HashMap(16);
            result.put(sinSurFile.getString("number"), isCurrentVersionMap);
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
        QFilter dataStatusQFilter = new QFilter("datastatus", "!=", (Object)"-2");
        QFilter sinSurFileIdQFilter = new QFilter("sinsurfile", "in", sinSurFileIds);
        sinSurFileIdQFilter.and(dataStatusQFilter);
        long startQuerySinSurFileBasesTime = System.currentTimeMillis();
        DynamicObject[] sinSurFileAttachs = hrBaseServiceHelper.query(selectProperties, new QFilter[]{sinSurFileIdQFilter}, "bsed asc");
        long endQuerySinSurFileBasesTime = System.currentTimeMillis();
        LOGGER.info("querySinSurFileAttach\uff1a {} cost time :{}", (Object)entityName, (Object)(endQuerySinSurFileBasesTime - startQuerySinSurFileBasesTime));
        HashMap<Long, List> sinSurFileAttachBySinSurFileId = new HashMap<Long, List>(sinSurFileAttachs.length);
        for (DynamicObject sinSurFileAttach : sinSurFileAttachs) {
            sinSurFileAttachTemps = sinSurFileAttachBySinSurFileId.computeIfAbsent(sinSurFileAttach.getLong("sinsurfile.id"), key -> new ArrayList());
            sinSurFileAttachTemps.add(sinSurFileAttach);
        }
        for (Map.Entry entry : sinSurFileMapNumber.entrySet()) {
            long sinSurFileId = ((DynamicObject)entry.getValue()).getLong("id");
            sinSurFileAttachTemps = (List)sinSurFileAttachBySinSurFileId.get(sinSurFileId);
            if (sinSurFileAttachTemps == null) continue;
            sinSurFileAttachTemps.forEach(sinSurFileAttachTemp -> {
                Map isCurrentVersionMap = result.computeIfAbsent((String)entry.getKey(), key -> new HashMap());
                List dynamicObjects = isCurrentVersionMap.computeIfAbsent(sinSurFileAttachTemp.getBoolean("iscurrentversion"), key -> new ArrayList());
                dynamicObjects.add(sinSurFileAttachTemp);
                isCurrentVersionMap.put(sinSurFileAttachTemp.getBoolean("iscurrentversion"), dynamicObjects);
            });
        }
        return result;
    }

    public static Map<Long, Map<Long, DynamicObject>> queryInsuranceItem(Collection<Long> welfareTypeIds) {
        DynamicObject[] sinSurStdCfgs;
        HashMap<Long, Map<Long, DynamicObject>> result = new HashMap<Long, Map<Long, DynamicObject>>(16);
        for (Long welfareTypeId : welfareTypeIds) {
            result.put(welfareTypeId, new HashMap(16));
        }
        for (DynamicObject sinSurStdCfg : sinSurStdCfgs = SinSurFileStdImportServiceHelper.querySinSurStdCfg(welfareTypeIds)) {
            long welfareTypeId = sinSurStdCfg.getLong("insurtype.id");
            HashMap<Long, DynamicObject> insuranceItemMap = new HashMap<Long, DynamicObject>(16);
            DynamicObjectCollection rentryentity = sinSurStdCfg.getDynamicObjectCollection("rentryentity");
            for (Map.Entry<String, Long> mapEntry : SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.entrySet()) {
                for (DynamicObject dynamicObject : rentryentity) {
                    DynamicObject insuranceItem = dynamicObject.getDynamicObject("insuritem");
                    if (insuranceItem.getLong("insurancetypeattr.id") != mapEntry.getValue().longValue()) continue;
                    insuranceItemMap.put(mapEntry.getValue(), insuranceItem);
                }
            }
            result.put(welfareTypeId, insuranceItemMap);
        }
        return result;
    }

    public static DynamicObject[] querySinSurStdCfg(Collection<Long> welfareTypeIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("sitbs_sinsurstdcfg");
        QFilter inSurTypeQFilter = new QFilter("insurtype", "in", welfareTypeIds);
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusQFilter = new QFilter("status", "=", (Object)"C");
        QFilter currentQFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        inSurTypeQFilter.and(enableQFilter);
        inSurTypeQFilter.and(statusQFilter);
        inSurTypeQFilter.and(currentQFilter);
        return hrBaseServiceHelper.query("rentryentity.insuritem,insurtype", new QFilter[]{inSurTypeQFilter});
    }

    public static DynamicObject getDBSinSurBaseVersion(Date bsed, List<DynamicObject> sinSurFileBases, Long welfareTypeId) {
        for (DynamicObject sinSurFileBase : sinSurFileBases) {
            if (sinSurFileBase.getLong("welfaretype.id") != welfareTypeId.longValue()) continue;
            return SinSurFileStdImportServiceHelper.getSourceVersion(bsed, sinSurFileBases, welfareTypeId);
        }
        return null;
    }

    private static DynamicObject getSourceVersion(Date bsed, List<DynamicObject> sinSurFileBases, long welfareTypeId) {
        DynamicObject currentSinSurFileBaseVersion = null;
        for (DynamicObject sinSurFileBaseVersion : sinSurFileBases) {
            if (sinSurFileBaseVersion.getLong("welfaretype.id") != welfareTypeId) continue;
            Date sinSurFileStdVersionBsed = sinSurFileBaseVersion.getDate("bsed");
            Date sinSurFileStdVersionBsled = sinSurFileBaseVersion.getDate("bsled");
            if (bsed.compareTo(sinSurFileStdVersionBsed) <= 0) {
                currentSinSurFileBaseVersion = sinSurFileBaseVersion;
                break;
            }
            if (bsed.compareTo(sinSurFileStdVersionBsed) < 0 || bsed.compareTo(sinSurFileStdVersionBsled) > 0) continue;
            currentSinSurFileBaseVersion = sinSurFileBaseVersion;
            break;
        }
        return currentSinSurFileBaseVersion;
    }

    public static Map<Long, Map<String, List<DynamicObject>>> queryPersonIndexSinSurBases(Collection<DynamicObject> sinSurFiles, List<Long> welfareTypeIds) {
        HashSet<Long> personIndexIds = new HashSet<Long>(sinSurFiles.size());
        for (DynamicObject sinSurFile : sinSurFiles) {
            personIndexIds.add(sinSurFile.getLong("personindexid"));
        }
        return SinSurFileStdImportServiceHelper.queryPersonIndexSinSurBases(personIndexIds, welfareTypeIds);
    }

    public static Map<Long, Map<String, List<DynamicObject>>> queryPersonIndexSinSurBases(Set<Long> personIndexIds, List<Long> welfareTypeIds) {
        HashMap<Long, Map<String, List<DynamicObject>>> result = new HashMap<Long, Map<String, List<DynamicObject>>>(16);
        if (personIndexIds == null || personIndexIds.size() == 0) {
            return result;
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
        QFilter personIndexIdFilter = new QFilter("personindexid", "in", personIndexIds);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SITBaseConstants.getEffectStatus());
        long startQuerySinSuFileTime = System.currentTimeMillis();
        DynamicObject[] DBSinSurFiles = hrBaseServiceHelper.query("id,personindexid,iscurrentversion,status,sinsurstatus,boid,bsed,bsled", new QFilter[]{personIndexIdFilter, dataStatusFilter});
        long endQuerySinSuFileTime = System.currentTimeMillis();
        LOGGER.info("QuerySinSuFile cost time :{}", (Object)(endQuerySinSuFileTime - startQuerySinSuFileTime));
        HashMap<Long, List<Object>> sinSurFileMap = new HashMap<Long, List<DynamicObject>>(DBSinSurFiles.length);
        for (DynamicObject dynamicObject : DBSinSurFiles) {
            List sinSurFilesTemp = sinSurFileMap.computeIfAbsent(dynamicObject.getLong("boid"), key -> new ArrayList());
            sinSurFilesTemp.add(dynamicObject);
        }
        SinSurFileStdServiceHelper.filterAbandonedSinSurFile(sinSurFileMap);
        if (sinSurFileMap.size() == 0) {
            return result;
        }
        hrBaseServiceHelper = new HRBaseServiceHelper("hcsi_sinsurbase");
        QFilter fileIdFilter = new QFilter("sinsurfile", "in", sinSurFileMap.keySet());
        QFilter baseStatusFilter = new QFilter("datastatus", "in", (Object)SITBaseConstants.getEffectStatus());
        if (welfareTypeIds != null) {
            QFilter welfareTypeFilter = new QFilter("welfaretype", "in", welfareTypeIds);
            fileIdFilter.and(welfareTypeFilter);
        }
        fileIdFilter.and(baseStatusFilter);
        long startQuerySinSurBaseTime = System.currentTimeMillis();
        DynamicObject[] allSinSurBases = hrBaseServiceHelper.query("sinsurfile,welfaretype,insured,bsed,bsled", new QFilter[]{fileIdFilter});
        long endQuerySinSuBaseTime = System.currentTimeMillis();
        LOGGER.info("QuerySinSuFile cost time :{}", (Object)(endQuerySinSuBaseTime - startQuerySinSurBaseTime));
        HashMap<Long, List> sinSurBaseMap = new HashMap<Long, List>(allSinSurBases.length);
        for (DynamicObject dynamicObject : allSinSurBases) {
            List sinSurBases = sinSurBaseMap.computeIfAbsent(dynamicObject.getLong("sinsurfile.id"), key -> new ArrayList());
            sinSurBases.add(dynamicObject);
        }
        sinSurFileMap = new HashMap(DBSinSurFiles.length);
        for (DynamicObject dynamicObject : DBSinSurFiles) {
            List sinSurFilesTemp = sinSurFileMap.computeIfAbsent(dynamicObject.getLong("personindexid"), key -> new ArrayList());
            sinSurFilesTemp.add(dynamicObject);
        }
        for (Long personIndexId : personIndexIds) {
            HashMap<String, List> map = new HashMap<String, List>();
            List sinSurFilesTemp = (List)sinSurFileMap.get(personIndexId);
            if (sinSurFilesTemp != null) {
                for (DynamicObject dynamicObject : sinSurFilesTemp) {
                    if (!dynamicObject.getBoolean("iscurrentversion")) continue;
                    ArrayList sinSurBases = (ArrayList)sinSurBaseMap.get(dynamicObject.getLong("boid"));
                    if (sinSurBases == null) {
                        sinSurBases = new ArrayList(10);
                    }
                    List allSinSurFileSinSurBases = map.computeIfAbsent("hcsi_sinsurbase", key -> new ArrayList());
                    allSinSurFileSinSurBases.addAll(sinSurBases);
                }
                map.put("hcsi_sinsurfile", sinSurFilesTemp);
            }
            result.put(personIndexId, map);
        }
        return result;
    }
}

