/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sit.hcsi.common.entity.sinsurbase.InsuranceItemDto;
import kd.sdk.sit.hcsi.common.entity.sinsurbase.SinSurFileBaseEntDto;
import kd.sdk.sit.hcsi.common.events.sinsurfilebase.SinSurFileBaseAddAttributeEvent;
import kd.sdk.sit.hcsi.common.events.sinsurfilebase.SinSurFileBaseAddPageAttributeEvent;
import kd.sdk.sit.hcsi.common.events.sinsurfilebase.SinSurFileBaseHisChangeEvent;
import kd.sdk.sit.hcsi.common.events.sinsurfilebase.SinSurFileBaseImportAddExcelColumnEvent;
import kd.sdk.sit.hcsi.common.events.sinsurfilebase.SinSurFileBaseReplaceNumValueEvent;
import kd.sdk.sit.hcsi.formplugin.sinsurfilebase.ISinSurFileBaseAddAttributePlugin;
import kd.sdk.sit.hcsi.formplugin.sinsurfilebase.ISinSurFileBaseImportAddExcelColumnPlugin;
import kd.sdk.sit.hcsi.oppplugin.sinsurfilebase.ISinSurFileBaseAddAttributeService;
import kd.sdk.sit.hcsi.oppplugin.sinsurfilebase.ISinSurFileBaseHisChangeService;
import kd.sdk.sit.hcsi.service.sinsurfilebase.ISinSurFileBaseImportAddAttributeService;
import kd.sdk.sit.hcsi.service.sinsurfilebase.ISinSurFileBaseReplaceNumValueService;
import kd.sit.hcsi.business.common.helper.StandardCfgHelper;
import kd.sit.hcsi.business.file.SinSurFileStdImportServiceHelper;
import kd.sit.hcsi.business.file.attach.DefaultSinSurFileBaseAddAttributePlugin;
import kd.sit.hcsi.business.file.attach.DefaultSinSurFileBaseAddAttributeService;
import kd.sit.hcsi.business.file.attach.DefaultSinSurFileBaseHisChangeService;
import kd.sit.hcsi.business.file.attach.DefaultSinSurFileBaseImportAddAttributeService;
import kd.sit.hcsi.business.file.attach.DefaultSinSurFileBaseImportAddExcelColumnPlugin;
import kd.sit.hcsi.business.file.attach.DefaultSinSurFileBaseReplaceNumValueService;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.common.constants.SITBaseConstants;

public class SinSurFileStdServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(SinSurFileStdServiceHelper.class);
    public static final String SIN_SUR_STD = "sinsurstd";
    public static final String SIN_SUR_FILE = "sinsurfile";
    public static final String WELFARE_TYPE = "welfaretype";
    public static final String WELFARE_TYPE_ID = "welfaretypeid";
    public static final String PERSONAL_CONTRIBUTION = "personalcontribution";
    public static final String COMPANY_CONTRIBUTION = "companycontribution";
    public static final String INSURED = "insured";
    public static final String ENTRY_BSED = "entrybsed";
    public static final String ENTRY_BSLED = "entrybsled";
    public static final String PERSONAL_UPPER_LIMIT = "personalupperlimit";
    public static final String PERSONAL_LOWER_LIMIT = "personallowerlimit";
    public static final String COMPANY_UPPER_LIMIT = "companyupperlimit";
    public static final String COMPANY_LOWER_LIMIT = "companylowerlimit";
    public static final String ENTRY_DESCRIPTION = "entrydescription";
    public static final String ENTRY_BO_ID = "entryboid";
    public static final String ENTRY_PK_VALUE = "entrypkvalue";
    public static final String INSURANCE_ITEM = "insuranceitem";
    public static final String INSURANCE_PROP = "insuranceprop";
    public static final String NUM_VALUE = "numvalue";
    public static final String FILE_SIN_SUR_STD = "sinsurfilestd";
    public static final String ORIGINAL_DATA = "originalData";
    public static final String SIN_SUR_STD_CHANGE = "sinsurstdchange";
    public static final String MUL_SIN_SUR_STD = "mulsinsurstd";
    public static final Map<String, Long> FILED_INSURANCE_TYPE_ATTR_MAP = new HashMap<String, Long>(16);
    public static final Map<String, Long> SYSTEM_WELFARE_TYPE_MAP = new HashMap<String, Long>(16);

    public static ListShowParameter getSinSurBaseListForm() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("hcsi_sinsurbase");
        return listShowParameter;
    }

    public static ListShowParameter getSinSurBaseHisListForm() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hcsi_sinsurbase");
        showParameter.setFormId("bos_list");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCaption(ResManager.loadKDString((String)"\u793e\u4fdd\u57fa\u6570\u8bbe\u7f6e\u7248\u672c", (String)"SinSurFileStdServiceHelper_0", (String)"sit-hcsi-business", (Object[])new Object[0]));
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
        showParameter.setCustomParam("option", (Object)"showhisversion");
        showParameter.setCustomParam("notOpenDefaultHyperLink", (Object)"number");
        return showParameter;
    }

    public static DynamicObjectCollection queryCurrentVersionSinSurBase(List<Long> sinSurFileIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hcsi_sinsurbase");
        QFilter sinSurFileFilter = new QFilter(SIN_SUR_FILE, "in", sinSurFileIds);
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        sinSurFileFilter.and(versionFilter);
        return hrBaseServiceHelper.queryOriginalCollection("id", new QFilter[]{sinSurFileFilter});
    }

    public static DynamicObject[] querySinSurFileStdBase(Long sinSurFileId, Long sinsurstd) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hcsi_sinsurbase");
        QFilter sinSurFileFilter = new QFilter(SIN_SUR_FILE, "=", (Object)sinSurFileId);
        QFilter sinSurStdFilter = new QFilter(SIN_SUR_STD, "=", (Object)sinsurstd);
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        sinSurFileFilter.and(versionFilter);
        sinSurFileFilter.and(sinSurStdFilter);
        return hrBaseServiceHelper.query(BaseDataHisHelper.getSelectProperties((String)"hcsi_sinsurbase"), new QFilter[]{sinSurFileFilter});
    }

    public static DynamicObject queryCurrentVersionFileSinSurStd(Long sinSurFileId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hcsi_sinsurfilestd");
        QFilter sinSurFileFilter = new QFilter(SIN_SUR_FILE, "=", (Object)sinSurFileId);
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        sinSurFileFilter.and(versionFilter);
        return hrBaseServiceHelper.queryOne("sinsurstd,bsed,bsled", sinSurFileFilter);
    }

    public static DynamicObjectCollection queryCurrentVersionFileSinSurStd(List<Long> sinSurFileIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hcsi_sinsurfilestd");
        QFilter sinSurFileFilter = new QFilter(SIN_SUR_FILE, "in", sinSurFileIds);
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        sinSurFileFilter.and(versionFilter);
        return hrBaseServiceHelper.queryOriginalCollection("id", sinSurFileFilter.toArray());
    }

    public static DynamicObject querySinSurStdVersion(Date bsed, Long sinSurStdId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("sitbs_sinsurstd");
        QFilter boIdFilter = new QFilter("boid", "=", (Object)sinSurStdId);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SITBaseConstants.getEffectStatus());
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)bsed);
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)bsed);
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
        boIdFilter.and(dataStatusFilter);
        boIdFilter.and(bsedFilter);
        boIdFilter.and(bsledFilter);
        boIdFilter.and(versionFilter);
        return hrBaseServiceHelper.queryOne("stdentryentity.insurtype,stdentryentity.isstddim,stdentryentity.stddim,subentryentity.insuritem,subentryentity.itemvalue,subentryentity.roundtype,subentryentity.registertype,subentryentity.category", boIdFilter);
    }

    public static Map<Long, List<DynamicObject>> querySinSurStdVersions(Set<Long> sinSurStdIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("sitbs_sinsurstd");
        QFilter boIdFilter = new QFilter("boid", "in", sinSurStdIds);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SITBaseConstants.getEffectStatus());
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
        boIdFilter.and(dataStatusFilter);
        boIdFilter.and(versionFilter);
        DynamicObject[] query = hrBaseServiceHelper.query("boid,bsed,bsled,stdentryentity.insurtype,stdentryentity.isstddim,stdentryentity.stddim,subentryentity.insuritem,subentryentity.itemvalue,subentryentity.roundtype,subentryentity.registertype,subentryentity.category", new QFilter[]{boIdFilter});
        return Arrays.stream(query).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("boid")));
    }

    public static DynamicObject querySinSurPersonVersion(Date bsed, Long personId, Long placeOfWelfareId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hcsi_sinsurperson");
        QFilter personIdFilter = new QFilter("person", "=", (Object)personId);
        QFilter placeOfWelfareIdFilter = new QFilter("placeofwelfare", "=", (Object)placeOfWelfareId);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SITBaseConstants.getEffectStatus());
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)bsed);
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)bsed);
        personIdFilter.and(dataStatusFilter);
        personIdFilter.and(bsedFilter);
        personIdFilter.and(bsledFilter);
        personIdFilter.and(placeOfWelfareIdFilter);
        return hrBaseServiceHelper.queryOne("registertype,category", personIdFilter);
    }

    public static DynamicObject welfareTypeInsuredFile(Long sinSurFileId, Long personIndexId, Long welfareTypeId, Date bsed, Date bsled) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
        QFilter personIndexIdFilter = new QFilter("personindexid", "=", (Object)personIndexId);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SITBaseConstants.getEffectStatus());
        DynamicObject[] query = hrBaseServiceHelper.query("id,number,status,sinsurstatus,boid,bsed,bsled", new QFilter[]{personIndexIdFilter, dataStatusFilter});
        HashMap<Long, List<DynamicObject>> sinSurFileMap = new HashMap<Long, List<DynamicObject>>(query.length);
        for (DynamicObject dynamicObject : query) {
            List sinSurFiles = sinSurFileMap.computeIfAbsent(dynamicObject.getLong("boid"), key -> new ArrayList());
            sinSurFiles.add(dynamicObject);
        }
        SinSurFileStdServiceHelper.filterAbandonedSinSurFile(sinSurFileMap);
        if (sinSurFileMap.size() == 1) {
            return null;
        }
        hrBaseServiceHelper = new HRBaseServiceHelper("hcsi_sinsurbase");
        QFilter baseStatusFilter = new QFilter("datastatus", "in", (Object)SITBaseConstants.getEffectStatus());
        QFilter fileIdFilter = new QFilter(SIN_SUR_FILE, "in", sinSurFileMap.keySet());
        QFilter welfareTypeFilter = new QFilter(WELFARE_TYPE, "in", (Object)new Long[]{welfareTypeId});
        welfareTypeFilter.and(baseStatusFilter);
        welfareTypeFilter.and(fileIdFilter);
        DynamicObject[] allSinSurBases = hrBaseServiceHelper.query("sinsurfile,insured,welfaretype,bsed,bsled", new QFilter[]{welfareTypeFilter});
        HashMap<Long, List<DynamicObject>> sinSurBaseMap = new HashMap<Long, List<DynamicObject>>(allSinSurBases.length);
        for (DynamicObject dynamicObject : allSinSurBases) {
            List sinSurBases = sinSurBaseMap.computeIfAbsent(dynamicObject.getLong("sinsurfile.id"), key -> new ArrayList());
            sinSurBases.add(dynamicObject);
        }
        return SinSurFileStdServiceHelper.welfareTypeInsuredFile(sinSurFileId, bsed, bsled, sinSurFileMap, sinSurBaseMap, welfareTypeId);
    }

    public static DynamicObject validateWelfareTypeInsuredFile(Date bsed, DynamicObject sinSurFile, Map<Long, Map<String, List<DynamicObject>>> personIndexSinSurBases, Long welfareTypeId, Date sinSurBaseBsled) {
        Map<String, List<DynamicObject>> map = personIndexSinSurBases.get(sinSurFile.getLong("personindexid"));
        if (map != null) {
            List<DynamicObject> allSinSurBases = map.get("hcsi_sinsurbase");
            List<DynamicObject> sinSurFilesTemp = map.get("hcsi_sinsurfile");
            if (sinSurFilesTemp == null || allSinSurBases == null) {
                return null;
            }
            HashMap<Long, List<DynamicObject>> sinSurFileMap = new HashMap<Long, List<DynamicObject>>(sinSurFilesTemp.size());
            for (DynamicObject dynamicObject : sinSurFilesTemp) {
                List sinSurFiles = sinSurFileMap.computeIfAbsent(dynamicObject.getLong("boid"), key -> new ArrayList());
                sinSurFiles.add(dynamicObject);
            }
            if (sinSurFileMap.size() == 1) {
                return null;
            }
            HashMap<Long, List<DynamicObject>> sinSurBaseMap = new HashMap<Long, List<DynamicObject>>(allSinSurBases.size());
            for (DynamicObject dynamicObject : allSinSurBases) {
                List sinSurBases = sinSurBaseMap.computeIfAbsent(dynamicObject.getLong("sinsurfile.id"), key -> new ArrayList());
                sinSurBases.add(dynamicObject);
            }
            return SinSurFileStdServiceHelper.welfareTypeInsuredFile(sinSurFile.getLong("id"), bsed, sinSurBaseBsled, sinSurFileMap, sinSurBaseMap, welfareTypeId);
        }
        return null;
    }

    public static DynamicObject welfareTypeInsuredFile(Long sinSurFileId, Date bsed, Date bsled, Map<Long, List<DynamicObject>> sinSurFileMap, Map<Long, List<DynamicObject>> sinSurBaseMap, Long welfareTypeId) {
        Long sinSurFileBoId;
        List<DynamicObject> currentSinSurFiles = sinSurFileMap.get(sinSurFileId);
        if (bsled == null) {
            bsled = SinSurFileStdServiceHelper.generateBsledDate();
        }
        ArrayList currentSinSurFileDatePeriods = new ArrayList(currentSinSurFiles.size());
        for (DynamicObject currentSinSurFile : currentSinSurFiles) {
            Date date = currentSinSurFile.getDate("bsed");
            Date currentSinSurFileBsled = currentSinSurFile.getDate("bsled");
            if (!sinSurFileId.equals(currentSinSurFile.getLong("boid")) || !HRStringUtils.equals((String)"normal", (String)currentSinSurFile.getString("sinsurstatus")) || !SinSurFileStdServiceHelper.checkTimesHasOverlap(date, currentSinSurFileBsled, bsed, bsled).booleanValue()) continue;
            HashMap<String, Date> sinSurFileDatePeriod2 = new HashMap<String, Date>(currentSinSurFiles.size());
            sinSurFileDatePeriod2.put("bsed", date.compareTo(bsed) < 0 ? bsed : date);
            sinSurFileDatePeriod2.put("bsled", currentSinSurFileBsled.compareTo(bsled) > 0 ? bsled : currentSinSurFileBsled);
            currentSinSurFileDatePeriods.add(sinSurFileDatePeriod2);
        }
        if (currentSinSurFileDatePeriods.size() == 0) {
            return null;
        }
        HashMap otherSinSurFileDatePeriodMap = new HashMap(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : sinSurFileMap.entrySet()) {
            sinSurFileBoId = entry.getKey();
            List<DynamicObject> sinSurFiles = entry.getValue();
            if (sinSurFileId.equals(sinSurFileBoId)) continue;
            for (DynamicObject otherSinSurFile : sinSurFiles) {
                if (!HRStringUtils.equals((String)"normal", (String)otherSinSurFile.getString("sinsurstatus"))) continue;
                Date otherSinSurFileBsed = otherSinSurFile.getDate("bsed");
                Date otherSinSurFileBsled = otherSinSurFile.getDate("bsled");
                currentSinSurFileDatePeriods.forEach(sinSurFileDatePeriod -> {
                    Date currentBsled;
                    Date currentBsed = (Date)sinSurFileDatePeriod.get("bsed");
                    if (SinSurFileStdServiceHelper.checkTimesHasOverlap(otherSinSurFileBsed, otherSinSurFileBsled, currentBsed, currentBsled = (Date)sinSurFileDatePeriod.get("bsled")).booleanValue()) {
                        HashMap<String, Date> otherSinSurFileDatePeriod = new HashMap<String, Date>(currentSinSurFiles.size());
                        otherSinSurFileDatePeriod.put("bsed", otherSinSurFileBsed.compareTo(currentBsed) < 0 ? currentBsed : otherSinSurFileBsed);
                        otherSinSurFileDatePeriod.put("bsled", otherSinSurFileBsled.compareTo(currentBsled) > 0 ? currentBsled : otherSinSurFileBsled);
                        List otherSinSurFileDatePeriods = otherSinSurFileDatePeriodMap.computeIfAbsent(sinSurFileBoId, key -> new ArrayList());
                        otherSinSurFileDatePeriods.add(otherSinSurFileDatePeriod);
                    }
                });
            }
        }
        if (otherSinSurFileDatePeriodMap.size() == 0) {
            return null;
        }
        for (Map.Entry<Long, List<Object>> entry : otherSinSurFileDatePeriodMap.entrySet()) {
            List<DynamicObject> otherSinSurBases;
            sinSurFileBoId = entry.getKey();
            List<Object> otherSinSurFileDatePeriods = entry.getValue();
            if (!SinSurFileStdServiceHelper.handleOtherBase(welfareTypeId, otherSinSurFileDatePeriods, otherSinSurBases = sinSurBaseMap.get(sinSurFileBoId))) continue;
            return sinSurFileMap.get(sinSurFileBoId).get(0);
        }
        return null;
    }

    private static boolean handleOtherBase(Long welfareTypeId, List<Map<String, Date>> otherSinSurFileDatePeriods, List<DynamicObject> otherSinSurBases) {
        if (otherSinSurBases != null) {
            for (DynamicObject otherSinSurBase : otherSinSurBases) {
                if (!welfareTypeId.equals(otherSinSurBase.getLong("welfaretype.id"))) continue;
                Date otherSinSurBaseBsed = otherSinSurBase.getDate("bsed");
                Date otherSinSurBaseBsled = otherSinSurBase.getDate("bsled");
                if (!otherSinSurBase.getBoolean(INSURED)) continue;
                for (Map<String, Date> otherSinSurFileDatePeriod : otherSinSurFileDatePeriods) {
                    if (!SinSurFileStdServiceHelper.checkTimesHasOverlap(otherSinSurFileDatePeriod.get("bsed"), otherSinSurFileDatePeriod.get("bsled"), otherSinSurBaseBsed, otherSinSurBaseBsled).booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Map<Long, Map<String, DynamicObject>> validateWelfareTypeInsuredFile(List<DynamicObject> sinSurFileDys) {
        if (sinSurFileDys == null) {
            return null;
        }
        HashSet<Long> personIndexIds = new HashSet<Long>(sinSurFileDys.size());
        for (DynamicObject sinSurFileDy : sinSurFileDys) {
            if (!HRStringUtils.equals((String)"normal", (String)sinSurFileDy.getString("sinsurstatus"))) continue;
            personIndexIds.add(sinSurFileDy.getLong("personindexid"));
        }
        HashMap<Long, Map<String, DynamicObject>> results = new HashMap<Long, Map<String, DynamicObject>>(sinSurFileDys.size());
        Map<Long, Map<String, List<DynamicObject>>> personIndexSinSurBases = SinSurFileStdImportServiceHelper.queryPersonIndexSinSurBases(personIndexIds, null);
        if (personIndexSinSurBases.size() == 0) {
            return null;
        }
        Set<Long> insurTypeIdsAllowedPayInMultipleArea = StandardCfgHelper.filterInsurTypeIdsInMultipleArea();
        for (DynamicObject sinSurFileDy : sinSurFileDys) {
            if (!HRStringUtils.equals((String)"normal", (String)sinSurFileDy.getString("sinsurstatus"))) continue;
            long personIndexId = sinSurFileDy.getLong("personindexid");
            long currentSinSurFileBoId = sinSurFileDy.getLong("boid");
            Map<String, List<DynamicObject>> map = personIndexSinSurBases.get(personIndexId);
            if (map == null) continue;
            List<DynamicObject> allSinSurBases = map.get("hcsi_sinsurbase");
            List<DynamicObject> sinSurFilesTemp = map.get("hcsi_sinsurfile");
            if (sinSurFilesTemp == null || allSinSurBases == null) continue;
            HashMap<Long, List> sinSurFileMap = new HashMap<Long, List>(sinSurFilesTemp.size());
            for (DynamicObject dynamicObject : sinSurFilesTemp) {
                List sinSurFiles = sinSurFileMap.computeIfAbsent(dynamicObject.getLong("boid"), key -> new ArrayList());
                sinSurFiles.add(dynamicObject);
            }
            if (sinSurFileMap.size() == 1) continue;
            HashMap<Long, List> sinSurBaseMap = new HashMap<Long, List>(allSinSurBases.size());
            for (DynamicObject dynamicObject3 : allSinSurBases) {
                List sinSurBases = sinSurBaseMap.computeIfAbsent(dynamicObject3.getLong("sinsurfile.id"), key -> new ArrayList());
                sinSurBases.add(dynamicObject3);
            }
            List list = (List)sinSurBaseMap.get(sinSurFileDy.getLong("boid"));
            if (list == null) continue;
            HashMap<Long, List<DynamicObject>> sinSurBaseByWelfareTypeMap = new HashMap<Long, List<DynamicObject>>(list.size());
            for (DynamicObject dynamicObject4 : allSinSurBases) {
                List list2 = sinSurBaseByWelfareTypeMap.computeIfAbsent(dynamicObject4.getLong("welfaretype.id"), key -> new ArrayList());
                list2.add(dynamicObject4);
            }
            HashMap<Long, List<Map<String, Date>>> currentSinSurFileDatePeriodMaps = new HashMap<Long, List<Map<String, Date>>>(sinSurBaseByWelfareTypeMap.size());
            SinSurFileStdServiceHelper.validateCurrentFileSinSurBase(sinSurFileDy, sinSurBaseByWelfareTypeMap, currentSinSurFileDatePeriodMaps);
            currentSinSurFileDatePeriodMaps.keySet().removeAll(insurTypeIdsAllowedPayInMultipleArea);
            for (Map.Entry<Long, List<DynamicObject>> entry : sinSurFileMap.entrySet()) {
                if (SinSurFileStdServiceHelper.validateCurrentFileInOtherSinSurBase(results, currentSinSurFileBoId, sinSurBaseByWelfareTypeMap, currentSinSurFileDatePeriodMaps, entry)) break;
            }
        }
        return results;
    }

    private static boolean validateCurrentFileInOtherSinSurBase(Map<Long, Map<String, DynamicObject>> results, long currentSinSurFileBoId, Map<Long, List<DynamicObject>> sinSurBaseByWelfareTypeMap, Map<Long, List<Map<String, Date>>> currentSinSurFileDatePeriodMaps, Map.Entry<Long, List<DynamicObject>> entry) {
        Long sinSurFileId = entry.getKey();
        if (sinSurFileId != currentSinSurFileBoId) {
            List<DynamicObject> otherSinSurFiles = entry.getValue();
            for (DynamicObject otherSinSurFile : otherSinSurFiles) {
                if (!HRStringUtils.equals((String)"normal", (String)otherSinSurFile.getString("sinsurstatus"))) continue;
                Date otherSinSurFileBsed = otherSinSurFile.getDate("bsed");
                Date otherSinSurFileBsled = otherSinSurFile.getDate("bsled");
                for (Map.Entry<Long, List<Map<String, Date>>> entrySet : currentSinSurFileDatePeriodMaps.entrySet()) {
                    Long welfareTypeId = entrySet.getKey();
                    ArrayList<Map<String, Date>> otherSinSurFileDatePeriods = new ArrayList<Map<String, Date>>();
                    List<Map<String, Date>> currentSinSurFileDatePeriods = entrySet.getValue();
                    SinSurFileStdServiceHelper.validateOtherFileInOtherSinSurBase(otherSinSurFileBsed, otherSinSurFileBsled, otherSinSurFileDatePeriods, currentSinSurFileDatePeriods);
                    if (!SinSurFileStdServiceHelper.validateOtherFileSinSurBase(results, currentSinSurFileBoId, sinSurBaseByWelfareTypeMap, sinSurFileId, otherSinSurFile, welfareTypeId, otherSinSurFileDatePeriods)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void validateOtherFileInOtherSinSurBase(Date otherSinSurFileBsed, Date otherSinSurFileBsled, List<Map<String, Date>> otherSinSurFileDatePeriods, List<Map<String, Date>> currentSinSurFileDatePeriods) {
        for (Map<String, Date> currentSinSurFileDatePeriod : currentSinSurFileDatePeriods) {
            Date currentSinSurFileBsled;
            Date currentSinSurFileBsed = currentSinSurFileDatePeriod.get("bsed");
            if (!SinSurFileStdServiceHelper.checkTimesHasOverlap(otherSinSurFileBsed, otherSinSurFileBsled, currentSinSurFileBsed, currentSinSurFileBsled = currentSinSurFileDatePeriod.get("bsled")).booleanValue()) continue;
            HashMap<String, Date> otherSinSurFileDatePeriod = new HashMap<String, Date>(currentSinSurFileDatePeriods.size());
            otherSinSurFileDatePeriod.put("bsed", otherSinSurFileBsed.compareTo(currentSinSurFileBsed) < 0 ? currentSinSurFileBsed : otherSinSurFileBsed);
            otherSinSurFileDatePeriod.put("bsled", otherSinSurFileBsled.compareTo(currentSinSurFileBsled) > 0 ? currentSinSurFileBsled : otherSinSurFileBsled);
            otherSinSurFileDatePeriods.add(otherSinSurFileDatePeriod);
        }
    }

    private static void validateCurrentFileSinSurBase(DynamicObject sinSurFileDy, Map<Long, List<DynamicObject>> sinSurBaseByWelfareTypeMap, Map<Long, List<Map<String, Date>>> currentSinSurFileDatePeriodMaps) {
        Date sinSurFileDyBsed = sinSurFileDy.getDate("bsed");
        Date sinSurFileDyBsled = sinSurFileDy.getDate("bsled");
        if (sinSurFileDyBsled == null) {
            sinSurFileDyBsled = SinSurFileStdServiceHelper.generateBsledDate();
        }
        for (Map.Entry<Long, List<DynamicObject>> entry : sinSurBaseByWelfareTypeMap.entrySet()) {
            Long welfareTypeId = entry.getKey();
            List<DynamicObject> sinSurBases = entry.getValue();
            for (DynamicObject sinSurBase : sinSurBases) {
                Date currentSinSurBaseBsed = sinSurBase.getDate("bsed");
                Date currentSinSurBaseBsled = sinSurBase.getDate("bsled");
                if (sinSurBase.getLong("sinsurfile.id") != sinSurFileDy.getLong("boid") || !sinSurBase.getBoolean(INSURED) || !SinSurFileStdServiceHelper.checkTimesHasOverlap(currentSinSurBaseBsed, currentSinSurBaseBsled, sinSurFileDyBsed, sinSurFileDyBsled).booleanValue()) continue;
                HashMap<String, Date> sinSurFileDatePeriod = new HashMap<String, Date>(sinSurBases.size());
                sinSurFileDatePeriod.put("bsed", currentSinSurBaseBsed.compareTo(sinSurFileDyBsed) < 0 ? sinSurFileDyBsed : currentSinSurBaseBsed);
                sinSurFileDatePeriod.put("bsled", currentSinSurBaseBsled.compareTo(sinSurFileDyBsled) > 0 ? sinSurFileDyBsled : currentSinSurBaseBsled);
                List sinSurFileDatePeriods = currentSinSurFileDatePeriodMaps.computeIfAbsent(welfareTypeId, key -> new ArrayList());
                sinSurFileDatePeriods.add(sinSurFileDatePeriod);
            }
        }
    }

    private static boolean validateOtherFileSinSurBase(Map<Long, Map<String, DynamicObject>> results, long currentSinSurFileBoId, Map<Long, List<DynamicObject>> sinSurBaseByWelfareTypeMap, Long sinSurFileId, DynamicObject otherSinSurFile, Long welfareTypeId, List<Map<String, Date>> otherSinSurFileDatePeriods) {
        for (Map<String, Date> otherSinSurFileDatePeriod : otherSinSurFileDatePeriods) {
            Date otherSinSurFileBaseBsed = otherSinSurFileDatePeriod.get("bsed");
            Date otherSinSurFileBaseBsled = otherSinSurFileDatePeriod.get("bsled");
            List<DynamicObject> otherSinSurBases = sinSurBaseByWelfareTypeMap.get(welfareTypeId);
            for (DynamicObject otherSinSurBase : otherSinSurBases) {
                if (otherSinSurBase.getLong("sinsurfile.id") != sinSurFileId.longValue()) continue;
                Date otherSinSurBaseBsed = otherSinSurBase.getDate("bsed");
                Date otherSinSurBaseBsled = otherSinSurBase.getDate("bsled");
                if (!otherSinSurBase.getBoolean(INSURED) || !SinSurFileStdServiceHelper.checkTimesHasOverlap(otherSinSurFileBaseBsed, otherSinSurFileBaseBsled, otherSinSurBaseBsed, otherSinSurBaseBsled).booleanValue()) continue;
                HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(16);
                result.put("hcsi_sinsurfile", otherSinSurFile);
                result.put("hcsi_sinsurbase", otherSinSurBase);
                results.put(currentSinSurFileBoId, result);
                return true;
            }
        }
        return false;
    }

    public static void filterAbandonedSinSurFile(Map<Long, List<DynamicObject>> sinSurFileMap) {
        Iterator<Map.Entry<Long, List<DynamicObject>>> iterator = sinSurFileMap.entrySet().iterator();
        block0: while (iterator.hasNext()) {
            Map.Entry<Long, List<DynamicObject>> entry = iterator.next();
            List<DynamicObject> value = entry.getValue();
            for (DynamicObject dynamicObject : value) {
                if (!HRStringUtils.equals((String)"E", (String)dynamicObject.getString("status"))) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    public static List<DynamicObject> querySinSurStd(Date bsed, Long welfarePayerId, QFilter orgQFilter) {
        DynamicObject coandDimRef = SinSurFileStdServiceHelper.queryCoandDimRef(bsed, welfarePayerId);
        if (coandDimRef == null) {
            return null;
        }
        DynamicObjectCollection dynamicObjectCollection = coandDimRef.getDynamicObjectCollection(MUL_SIN_SUR_STD);
        ArrayList<Long> sinSurStdIds = new ArrayList<Long>(dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            sinSurStdIds.add(dynamicObject.getLong("fbasedataid.id"));
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("sitbs_sinsurstd");
        QFilter idQFilter = new QFilter("id", "in", sinSurStdIds);
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusQFilter = new QFilter("status", "=", (Object)"C");
        idQFilter.and(enableQFilter);
        idQFilter.and(statusQFilter);
        if (orgQFilter != null) {
            idQFilter.and(orgQFilter);
        }
        DynamicObject[] query = hrBaseServiceHelper.query("bsed,stdentryentity.insurtype", new QFilter[]{idQFilter});
        return Arrays.asList(query);
    }

    public static DynamicObject queryCoandDimRef(Date bsed, Long welfarePayerId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("sitbs_coanddimref");
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)bsed);
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)bsed);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SITBaseConstants.getEffectStatus());
        QFilter welfarePayerFilter = new QFilter("welfarepayer", "=", (Object)welfarePayerId);
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
        bsedFilter.and(bsledFilter);
        bsedFilter.and(dataStatusFilter);
        bsedFilter.and(welfarePayerFilter);
        bsedFilter.and(versionFilter);
        return hrBaseServiceHelper.queryOne(BaseDataHisHelper.getSelectProperties((String)"sitbs_coanddimref"), bsedFilter);
    }

    public static Map<Long, Map<Long, Long>> queryWelfareTypeInsuranceTypeAttrInsurItem(List<Long> welfareTypeIds, Collection<Long> insuranceTypeAttrs) {
        DynamicObject[] sinSurStdCfgDynamicObjects;
        HashMap<Long, Map<Long, Long>> welfareTypeInsuranceTypeAttrInsurItemMap = new HashMap<Long, Map<Long, Long>>(welfareTypeIds.size());
        for (Long welfareTypeId : welfareTypeIds) {
            HashMap<Long, Long> insuranceTypeAttrInsurItemMap = new HashMap<Long, Long>(insuranceTypeAttrs.size());
            for (Long insuranceTypeAttr : insuranceTypeAttrs) {
                insuranceTypeAttrInsurItemMap.put(insuranceTypeAttr, 0L);
            }
            welfareTypeInsuranceTypeAttrInsurItemMap.put(welfareTypeId, insuranceTypeAttrInsurItemMap);
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("sitbs_sinsurstdcfg");
        QFilter inSurTypeQFilter = new QFilter("insurtype", "in", welfareTypeIds);
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusQFilter = new QFilter("status", "=", (Object)"C");
        QFilter currentQFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        inSurTypeQFilter.and(enableQFilter);
        inSurTypeQFilter.and(statusQFilter);
        inSurTypeQFilter.and(currentQFilter);
        for (DynamicObject sinSurStdCfgDynamicObject : sinSurStdCfgDynamicObjects = hrBaseServiceHelper.query("rentryentity.insuritem,insurtype", new QFilter[]{inSurTypeQFilter})) {
            Long welfareTypeId = sinSurStdCfgDynamicObject.getLong("insurtype.id");
            Map insuranceTypeAttrMap = (Map)welfareTypeInsuranceTypeAttrInsurItemMap.get(welfareTypeId);
            DynamicObjectCollection rentryentity = sinSurStdCfgDynamicObject.getDynamicObjectCollection("rentryentity");
            for (DynamicObject dynamicObject : rentryentity) {
                DynamicObject insuranceItem = dynamicObject.getDynamicObject("insuritem");
                if (!insuranceTypeAttrMap.containsKey(insuranceItem.getLong("insurancetypeattr.id"))) continue;
                insuranceTypeAttrMap.put(insuranceItem.getLong("insurancetypeattr.id"), insuranceItem.getLong("id"));
            }
        }
        return welfareTypeInsuranceTypeAttrInsurItemMap;
    }

    public static Map<Long, Map<Long, Boolean>> queryInsuranceTypeAttrSetting(Collection<Long> welfareTypeIds, Collection<Long> insuranceTypeAttrs) {
        DynamicObject[] sinSurStdCfgDynamicObjects;
        HashMap<Long, Map<Long, Boolean>> result = new HashMap<Long, Map<Long, Boolean>>(welfareTypeIds.size());
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("sitbs_sinsurstdcfg");
        for (Long welfareTypeId : welfareTypeIds) {
            HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(insuranceTypeAttrs.size());
            for (Long insuranceTypeAttrId : insuranceTypeAttrs) {
                map.put(insuranceTypeAttrId, Boolean.FALSE);
            }
            result.put(welfareTypeId, map);
        }
        QFilter inSurTypeQFilter = new QFilter("insurtype", "in", welfareTypeIds);
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusQFilter = new QFilter("status", "=", (Object)"C");
        QFilter currentQFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        inSurTypeQFilter.and(enableQFilter);
        inSurTypeQFilter.and(statusQFilter);
        inSurTypeQFilter.and(currentQFilter);
        for (DynamicObject sinSurStdCfgDynamicObject : sinSurStdCfgDynamicObjects = hrBaseServiceHelper.query("rentryentity.insuritem,insurtype", new QFilter[]{inSurTypeQFilter})) {
            Long welfareTypeId = sinSurStdCfgDynamicObject.getLong("insurtype.id");
            Map insuranceTypeAttrMap = (Map)result.get(welfareTypeId);
            DynamicObjectCollection rentryentity = sinSurStdCfgDynamicObject.getDynamicObjectCollection("rentryentity");
            for (DynamicObject dynamicObject : rentryentity) {
                DynamicObject insuranceItem = dynamicObject.getDynamicObject("insuritem");
                if (!insuranceTypeAttrMap.containsKey(insuranceItem.getLong("insurancetypeattr.id"))) continue;
                insuranceTypeAttrMap.put(insuranceItem.getLong("insurancetypeattr.id"), Boolean.TRUE);
            }
        }
        return result;
    }

    public static Map<Long, Map<Long, String>> parseSinSurStd(List<Long> welfareTypeIds, Map<String, Long> systemWelfareTypeMap, DynamicObject sinSurStdVersion, long personId, Long placeOfWelfareId, Date bsed) {
        HashMap<Long, Map<Long, String>> result = new HashMap<Long, Map<Long, String>>(systemWelfareTypeMap.size());
        for (Long welfareTypeId : welfareTypeIds) {
            HashMap<Long, Object> map = new HashMap<Long, Object>(systemWelfareTypeMap.size());
            for (Map.Entry<String, Long> mapEntry : systemWelfareTypeMap.entrySet()) {
                map.put(mapEntry.getValue(), null);
            }
            result.put(welfareTypeId, map);
        }
        if (sinSurStdVersion == null) {
            return result;
        }
        DynamicObject sinSurPersonVersion = SinSurFileStdServiceHelper.querySinSurPersonVersion(bsed, personId, placeOfWelfareId);
        Map<Long, Map<Long, Long>> welfareTypeInsuranceTypeAttrInsurItemMap = SinSurFileStdServiceHelper.queryWelfareTypeInsuranceTypeAttrInsurItem(welfareTypeIds, systemWelfareTypeMap.values());
        DynamicObjectCollection stdEntryEntities = sinSurStdVersion.getDynamicObjectCollection("stdentryentity");
        for (Long welfareTypeId : welfareTypeIds) {
            for (DynamicObject stdEntryEntity : stdEntryEntities) {
                if (!welfareTypeId.equals(stdEntryEntity.getLong("insurtype.id"))) continue;
                Map systemValueMap = (Map)result.get(welfareTypeId);
                Map<Long, Long> insuranceTypeAttrInsurItemMap = welfareTypeInsuranceTypeAttrInsurItemMap.get(welfareTypeId);
                DynamicObjectCollection subEntryEntities = stdEntryEntity.getDynamicObjectCollection("subentryentity");
                String stdDim = stdEntryEntity.getString("stddim");
                boolean isStdDim = stdEntryEntity.getBoolean("isstddim");
                SinSurFileStdServiceHelper.handelSystemWelfareType(systemWelfareTypeMap, sinSurPersonVersion, systemValueMap, insuranceTypeAttrInsurItemMap, subEntryEntities, stdDim, isStdDim);
            }
        }
        return result;
    }

    private static void handelSystemWelfareType(Map<String, Long> systemWelfareTypeMap, DynamicObject sinSurPersonVersion, Map<Long, String> systemValueMap, Map<Long, Long> insuranceTypeAttrInsurItemMap, DynamicObjectCollection subEntryEntities, String stdDim, boolean isStdDim) {
        for (Map.Entry<String, Long> mapEntry : systemWelfareTypeMap.entrySet()) {
            String itemValue = null;
            for (DynamicObject subEntryEntity : subEntryEntities) {
                if (!insuranceTypeAttrInsurItemMap.get(mapEntry.getValue()).equals(subEntryEntity.getLong("insuritem.id"))) continue;
                if (isStdDim) {
                    if (sinSurPersonVersion != null && !HRStringUtils.isNotEmpty((String)(itemValue = SinSurFileStdServiceHelper.enableStdDimGetValue(sinSurPersonVersion, stdDim, subEntryEntity, "itemvalue")))) continue;
                    break;
                }
                itemValue = subEntryEntity.getString("itemvalue");
                break;
            }
            systemValueMap.put(mapEntry.getValue(), itemValue);
        }
    }

    public static String enableStdDimGetValue(DynamicObject sinSurPersonVersion, String stdDim, DynamicObject subEntryEntity, String filedKey) {
        String truncationCode = null;
        List<String> stdDims = SinSurFileStdServiceHelper.splitStdDim(stdDim);
        long registerTypeId = subEntryEntity.getLong("registertype.id");
        long categoryId = subEntryEntity.getLong("category.id");
        if (stdDims.size() == 1) {
            if ("0".equals(stdDims.get(0))) {
                if (registerTypeId != 0L && registerTypeId == sinSurPersonVersion.getLong("registertype.id")) {
                    truncationCode = subEntryEntity.getString(filedKey);
                }
            } else if (categoryId != 0L && categoryId == sinSurPersonVersion.getLong("category.id")) {
                truncationCode = subEntryEntity.getString(filedKey);
            }
        } else if (registerTypeId == sinSurPersonVersion.getLong("registertype.id") && categoryId == sinSurPersonVersion.getLong("category.id")) {
            truncationCode = subEntryEntity.getString(filedKey);
        }
        return truncationCode;
    }

    private static List<String> splitStdDim(String stdDim) {
        String[] split = stdDim.split(",");
        ArrayList<String> stdDims = new ArrayList<String>(split.length);
        for (String tmpStdDim : split) {
            if (!HRStringUtils.isNotEmpty((String)tmpStdDim)) continue;
            stdDims.add(tmpStdDim);
        }
        return stdDims;
    }

    public static DynamicObject createChangedDynamicObject(HRBaseServiceHelper hrBaseServiceHelper, DynamicObject sourceDataEntity) {
        DynamicObject sinSurFileStd = SinSurFileStdServiceHelper.setAllField(sourceDataEntity, hrBaseServiceHelper);
        sinSurFileStd.set("boid", (Object)sourceDataEntity.getLong("boid"));
        return sinSurFileStd;
    }

    public static DynamicObject createNewSinSurBase(HRBaseServiceHelper hrBaseServiceHelper, DynamicObject sourceDataEntity, DynamicObject dynamicObject, Map<Long, Map<Long, DynamicObject>> insuranceItemMap) {
        DynamicObject sinSurBase = hrBaseServiceHelper.generateEmptyDynamicObject();
        sinSurBase.set(SIN_SUR_STD, sourceDataEntity.get(SIN_SUR_STD));
        sinSurBase.set(SIN_SUR_FILE, sourceDataEntity.get(SIN_SUR_FILE));
        sinSurBase.set(FILE_SIN_SUR_STD, (Object)sourceDataEntity);
        sinSurBase.set("bsed", dynamicObject.get(ENTRY_BSED));
        sinSurBase.set("bsled", dynamicObject.get(ENTRY_BSLED));
        sinSurBase.set(WELFARE_TYPE, (Object)SinSurFileStdServiceHelper.getWelfareType(dynamicObject.getLong(WELFARE_TYPE_ID)));
        sinSurBase.set(INSURED, dynamicObject.get(INSURED));
        sinSurBase.set("description", dynamicObject.get(ENTRY_DESCRIPTION));
        DynamicObjectCollection sinSurBaseEntries = SinSurFileStdServiceHelper.createEntry(sinSurBase, dynamicObject, hrBaseServiceHelper, insuranceItemMap);
        sinSurBase.set("entryentity", (Object)sinSurBaseEntries);
        return sinSurBase;
    }

    public static DynamicObject setAllField(DynamicObject sourceDataEntity, HRBaseServiceHelper hrBaseServiceHelper) {
        DynamicObject dynamicObject = hrBaseServiceHelper.generateEmptyDynamicObject();
        DataEntityPropertyCollection collection = sourceDataEntity.getDataEntityType().getProperties();
        collection.forEach(entityProperty -> {
            String propertyName = entityProperty.getName();
            if (!(HRStringUtils.equals((String)propertyName, (String)"id") || HRStringUtils.equals((String)propertyName, (String)"masterid") || HRStringUtils.equals((String)propertyName, (String)"description") || HRStringUtils.equals((String)propertyName, (String)"bsed") || HRStringUtils.equals((String)propertyName, (String)"bsled") || HRStringUtils.equals((String)propertyName, (String)"multilanguagetext") || propertyName.endsWith("_id") || HRStringUtils.equals((String)propertyName, (String)"boid") || HRStringUtils.equals((String)propertyName, (String)"datastatus") || entityProperty instanceof EntryProp)) {
                dynamicObject.set(propertyName, sourceDataEntity.get(propertyName));
            }
        });
        return dynamicObject;
    }

    public static DynamicObject getWelfareType(Long pkValue) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("sitbs_welfaretype");
        return hrBaseServiceHelper.queryOne((Object)pkValue);
    }

    public static DynamicObjectCollection createEntry(DynamicObject sinSurBase, DynamicObject dynamicObject, HRBaseServiceHelper hrBaseServiceHelper, Map<Long, Map<Long, DynamicObject>> insuranceItemMap) {
        DynamicObjectCollection dynamicObjectCollection = sinSurBase.getDynamicObjectCollection("entryentity");
        for (Map.Entry<String, Long> mapEntry : FILED_INSURANCE_TYPE_ATTR_MAP.entrySet()) {
            DynamicObject sinSurBaseEntry = hrBaseServiceHelper.generateEmptyEntryDynamicObject("entryentity");
            Map<Long, DynamicObject> map = insuranceItemMap.get(dynamicObject.getLong(WELFARE_TYPE_ID));
            if (map != null) {
                sinSurBaseEntry.set(INSURANCE_ITEM, (Object)map.get(mapEntry.getValue()));
            }
            sinSurBaseEntry.set(INSURANCE_PROP, (Object)mapEntry.getValue());
            sinSurBaseEntry.set(NUM_VALUE, dynamicObject.get(mapEntry.getKey()));
            dynamicObjectCollection.add((Object)sinSurBaseEntry);
        }
        return dynamicObjectCollection;
    }

    public static Boolean checkTimesHasOverlap(Date dynaStartTime, Date dynaEndTime, Date fixedStartTime, Date fixedEndTime) {
        return dynaEndTime.getTime() >= fixedStartTime.getTime() && dynaStartTime.getTime() <= fixedEndTime.getTime();
    }

    public static Date generateBsledDate() {
        Date entryBsledDate;
        try {
            entryBsledDate = HRDateTimeUtils.parseDate((String)"2999-12-31");
        }
        catch (ParseException e) {
            entryBsledDate = null;
            LOGGER.error("\u65e5\u671f\u8f6c\u6362\u5931\u8d25", (Throwable)e);
        }
        return entryBsledDate;
    }

    public static OperationResult hisChangeSinSurBase(List<DynamicObject> hisChangeDynamicObject) {
        if (hisChangeDynamicObject.size() <= 0) {
            return null;
        }
        DynamicObject[] arraySinSurBase = new DynamicObject[hisChangeDynamicObject.size()];
        return SinSurFileStdServiceHelper.hisChangeSinSurBase(hisChangeDynamicObject.toArray(arraySinSurBase));
    }

    public static OperationResult hisChangeSinSurBase(DynamicObject[] dynamicObjects) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        return opImpl.localInvokeOperation("saveafteraudit", dynamicObjects, operateOption);
    }

    public static Map<Long, DynamicObject> queryFileStd(List<Long> fileIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hcsi_sinsurfilestd");
        QFilter qFilter = new QFilter(SIN_SUR_FILE, "in", fileIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        DynamicObject[] objects = hrBaseServiceHelper.query(BaseDataHisHelper.getSelectProperties((String)"hcsi_sinsurfilestd"), new QFilter[]{qFilter});
        Map<Long, DynamicObject> map = Arrays.stream(objects).collect(Collectors.toMap(obj -> obj.getLong("sinsurfile.id"), obj -> obj, (oldVal, newVal) -> oldVal));
        return map;
    }

    public static DynamicObject getSourceVersion(Date bsed, List<DynamicObject> sinSurFileStdVersions) {
        DynamicObject currentSinSurFileStdVersion = null;
        for (DynamicObject sinSurFileStdVersion : sinSurFileStdVersions) {
            Date sinSurFileStdVersionBsed = sinSurFileStdVersion.getDate("bsed");
            Date sinSurFileStdVersionBsled = sinSurFileStdVersion.getDate("bsled");
            if (bsed.before(sinSurFileStdVersionBsed)) {
                currentSinSurFileStdVersion = sinSurFileStdVersion;
                break;
            }
            if (bsed.compareTo(sinSurFileStdVersionBsed) < 0 || !bsed.before(sinSurFileStdVersionBsled)) continue;
            currentSinSurFileStdVersion = sinSurFileStdVersion;
            break;
        }
        return currentSinSurFileStdVersion;
    }

    public static boolean isStdDim(DynamicObject sinSurStdVersion, Long welfareTypeId) {
        if (sinSurStdVersion != null) {
            DynamicObjectCollection stdentryentities = sinSurStdVersion.getDynamicObjectCollection("stdentryentity");
            for (DynamicObject stdEntryEntity : stdentryentities) {
                long insurType = stdEntryEntity.getLong("insurtype.id");
                if (insurType != welfareTypeId) continue;
                return stdEntryEntity.getBoolean("isstddim");
            }
        }
        return false;
    }

    public static boolean isContainsTruncation(DynamicObject sinSurStdVersion, Long welfareTypeId, Long insuranceItemId) {
        if (sinSurStdVersion != null) {
            DynamicObjectCollection stdentryentities = sinSurStdVersion.getDynamicObjectCollection("stdentryentity");
            for (DynamicObject stdEntryEntity : stdentryentities) {
                long insurType = stdEntryEntity.getLong("insurtype.id");
                if (insurType != welfareTypeId) continue;
                DynamicObjectCollection subEntryEntities = stdEntryEntity.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subEntryEntity : subEntryEntities) {
                    if (insuranceItemId.longValue() != subEntryEntity.getLong("insuritem.id")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getTruncationCode(DynamicObject sinSurPersonVersion, DynamicObject sinSurStdVersion, boolean isStdDim, Long welfareTypeId, Long insuranceItemId) {
        String truncationCode = null;
        if (sinSurStdVersion != null && sinSurPersonVersion != null) {
            DynamicObjectCollection stdentryentities = sinSurStdVersion.getDynamicObjectCollection("stdentryentity");
            block0: for (DynamicObject stdEntryEntity : stdentryentities) {
                long insurType = stdEntryEntity.getLong("insurtype.id");
                if (insurType != welfareTypeId) continue;
                DynamicObjectCollection subEntryEntities = stdEntryEntity.getDynamicObjectCollection("subentryentity");
                String stdDim = stdEntryEntity.getString("stddim");
                for (DynamicObject subEntryEntity : subEntryEntities) {
                    if (insuranceItemId.longValue() != subEntryEntity.getLong("insuritem.id") || !HRStringUtils.isNotEmpty((String)subEntryEntity.getString("roundtype"))) continue;
                    if (isStdDim) {
                        truncationCode = SinSurFileStdServiceHelper.enableStdDimGetValue(sinSurPersonVersion, stdDim, subEntryEntity, "roundtype");
                        if (!HRStringUtils.isNotEmpty((String)truncationCode)) continue;
                        continue block0;
                    }
                    truncationCode = subEntryEntity.getString("roundtype");
                    continue block0;
                }
            }
        }
        return truncationCode;
    }

    public static Long queryPlaceOfWelfareId(Long welfarePayerId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("sitbs_welfarepayer");
        DynamicObject welfarePayer = hrBaseServiceHelper.queryOne("placeofwelfare", (Object)welfarePayerId);
        return welfarePayer.getLong("placeofwelfare.id");
    }

    public static Map<Long, Long> queryPlaceOfWelfareIds(Set<Long> welfarePayerIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("sitbs_welfarepayer");
        DynamicObject[] placeofwelfares = hrBaseServiceHelper.query("placeofwelfare", new QFilter[]{new QFilter("id", "in", welfarePayerIds)});
        HashMap<Long, Long> placeOfWelfareIds = new HashMap<Long, Long>(placeofwelfares.length);
        for (DynamicObject welfarePayer : placeofwelfares) {
            placeOfWelfareIds.put(welfarePayer.getLong("id"), welfarePayer.getLong("placeofwelfare.id"));
        }
        return placeOfWelfareIds;
    }

    public static Map<Long, List<DynamicObject>> queryWelfarePayerSinSurStd(Set<Long> welfarePayerIds) {
        DynamicObject[] query;
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>(16);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("sitbs_coanddimref");
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SITBaseConstants.getEffectStatus());
        QFilter welfarePayerFilter = new QFilter("welfarepayer", "in", welfarePayerIds);
        for (DynamicObject dynamicObject : query = hrBaseServiceHelper.query("bsed,bsled,welfarepayer,mulsinsurstd", new QFilter[]{qFilter, dataStatusFilter, welfarePayerFilter})) {
            List dynamicObjects = result.computeIfAbsent(dynamicObject.getLong("welfarepayer.id"), key -> new ArrayList());
            dynamicObjects.add(dynamicObject);
        }
        return result;
    }

    public static String parseSinSurFileBaseEntEvent(Map<Long, SinSurFileBaseEntDto> changeSinSurFileBaseEntDto, long welfareTypeId, boolean insured, Long insurancePropId, Map<Long, Map<Long, Boolean>> welfareTypeInsuranceTypeAttrMap) {
        SinSurFileBaseEntDto sinSurFileBaseEntDto;
        List insuranceItemDtos;
        String contribution = null;
        if (insured && changeSinSurFileBaseEntDto != null && (insuranceItemDtos = (sinSurFileBaseEntDto = changeSinSurFileBaseEntDto.get(welfareTypeId)).getInsuranceItemDtos()) != null) {
            Map<Long, Boolean> insuranceTypeAttrMap = welfareTypeInsuranceTypeAttrMap.get(welfareTypeId);
            for (InsuranceItemDto insuranceItemDto : insuranceItemDtos) {
                if (!insuranceTypeAttrMap.get(insurancePropId).booleanValue() || !insurancePropId.equals(insuranceItemDto.getInsurancePropId())) continue;
                contribution = insuranceItemDto.getInsurancePropValue();
            }
        }
        return contribution;
    }

    public static void addAttribute(SinSurFileBaseAddAttributeEvent sinSurFileBaseAddAttributeEvent) {
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)new DefaultSinSurFileBaseAddAttributeService(), ISinSurFileBaseAddAttributeService.class, (String)"kd.sdk.sit.hcsi.oppplugin.sinsurfilebase.ISinSurFileBaseAddAttributeService#addAttribute", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.addAttribute(sinSurFileBaseAddAttributeEvent);
            return null;
        });
    }

    public static void addImportAttribute(SinSurFileBaseAddAttributeEvent sinSurFileBaseAddAttributeEvent) {
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)new DefaultSinSurFileBaseImportAddAttributeService(), ISinSurFileBaseImportAddAttributeService.class, (String)"kd.sdk.sit.hcsi.service.sinsurfilebase.ISinSurFileBaseImportAddAttributeService#addImportAttribute", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.addImportAttribute(sinSurFileBaseAddAttributeEvent);
            return null;
        });
    }

    public static void tableValueSetterAddAttribute(SinSurFileBaseAddPageAttributeEvent sinSurFileBaseAddPageAttributeEvent) {
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)new DefaultSinSurFileBaseAddAttributePlugin(), ISinSurFileBaseAddAttributePlugin.class, (String)"kd.sdk.sit.hcsi.formplugin.sinsurfilebase.ISinSurFileBaseAddAttributePlugin#addAttribute", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.addAttribute(sinSurFileBaseAddPageAttributeEvent);
            return null;
        });
    }

    public static void addExcelColumn(SinSurFileBaseImportAddExcelColumnEvent sinSurFileBaseImportAddExcelColumnEvent) {
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)new DefaultSinSurFileBaseImportAddExcelColumnPlugin(), ISinSurFileBaseImportAddExcelColumnPlugin.class, (String)"kd.sdk.sit.hcsi.formplugin.sinsurfilebase.ISinSurFileBaseImportAddExcelColumnPlugin#addExcelColumn", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.addExcelColumn(sinSurFileBaseImportAddExcelColumnEvent);
            return null;
        });
    }

    public static void isChange(SinSurFileBaseHisChangeEvent sinSurFileBaseHisChangeEvent) {
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)new DefaultSinSurFileBaseHisChangeService(), ISinSurFileBaseHisChangeService.class, (String)"kd.sdk.sit.hcsi.oppplugin.sinsurfilebase.ISinSurFileBaseHisChangeService#isChange", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.isChange(sinSurFileBaseHisChangeEvent);
            return null;
        });
    }

    public static void replaceSinSurBaseNumValue(SinSurFileBaseReplaceNumValueEvent sinSurFileBaseReplaceNumValueEvents) {
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)new DefaultSinSurFileBaseReplaceNumValueService(), ISinSurFileBaseReplaceNumValueService.class, (String)"kd.sdk.sit.hcsi.service.sinsurfilebase.ISinSurFileBaseReplaceNumValueService#replaceSinSurBaseNumValue", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.replaceSinSurBaseNumValue(sinSurFileBaseReplaceNumValueEvents);
            return null;
        });
    }

    static {
        FILED_INSURANCE_TYPE_ATTR_MAP.put(PERSONAL_CONTRIBUTION, 1010L);
        FILED_INSURANCE_TYPE_ATTR_MAP.put(COMPANY_CONTRIBUTION, 1020L);
        SYSTEM_WELFARE_TYPE_MAP.put(PERSONAL_UPPER_LIMIT, 1070L);
        SYSTEM_WELFARE_TYPE_MAP.put(PERSONAL_LOWER_LIMIT, 1080L);
        SYSTEM_WELFARE_TYPE_MAP.put(COMPANY_UPPER_LIMIT, 1130L);
        SYSTEM_WELFARE_TYPE_MAP.put(COMPANY_LOWER_LIMIT, 1140L);
    }
}

