/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file;

import com.alibaba.fastjson.JSON;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.business.servicehelper.SITCertCommonHelper;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITListUtil;
import org.apache.commons.collections.ListUtils;

public class SinSurPersonCertCommonHelper {
    private static final Log LOGGER = LogFactory.getLog(SinSurPersonCertCommonHelper.class);

    public static Map<String, Object> verifyCertForApply(List<Long> personIndexIds) {
        return SITCertCommonHelper.verifyCertForApply((String)"2AXKDRPJUQ77", (String)"hcsi_sinsurfile", personIndexIds);
    }

    public static Map<String, Object> verifyCert(List<DynamicObject> files) {
        HashSet<Long> successList = new HashSet<Long>(16);
        HashSet failList = new HashSet(16);
        HashSet<Long> requireList = new HashSet<Long>(16);
        for (DynamicObject file : files) {
            Long pid = file.getLong("person.personindexid");
            if (SinSurPersonCertCommonHelper.isRequireCert(file)) {
                requireList.add(pid);
                continue;
            }
            successList.add(pid);
        }
        LOGGER.info("SinSurPersonCertCommonHelper requireList: {}", requireList);
        Map<String, Object> resultUsable = SinSurPersonCertCommonHelper.verifyCertForApply(new ArrayList<Long>(requireList));
        boolean result = (Boolean)resultUsable.get("result");
        if (result) {
            successList.addAll(requireList);
        } else {
            List noCerts = (List)resultUsable.get("datas");
            failList.addAll(noCerts);
            List hsaDetail = ListUtils.removeAll(requireList, (Collection)noCerts);
            successList.addAll(hsaDetail);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("successList", successList);
        resultMap.put("failList", failList);
        LOGGER.info("SinSurPersonCertCommonHelper resultUsable: {}", (Object)JSON.toJSONString(resultUsable));
        Map checkCountMap = (Map)resultUsable.get("msg");
        resultMap.put("message", checkCountMap.get("message"));
        resultMap.put("msg", resultUsable.get("msg"));
        return resultMap;
    }

    private static boolean isRequireCert(DynamicObject salaryfile) {
        boolean isRequire = false;
        Date bsled = salaryfile.getDate("bsled");
        try {
            if (bsled == null) {
                bsled = SITDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd");
            }
        }
        catch (ParseException e) {
            LOGGER.info("[cert]:parse datetime 2999-12-31 error", (Object)e);
        }
        Date today = SITDateTimeUtils.getTodayDateWithoutTime();
        String status = salaryfile.getString("status");
        return "normal".equals(salaryfile.getString("sinsurstatus")) && !bsled.before(today);
    }

    public static void calPersonCertByPersonId(List<Long> personIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_person");
        QFilter idFilter = new QFilter("id", "in", personIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)idFilter);
        DynamicObjectCollection fileDys = serviceHelper.queryOriginalCollection("personindexid", new QFilter[]{idFilter});
        List<Long> pIds = fileDys.stream().map(dy -> dy.getLong("personindexid")).collect(Collectors.toList());
        SinSurPersonCertCommonHelper.calPersonCertByIndexId(pIds, personIds);
    }

    public static void calPersonCertByIndexId(List<Long> personIndexIds, List<Long> personIds) {
        DynamicObject[] sinSurFileDys = SinSurPersonCertCommonHelper.getNeedCertByFileType(personIndexIds, "hcsi_sinsurfile", "sinsurstatus", personIds);
        Set requireCertSinSurIds = Arrays.stream(sinSurFileDys).map(dy -> dy.getLong("personindexid")).collect(Collectors.toSet());
        SITCertCommonHelper.updateCert((String)"2AXKDRPJUQ77", (String)"hcsi_sinsurfile", new ArrayList(requireCertSinSurIds));
        List releaseDelIds = ListUtils.removeAll(personIndexIds, requireCertSinSurIds);
        SITCertCommonHelper.releaseCert((String)"2AXKDRPJUQ77", (String)"hcsi_sinsurfile", (List)releaseDelIds);
    }

    private static DynamicObject[] getNeedCertByFileType(List<Long> personIndexIds, String billName, String statusType, List<Long> personIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(billName);
        QFilter pIdFilter = new QFilter("personindexid", "in", personIndexIds);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter isVersionFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
        QFilter qIdFilter = new QFilter("status", "!=", (Object)"E");
        QFilter payFilter = "hcsi_sinsurfile".equals(billName) ? new QFilter(statusType, "=", (Object)"normal") : new QFilter(statusType, "=", (Object)"1");
        ArrayList<String> dataStatus = new ArrayList<String>(2);
        dataStatus.add("1");
        dataStatus.add("0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", dataStatus);
        QFilter abandonFilter = SinSurPersonCertCommonHelper.getAbandonFilter(serviceHelper, pIdFilter);
        QFilter[] params = new QFilter[]{pIdFilter, statusFilter, isVersionFilter, qIdFilter, payFilter, dataStatusFilter, abandonFilter};
        return serviceHelper.query("personindexid", params);
    }

    private static QFilter getAbandonFilter(HRBaseServiceHelper serviceHelper, QFilter personFilter) {
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        QFilter abandonStatusFilter = new QFilter("status", "=", (Object)"E");
        DynamicObject[] queryAbandonDys = serviceHelper.query("id", new QFilter[]{personFilter, currentFilter, abandonStatusFilter});
        ArrayList<Long> abandonIdList = new ArrayList<Long>(queryAbandonDys.length);
        for (DynamicObject queryResultDy : queryAbandonDys) {
            abandonIdList.add(queryResultDy.getLong("id"));
        }
        QFilter abandonFilter = SITListUtil.isEmpty(abandonIdList) ? new QFilter("1", "=", (Object)1) : new QFilter("boid", "not in", abandonIdList);
        return abandonFilter;
    }

    public static void showWarningTip(IFormView showView, String preMsg, List<DynamicObject> dys) {
        Map<String, Object> resultUsable = SinSurPersonCertCommonHelper.verifyCert(dys);
        Map checkCountMap = (Map)resultUsable.get("msg");
        String showMessageType = (String)checkCountMap.get("showMessageType");
        if ("true".equals(checkCountMap.get("showMessage")) && "2".equals(showMessageType)) {
            showView.showTipNotification(preMsg + (String)checkCountMap.get("message"));
        }
    }
}

