/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.sdk.sit.hcsi.common.events.sinsurfilebase.SinSurFileBaseImportAddExcelColumnEvent;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.sitbp.business.helper.excel.ExcelHelper;
import kd.sit.sitbp.common.enums.SITShowType;
import kd.sit.sitbp.common.util.SITListUtil;
import kd.sit.sitbp.common.util.SITStringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;

public class SinsurBaseImportService {
    private static final Log logger = LogFactory.getLog(SinsurBaseImportService.class);
    List<String> dropDownList = Arrays.asList(ResManager.loadKDString((String)"\u662f", (String)"SinsurBaseImportService_15", (String)"sit-hcsi-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5426", (String)"SinsurBaseImportService_16", (String)"sit-hcsi-business", (Object[])new Object[0]));

    public String exportExcelTemplate(HRPageCache pageCache, String type, long welfarepayerId, long coanddimrefId, long sinSurStdId, boolean isTemplate) {
        List personIdList = (List)pageCache.get("sinsurbase_import_userid", List.class);
        return this.exportStdBaseExcelTemplate(personIdList, welfarepayerId, coanddimrefId, sinSurStdId, isTemplate, type);
    }

    public String exportStdBaseExcelTemplate(List<Long> personIdList, long welfarepayerId, long coanddimrefId, long sinSurStdId, boolean isTemplate, String type) {
        String url = "";
        try (SXSSFWorkbook wb = new SXSSFWorkbook();){
            String dd = String.valueOf(new Date().getTime());
            String exportFileName = SITStringUtils.equals((String)"1", (String)type) ? MessageFormat.format(ResManager.loadKDString((String)"\u6dfb\u52a0\u53ca\u66f4\u65b0\u53c2\u4fdd\u6807\u51c6\u53ca\u9669\u79cd\u57fa\u6570_\u5bfc\u5165\u6a21\u677f_{0}.xlsx", (String)"SinsurBaseImportService_17", (String)"sit-hcsi-business", (Object[])new Object[0]), dd) : MessageFormat.format(ResManager.loadKDString((String)"\u4ec5\u66f4\u65b0\u9669\u79cd\u57fa\u6570_\u5bfc\u5165\u6a21\u677f_{0}.xlsx", (String)"SinsurBaseImportService_0", (String)"sit-hcsi-business", (Object[])new Object[0]), dd);
            List<Map<String, String>> personDataList = this.assemblePersonDataList(personIdList);
            this.createStdBaseDataSheet(wb, personDataList, isTemplate, coanddimrefId, sinSurStdId, type, null, null, null);
            url = ExcelHelper.storeFile((Workbook)wb, (String)exportFileName);
        }
        catch (Exception exception) {
            logger.error("SinsurBaseImportService  error : ", (Throwable)exception);
        }
        return url;
    }

    public String genErrDataExcel(List<Map<Integer, String>> dataHead, List<Map<Integer, String>> dataRow, List<Map<String, String>> errDataList, String type, Long coanddimrefId, long sinSurStdId) {
        String url = "";
        try (SXSSFWorkbook wb = new SXSSFWorkbook();){
            String dd = String.valueOf(new Date().getTime());
            String exportFileName = SITStringUtils.equals((String)"1", (String)type) ? MessageFormat.format(ResManager.loadKDString((String)"\u6dfb\u52a0\u53ca\u66f4\u65b0\u53c2\u4fdd\u6807\u51c6\u53ca\u9669\u79cd\u57fa\u6570_\u6570\u636e\u5bfc\u5165\u5931\u8d25\u7ed3\u679c_{0}.xlsx", (String)"SinsurBaseImportService_45", (String)"sit-hcsi-business", (Object[])new Object[0]), dd) : MessageFormat.format(ResManager.loadKDString((String)"\u4ec5\u66f4\u65b0\u9669\u79cd\u57fa\u6570_\u6570\u636e\u5bfc\u5165\u5931\u8d25\u7ed3\u679c_{0}.xlsx", (String)"SinsurBaseImportService_46", (String)"sit-hcsi-business", (Object[])new Object[0]), dd);
            this.createStdBaseDataSheet(wb, null, false, coanddimrefId, sinSurStdId, type, dataHead, dataRow, errDataList);
            url = ExcelHelper.storeFile((Workbook)wb, (String)exportFileName);
        }
        catch (Exception exception) {
            logger.error("SinsurBaseImportService_genErrDataExcel_error ", (Throwable)exception);
        }
        return url;
    }

    private void createStdBaseDataSheet(SXSSFWorkbook wb, List<Map<String, String>> personDataList, boolean isTemplate, long coanddimrefId, long sinSurStdId, String type, List<Map<Integer, String>> dataHeader, List<Map<Integer, String>> dataRow, List<Map<String, String>> errDataList) {
        int dataIndex;
        int headIndex;
        List<List<Map<String, Object>>> descList;
        SXSSFSheet sheet = wb.createSheet();
        sheet.setRandomAccessWindowSize(-1);
        HashMap<String, String> descMap = new HashMap<String, String>(2);
        List<List<Map<String, Object>>> headList = this.getHeaderListByType(coanddimrefId, sinSurStdId, type, descMap);
        if (SITStringUtils.equals((String)"1", (String)type)) {
            descList = this.assembleStdBaseDescList(descMap);
            headIndex = 4;
            dataIndex = 6;
        } else {
            SinSurFileBaseImportAddExcelColumnEvent sinSurFileBaseImportAddExcelColumnEvent = new SinSurFileBaseImportAddExcelColumnEvent(headList);
            SinSurFileStdServiceHelper.addExcelColumn(sinSurFileBaseImportAddExcelColumnEvent);
            descList = this.assembleOnlyBaseDescDataList();
            headIndex = 2;
            dataIndex = 4;
        }
        this.setSheetColumnWidth(sheet, headList.get(0).size(), isTemplate);
        if (isTemplate) {
            this.writeDescAndHeaderRow(0, sheet, descList, isTemplate, dataHeader, "");
            this.writeDescAndHeaderRow(headIndex, sheet, headList, isTemplate, dataHeader, "");
            List<List<Map<String, Object>>> personList = this.assemblePersonList(personDataList);
            if (!SITListUtil.isEmpty(personList)) {
                this.writeExportPersonData(dataIndex, sheet, personList, isTemplate);
            }
        } else {
            this.writeDescAndHeaderRow(0, sheet, headList, isTemplate, dataHeader, type);
            this.writeErrorPersonData(dataRow, dataIndex, sheet, errDataList);
        }
    }

    private void writeErrorPersonData(List<Map<Integer, String>> dataRow, int dataIndex, SXSSFSheet sheet, List<Map<String, String>> errDataList) {
        Map errMap = errDataList.stream().collect(Collectors.toMap(key -> (String)key.get("dataIndex"), Function.identity(), (v1, v2) -> v1));
        CellStyle redColumnStyle = SinsurBaseImportService.getColumnStyle(true, 0, 0, SITShowType.TEXT.getCode(), HorizontalAlignment.GENERAL, sheet.getWorkbook(), (short)9, true);
        Font font = sheet.getWorkbook().createFont();
        font.setColor((short)10);
        redColumnStyle.setFont(font);
        Map errMsgMap = (Map)errMap.get("0");
        if (errMsgMap != null) {
            if (SITListUtil.isEmpty(dataRow)) {
                SXSSFRow errRow = sheet.createRow(dataIndex);
                SXSSFCell cell = errRow.createCell(0);
                cell.setCellValue((String)errMsgMap.get("errMsg"));
                cell.setCellStyle(redColumnStyle);
            } else {
                for (Map<Integer, String> data : dataRow) {
                    SXSSFRow row = sheet.createRow(dataIndex);
                    SXSSFCell sXSSFCell = row.createCell(0);
                    sXSSFCell.setCellValue((String)errMsgMap.get("errMsg"));
                    sXSSFCell.setCellStyle(redColumnStyle);
                    for (Map.Entry<Integer, String> cellData : data.entrySet()) {
                        SXSSFCell dataCell = row.createCell(cellData.getKey() + 1);
                        dataCell.setCellValue(cellData.getValue());
                    }
                    ++dataIndex;
                }
            }
        } else {
            HashMap<String, Map<Integer, String>> dataMap = new HashMap<String, Map<Integer, String>>(16);
            int index = dataIndex + 1;
            for (Map<Integer, String> map : dataRow) {
                dataMap.put(index + "", map);
                ++index;
            }
            for (Map.Entry entry : errMap.entrySet()) {
                Map errMsgMap1 = (Map)entry.getValue();
                SXSSFRow row = sheet.createRow(dataIndex);
                SXSSFCell errCell = row.createCell(0);
                errCell.setCellValue((String)errMsgMap1.get("errMsg"));
                errCell.setCellStyle(redColumnStyle);
                Map dataRowMap = (Map)dataMap.get(entry.getKey());
                if (dataRowMap != null) {
                    for (Map.Entry cellData : dataRowMap.entrySet()) {
                        SXSSFCell cell = row.createCell((Integer)cellData.getKey() + 1);
                        cell.setCellValue((String)cellData.getValue());
                    }
                }
                ++dataIndex;
            }
        }
    }

    public Map<String, String> assembleErrMap(int dataIndex, boolean isAll, String fileNumber, String msg) {
        HashMap<String, String> errMap = new HashMap<String, String>(4);
        errMap.put("fileNumber", fileNumber);
        errMap.put("errMsg", msg);
        errMap.put("isAll", isAll ? "1" : "0");
        errMap.put("dataIndex", String.valueOf(dataIndex));
        return errMap;
    }

    public List<List<Map<String, Object>>> getHeaderListByType(long coanddimrefId, long sinSurStdId, String type, Map<String, String> descMap) {
        List<List<Map<String, Object>>> headList = SITStringUtils.equals((String)"1", (String)type) ? this.assembleStdBaseHeaderList(coanddimrefId, sinSurStdId, descMap) : this.assembleOnlyBaseHeaderList();
        return headList;
    }

    private List<List<Map<String, Object>>> assembleStdBaseDescList(Map<String, String> descMap) {
        ArrayList<List<Map<String, Object>>> descList = new ArrayList<List<Map<String, Object>>>(2);
        ArrayList rowList1 = new ArrayList(1);
        ArrayList rowList2 = new ArrayList(1);
        ArrayList rowList3 = new ArrayList(1);
        ArrayList rowList4 = new ArrayList(1);
        HashMap<String, Object> cellMap11 = new HashMap<String, Object>(2);
        cellMap11.put("index", 0);
        cellMap11.put("value", MessageFormat.format(ResManager.loadKDString((String)"\u53c2\u4fdd\u5355\u4f4d=\u201c{0}\u201d", (String)"SinsurBaseImportService_42", (String)"sit-hcsi-business", (Object[])new Object[0]), descMap.get("welFarePayerName")));
        HashMap<String, Object> cellMap21 = new HashMap<String, Object>(2);
        cellMap21.put("index", 0);
        cellMap21.put("value", MessageFormat.format(ResManager.loadKDString((String)"\u53c2\u4fdd\u6807\u51c6=\u201c{0}\u201d", (String)"SinsurBaseImportService_43", (String)"sit-hcsi-business", (Object[])new Object[0]), descMap.get("sinSurStdName")));
        HashMap<String, Object> cellMap22 = new HashMap<String, Object>(2);
        cellMap22.put("index", 1);
        cellMap22.put("value", MessageFormat.format(ResManager.loadKDString((String)"\u5173\u8054\u53c2\u4fdd\u6807\u51c6=\u201c{0}\u201d", (String)"SinsurBaseImportService_47", (String)"sit-hcsi-business", (Object[])new Object[0]), descMap.get("coanddimref")));
        HashMap<String, Object> cellMap31 = new HashMap<String, Object>(2);
        cellMap31.put("index", 0);
        cellMap31.put("value", ResManager.loadKDString((String)"\u793e\u4fdd\u57fa\u6570\u8bbe\u7f6e #", (String)"SinsurBaseImportService_11", (String)"sit-hcsi-business", (Object[])new Object[0]));
        HashMap<String, Object> cellMap41 = new HashMap<String, Object>(3);
        cellMap41.put("index", 0);
        cellMap41.put("value", ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\r\n2\u3001\u7ea2\u8272\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5\r\n#SetNULL\uff08\u542f\u7528\u5355\u5143\u683c\u8f93\u5165NULL\u6e05\u7a7a\u5b57\u6bb5\uff09\r\n3.\u5f53\u5404\u4e2a\u9669\u79cd\u7684\u662f\u5426\u53c2\u4fdd\u5217\u9009\u62e9\u201c\u5426\u201d\u65f6\uff0c\u4e0d\u9700\u586b\u5199\u9669\u79cd\u7684\u4e2a\u4eba\u7f34\u8d39\u57fa\u6570\u3001\u5355\u4f4d\u7f34\u8d39\u57fa\u6570", (String)"SinsurBaseImportService_44", (String)"sit-hcsi-business", (Object[])new Object[0]));
        cellMap41.put("color", Boolean.TRUE);
        rowList1.add(cellMap11);
        rowList2.add(cellMap21);
        rowList2.add(cellMap22);
        rowList3.add(cellMap31);
        rowList4.add(cellMap41);
        descList.add(rowList1);
        descList.add(rowList2);
        descList.add(rowList3);
        descList.add(rowList4);
        return descList;
    }

    private List<List<Map<String, Object>>> assembleStdBaseHeaderList(long coanddimrefId, long sinSurStdId, Map<String, String> descMap) {
        ArrayList<List<Map<String, Object>>> headerList = new ArrayList<List<Map<String, Object>>>(2);
        ArrayList<Map<String, Object>> numberList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> nameList = new ArrayList<Map<String, Object>>(10);
        List<String> fixedNumberList = Arrays.asList("sinsurfile.number", "name", "empnumber", "bsed");
        List<String> fixedNameList = this.assembleFixedNameList();
        List<String> numberAfterFixList = Arrays.asList("insured", "personalcontribution", "companycontribution", "remarks");
        List<String> nameAfterFixList = Arrays.asList(ResManager.loadKDString((String)"\u662f\u5426\u53c2\u4fdd", (String)"SinsurBaseImportService_18", (String)"sit-hcsi-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e2a\u4eba\u7f34\u8d39\u57fa\u6570", (String)"SinsurBaseImportService_19", (String)"sit-hcsi-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u4f4d\u7f34\u8d39\u57fa\u6570", (String)"SinsurBaseImportService_20", (String)"sit-hcsi-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5907\u6ce8", (String)"SinsurBaseImportService_21", (String)"sit-hcsi-business", (Object[])new Object[0]));
        headerList.add(numberList);
        headerList.add(nameList);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_coanddimref");
        QFilter filter = new QFilter("id", "=", (Object)coanddimrefId);
        DynamicObject sinSurStdObj = helper.queryOne("welfarepayer.name,datastatus", new QFilter[]{filter});
        if (sinSurStdObj == null) {
            return headerList;
        }
        helper = new HRBaseServiceHelper("sitbs_sinsurstd");
        DynamicObject sinSurStd = helper.queryOne("id,name,stdentryentity.insurtype", (Object)sinSurStdId);
        DynamicObjectCollection sinsurstdObjs = sinSurStd.getDynamicObjectCollection("stdentryentity");
        descMap.put("welFarePayerName", sinSurStdObj.getString("welfarepayer.name"));
        descMap.put("sinSurStdName", sinSurStd.getString("name"));
        descMap.put("coanddimref", coanddimrefId + "");
        descMap.put("dataStatus", sinSurStdObj.getString("datastatus"));
        this.assembleFixNumberNameList(numberList, nameList, fixedNumberList, fixedNameList);
        if (!SITListUtil.isEmpty((List)sinsurstdObjs)) {
            for (DynamicObject stdobj : sinsurstdObjs) {
                String number = stdobj.getString("insurtype.number");
                String name = stdobj.getString("insurtype.name");
                this.addSinSurStdColumn(number, name, numberList, nameList, numberAfterFixList, nameAfterFixList);
            }
        }
        return headerList;
    }

    private void addSinSurStdColumn(String number, String name, List<Map<String, Object>> numberList, List<Map<String, Object>> nameList, List<String> tempNumberList, List<String> tempNameList) {
        HashMap<String, Object> columnMap;
        int index = numberList.size();
        for (int i = 0; i < tempNumberList.size(); ++i) {
            columnMap = new HashMap<String, Object>(2);
            columnMap.put("index", i + index);
            columnMap.put("value", number + "." + tempNumberList.get(i));
            columnMap.put("header", Boolean.FALSE);
            numberList.add(columnMap);
        }
        for (int j = 0; j < tempNameList.size(); ++j) {
            columnMap = new HashMap(4);
            columnMap.put("index", j + index);
            columnMap.put("value", name + "." + tempNameList.get(j));
            columnMap.put("header", Boolean.TRUE);
            if (j == 0) {
                columnMap.put("color", Boolean.TRUE);
                columnMap.put("mustInput", Boolean.TRUE);
                columnMap.put("isDropDown", Boolean.TRUE);
                columnMap.put("dropDownList", this.dropDownList);
            }
            nameList.add(columnMap);
        }
    }

    private void assembleFixNumberNameList(List<Map<String, Object>> numberList, List<Map<String, Object>> nameList, List<String> fixedNumberList, List<String> fixedNameList) {
        int i;
        for (i = 0; i < fixedNumberList.size(); ++i) {
            HashMap<String, Object> fixedNumberMap = new HashMap<String, Object>(2);
            fixedNumberMap.put("index", i);
            fixedNumberMap.put("value", fixedNumberList.get(i));
            fixedNumberMap.put("header", Boolean.FALSE);
            numberList.add(fixedNumberMap);
        }
        for (i = 0; i < fixedNameList.size(); ++i) {
            HashMap<String, Object> fixedNameMap = new HashMap<String, Object>(2);
            fixedNameMap.put("index", i);
            fixedNameMap.put("value", fixedNameList.get(i));
            fixedNameMap.put("header", Boolean.TRUE);
            if (i == 0 || i == 3) {
                fixedNameMap.put("color", Boolean.TRUE);
                fixedNameMap.put("mustInput", Boolean.TRUE);
            }
            nameList.add(fixedNameMap);
        }
    }

    private List<String> assembleFixedNameList() {
        List<String> list = Arrays.asList(ResManager.loadKDString((String)"\u793e\u4fdd\u6863\u6848.\u6863\u6848\u7f16\u53f7", (String)"SinsurBaseImportService_1", (String)"sit-hcsi-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u59d3\u540d", (String)"SinsurBaseImportService_2", (String)"sit-hcsi-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5de5\u53f7", (String)"SinsurBaseImportService_3", (String)"sit-hcsi-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"SinsurBaseImportService_6", (String)"sit-hcsi-business", (Object[])new Object[0]));
        return list;
    }

    private List<List<Map<String, Object>>> assemblePersonList(List<Map<String, String>> personDataList) {
        ArrayList<List<Map<String, Object>>> personList = new ArrayList<List<Map<String, Object>>>(personDataList.size());
        if (!SITListUtil.isEmpty(personDataList)) {
            for (Map<String, String> person : personDataList) {
                ArrayList rowList = new ArrayList(3);
                HashMap<String, Object> numberMap = new HashMap<String, Object>(2);
                numberMap.put("index", 0);
                numberMap.put("value", person.get("number"));
                HashMap<String, Object> nameMap = new HashMap<String, Object>(2);
                nameMap.put("index", 1);
                nameMap.put("value", person.get("name"));
                HashMap<String, Object> empNumberMap = new HashMap<String, Object>(2);
                empNumberMap.put("index", 2);
                empNumberMap.put("value", person.get("empnumber"));
                rowList.add(numberMap);
                rowList.add(nameMap);
                rowList.add(empNumberMap);
                personList.add(rowList);
            }
        }
        return personList;
    }

    private void writeExportPersonData(int startIndex, SXSSFSheet sheet, List<List<Map<String, Object>>> personDataList, boolean isTemplate) {
        for (List<Map<String, Object>> personData : personDataList) {
            SXSSFRow row = sheet.createRow(startIndex);
            for (Map<String, Object> cellData : personData) {
                int cellIndex = (Integer)cellData.get("index");
                SXSSFCell cell = row.createCell(isTemplate ? cellIndex : cellIndex + 1);
                cell.setCellValue((String)cellData.get("value"));
            }
            ++startIndex;
        }
    }

    private List<List<Map<String, Object>>> assembleOnlyBaseHeaderList() {
        ArrayList<List<Map<String, Object>>> headerList = new ArrayList<List<Map<String, Object>>>(10);
        ArrayList numberRowList = new ArrayList(10);
        ArrayList nameRowList = new ArrayList(10);
        List<String> numberList = Arrays.asList("sinsurfile.number", "name", "empnumber", "welfaretype.name", "bsed", "insured", "personalcontribution", "companycontribution", "remarks");
        List<Integer> mustInputColumn = Arrays.asList(0, 3, 4, 5);
        List<Integer> isDropDownColumn = Collections.singletonList(5);
        List<String> nameList = this.assembleOnlyBaseHeaderNameList();
        for (int i = 0; i < numberList.size(); ++i) {
            HashMap<String, Object> numberCellMap = new HashMap<String, Object>(3);
            numberCellMap.put("index", i);
            numberCellMap.put("value", numberList.get(i));
            numberCellMap.put("header", Boolean.FALSE);
            numberRowList.add(numberCellMap);
        }
        for (int j = 0; j < nameList.size(); ++j) {
            HashMap<String, Object> nameCellMap = new HashMap<String, Object>(4);
            nameCellMap.put("index", j);
            nameCellMap.put("value", nameList.get(j));
            nameCellMap.put("header", Boolean.TRUE);
            if (mustInputColumn.contains(j)) {
                nameCellMap.put("color", Boolean.TRUE);
                nameCellMap.put("mustInput", Boolean.TRUE);
            }
            if (isDropDownColumn.contains(j)) {
                nameCellMap.put("isDropDown", Boolean.TRUE);
                nameCellMap.put("dropDownList", this.dropDownList);
            }
            nameRowList.add(nameCellMap);
        }
        headerList.add(numberRowList);
        headerList.add(nameRowList);
        return headerList;
    }

    private List<String> assembleOnlyBaseHeaderNameList() {
        List<String> nameList = Arrays.asList(ResManager.loadKDString((String)"\u793e\u4fdd\u6863\u6848.\u6863\u6848\u7f16\u53f7", (String)"SinsurBaseImportService_1", (String)"sit-hcsi-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u59d3\u540d", (String)"SinsurBaseImportService_2", (String)"sit-hcsi-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5de5\u53f7", (String)"SinsurBaseImportService_3", (String)"sit-hcsi-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9669\u79cd.\u540d\u79f0", (String)"SinsurBaseImportService_5", (String)"sit-hcsi-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"SinsurBaseImportService_6", (String)"sit-hcsi-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u662f\u5426\u53c2\u4fdd", (String)"SinsurBaseImportService_7", (String)"sit-hcsi-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e2a\u4eba\u7f34\u8d39\u57fa\u6570", (String)"SinsurBaseImportService_8", (String)"sit-hcsi-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u4f4d\u7f34\u8d39\u57fa\u6570", (String)"SinsurBaseImportService_9", (String)"sit-hcsi-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5907\u6ce8", (String)"SinsurBaseImportService_10", (String)"sit-hcsi-business", (Object[])new Object[0]));
        return nameList;
    }

    private void writeDescAndHeaderRow(int startIndex, SXSSFSheet sheet, List<List<Map<String, Object>>> descList, boolean isTemplate, List<Map<Integer, String>> dataHeader, String type) {
        CellStyle columnStyle = SinsurBaseImportService.getColumnStyle(true, 0, 0, SITShowType.TEXT.getCode(), HorizontalAlignment.GENERAL, sheet.getWorkbook(), (short)9, true);
        CellStyle headerColumnStyle = SinsurBaseImportService.getColumnStyle(true, 0, 0, SITShowType.TEXT.getCode(), HorizontalAlignment.GENERAL, sheet.getWorkbook(), (short)22, true);
        CellStyle redHeaderColumnStyle = SinsurBaseImportService.getColumnStyle(true, 0, 0, SITShowType.TEXT.getCode(), HorizontalAlignment.GENERAL, sheet.getWorkbook(), (short)22, true);
        CellStyle redColumnStyle = SinsurBaseImportService.getColumnStyle(true, 0, 0, SITShowType.TEXT.getCode(), HorizontalAlignment.GENERAL, sheet.getWorkbook(), (short)9, true);
        Font font = sheet.getWorkbook().createFont();
        font.setColor((short)10);
        redColumnStyle.setFont(font);
        redHeaderColumnStyle.setFont(font);
        List<Integer> errRedCellList1 = Arrays.asList(1, 4, 5, 9, 13, 17, 21);
        List<Integer> errRedCellList2 = Arrays.asList(1, 4, 5, 6);
        if (isTemplate) {
            for (List<Map<String, Object>> rowData : descList) {
                SXSSFRow row = sheet.createRow(startIndex);
                this.createCellData(sheet, isTemplate, columnStyle, headerColumnStyle, redHeaderColumnStyle, redColumnStyle, rowData, row);
                ++startIndex;
            }
        } else {
            for (int i = 0; i < dataHeader.size(); ++i) {
                SXSSFRow row = sheet.createRow(i);
                Map<Integer, String> cellMap = dataHeader.get(i);
                this.createErrCellData(type, headerColumnStyle, redHeaderColumnStyle, redColumnStyle, errRedCellList1, errRedCellList2, i, row, cellMap);
            }
        }
    }

    private void createErrCellData(String type, CellStyle headerColumnStyle, CellStyle redHeaderColumnStyle, CellStyle redColumnStyle, List<Integer> errRedCellList1, List<Integer> errRedCellList2, int index, SXSSFRow row, Map<Integer, String> cellMap) {
        for (Map.Entry<Integer, String> cellEntry : cellMap.entrySet()) {
            SXSSFCell cell = row.createCell(cellEntry.getKey() + 1);
            cell.setCellValue(cellEntry.getValue());
            if (SITStringUtils.equals((String)"1", (String)type)) {
                if (index == 3) {
                    cell.setCellStyle(redColumnStyle);
                    continue;
                }
                if (index != 5) continue;
                if (errRedCellList1.contains(cellEntry.getKey() + 1)) {
                    cell.setCellStyle(redHeaderColumnStyle);
                    continue;
                }
                cell.setCellStyle(headerColumnStyle);
                continue;
            }
            if (!SITStringUtils.equals((String)"2", (String)type)) continue;
            if (index == 1) {
                cell.setCellStyle(redColumnStyle);
                continue;
            }
            if (index != 3) continue;
            if (errRedCellList2.contains(cellEntry.getKey() + 1)) {
                cell.setCellStyle(redHeaderColumnStyle);
                continue;
            }
            cell.setCellStyle(headerColumnStyle);
        }
    }

    private void createCellData(SXSSFSheet sheet, boolean isTemplate, CellStyle columnStyle, CellStyle headerColumnStyle, CellStyle redHeaderColumnStyle, CellStyle redColumnStyle, List<Map<String, Object>> rowData, SXSSFRow row) {
        for (Map<String, Object> cellData : rowData) {
            int cellIndex = (Integer)cellData.get("index");
            SXSSFCell cell = row.createCell(isTemplate ? cellIndex : cellIndex + 1);
            String value = cellData.get("mustInput") != null && (Boolean)cellData.get("mustInput") != false ? "*" + cellData.get("value") : (String)cellData.get("value");
            cell.setCellValue(value);
            if (cellData.get("header") != null && ((Boolean)cellData.get("header")).booleanValue()) {
                cell.setCellStyle(headerColumnStyle);
            } else {
                cell.setCellStyle(columnStyle);
            }
            if (cellData.get("color") != null && ((Boolean)cellData.get("color")).booleanValue()) {
                if (cellData.get("header") != null && ((Boolean)cellData.get("header")).booleanValue()) {
                    cell.setCellStyle(redHeaderColumnStyle);
                } else {
                    cell.setCellStyle(redColumnStyle);
                }
            }
            if (cellData.get("isDropDown") == null || !((Boolean)cellData.get("isDropDown")).booleanValue()) continue;
            SinsurBaseImportService.setCellValidation((Sheet)sheet, (Cell)cell, (List)cellData.get("dropDownList"));
        }
    }

    private static void setCellValidation(Sheet sheet, Cell cell, List<String> dropDownVals) {
        DataValidationHelper helper = sheet.getDataValidationHelper();
        int lastCellNum = cell.getColumnIndex();
        CellRangeAddressList addressList = new CellRangeAddressList(cell.getRowIndex() + 1, 10000, lastCellNum, lastCellNum);
        DataValidationConstraint constraint = helper.createExplicitListConstraint(dropDownVals.toArray(new String[dropDownVals.size()]));
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }

    private void addRowInfo(boolean isErr, int index, SXSSFSheet sheet, String value, String name, CellStyle taskDescColumnStyle) {
        SXSSFRow row = sheet.createRow(index);
        SXSSFCell nameCell = row.createCell(isErr ? 1 : 0);
        SXSSFCell valueCell = row.createCell(isErr ? 2 : 1);
        nameCell.setCellValue(name);
        valueCell.setCellValue(value);
        nameCell.setCellStyle(taskDescColumnStyle);
        valueCell.setCellStyle(taskDescColumnStyle);
    }

    public static CellStyle getColumnStyle(boolean isTmpl, int precision, int scale, String columnType, HorizontalAlignment alignment, SXSSFWorkbook wb, short colorIndex, boolean needBoard) {
        short format;
        CellStyle headColumnStyle = wb.createCellStyle();
        DataFormat dataFormat = wb.createDataFormat();
        if (!isTmpl) {
            if (SITStringUtils.equals((String)SITShowType.DATE.getCode(), (String)columnType)) {
                format = dataFormat.getFormat("yyyy-MM-dd");
            } else if (SITStringUtils.equals((String)SITShowType.AMOUNT.getCode(), (String)columnType)) {
                String amountFormat = SinsurBaseImportService.getAmountFormat(precision);
                format = dataFormat.getFormat(amountFormat);
            } else if (SITStringUtils.equals((String)SITShowType.NUM.getCode(), (String)columnType)) {
                String amountFormat = SinsurBaseImportService.getAmountFormat(scale);
                format = dataFormat.getFormat(amountFormat);
            } else {
                format = dataFormat.getFormat("text");
            }
        } else {
            format = SITStringUtils.equals((String)SITShowType.DATE.getCode(), (String)columnType) ? dataFormat.getFormat("yyyy-MM-dd") : dataFormat.getFormat("text");
        }
        headColumnStyle.setDataFormat(format);
        if (needBoard) {
            headColumnStyle.setBorderBottom(BorderStyle.HAIR);
            headColumnStyle.setBorderTop(BorderStyle.HAIR);
            headColumnStyle.setBorderLeft(BorderStyle.HAIR);
            headColumnStyle.setBorderRight(BorderStyle.HAIR);
        }
        headColumnStyle.setFillForegroundColor(colorIndex);
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(alignment);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.JUSTIFY);
        headColumnStyle.setHidden(true);
        return headColumnStyle;
    }

    private static String getAmountFormat(int precision) {
        StringBuilder format = new StringBuilder("0");
        if (precision > 0) {
            format.append('.');
            for (int i = 0; i < precision; ++i) {
                format.append('0');
            }
        }
        return format.toString();
    }

    private List<List<Map<String, Object>>> assembleOnlyBaseDescDataList() {
        ArrayList<List<Map<String, Object>>> descList = new ArrayList<List<Map<String, Object>>>(2);
        ArrayList rowList1 = new ArrayList(2);
        ArrayList rowList2 = new ArrayList(3);
        HashMap<String, Object> cellMap11 = new HashMap<String, Object>(2);
        cellMap11.put("index", 0);
        cellMap11.put("value", ResManager.loadKDString((String)"\u793e\u4fdd\u57fa\u6570\u8bbe\u7f6e #", (String)"SinsurBaseImportService_11", (String)"sit-hcsi-business", (Object[])new Object[0]));
        rowList1.add(cellMap11);
        HashMap<String, Object> cellMap21 = new HashMap<String, Object>(2);
        cellMap21.put("index", 0);
        cellMap21.put("value", ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\r\n2\u3001\u7ea2\u8272\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5\r\n#SetNULL\uff08\u542f\u7528\u5355\u5143\u683c\u8f93\u5165NULL\u6e05\u7a7a\u5b57\u6bb5\uff09", (String)"SinsurBaseImportService_12", (String)"sit-hcsi-business", (Object[])new Object[0]));
        cellMap21.put("color", Boolean.TRUE);
        HashMap<String, Object> cellMap23 = new HashMap<String, Object>(2);
        cellMap23.put("index", 6);
        cellMap23.put("value", ResManager.loadKDString((String)"\u9009\u62e9\u201c\u5426\u201d\u65f6\uff0c\u4e0d\u9700\u586b\u5199\u9669\u79cd\u7684\u4e2a\u4eba\u7f34\u8d39\u57fa\u6570\u3001\u5355\u4f4d\u7f34\u8d39\u57fa\u6570", (String)"SinsurBaseImportService_14", (String)"sit-hcsi-business", (Object[])new Object[0]));
        rowList2.add(cellMap21);
        rowList2.add(cellMap23);
        descList.add(rowList1);
        descList.add(rowList2);
        return descList;
    }

    private void setSheetColumnWidth(SXSSFSheet sheet, int columnSize, boolean isTemplate) {
        List<Integer> list = Arrays.asList(5, 6, 9, 10, 13, 14, 17, 18, 21, 22);
        int columnWidth = 2048;
        if (isTemplate) {
            for (int i = 0; i < columnSize; ++i) {
                if (i == 0 || i == 1) {
                    sheet.setColumnWidth(i, columnWidth * 5);
                    continue;
                }
                if (list.contains(i)) {
                    sheet.setColumnWidth(i, columnWidth * 4);
                    continue;
                }
                sheet.setColumnWidth(i, columnWidth * 3);
            }
        } else {
            sheet.setColumnWidth(0, columnWidth * 5);
            for (int i = 1; i <= columnSize; ++i) {
                if (i == 1 || i == 2) {
                    sheet.setColumnWidth(i, columnWidth * 5);
                    continue;
                }
                if (list.contains(i - 1)) {
                    sheet.setColumnWidth(i, columnWidth * 4);
                    continue;
                }
                sheet.setColumnWidth(i, columnWidth * 3);
            }
        }
    }

    private List<Map<String, String>> assemblePersonDataList(List<Long> personIdList) {
        if (SITListUtil.isEmpty(personIdList)) {
            return new ArrayList<Map<String, String>>(0);
        }
        ArrayList<Map<String, String>> personDataList = new ArrayList<Map<String, String>>(personIdList.size());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsurfile");
        QFilter filter = new QFilter("id", "in", personIdList);
        DynamicObjectCollection objs = helper.queryOriginalCollection("number,name,employee.empnumber", new QFilter[]{filter});
        if (!SITListUtil.isEmpty((List)objs)) {
            for (DynamicObject dyObj : objs) {
                HashMap<String, String> data = new HashMap<String, String>(3);
                data.put("number", dyObj.getString("number"));
                data.put("name", dyObj.getString("name"));
                data.put("empnumber", dyObj.getString("employee.empnumber"));
                personDataList.add(data);
            }
        }
        return personDataList;
    }

    public Map<String, Long> assembleSinsurWelfareDyMap(Long sinSurStdId, Long coanddimrefId, Map<Integer, DynamicObject> columnWelfareTypeIdMap) {
        HashMap<String, Long> map = new HashMap<String, Long>(2);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_coanddimref");
        QFilter filter = new QFilter("id", "=", (Object)coanddimrefId);
        DynamicObject coandDimref = helper.queryOne("welfarepayer,bsed,bsled", new QFilter[]{filter});
        helper = new HRBaseServiceHelper("sitbs_sinsurstd");
        DynamicObject sinSurStd = helper.queryOne("id,name,stdentryentity.insurtype", (Object)sinSurStdId);
        map.put("sinsurstd", sinSurStd.getLong("id"));
        map.put("welfarepayer", coandDimref.getLong("welfarepayer.id"));
        map.put("coandDimref", coandDimref.getLong("id"));
        DynamicObjectCollection sinsurstdObjs = sinSurStd.getDynamicObjectCollection("stdentryentity");
        int columnIndex = 4;
        if (!SITListUtil.isEmpty((List)sinsurstdObjs)) {
            for (DynamicObject stdobj : sinsurstdObjs) {
                columnWelfareTypeIdMap.put(columnIndex, stdobj.getDynamicObject("insurtype"));
                columnIndex += 4;
            }
        }
        return map;
    }
}

