/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.common.util.DynamicTransformUtil;

public class SinsurFileQueryServiceHelper {
    private static final Log LOG = LogFactory.getLog(SinsurFileQueryServiceHelper.class);
    private static final HRBaseServiceHelper FILE_HELPER = new HRBaseServiceHelper("hcsi_sinsurfile");
    private static final List<String> IGNOR_ELIST = Arrays.asList("enable", "simplename", "index", "issyspreset", "disabler", "disabledate", "boid", "iscurrentversion", "datastatus", "bred", "brled", "bsed", "bsled", "ismodify", "salaryfile");

    public static Map<String, Object> querySinsurFileBoByEmp(Map<String, Object> param) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            SinsurFileQueryServiceHelper.validateParam(param, result);
            if (result.containsKey("success")) {
                return result;
            }
            List<Map<String, Object>> datas = SinsurFileQueryServiceHelper.queryFileBoByEmpCore(param);
            result.put("success", Boolean.TRUE);
            result.put("data", datas);
        }
        catch (Exception ex) {
            LOG.error("FileQueryServiceHelper...queryFile.error\uff1a", (Throwable)ex);
            result.put("success", Boolean.FALSE);
            result.put("message", ex.getMessage());
        }
        return result;
    }

    private static void validateParam(Map<String, Object> param, Map<String, Object> result) {
        try {
            if (!(param.get("employees") instanceof List) || ((List)param.get("employees")).size() == 0) {
                result.put("success", Boolean.FALSE);
                result.put("message", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\u3002", (String)"SinsurFileQueryServiceHelper_1", (String)"sit-hcsi-business", (Object[])new Object[0]));
                return;
            }
            List employees = (List)param.get("employees");
            ArrayList<Long> employeesNew = new ArrayList<Long>(10);
            for (Object empId : employees) {
                employeesNew.add(Long.parseLong(String.valueOf(empId)));
            }
            param.put("employees", employeesNew);
            List status = (List)param.get("status");
            String string = (String)param.get("selectProperties");
        }
        catch (Exception ex) {
            LOG.error("FileQueryServiceHelper...validateParam.error\uff1a", (Throwable)ex);
            result.put("success", Boolean.FALSE);
            result.put("message", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\u3002", (String)"SinsurFileQueryServiceHelper_1", (String)"sit-hcsi-business", (Object[])new Object[0]));
            return;
        }
    }

    private static List<Map<String, Object>> queryFileBoByEmpCore(Map<String, Object> param) {
        String selectProperties;
        ArrayList<String> status;
        QFilter fileIdFilter = BaseDataHisHelper.getHisCurrFilter();
        fileIdFilter.and("employee.id", "in", param.get("employees"));
        ArrayList<String> arrayList = status = param.get("status") == null ? null : (ArrayList<String>)param.get("status");
        if (status == null) {
            status = new ArrayList<String>(1);
            status.add("C");
        }
        fileIdFilter.and("status", "in", status);
        List<String> needKeys = null;
        String string = selectProperties = param.get("selectProperties") == null ? null : String.valueOf(param.get("selectProperties"));
        if (selectProperties == null || "".equals(selectProperties)) {
            selectProperties = BaseDataHisHelper.getSelectProperties((String)FILE_HELPER.getEntityName());
        } else {
            if (!selectProperties.contains("employee.id")) {
                selectProperties = selectProperties + ",employee.id";
            }
            needKeys = Arrays.asList(selectProperties.replace(" ", "").replace('.', '_').split(","));
        }
        DynamicObject[] fileDys = FILE_HELPER.query(selectProperties, new QFilter[]{fileIdFilter});
        HashSet<String> ignoreKey = new HashSet<String>(16);
        ignoreKey.addAll(IGNOR_ELIST);
        ArrayList<Map<String, Object>> fileMaps = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject fileDy : fileDys) {
            Map fileMap = DynamicTransformUtil.dynamicObjectToMap((DynamicObject)fileDy, ignoreKey, needKeys);
            fileMaps.add(fileMap);
        }
        return fileMaps;
    }
}

