/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.TipsSupport;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sit.hcsi.oppplugin.sinsurfile.ISinSurFileBsedValidatorPlugin;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.hcsi.common.constants.SinsurFileConstants;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.business.multiview.CombinePageCfgCacheService;
import kd.sit.sitbp.common.cache.SITPageCache;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITMServiceUtils;
import kd.sit.sitbp.common.util.SitDateUtil;

public class SinsurFileServiceHelper
implements SinsurFileConstants {
    private static final Log logger = LogFactory.getLog(SinsurFileServiceHelper.class);

    public static void setTipsByHrcs(IFormView view, String controlKey) {
        Tips tips = new Tips();
        List tipsStr = (List)SITMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptForString", (Object[])new Object[]{view.getModel().getDataEntityType().getName(), controlKey, view.getModel().getDataEntity()});
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)tipsStr)) {
            tips.setContent(new LocaleString((String)tipsStr.get(0)));
            tips.setType("text");
            tips.setTriggerType("hover");
            tips.setIsConfirm(false);
            tips.setShowIcon(true);
            TipsSupport control = (TipsSupport)view.getControl(controlKey);
            control.addTips(tips);
        }
    }

    public static DynamicObject queryFile(Object fileId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
        return serviceHelper.queryOne(BaseDataHisHelper.getSelectProperties((String)"hcsi_sinsurfile"), fileId);
    }

    public static DynamicObject[] queryFile(List<Long> fileId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
        QFilter qFilter = new QFilter("id", "in", fileId);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public static String openFileBase(DynamicObject fileDy, IFormView formView, boolean isOnlyView) {
        Long pkId = fileDy.getLong("id");
        Map<String, String> relateFileIds = SinsurFileServiceHelper.queryAllFileRelatedPkId(fileDy);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("taxregionid", fileDy.getLong("manageregion.id"));
        params.put("businesstype", "20");
        Map dynFileInfo = (Map)SITMServiceUtils.invokeSITService((String)"sitbs", (String)"ISITBSService", (String)"getPageCfgMapByTaxRegionId", (Object[])new Object[]{params});
        if (!Objects.isNull(dynFileInfo) && !dynFileInfo.isEmpty()) {
            if (!Objects.isNull(dynFileInfo.get("cfgid"))) {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId(String.valueOf(dynFileInfo.get("formid")));
                formShowParameter.setPageId(formView.getPageId() + pkId);
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                String name = fileDy.getString("person.name");
                formShowParameter.setCaption(MessageFormat.format(ResManager.loadKDString((String)"\u4eba\u5458\u793e\u4fdd\u6863\u6848 - {0}", (String)"SinsurFileServiceHelper_0", (String)"sit-hcsi-business", (Object[])new Object[0]), name));
                formShowParameter.setCustomParam("employeeId", fileDy.get("employee.id"));
                formShowParameter.setCustomParam("sinsur_file_id", (Object)pkId);
                formShowParameter.setCustomParam("cfgid", dynFileInfo.get("cfgid"));
                formShowParameter.setCustomParam("mainDataId", (Object)fileDy.getLong("boid"));
                formShowParameter.setCustomParam("mainEntityNumber", (Object)"hcsi_sinsurfile");
                formShowParameter.setCustomParam("mainStatus", (Object)fileDy.getString("status"));
                formShowParameter.setCustomParam("relateFileIds", relateFileIds);
                formShowParameter.setCustomParam("status", fileDy.get("status"));
                if (isOnlyView) {
                    formShowParameter.setCustomParam("isOnlyView", (Object)"true");
                }
                formShowParameter.setCustomParam("name", (Object)name);
                formView.showForm(formShowParameter);
                return formShowParameter.getPageId();
            }
            formView.showErrorNotification((String)dynFileInfo.get("resultMsg"));
        } else {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u591a\u89c6\u56fe\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u591a\u89c6\u56fe\u914d\u7f6e\u3002", (String)"SinsurFileServiceHelper_1", (String)"sit-itc-business", (Object[])new Object[0]));
        }
        return null;
    }

    public static Map<String, String> queryAllFileRelatedPkId(DynamicObject fileDy) {
        HashMap<String, String> result = new HashMap<String, String>(8);
        result.put("hcsi_sinsurfile", fileDy.getString("id"));
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hcsi_sinsurperson");
        QFilter qFilter = new QFilter("person", "=", fileDy.get("person.id"));
        QFilter placeofwelfareFilter = new QFilter("placeofwelfare", "=", fileDy.get("welfarepayer.placeofwelfare.id"));
        BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        DynamicObject personDyObj = personHelper.loadDynamicObject(new QFilter[]{qFilter, placeofwelfareFilter});
        if (personDyObj != null) {
            result.put("hcsi_sinsurperson", personDyObj.getString("id"));
            DynamicObject fileSinSurStd = SinSurFileStdServiceHelper.queryCurrentVersionFileSinSurStd(Long.valueOf(fileDy.getString("id")));
            if (fileSinSurStd != null) {
                result.put("hcsi_sinsurfilestd", fileSinSurStd.getString("id"));
            }
        }
        return result;
    }

    public static Map<String, List<Long>> getFileMultiEntityPkIds(EndOperationTransactionArgs args) {
        if (args.getDataEntities().length != 0) {
            return SinsurFileServiceHelper.queryAllFileRelatedPkIds(args.getDataEntities());
        }
        return new HashMap<String, List<Long>>();
    }

    private static Map<String, List<Long>> queryAllFileRelatedPkIds(DynamicObject[] sinSurFiles) {
        HashSet<Long> personIds = new HashSet<Long>(16);
        HashSet<Long> placeOfWelfareIds = new HashSet<Long>(16);
        HashSet keyOfPerson = Sets.newHashSetWithExpectedSize((int)sinSurFiles.length);
        int size = sinSurFiles.length;
        for (int i = 0; i < size; ++i) {
            long personId = sinSurFiles[i].getLong("person.id");
            long placeId = sinSurFiles[i].getLong("welfarepayer.placeofwelfare.id");
            personIds.add(personId);
            placeOfWelfareIds.add(placeId);
            keyOfPerson.add(personId + "_" + placeId);
        }
        QFilter qFilter = new QFilter("person", "in", personIds);
        QFilter placeOfWelfareFilter = new QFilter("placeofwelfare", "in", placeOfWelfareIds);
        QFilter statusFilter = new QFilter("status", "=", (Object)"A");
        BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hcsi_sinsurperson");
        DynamicObject[] personDyObjs = personHelper.loadDynamicObjectArray(new QFilter[]{qFilter, placeOfWelfareFilter, statusFilter});
        HashMap<String, List<Long>> dataMap = new HashMap<String, List<Long>>();
        if (personDyObjs != null && personDyObjs.length >= 1) {
            List sinSurPersonIds = Arrays.stream(personDyObjs).filter(ele -> keyOfPerson.contains(ele.getString("person.id") + "_" + ele.getString("placeofwelfare.id"))).map(row -> row.getLong("id")).collect(Collectors.toList());
            dataMap.put("hcsi_sinsurperson", sinSurPersonIds);
        }
        List<Long> fileIds = Arrays.stream(sinSurFiles).map(ele -> ele.getLong("id")).collect(Collectors.toList());
        SinsurFileServiceHelper.queryFileSinSurStd(fileIds, dataMap);
        SinsurFileServiceHelper.queryFileSinSurBase(fileIds, dataMap);
        return dataMap;
    }

    private static void queryFileSinSurBase(List<Long> fileIds, Map<String, List<Long>> datas) {
        ArrayList<Long> fileSinSurBaseIds = new ArrayList<Long>(10);
        DynamicObjectCollection fileSinSurBases = SinSurFileStdServiceHelper.queryCurrentVersionSinSurBase(fileIds);
        for (DynamicObject fileSinSurBase : fileSinSurBases) {
            fileSinSurBaseIds.add(fileSinSurBase.getLong("id"));
        }
        datas.put("hcsi_sinsurbase", fileSinSurBaseIds);
    }

    private static void queryFileSinSurStd(List<Long> fileIds, Map<String, List<Long>> datas) {
        ArrayList<Long> fileSinSurStdIds = new ArrayList<Long>(10);
        DynamicObjectCollection fileSinSurStds = SinSurFileStdServiceHelper.queryCurrentVersionFileSinSurStd(fileIds);
        for (DynamicObject fileSinSurStd : fileSinSurStds) {
            fileSinSurStdIds.add(fileSinSurStd.getLong("id"));
        }
        datas.put("hcsi_sinsurfilestd", fileSinSurStdIds);
    }

    private static void addInputPkIdList(List<Long> pkIds, String dbFieldId, ResultSet rs) {
        try {
            if (null != rs.getObject(dbFieldId)) {
                pkIds.add(rs.getLong(dbFieldId));
            }
        }
        catch (SQLException e) {
            logger.error((Throwable)e);
        }
    }

    private static void inputIntoDatasMap(String entityId, Map<String, List<Long>> datas, List<Long> pkIds) {
        if (!pkIds.isEmpty()) {
            datas.put(entityId, pkIds);
        }
    }

    private static void putValueIfNotEmpty(Map<String, String> result, ResultSet rs, String fieldKey, String mapKey) {
        try {
            if (null != rs.getObject(fieldKey)) {
                result.put(mapKey, rs.getString(fieldKey));
            }
        }
        catch (SQLException e) {
            logger.error((Throwable)e);
        }
    }

    public static void auditFileRelatedData(String entityId, List<Long> ids) {
        DynamicObject[] dyObjs;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityId);
        QFilter qFilter = new QFilter("id", "in", ids);
        for (DynamicObject dyObj : dyObjs = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter})) {
            dyObj.set("status", (Object)"B");
        }
        serviceHelper.update(dyObjs);
        BaseDataHisHelper.saveTimeVersion((DynamicObject[])dyObjs, (boolean)true);
    }

    public static void refreshSalaryFileSummary(IFormView salaryFileView, IFormView view) {
        SITPageCache pageCache = new SITPageCache(salaryFileView);
        Map pageIdMap = (Map)pageCache.get("pageids", Map.class);
        String previewPageId = (String)pageIdMap.get("HCSI_SINSURFILE_SUMMARY");
        if (null != previewPageId) {
            IFormView previewView = salaryFileView.getView(previewPageId);
            previewView.updateView();
            view.sendFormAction(previewView);
        }
    }

    public static void deleteFileAll(List<Long> fileIdList) {
        DynamicObject[] personDys = SinsurFileServiceHelper.getCanDeletePerson(fileIdList);
        SinsurFileServiceHelper.deleteFile(fileIdList);
        SinsurFileServiceHelper.deleteFilePerson(personDys);
    }

    private static void deleteFile(List<Long> fileIdList) {
        HRBaseServiceHelper fileServiceHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
        QFilter qIdFilter = new QFilter("boid", "in", fileIdList);
        fileServiceHelper.deleteByFilter(new QFilter[]{qIdFilter});
    }

    private static DynamicObject[] getCanDeletePerson(List<Long> fileIdList) {
        HRBaseServiceHelper fileServiceHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
        QFilter idFilter = new QFilter("id", "in", fileIdList);
        DynamicObject[] fileDys = fileServiceHelper.query(BaseDataHisHelper.getSelectProperties((String)"hcsi_sinsurfile"), new QFilter[]{idFilter});
        ArrayList<Long> personIds = new ArrayList<Long>(10);
        ArrayList<Object> placeofwelfareIds = new ArrayList<Object>(10);
        HashSet<String> personKeySet = new HashSet<String>(16);
        for (DynamicObject obj : fileDys) {
            Long personId = obj.getLong("person.id");
            DynamicObject[] placeofWelfareId = Long.valueOf(obj.getLong("welfarepayer.placeofwelfare.id"));
            personIds.add(personId);
            placeofwelfareIds.add(placeofWelfareId);
            personKeySet.add(personId + "_" + placeofWelfareId);
        }
        QFilter idNotExistsFilter = new QFilter("id", "not in", fileIdList);
        QFilter employeeFilter = new QFilter("person", "in", personIds);
        QFilter placeOfWelfareFilter = new QFilter("welfarepayer.placeofwelfare", "in", placeofwelfareIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)employeeFilter);
        DynamicObject[] otherFileDys = fileServiceHelper.query(BaseDataHisHelper.getSelectProperties((String)"hcsi_sinsurfile"), new QFilter[]{idNotExistsFilter, employeeFilter, placeOfWelfareFilter});
        HashSet<String> hasOtherFileSet = new HashSet<String>(16);
        for (DynamicObject obj : otherFileDys) {
            String personId = obj.getString("person.id");
            String placeOfWelfareStr = obj.getString("welfarepayer.placeofwelfare.id");
            hasOtherFileSet.add(personId + "_" + placeOfWelfareStr);
        }
        personKeySet.removeAll(hasOtherFileSet);
        personIds.clear();
        placeofwelfareIds.clear();
        for (String personKey : personKeySet) {
            String[] personKeyArr = personKey.split("_");
            String employeeIdStr = personKeyArr[0];
            String placeofwelfareStr = personKeyArr[1];
            personIds.add(Long.parseLong(employeeIdStr));
            placeofwelfareIds.add(Long.parseLong(placeofwelfareStr));
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcsi_sinsurperson");
        QFilter employeeFilter2 = new QFilter("person", "in", personIds);
        QFilter placeOfWelfareFilter2 = new QFilter("placeofwelfare", "in", placeofwelfareIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)employeeFilter2);
        return serviceHelper.query(BaseDataHisHelper.getSelectProperties((String)"hcsi_sinsurperson"), new QFilter[]{employeeFilter2, placeOfWelfareFilter2});
    }

    private static void deleteFilePerson(DynamicObject[] personDys) {
        if (personDys == null || personDys.length == 0) {
            return;
        }
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        OperationResult result = opImpl.localInvokeOperation("delete", personDys, operateOption);
        logger.info("------------deletePaysetting,isSuccess={}", (Object)result.isSuccess());
        logger.info("------------deletePaysetting,getMessage={}", (Object)result.getMessage());
    }

    public static void abandonFile(List<Long> idList) {
        DynamicObject[] salaryFileDyobjs;
        HRBaseServiceHelper fileServiceHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
        QFilter qIdFilter = new QFilter("id", "in", idList);
        for (DynamicObject salaryFileDyobj : salaryFileDyobjs = fileServiceHelper.query("status", new QFilter[]{qIdFilter})) {
            salaryFileDyobj.set("status", (Object)"E");
        }
        fileServiceHelper.update(salaryFileDyobjs);
    }

    public static void setPersonViewPerCreByEmployeeId(IFormView view, Long employeeId) {
        SinsurFileServiceHelper.setPerCerInfo(view, SinsurFileServiceHelper.queryPersonPerCreByEmployeeId(employeeId));
    }

    public static void setPersonViewPerCreByPersonId(IFormView view, Long personId) {
        SinsurFileServiceHelper.setPerCerInfo(view, SinsurFileServiceHelper.queryPersonPerCreByPersonId(personId));
    }

    private static void setPerCerInfo(IFormView view, Map<String, Object> perCreMap) {
        if (perCreMap != null) {
            view.getModel().setValue("certificatetype", perCreMap.get("credentialstype_id"));
            view.getModel().setValue("certificatenumber", perCreMap.get("number"));
        } else {
            view.getModel().setValue("certificatetype", null);
            view.getModel().setValue("certificatenumber", null);
        }
    }

    public static String queryPersonCertificateNumberByEmployeeId(Long employeeId) {
        if (employeeId == 0L) {
            return null;
        }
        Map<String, Object> percreMap = SinsurFileServiceHelper.queryPersonPerCreByEmployeeId(employeeId);
        if (percreMap != null) {
            return String.valueOf(percreMap.get("number"));
        }
        return null;
    }

    public static Map<String, Object> queryPersonPerCreByEmployeeId(Long employeeId) {
        if (employeeId == 0L) {
            return null;
        }
        HRBaseServiceHelper employeeHelper = new HRBaseServiceHelper("hrpi_employee");
        DynamicObject employeeDy = employeeHelper.queryOne("id,person.id", (Object)employeeId);
        Long personId = employeeDy.getLong("person.id");
        return SinsurFileServiceHelper.queryPersonPerCreByPersonId(personId);
    }

    public static Map<String, Object> queryPersonById(Long id) {
        List<Map<String, Object>> result = SinsurFileServiceHelper.invokePersonListInfo("hrpi_person", id, null, null);
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        return result.get(0);
    }

    public static Map<String, Object> queryEmployeeById(Long id) {
        List<Map<String, Object>> result = SinsurFileServiceHelper.invokePersonListInfo("hrpi_employee", id, null, null);
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        return result.get(0);
    }

    public static Map<String, Object> queryPersonPerCreByPersonId(Long personId) {
        if (personId == 0L) {
            return null;
        }
        List<Map<String, Object>> result = SinsurFileServiceHelper.invokePersonListInfo("hrpi_percre", null, null, personId);
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        for (Map<String, Object> percre : result) {
            if (!((Boolean)percre.get("iscurrentversion")).booleanValue() || !((Boolean)percre.get("ismajor")).booleanValue()) continue;
            return percre;
        }
        return null;
    }

    private static List<Map<String, Object>> invokePersonListInfo(String entityName, Long id, Long boId, Long relationId) {
        String appId = "hrpi";
        String serviceName = "IHRPIPersonSyncService";
        String methodName = "listInfo";
        Object[] paras = new Object[]{entityName, id, boId, relationId};
        return (List)SITMServiceUtils.invokeHRMPService((String)appId, (String)serviceName, (String)methodName, (Object[])paras);
    }

    public static Map<String, Object> queryPersonEmpentrelByEmployeeId(Long employeeId) {
        List<Map<String, Object>> result = SinsurFileServiceHelper.invokePersonListInfo("hrpi_empentrel", null, null, employeeId);
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        for (Map<String, Object> percre : result) {
            if (!((Boolean)percre.get("iscurrentversion")).booleanValue()) continue;
            return percre;
        }
        return null;
    }

    private static Map<String, List<Map<String, Object>>> getPageCfg(IFormView view) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        Long cfgId = HRJSONUtils.getLongValOfCustomParam(customParams.get("cfgid"));
        Map dynFileAllCnf = CombinePageCfgCacheService.getInstance().getCfg(cfgId);
        String pageJson = (String)dynFileAllCnf.get("PageJson");
        Map pageConfig = (Map)SerializationUtils.fromJsonString((String)pageJson, Map.class);
        return pageConfig;
    }

    public static void showRelatedPage(String currentNumber, IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Map<String, List<Map<String, Object>>> pageConfig = SinsurFileServiceHelper.getPageCfg(view);
        List<Map<String, Object>> topPageList = pageConfig.get("toppage");
        List<Map<String, Object>> siderPageList = pageConfig.get("siderentry");
        Map<String, Object> currentSider = null;
        for (Map<String, Object> siderMap : siderPageList) {
            String number = String.valueOf(siderMap.get("number"));
            if (!currentNumber.equals(number)) continue;
            currentSider = siderMap;
        }
        if (null == currentSider) {
            return;
        }
        FormShowParameter pageFormShowParameter = new FormShowParameter();
        pageFormShowParameter.setCustomParams(formShowParameter.getCustomParams());
        pageFormShowParameter.setCustomParam("currentRelatePage", (Object)String.valueOf(currentSider.get("number")));
        pageFormShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        pageFormShowParameter.setCustomParam("toppage", (Object)SerializationUtils.toJsonString(topPageList));
        pageFormShowParameter.setCustomParam("parentpageid", (Object)view.getPageId());
        pageFormShowParameter.setCustomParam("siderentry", (Object)SerializationUtils.toJsonString(siderPageList));
        pageFormShowParameter.setFormId("sitbs_siderrelatepage");
        Map customParams = view.getFormShowParameter().getCustomParams();
        String name = (String)customParams.get("name");
        String caption = ResManager.loadKDString((String)"\u4eba\u5458\u793e\u4fdd\u6863\u6848\u5173\u8054\u4fe1\u606f", (String)"SinsurFileServiceHelper_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)name)) {
            pageFormShowParameter.setCaption(caption);
        } else {
            pageFormShowParameter.setCaption(caption + " - " + name);
        }
        view.showForm(pageFormShowParameter);
    }

    public static Set<Long> getAlreadyCalFileIds(List<Long> ids) {
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hcsi_calperson");
        DynamicObjectCollection persons = personHelper.queryOriginalCollection("sinsurfilev.boid", new QFilter("sinsurfilev.boid", "in", ids).toArray());
        return persons.stream().map(person -> person.getLong("sinsurfilev.boid")).collect(Collectors.toSet());
    }

    public static Set<Long> getAlreadyDclFileIds(List<Long> ids) {
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hcsi_dclperson");
        DynamicObjectCollection persons = personHelper.queryOriginalCollection("sinsurfile.id", new QFilter("sinsurfile.id", "in", ids).toArray());
        return persons.stream().map(person -> person.getLong("sinsurfile.id")).collect(Collectors.toSet());
    }

    public static void recycleNumbers(List<DynamicObject> codeRuleFiles) {
        if (codeRuleFiles != null && codeRuleFiles.size() > 0) {
            List numbers = codeRuleFiles.stream().map(codeRuleFile -> codeRuleFile.getString("number")).collect(Collectors.toList());
            HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
            DynamicObjectCollection dbFiles = fileHelper.queryOriginalCollection("number", new QFilter("number", "in", numbers).toArray());
            Set dbNumbers = dbFiles.stream().map(dbFile -> dbFile.getString("number")).collect(Collectors.toSet());
            codeRuleFiles.removeIf(coleRuleFile -> dbNumbers.contains(coleRuleFile.getString("number")));
            if (codeRuleFiles.size() > 0) {
                CodeRuleServiceHelper.recycleBatchNumber((String)"hcsi_sinsurfile", (DynamicObject[])codeRuleFiles.toArray(new DynamicObject[0]), (String)String.valueOf(RequestContext.get().getOrgId()), (String[])((String[])codeRuleFiles.stream().map(coldRuleFile -> coldRuleFile.getString("number")).toArray(String[]::new)));
            }
        }
    }

    public static void setSinSurFileDefaultValue(DynamicObject[] SinSurFiles) {
        HashSet<Long> personIds = new HashSet<Long>(SinSurFiles.length);
        for (DynamicObject dataEntity : SinSurFiles) {
            dataEntity.set("name", dataEntity.get("employee.person.name"));
            if (!dataEntity.getBoolean("isescrowstaff")) {
                dataEntity.set("welfarepayertheory", dataEntity.get("welfarepayer"));
            }
            if (dataEntity.getLong("personindexid") != 0L) continue;
            personIds.add(dataEntity.getLong("person.id"));
        }
        SinsurFileServiceHelper.setPersonIndexId(SinSurFiles, personIds);
    }

    private static void setPersonIndexId(DynamicObject[] SinSurFiles, Set<Long> personIds) {
        if (personIds == null || personIds.size() == 0) {
            return;
        }
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hrpi_person");
        String selectProperties = "id,personindexid";
        DynamicObject[] personColl = personHelper.queryOriginalArray(selectProperties, new QFilter[]{new QFilter("id", "in", personIds)});
        HashMap<Long, DynamicObject> personIdToObjMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject person : personColl) {
            personIdToObjMap.put(person.getLong("id"), person);
        }
        for (DynamicObject dataEntity : SinSurFiles) {
            long personId = dataEntity.getLong("person.id");
            DynamicObject person = (DynamicObject)personIdToObjMap.get(personId);
            if (person == null) {
                logger.error("person id {} not query", (Object)personId);
                dataEntity.set("personindexid", (Object)-1L);
                continue;
            }
            dataEntity.set("personindexid", (Object)person.getLong("personindexid"));
        }
    }

    public static BaseResult<?> matchEmployee(DynamicObject entityDyObj, List<DynamicObject> empObjs, boolean isNew, String dataSrc) {
        Object employee = entityDyObj.get("employee");
        long empId = 0L;
        if (employee instanceof DynamicObject) {
            empId = ((DynamicObject)employee).getLong("id");
        } else if (employee instanceof Long) {
            empId = (Long)employee;
        }
        if (empId != 0L && !HRStringUtils.equals((String)"normal", (String)entityDyObj.getString("sinsurstatus"))) {
            for (DynamicObject empObj : empObjs) {
                if (empObj.getLong("id") != empId) continue;
                return BaseResult.success((Object)empObj);
            }
        }
        empObjs.sort((o1, o2) -> {
            Date startDate1 = o1.getDate("startdate");
            Date startDate2 = o2.getDate("startdate");
            if (startDate1 == null && startDate2 == null) {
                return 0;
            }
            if (startDate1 == null) {
                return 1;
            }
            if (startDate2 == null) {
                return -1;
            }
            return startDate1.compareTo(startDate2);
        });
        DynamicObject latestEmp = null;
        Date bsed = entityDyObj.getDate("bsed");
        LinkedHashSet dataRanges = Sets.newLinkedHashSetWithExpectedSize((int)empObjs.size());
        boolean reMatch = entityDyObj.getDataEntityState().getFromDatabase() && "PAGE".equals(dataSrc) || "IMPORT".equals(dataSrc);
        for (DynamicObject empObj : empObjs) {
            boolean match;
            Date startDate = empObj.getDate("startdate");
            Date endDate = empObj.getDate("enddate");
            boolean bl = match = isNew || entityDyObj.getLong("person.id") == empObj.getLong("person.id");
            if (!match) {
                logger.info("Trace by Quinn: not match: {}, {}", (Object)entityDyObj.getLong("person.id"), (Object)empObj.getLong("person.id"));
            }
            if (!match) continue;
            if (reMatch) {
                if (startDate != null && SitDateUtil.isCover((Date)bsed, (Date)startDate, (Date)endDate)) {
                    entityDyObj.set("employee", (Object)empObj);
                    if (isNew) {
                        entityDyObj.set("person", (Object)empObj.getDynamicObject("person"));
                    }
                    return BaseResult.success((Object)empObj);
                }
                String builder = '[' + SITDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd") + '~' + SITDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd") + ']';
                dataRanges.add(builder);
                continue;
            }
            if (bsed.before(startDate)) continue;
            latestEmp = empObj;
        }
        if (SinsurFileServiceHelper.handleLastEmp(entityDyObj, isNew, empId, latestEmp)) {
            return BaseResult.success(latestEmp);
        }
        return BaseResult.fail((String)Joiner.on((String)",").join((Iterable)dataRanges));
    }

    private static boolean handleLastEmp(DynamicObject entityDyObj, boolean isNew, long empId, DynamicObject latestEmp) {
        if (latestEmp != null) {
            logger.info("Trace by Quinn: latestEmp matched: {}, {} of {} - {}", new Object[]{latestEmp.getLong("person.id"), latestEmp.getLong("id"), entityDyObj.getString("number"), empId});
            if (latestEmp.getLong("id") == empId) {
                entityDyObj.set("employee", (Object)latestEmp);
                if (isNew) {
                    entityDyObj.set("person", (Object)latestEmp.getDynamicObject("person"));
                }
                return true;
            }
        }
        return false;
    }

    public static void checkModifyTime(IFormView view, BeforeDoOperationEventArgs args) {
        Date fileModifyTime = view.getModel().getDataEntity().getDate("modifytime");
        Object fileId = view.getModel().getDataEntity().getPkValue();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(view.getFormShowParameter().getFormId());
        DynamicObject file = helper.queryOne(fileId);
        Date dbModifyTime = file.getDate("modifytime");
        if (fileModifyTime != null && dbModifyTime != null && dbModifyTime.after(fileModifyTime)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u7f16\u8f91\u3002", (String)"SinsurFileServiceHelper_3", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public static boolean isNotValidator() {
        ISinSurFileBsedValidatorPlugin defaultPlugin = new ISinSurFileBsedValidatorPlugin(){

            public boolean isNotValidator() {
                return false;
            }
        };
        AtomicBoolean isNotValidator = new AtomicBoolean(false);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)defaultPlugin, ISinSurFileBsedValidatorPlugin.class, (String)"kd.sdk.sit.hcsi.oppplugin.sinsurfile.ISinSurFileBsedValidatorPlugin#isNotValidator", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            isNotValidator.set(proxy.isNotValidator());
            return null;
        });
        return isNotValidator.get();
    }
}

