/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.common.constants.SinsurFileConstants;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import org.apache.commons.collections4.CollectionUtils;

public class SinsurPersonServiceHelper
implements SinsurFileConstants {
    public static DynamicObject getSinsurPerson(Long personId, Long placeOfWelfareId) {
        HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hcsi_sinsurperson");
        QFilter qFilter = new QFilter("person", "=", (Object)personId);
        QFilter placeOfWelfareFilter = new QFilter("placeofwelfare", "=", (Object)placeOfWelfareId);
        BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        return fileHelper.loadDynamicObject(new QFilter[]{qFilter, placeOfWelfareFilter});
    }

    public static DynamicObject getSinSurPerson(DynamicObject personDy) {
        return SinsurPersonServiceHelper.getSinsurPerson(personDy.getLong("person.id"), personDy.getLong("placeofwelfare.id"));
    }

    public static Map<Long, DynamicObject> getSinsurPersonByFileIds(List<Long> fileIds) {
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(16);
        if (fileIds == null || fileIds.size() == 0) {
            return result;
        }
        HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
        QFilter qFilter = new QFilter("id", "in", fileIds);
        DynamicObject[] fileDys = fileHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        HashSet<Long> employeeIds = new HashSet<Long>(16);
        HashSet<Long> placeofwelfareIds = new HashSet<Long>(16);
        int size = fileDys.length;
        for (int i = 0; i < size; ++i) {
            employeeIds.add(fileDys[i].getLong("employee.id"));
            placeofwelfareIds.add(fileDys[i].getLong("welfarepayer.placeofwelfare.id"));
        }
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hcsi_sinsurperson");
        QFilter employeeFilter = new QFilter("employee", "in", employeeIds);
        QFilter placeofwelfareFilter = new QFilter("placeofwelfare", "in", placeofwelfareIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        DynamicObject[] personDyObjs = personHelper.query(BaseDataHisHelper.getSelectProperties((String)"hcsi_sinsurperson"), new QFilter[]{employeeFilter, placeofwelfareFilter});
        HashMap<String, DynamicObject> personDyMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject personDy : personDyObjs) {
            String key = personDy.getString("employee.id") + personDy.getString("placeofwelfare.id");
            personDyMap.put(key, personDy);
        }
        int size2 = fileDys.length;
        for (int i = 0; i < size2; ++i) {
            DynamicObject personDy;
            String key = fileDys[i].getString("employee.id") + fileDys[i].getString("welfarepayer.placeofwelfare.id");
            personDy = (DynamicObject)personDyMap.get(key);
            if (personDy == null) continue;
            result.put(fileDys[i].getLong("id"), personDy);
        }
        return result;
    }

    public static List<Map<String, Object>> getSinsurPersonByFileVIds(List<Map<String, Object>> params) {
        Set fileVIds = params.stream().map(bo -> (Long)bo.get("fileVId")).collect(Collectors.toSet());
        if (fileVIds == null || fileVIds.size() == 0) {
            return params;
        }
        HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
        QFilter qFilter = new QFilter("id", "in", fileVIds);
        DynamicObject[] fileDys = fileHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        HashSet<Long> personIds = new HashSet<Long>(16);
        HashSet<Long> placeofwelfareIds = new HashSet<Long>(16);
        HashMap<Long, DynamicObject> fileDyMap = new HashMap<Long, DynamicObject>(16);
        int size = fileDys.length;
        for (int i = 0; i < size; ++i) {
            personIds.add(fileDys[i].getLong("person.id"));
            placeofwelfareIds.add(fileDys[i].getLong("welfarepayer.placeofwelfare.id"));
            fileDyMap.put(fileDys[i].getLong("id"), fileDys[i]);
        }
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hcsi_sinsurperson");
        QFilter personFilter = new QFilter("person", "in", personIds);
        QFilter placeofwelfareFilter = new QFilter("placeofwelfare", "in", placeofwelfareIds);
        HashSet<String> validStatus = new HashSet<String>(16);
        validStatus.add("2");
        validStatus.add("1");
        validStatus.add("0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", validStatus);
        BaseDataHisHelper.addHisVerFilter((QFilter)personFilter);
        DynamicObject[] personDyObjs = personHelper.query(BaseDataHisHelper.getSelectProperties((String)"hcsi_sinsurperson"), new QFilter[]{personFilter, placeofwelfareFilter, dataStatusFilter}, "bsled desc");
        HashMap<String, List> personDyMap = new HashMap<String, List>(16);
        List tmpPersons = null;
        for (DynamicObject personDy : personDyObjs) {
            String key = personDy.getString("person.id") + personDy.getString("placeofwelfare.id");
            tmpPersons = personDyMap.computeIfAbsent(key, keys -> new ArrayList(10));
            tmpPersons.add(personDy);
        }
        DynamicObject fileDy = null;
        int size2 = params.size();
        block2: for (int i = 0; i < size2; ++i) {
            Map<String, Object> param = params.get(i);
            Long fileVid = (Long)param.get("fileVId");
            Date periodEndDate = (Date)param.get("periodEndDate");
            fileDy = (DynamicObject)fileDyMap.get(fileVid);
            tmpPersons = Optional.ofNullable(fileDy).map(dyObj -> dyObj.getString("person.id") + dyObj.getString("welfarepayer.placeofwelfare.id")).map(personDyMap::get).orElseGet(Collections::emptyList);
            for (DynamicObject person : tmpPersons) {
                boolean isMatchPeriodEndDate;
                Date personBsed = person.getDate("bsed");
                Date personBsled = person.getDate("bsled");
                boolean isMatchFileVer = !fileDy.getDate("bsed").after(personBsled) && !personBsed.after(fileDy.getDate("bsled"));
                boolean bl = isMatchPeriodEndDate = periodEndDate == null || !periodEndDate.before(personBsed) && !periodEndDate.after(personBsled);
                if (!isMatchFileVer || !isMatchPeriodEndDate) continue;
                param.put("sinsurPerson", person);
                continue block2;
            }
        }
        return params;
    }

    public static synchronized DynamicObject savePerson(DynamicObject personDy) {
        String opName = "save";
        OperateOption operateOption = OperateOption.create();
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperationResult operationResult = opImpl.localInvokeOperation(opName, new DynamicObject[]{personDy}, operateOption);
        SinsurPersonServiceHelper.dealOperationResult(operationResult);
        return personDy;
    }

    private static void dealOperationResult(OperationResult operationResult) {
        HashSet<String> errorMsgs = new HashSet<String>(16);
        if (!operationResult.isSuccess()) {
            List operateInfos = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo operateInfo : operateInfos) {
                errorMsgs.add(operateInfo.getMessage());
            }
            String msg = operationResult.getMessage();
            if (CollectionUtils.isEmpty((Collection)operateInfos) && StringUtils.isNotEmpty((CharSequence)msg)) {
                errorMsgs.add(msg);
            }
            throw new KDBizException(((Object)errorMsgs).toString());
        }
    }
}

