/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.cloudcolla.CloudCollaContextHelper;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.business.servicehelper.SITBaseDataHelper;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SyncPersonServiceHelper {
    private static final Log logger = LogFactory.getLog(SyncPersonServiceHelper.class);
    public static final String CLOUD_COLLA = "cloudcolla";

    public static Map<String, Object> synchroInfo(DynamicObject data, Map<String, Object> commonDataMap, Map<String, Object> taskDataMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("code", 200);
        try {
            CloudCollaContextHelper.getInstance().parseAndSetCustomizeResultOnlyFlowOutData(data, commonDataMap);
            HRBaseServiceHelper welfarePayerHelper = new HRBaseServiceHelper("sitbs_welfarepayer");
            Map apiDataListMap = (Map)taskDataMap.get("apiDataList");
            List employees = (List)apiDataListMap.get("hsas_employee");
            long employeeId = ((DynamicObject)employees.get(0)).getLong("boid");
            DynamicObject employee = new HRBaseServiceHelper("hrpi_employee").queryOne((Object)employeeId);
            String empNumber = ((DynamicObject)employees.get(0)).getString("empnumber");
            List personHrs = (List)apiDataListMap.get("hsas_personhr");
            long personId = ((DynamicObject)personHrs.get(0)).getLong("boid");
            DynamicObject person = welfarePayerHelper.generateEmptyDynamicObject("hrpi_person");
            person.set("id", (Object)personId);
            person.set("name", (Object)((DynamicObject)personHrs.get(0)).getString("name"));
            String flowType = (String)commonDataMap.get("flowType");
            String name = ((DynamicObject)personHrs.get(0)).getString("name");
            long welfarePayerId = data.getLong("welfarepayer.id");
            DynamicObject welfarePayer = welfarePayerHelper.queryOne((Object)welfarePayerId);
            data.set("welfarepayer", (Object)welfarePayer);
            logger.info("employee:{},person:{},flowType:{},welfarepayer:{},sinsurstatus:{},bsed:{},name{}", new Object[]{employeeId, personId, flowType, welfarePayerId, data.getString("sinsurstatus"), data.getDate("bsed"), person.getString("name")});
            QFilter filter = new QFilter("welfarepayer", "=", (Object)welfarePayerId);
            filter.and("person.id", "=", (Object)personId);
            filter.and("status", "!=", (Object)"E");
            BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
            HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
            DynamicObject existFile = fileHelper.queryOne(SITBaseDataHelper.getSelectProperties((String)"hcsi_sinsurfile"), filter.toArray());
            HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hcsi_sinsurperson");
            QFilter filter1 = new QFilter("person.id", "=", (Object)personId);
            filter1.and("placeofwelfare", "=", (Object)welfarePayer.getLong("placeofwelfare.id"));
            BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
            DynamicObject existPerson = personHelper.queryOne(filter1.toArray());
            if (SITStringUtils.equals((String)flowType, (String)"1")) {
                if (existFile != null) {
                    return SyncPersonServiceHelper.existFile(data, resultMap, name, empNumber, employee, existFile, commonDataMap);
                }
                return SyncPersonServiceHelper.createFileAndPerson(data, resultMap, employee, person, existPerson, commonDataMap);
            }
            if (existFile != null) {
                return SyncPersonServiceHelper.existFile(data, resultMap, name, empNumber, employee, existFile, commonDataMap);
            }
            resultMap.put("code", 500);
            resultMap.put("errorMsg", ResManager.loadKDString((String)"{0}({1})\u672a\u521b\u5efa\u793e\u4fdd\u6863\u6848\uff0c\u65e0\u6cd5\u8fdb\u884c\u53d8\u66f4\u3002", (String)"SyncPersonServiceHelper_2", (String)"sit-hcsi-business", (Object[])new Object[]{name, empNumber}));
            return resultMap;
        }
        catch (Exception e) {
            logger.error("\u793e\u4fdd\u534f\u4f5c\u63a5\u53e3\u62a5\u9519", (Throwable)e);
            resultMap.put("code", 500);
            resultMap.put("errorMsg", e.getMessage());
            return resultMap;
        }
    }

    private static Map<String, Object> existFile(DynamicObject data, Map<String, Object> resultMap, String name, String empNumber, DynamicObject employee, DynamicObject existFile, Map<String, Object> commonDataMap) {
        String fileStatus = existFile.getString("status");
        existFile.set("employee", (Object)employee);
        CloudCollaContextHelper.getInstance().parseAndSetCustomizeResultOnlyExistData(data, commonDataMap, existFile);
        if (SITStringUtils.equals((String)fileStatus, (String)"C")) {
            return SyncPersonServiceHelper.changeFile(data, resultMap, existFile, commonDataMap);
        }
        resultMap.put("code", 500);
        resultMap.put("errorMsg", ResManager.loadKDString((String)"{0}({1})\u7684\u793e\u4fdd\u6863\u6848({2})\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u65e0\u6cd5\u8fdb\u884c\u53d8\u66f4\u3002", (String)"SyncPersonServiceHelper_1", (String)"sit-hcsi-business", (Object[])new Object[]{name, empNumber, existFile.getString("number")}));
        return resultMap;
    }

    private static Map<String, Object> changeFile(DynamicObject data, Map<String, Object> resultMap, DynamicObject existFile, Map<String, Object> commonDataMap) {
        List successPkIds;
        CloudCollaContextHelper contextHelper = CloudCollaContextHelper.getInstance();
        contextHelper.copyPropValue(data, existFile, contextHelper.parseCurrentCollaFields(commonDataMap, "hcsi_sinsurfile"));
        existFile.set("bsled", null);
        DynamicObject welfarePayer = data.getDynamicObject("welfarepayer");
        DynamicObject welfarePayerTheory = data.getDynamicObject("welfarepayertheory");
        existFile.set("manageregion", data.get("welfarepayer.country"));
        Long welfarePayerId = Optional.ofNullable(welfarePayer).map(item -> item.getLong("id")).orElse(-1L);
        if (welfarePayerTheory != null && welfarePayerTheory.getLong("id") != welfarePayerId.longValue()) {
            existFile.set("isescrowstaff", (Object)Boolean.TRUE);
        } else {
            existFile.set("isescrowstaff", (Object)Boolean.FALSE);
        }
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        operateOption.setVariableValue("skipCheckDataPermission", "true");
        operateOption.setVariableValue("skipCheckSpecialDataPermission", "true");
        operateOption.setVariableValue(CLOUD_COLLA, "true");
        operateOption.setVariableValue("dataSrc", "SYNC");
        OperationResult saveafteraudit = opImpl.localInvokeOperation("saveafteraudit", new DynamicObject[]{existFile}, operateOption);
        if (!saveafteraudit.isSuccess()) {
            resultMap.put("code", 500);
            SyncPersonServiceHelper.putErrMsg(resultMap, saveafteraudit);
        }
        if (!CollectionUtils.isEmpty((Collection)(successPkIds = saveafteraudit.getSuccessPkIds()))) {
            List tempList = (List)resultMap.computeIfAbsent("executeResult", item -> new ArrayList(10));
            for (Object successPkId : successPkIds) {
                tempList.add(ImmutableMap.of((Object)"entityNumber", (Object)existFile.getDataEntityType().getName(), (Object)"dataId", successPkId, (Object)"type", (Object)"CHANGE"));
            }
        }
        return resultMap;
    }

    private static Map<String, Object> createFileAndPerson(DynamicObject data, Map<String, Object> resultMap, DynamicObject employee, DynamicObject person, DynamicObject existPerson, Map<String, Object> commonDataMap) {
        OperationResult saveResult;
        DynamicObject newFile = SyncPersonServiceHelper.getNewFileDy(data, employee, person, commonDataMap);
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        operateOption.setVariableValue("skipCheckDataPermission", "true");
        operateOption.setVariableValue("skipCheckSpecialDataPermission", "true");
        operateOption.setVariableValue("dataSrc", "SYNC");
        DynamicObject welfarePayer = newFile.getDynamicObject("welfarePayer");
        DynamicObject newPerson = null;
        if (existPerson == null) {
            newPerson = new HRBaseServiceHelper("hcsi_sinsurperson").generateEmptyDynamicObject();
            newPerson.set("placeofwelfare", welfarePayer.get("placeofwelfare"));
            newPerson.set("person", (Object)person);
            newPerson.set("employee", (Object)employee);
            newPerson.set("org", welfarePayer.get("org"));
            newPerson.set("bsed", (Object)data.getDate("bsed"));
            newPerson.set("bsled", null);
            newPerson.set("creator", (Object)RequestContext.get().getCurrUserId());
            OperationServiceImpl opImpl1 = new OperationServiceImpl();
            OperateOption operateOption1 = OperateOption.create();
            operateOption1.setVariableValue("ishasright", "true");
            operateOption1.setVariableValue("skipCheckDataPermission", "true");
            operateOption1.setVariableValue("skipCheckSpecialDataPermission", "true");
            operateOption1.setVariableValue(CLOUD_COLLA, "true");
            operateOption1.setVariableValue("dataSrc", "SYNC");
            OperationResult validator = opImpl1.localInvokeOperation("donothing_savevalidator", new DynamicObject[]{newPerson}, operateOption1);
            if (!validator.isSuccess()) {
                resultMap.put("code", 500);
                SyncPersonServiceHelper.putErrMsg(resultMap, validator);
                return resultMap;
            }
        }
        if ((saveResult = opImpl.localInvokeOperation("save", new DynamicObject[]{newFile}, operateOption)).isSuccess()) {
            List successPkIds;
            if (newPerson != null) {
                OperationServiceImpl opImpl1 = new OperationServiceImpl();
                OperateOption operateOption1 = OperateOption.create();
                operateOption1.setVariableValue("ishasright", "true");
                operateOption1.setVariableValue("dataSrc", "SYNC");
                operateOption1.setVariableValue("skipCheckDataPermission", "true");
                operateOption1.setVariableValue("skipCheckSpecialDataPermission", "true");
                operateOption1.setVariableValue(CLOUD_COLLA, "true");
                opImpl1.localInvokeOperation("save", new DynamicObject[]{newPerson}, operateOption1);
            }
            if (!CollectionUtils.isEmpty((Collection)(successPkIds = saveResult.getSuccessPkIds()))) {
                List tempList = (List)resultMap.computeIfAbsent("executeResult", item -> new ArrayList(10));
                for (Object successPkId : successPkIds) {
                    tempList.add(ImmutableMap.of((Object)"entityNumber", (Object)newFile.getDataEntityType().getName(), (Object)"dataId", successPkId, (Object)"type", (Object)"NEW"));
                }
            }
            resultMap.put("code", 200);
        } else {
            resultMap.put("code", 500);
            SyncPersonServiceHelper.putErrMsg(resultMap, saveResult);
        }
        return resultMap;
    }

    private static void putErrMsg(Map<String, Object> resultMap, OperationResult saveResult) {
        List allErrorOrValidateInfo = saveResult.getAllErrorOrValidateInfo();
        if (allErrorOrValidateInfo != null && !allErrorOrValidateInfo.isEmpty()) {
            resultMap.put("errorMsg", ((IOperateInfo)allErrorOrValidateInfo.get(0)).getMessage());
        } else {
            resultMap.put("errorMsg", saveResult.getMessage());
        }
    }

    private static DynamicObject getNewFileDy(DynamicObject data, DynamicObject employee, DynamicObject person, Map<String, Object> commonMaps) {
        HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
        DynamicObject newFile = fileHelper.generateEmptyDynamicObject();
        CloudCollaContextHelper instance = CloudCollaContextHelper.getInstance();
        instance.copyPropValue(data, newFile, instance.parseCurrentCollaFields(commonMaps, "hcsi_sinsurfile"));
        newFile.set("id", (Object)ID.genLongId());
        newFile.set("employee", (Object)employee);
        newFile.set("name", (Object)person.getString("name"));
        newFile.set("org", newFile.get("welfarepayer.org"));
        newFile.set("person", (Object)person);
        newFile.set("manageregion", newFile.get("welfarepayer.country"));
        newFile.set("creator", (Object)RequestContext.get().getCurrUserId());
        long welfarePayerTheoryId = newFile.getLong("welfarepayertheory.id");
        long welfarePayerId = newFile.getLong("welfarepayer.id");
        if (welfarePayerTheoryId != 0L && welfarePayerTheoryId != welfarePayerId) {
            newFile.set("isescrowstaff", (Object)Boolean.TRUE);
        } else {
            newFile.set("isescrowstaff", (Object)Boolean.FALSE);
        }
        newFile.set("bsled", null);
        return newFile;
    }
}

