/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file.attach;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.file.SinSurFileStdImportServiceHelper;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.hcsi.business.file.attach.SinSurBase;
import kd.sit.hcsi.business.file.attach.SinSurBaseErrorResultEnum;
import kd.sit.hcsi.business.file.attach.SinSurFileBase;
import kd.sit.hcsi.business.file.attach.SinSurFileBaseParamAbstract;

public abstract class HisChangeSinSurBaseParamAbstract
extends SinSurFileBaseParamAbstract {
    private static final Log LOGGER = LogFactory.getLog(HisChangeSinSurBaseParamAbstract.class);
    protected Map<String, Map<Boolean, List<DynamicObject>>> allSinSurFileBases;

    @Override
    public void validateBusiness() {
        ArrayList<SinSurFileBase> successSinSurFileBases = new ArrayList<SinSurFileBase>(this.successSinSurFileBases.size());
        HashMap<Long, Set> sinSurFileWelfareTypes = new HashMap<Long, Set>(this.successSinSurFileBases.size());
        block0: for (SinSurFileBase sinSurFileBase : this.successSinSurFileBases) {
            for (SinSurBase sinSurBase : sinSurFileBase.getSinSurBases()) {
                DynamicObject sinSurFile = sinSurBase.getSinSurFile();
                if (sinSurFile == null) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.SIN_SUR_FILE_NO_STATUS);
                    continue block0;
                }
                Long sinSurFileId = sinSurBase.getSinSurFileId();
                if (!HRStringUtils.equals((String)"C", (String)sinSurFile.getString("status"))) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.SIN_SUR_FILE_NO_STATUS);
                    continue block0;
                }
                DynamicObject welfareType = sinSurBase.getWelfareType();
                if (welfareType == null) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.WELFARE_TYPE_NOT_EXISTS);
                    continue block0;
                }
                Long welfareTypeId = sinSurBase.getWelfareTypeId();
                Set sinSurFileWelfareTypeIds = sinSurFileWelfareTypes.getOrDefault(sinSurFileId, new HashSet(16));
                if (!sinSurFileWelfareTypeIds.add(welfareTypeId)) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.FILE_REPEAT_WELFARE_TYPE);
                    continue block0;
                }
                sinSurFileWelfareTypes.put(sinSurFileId, sinSurFileWelfareTypeIds);
                if (sinSurBase.getBsed().after(SinSurFileStdServiceHelper.generateBsledDate())) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.BSED_EXCEED);
                    continue block0;
                }
                String description = sinSurBase.getDescription();
                if (HRStringUtils.isNotEmpty((String)description) && description.trim().length() > 100) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.DESCRIPTION_OVER_SIZE);
                    continue block0;
                }
                Map<Boolean, List<DynamicObject>> DBSinSurFileBases = this.allSinSurFileBases.get(sinSurFile.getString("number"));
                List<DynamicObject> currentSinSurFileBases = DBSinSurFileBases.get(Boolean.TRUE);
                if (currentSinSurFileBases == null) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.SIN_SUR_FILE_BASE_NOT_EXISTS);
                    continue block0;
                }
                DynamicObject currentSinSurFileBase = this.getSinSurBase(welfareType.getLong("id"), currentSinSurFileBases);
                if (currentSinSurFileBase == null) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.SIN_SUR_FILE_BASE_NOT_EXISTS);
                    continue block0;
                }
                Date bsed = sinSurBase.getBsed();
                if (bsed.compareTo(currentSinSurFileBase.getDate("firstbsed")) < 0) {
                    String firstBsedStr = HRInteDateTimeUtil.formatDate((String)"hcsi_sinsurbase", (String)"firstbsed", (Date)currentSinSurFileBase.getDate("firstbsed"));
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.BSED_BEFORE_FIRST_BSED, firstBsedStr);
                    continue block0;
                }
                List<DynamicObject> currentSinSurFileBaseVersions = DBSinSurFileBases.get(Boolean.FALSE);
                if (currentSinSurFileBaseVersions == null) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.HIS_SIN_SUR_FILE_BASE_NOT_EXISTS);
                    continue block0;
                }
                DynamicObject sinSurFileBaseVersion = SinSurFileStdImportServiceHelper.getDBSinSurBaseVersion(sinSurBase.getBsed(), currentSinSurFileBaseVersions, welfareType.getLong("id"));
                if (sinSurFileBaseVersion == null) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.HIS_SIN_SUR_FILE_BASE_NOT_EXISTS);
                    continue block0;
                }
                sinSurBase.setSinSurFileBaseVersion(sinSurFileBaseVersion);
                if (this.validateInSurAnceProp(sinSurBase, sinSurFileBase) || this.validateMustInputInSurAnceProp(sinSurBase, sinSurFileBase)) continue block0;
                DynamicObject sinSurStd = sinSurFileBaseVersion.getDynamicObject("sinsurstd");
                if (sinSurStd == null) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.SIN_SUR_STD_NO_MATCH_WELFARE, sinSurBase.getSinSurFileNumber(), sinSurBase.getWelfareTypeName());
                    continue block0;
                }
                sinSurBase.setSinSurStd(sinSurStd);
                if (!this.getHisSinSurBaseTruncationCode(sinSurBase, sinSurFileBase) && !this.validateInsurancePropValueLength(sinSurBase, sinSurFileBase)) continue;
                continue block0;
            }
            successSinSurFileBases.add(sinSurFileBase);
        }
        this.successSinSurFileBases = successSinSurFileBases;
        LOGGER.info("validateBusiness success");
    }

    protected Set<Long> getSinSurStdIds() {
        HashSet<Long> sinSurStdIds = new HashSet<Long>(16);
        for (Map.Entry<String, Map<Boolean, List<DynamicObject>>> entry : this.allSinSurFileBases.entrySet()) {
            List<DynamicObject> sinSurFileBaseVersions;
            Map<Boolean, List<DynamicObject>> value = entry.getValue();
            if (value == null || (sinSurFileBaseVersions = value.get(Boolean.FALSE)) == null) continue;
            for (DynamicObject sinSurFileBaseVersion : sinSurFileBaseVersions) {
                DynamicObject sinSurStd = sinSurFileBaseVersion.getDynamicObject("sinsurstd");
                if (sinSurStd == null) continue;
                sinSurStdIds.add(sinSurStd.getLong("id"));
            }
        }
        return sinSurStdIds;
    }

    @Override
    protected List<DynamicObject> getFileObjs() {
        if (this.successSinSurFileBases == null) {
            return Collections.emptyList();
        }
        HashSet<Long> fileIds = new HashSet<Long>(this.successSinSurFileBases.size());
        ArrayList<DynamicObject> files = new ArrayList<DynamicObject>(this.successSinSurFileBases.size());
        for (SinSurFileBase successSinSurFileBase : this.successSinSurFileBases) {
            List<SinSurBase> sinSurBases = successSinSurFileBase.getSinSurBases();
            if (sinSurBases == null) continue;
            for (SinSurBase sinSurBase : sinSurBases) {
                DynamicObject sinSurFile = sinSurBase.getSinSurFile();
                long fileId = sinSurFile.getLong("id");
                if (!fileIds.add(fileId)) continue;
                files.add(sinSurFile);
            }
        }
        return files;
    }
}

