/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file.attach;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.file.SinSurFileStdImportServiceHelper;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.hcsi.business.file.attach.HisChangeSinSurBaseParamAbstract;
import kd.sit.hcsi.business.file.attach.InsuranceItemEntry;
import kd.sit.hcsi.business.file.attach.SinSurBase;
import kd.sit.hcsi.business.file.attach.SinSurBaseErrorResultEnum;
import kd.sit.hcsi.business.file.attach.SinSurFileBase;
import kd.sit.hcsi.business.file.attach.SinSurFileBaseExcelService;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class HisChangeSinSurBaseParamExcelImpl
extends HisChangeSinSurBaseParamAbstract
implements SinSurFileBaseExcelService {
    private static final Log LOGGER = LogFactory.getLog(HisChangeSinSurBaseParamExcelImpl.class);

    @Override
    public String getSourceType() {
        return "import";
    }

    @Override
    public List<SinSurFileBase> paramConvert(List<Map<String, Object>> params) {
        ArrayList<SinSurFileBase> sinSurFileBases = new ArrayList<SinSurFileBase>(params.size());
        for (Map<String, Object> param : params) {
            SinSurFileBase sinSurFileBase = new SinSurFileBase();
            ArrayList sinSurBases = Lists.newArrayListWithCapacity((int)10);
            SinSurBase sinSurBase = new SinSurBase();
            sinSurBase.setRowIndex((Integer)BaseDataConverter.convert((Object)param.get("index"), Integer.class));
            sinSurBase.setSinSurFileNumber((String)BaseDataConverter.convert((Object)param.get("sinsurfile.number"), String.class));
            sinSurBase.setWelfareTypeName((String)BaseDataConverter.convert((Object)param.get("welfaretype.name"), String.class));
            sinSurBase.setBsed((Date)BaseDataConverter.convert((Object)param.get("bsed"), Date.class));
            String insured = (String)BaseDataConverter.convert((Object)param.get("insured"), String.class);
            sinSurBase.setInsured(HRStringUtils.isEmpty((String)insured) ? null : (HRStringUtils.equals((String)insured, (String)ResManager.loadKDString((String)"\u662f", (String)"SinsurBaseImportService_15", (String)"sit-hcsi-business", (Object[])new Object[0])) ? Boolean.TRUE : Boolean.FALSE));
            sinSurBase.setDescription((String)BaseDataConverter.convert((Object)param.get("description"), String.class));
            sinSurBase.setAttribute((Map)BaseDataConverter.convert((Object)param.get("attribute"), Map.class));
            ArrayList insuranceItemEntry = Lists.newArrayListWithCapacity((int)10);
            for (Map.Entry insuranceType : COLUMN_INSURANCE_TYPE_ATTR_MAP.entrySet()) {
                InsuranceItemEntry insuranceItemTemp = sinSurBase.getInsuranceItemEntry();
                insuranceItemTemp.setInsurancePropId((Long)insuranceType.getValue());
                insuranceItemTemp.setInsurancePropValue((String)BaseDataConverter.convert((Object)param.get(insuranceType.getKey()), String.class));
                insuranceItemEntry.add(insuranceItemTemp);
            }
            sinSurBase.setInsuranceItemEntries(insuranceItemEntry);
            sinSurBases.add(sinSurBase);
            sinSurFileBase.setSinSurBases(sinSurBases);
            sinSurFileBases.add(sinSurFileBase);
        }
        LOGGER.info("paramConvert success");
        return sinSurFileBases;
    }

    @Override
    public void validateMustInput(List<SinSurFileBase> sinSurFileBases) {
        ArrayList<SinSurFileBase> successSinSurFileBases = new ArrayList<SinSurFileBase>(sinSurFileBases.size());
        for (SinSurFileBase sinSurFileBase : sinSurFileBases) {
            List<SinSurBase> sinSurBases;
            if (this.checkBases(sinSurFileBase, sinSurBases = sinSurFileBase.getSinSurBases())) continue;
            successSinSurFileBases.add(sinSurFileBase);
        }
        this.successSinSurFileBases = successSinSurFileBases;
        LOGGER.info("validateMustInput success");
    }

    private boolean checkBases(SinSurFileBase sinSurFileBase, List<SinSurBase> sinSurBases) {
        for (SinSurBase sinSurBase : sinSurBases) {
            if (HRStringUtils.isEmpty((String)sinSurBase.getSinSurFileNumber())) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.SIN_SUR_FILE_NUMBER_EMPTY);
                return true;
            }
            if (HRStringUtils.isEmpty((String)sinSurBase.getWelfareTypeName())) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.MUST_INPUT, sinSurBase.getSinSurFileNumber(), ResManager.loadKDString((String)"\u9669\u79cd\u540d\u79f0", (String)"SinSurFileStdImportThread_2", (String)"sit-hcsi-business", (Object[])new Object[0]));
                return true;
            }
            if (sinSurBase.getBsed() == null) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.MUST_INPUT, sinSurBase.getSinSurFileNumber(), ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"SinSurFileStdImportThread_1", (String)"sit-hcsi-business", (Object[])new Object[0]));
                return true;
            }
            if (sinSurBase.isInsured() == null) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.INSURED);
                return true;
            }
            List<InsuranceItemEntry> insuranceItemEntries = sinSurBase.getInsuranceItemEntries();
            if (CollectionUtils.isEmpty(insuranceItemEntries)) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.INSURANCE_ITEM);
                return true;
            }
            for (InsuranceItemEntry insuranceItem : insuranceItemEntries) {
                if (!this.longIsEmpty(insuranceItem.getInsurancePropId())) continue;
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.IN_SUR_ANCE_PROP_ID);
                return true;
            }
        }
        return false;
    }

    @Override
    public void extractParam() {
        long startTime = System.currentTimeMillis();
        HashSet sinSurFileNumbers = Sets.newHashSetWithExpectedSize((int)this.successSinSurFileBases.size());
        HashSet welfareTypeNames = Sets.newHashSetWithExpectedSize((int)this.successSinSurFileBases.size());
        for (Object sinSurFileBase : this.successSinSurFileBases) {
            List<SinSurBase> sinSurBases = ((SinSurFileBase)sinSurFileBase).getSinSurBases();
            for (SinSurBase sinSurBase : sinSurBases) {
                sinSurFileNumbers.add(sinSurBase.getSinSurFileNumber());
                welfareTypeNames.add(sinSurBase.getWelfareTypeName());
            }
        }
        this.welfareTypes = this.queryWelfareTypesByNames(welfareTypeNames);
        this.sinSurFiles = this.querySinSurFileByNumbers(sinSurFileNumbers);
        HashSet welfareTypeIds = Sets.newHashSetWithExpectedSize((int)this.welfareTypes.size());
        for (DynamicObject welfareType : this.welfareTypes) {
            welfareTypeIds.add(welfareType.getLong("id"));
        }
        this.welfareTypeInsuranceTypeAttrMap = SinSurFileStdServiceHelper.queryInsuranceTypeAttrSetting(welfareTypeIds, SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.values());
        this.insuranceItemMap = SinSurFileStdImportServiceHelper.queryInsuranceItem(welfareTypeIds);
        Map<String, DynamicObject> sinSurFileByNumberMap = this.sinSurFiles.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), DynamicObject2 -> DynamicObject2));
        Map<String, DynamicObject> welfareTypeByNameMap = this.welfareTypes.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("name"), DynamicObject2 -> DynamicObject2));
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)this.successSinSurFileBases.size());
        HashSet welfarePayerIds = Sets.newHashSetWithExpectedSize((int)this.successSinSurFileBases.size());
        for (SinSurFileBase sinSurFileBase : this.successSinSurFileBases) {
            for (SinSurBase sinSurBase : sinSurFileBase.getSinSurBases()) {
                DynamicObject sinSurFile = sinSurFileByNumberMap.get(sinSurBase.getSinSurFileNumber());
                sinSurBase.setSinSurFile(sinSurFile);
                if (sinSurFile != null) {
                    personIds.add(sinSurFile.getLong("person.id"));
                    welfarePayerIds.add(sinSurFile.getLong("welfarepayer.id"));
                }
                sinSurBase.setWelfareType(welfareTypeByNameMap.get(sinSurBase.getWelfareTypeName()));
            }
        }
        this.placeOfWelfareIds = SinSurFileStdServiceHelper.queryPlaceOfWelfareIds(welfarePayerIds);
        this.personVersions = this.querySinSurPersonVersions(personIds);
        this.allSinSurFileBases = SinSurFileStdImportServiceHelper.querySinSurFileBases(this.sinSurFiles);
        Set<Long> sinSurStdIds = this.getSinSurStdIds();
        this.sinSurStdVersions = SinSurFileStdServiceHelper.querySinSurStdVersions(sinSurStdIds);
        long endTime = System.currentTimeMillis();
        LOGGER.info("extractParam success cost time :{}", (Object)(endTime - startTime));
    }
}

