/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file.attach;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.sit.hcsi.business.file.SinSurFileStdImportServiceHelper;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.hcsi.business.file.attach.HisChangeSinSurBaseParamAbstract;
import kd.sit.hcsi.business.file.attach.InsuranceItemEntry;
import kd.sit.hcsi.business.file.attach.SinSurBase;
import kd.sit.hcsi.business.file.attach.SinSurBaseErrorResultEnum;
import kd.sit.hcsi.business.file.attach.SinSurFileBase;
import kd.sit.hcsi.business.file.attach.SinSurFileBaseInterfaceService;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class HisChangeSinSurBaseParamInterfaceImpl
extends HisChangeSinSurBaseParamAbstract
implements SinSurFileBaseInterfaceService {
    private static final Log LOGGER = LogFactory.getLog(HisChangeSinSurBaseParamInterfaceImpl.class);

    @Override
    public String getSourceType() {
        return "interface";
    }

    @Override
    public List<SinSurFileBase> paramConvert(List<Map<String, Object>> params) {
        ArrayList<SinSurFileBase> sinSurFileBases = new ArrayList<SinSurFileBase>(params.size());
        for (Map<String, Object> param : params) {
            SinSurFileBase sinSurFileBaseResult = new SinSurFileBase();
            ArrayList sinSurBases = Lists.newArrayListWithCapacity((int)10);
            SinSurBase sinSurBase = new SinSurBase();
            sinSurBase.setUniqueCode(param.get("uniqueCode"));
            Map sinSurFileBase = (Map)BaseDataConverter.convert((Object)param.get("sinSurFileBase"), Map.class);
            if (sinSurFileBase != null) {
                sinSurBase.setSinSurFileId((Long)BaseDataConverter.convert(sinSurFileBase.get("sinSurFileId"), Long.class));
                sinSurBase.setWelfareTypeId((Long)BaseDataConverter.convert(sinSurFileBase.get("welfareTypeId"), Long.class));
                sinSurBase.setBsed((Date)BaseDataConverter.convert(sinSurFileBase.get("bsed"), Date.class));
                sinSurBase.setInsured((Boolean)BaseDataConverter.convert(sinSurFileBase.get("insured"), Boolean.class));
                sinSurBase.setDescription((String)BaseDataConverter.convert(sinSurFileBase.get("description"), String.class));
                sinSurBase.setSinSurFileBaseExtParams((Map)BaseDataConverter.convert(sinSurFileBase.get("sinSurFileBaseExtparams"), Map.class));
                List insuranceItems = (List)BaseDataConverter.convert(sinSurFileBase.get("insuranceItem"), List.class);
                if (insuranceItems != null) {
                    ArrayList<InsuranceItemEntry> insuranceItemEntry = new ArrayList<InsuranceItemEntry>(insuranceItems.size());
                    for (Map insuranceItem : insuranceItems) {
                        InsuranceItemEntry insuranceItemTemp = sinSurBase.getInsuranceItemEntry();
                        insuranceItemTemp.setInsurancePropId((Long)BaseDataConverter.convert(insuranceItem.get("insurancePropId"), Long.class));
                        insuranceItemTemp.setInsurancePropValue((String)BaseDataConverter.convert(insuranceItem.get("insurancePropValue"), String.class));
                        insuranceItemEntry.add(insuranceItemTemp);
                    }
                    sinSurBase.setInsuranceItemEntries(insuranceItemEntry);
                }
            }
            sinSurBases.add(sinSurBase);
            sinSurFileBaseResult.setSinSurBases(sinSurBases);
            sinSurFileBases.add(sinSurFileBaseResult);
        }
        LOGGER.info("paramConvert success");
        return sinSurFileBases;
    }

    @Override
    public void validateMustInput(List<SinSurFileBase> sinSurFileBases) {
        ArrayList<SinSurFileBase> successSinSurFileBases = new ArrayList<SinSurFileBase>(sinSurFileBases.size());
        for (SinSurFileBase sinSurFileBase : sinSurFileBases) {
            List<SinSurBase> sinSurBases;
            if (this.checkSInsurFileBases(sinSurFileBase, sinSurBases = sinSurFileBase.getSinSurBases())) continue;
            successSinSurFileBases.add(sinSurFileBase);
        }
        this.successSinSurFileBases = successSinSurFileBases;
        LOGGER.info("validateMustInput success");
    }

    private boolean checkSInsurFileBases(SinSurFileBase sinSurFileBase, List<SinSurBase> sinSurBases) {
        for (SinSurBase sinSurBase : sinSurBases) {
            if (this.longIsEmpty(sinSurBase.getSinSurFileId())) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.SIN_SUR_FILE_ID);
                break;
            }
            if (this.longIsEmpty(sinSurBase.getWelfareTypeId())) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.WELFARE_TYPE_ID);
                break;
            }
            if (sinSurBase.getBsed() == null) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.BSED);
                break;
            }
            if (sinSurBase.isInsured() == null) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.INSURED);
                break;
            }
            List<InsuranceItemEntry> insuranceItemEntries = sinSurBase.getInsuranceItemEntries();
            if (CollectionUtils.isEmpty(insuranceItemEntries)) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.INSURANCE_ITEM);
                return true;
            }
            for (InsuranceItemEntry insuranceItem : insuranceItemEntries) {
                if (!this.longIsEmpty(insuranceItem.getInsurancePropId())) continue;
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.IN_SUR_ANCE_PROP_ID);
                return true;
            }
        }
        return false;
    }

    @Override
    public void extractParam() {
        long startTime = System.currentTimeMillis();
        HashSet sinSurFileIds = Sets.newHashSetWithExpectedSize((int)this.successSinSurFileBases.size());
        HashSet welfareTypeIds = Sets.newHashSetWithExpectedSize((int)16);
        for (SinSurFileBase sinSurFileBase : this.successSinSurFileBases) {
            List<SinSurBase> sinSurBases = sinSurFileBase.getSinSurBases();
            for (SinSurBase sinSurBase : sinSurBases) {
                sinSurFileIds.add(sinSurBase.getSinSurFileId());
                welfareTypeIds.add(sinSurBase.getWelfareTypeId());
            }
        }
        this.welfareTypes = this.queryWelfareTypesByIds(welfareTypeIds);
        this.welfareTypeInsuranceTypeAttrMap = SinSurFileStdServiceHelper.queryInsuranceTypeAttrSetting(welfareTypeIds, SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.values());
        this.sinSurFiles = this.querySinSurFileByIds(sinSurFileIds);
        this.insuranceItemMap = SinSurFileStdImportServiceHelper.queryInsuranceItem(welfareTypeIds);
        Map<Object, DynamicObject> sinSurFileByIdMap = this.sinSurFiles.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, DynamicObject2 -> DynamicObject2));
        Map<Object, DynamicObject> welfareTypeMap = this.welfareTypes.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, DynamicObject2 -> DynamicObject2));
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)this.successSinSurFileBases.size());
        HashSet welfarePayerIds = Sets.newHashSetWithExpectedSize((int)16);
        for (SinSurFileBase sinSurFileBase : this.successSinSurFileBases) {
            for (SinSurBase sinSurBase : sinSurFileBase.getSinSurBases()) {
                DynamicObject sinSurFile = sinSurFileByIdMap.get(sinSurBase.getSinSurFileId());
                sinSurBase.setSinSurFile(sinSurFile);
                if (sinSurFile != null) {
                    personIds.add(sinSurFile.getLong("person.id"));
                    welfarePayerIds.add(sinSurFile.getLong("welfarepayer.id"));
                }
                Long welfareTypeId = sinSurBase.getWelfareTypeId();
                sinSurBase.setWelfareType(welfareTypeMap.get(welfareTypeId));
            }
        }
        this.placeOfWelfareIds = SinSurFileStdServiceHelper.queryPlaceOfWelfareIds(welfarePayerIds);
        this.personVersions = this.querySinSurPersonVersions(personIds);
        this.allSinSurFileBases = SinSurFileStdImportServiceHelper.querySinSurFileBases(this.sinSurFiles);
        Set<Long> set = this.getSinSurStdIds();
        this.sinSurStdVersions = SinSurFileStdServiceHelper.querySinSurStdVersions(set);
        long endTime = System.currentTimeMillis();
        LOGGER.info("extractParam success cost time :{}", (Object)(endTime - startTime));
    }
}

