/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file.attach;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.sit.hcsi.common.events.sinsurfilebase.SinSurFileBaseAddAttributeEvent;
import kd.sit.hcsi.business.common.helper.StandardCfgHelper;
import kd.sit.hcsi.business.file.SinSurFileStdImportServiceHelper;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.hcsi.business.file.attach.HisChangeSinSurBaseAbstract;
import kd.sit.hcsi.business.file.attach.InsuranceItemEntry;
import kd.sit.hcsi.business.file.attach.SinSurBase;
import kd.sit.hcsi.business.file.attach.SinSurBaseErrorResultEnum;
import kd.sit.hcsi.business.file.attach.SinSurFileBase;

public class HisChangeSinSurBaseServiceImpl
extends HisChangeSinSurBaseAbstract {
    private static final Log LOGGER = LogFactory.getLog(HisChangeSinSurBaseServiceImpl.class);
    protected List<DynamicObject> hisChangeSinSurBases = Lists.newArrayListWithCapacity((int)10);
    protected Map<Long, Map<String, List<DynamicObject>>> personIndexSinSurBases;
    protected Set<Long> insurTypeIdsAllowedPayInMultipleArea;

    @Override
    protected void parseDynamicObject(List<SinSurFileBase> sinSurFileBases) {
        long startTime = System.currentTimeMillis();
        ArrayList<SinSurFileBase> successSinSurFileBases = new ArrayList<SinSurFileBase>(sinSurFileBases.size());
        HashSet welfareTypeIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet personIndexIds = Sets.newHashSetWithExpectedSize((int)sinSurFileBases.size());
        for (SinSurFileBase sinSurFileBase : sinSurFileBases) {
            for (SinSurBase sinSurBase : sinSurFileBase.getSinSurBases()) {
                DynamicObject sinSurFile = sinSurBase.getSinSurFile();
                personIndexIds.add(sinSurFile.getLong("personindexid"));
                this.welfareTypes.add(sinSurBase.getWelfareType());
                welfareTypeIds.add(sinSurBase.getWelfareTypeId());
            }
        }
        this.welfareTypeInsuranceTypeAttrMap = SinSurFileStdServiceHelper.queryInsuranceTypeAttrSetting(welfareTypeIds, SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.values());
        this.insuranceItemMap = SinSurFileStdImportServiceHelper.queryInsuranceItem(welfareTypeIds);
        this.personIndexSinSurBases = SinSurFileStdImportServiceHelper.queryPersonIndexSinSurBases(personIndexIds, new ArrayList<Long>(welfareTypeIds));
        this.insurTypeIdsAllowedPayInMultipleArea = StandardCfgHelper.filterInsurTypeIdsInMultipleArea();
        this.dealSinSurFileBaseData(sinSurFileBases, successSinSurFileBases);
        this.successSinSurFileBases = successSinSurFileBases;
        long endTime = System.currentTimeMillis();
        LOGGER.info("parseDynamicObject success cost time :{}", (Object)(endTime - startTime));
    }

    @Override
    protected void doInvokeOp() {
        try (TXHandle txHandle = TX.required();){
            this.dealOperationResult(this.successSinSurFileBases, SinSurFileStdServiceHelper.hisChangeSinSurBase(this.hisChangeSinSurBases));
            txHandle.commit();
        }
    }

    protected void dealOperationResult(List<SinSurFileBase> sinSurFileBases, OperationResult operationResult) {
        if (operationResult != null && !operationResult.isSuccess()) {
            HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)16);
            for (SinSurFileBase sinSurFileBase : sinSurFileBases) {
                for (SinSurBase sinSurBase : sinSurFileBase.getSinSurBases()) {
                    paramsMap.put(sinSurBase.getPkValue(), sinSurFileBase);
                }
            }
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                SinSurFileBase sinSurFileBase = (SinSurFileBase)paramsMap.get(iOperateInfo.getPkValue());
                this.setErrorSinSurFileBaseResult(sinSurFileBase, iOperateInfo.getMessage(), SinSurBaseErrorResultEnum.EXCEPTION.getErrorCode());
            }
        }
    }

    private void dealSinSurFileBaseData(List<SinSurFileBase> sinSurFileBases, List<SinSurFileBase> successSinSurFileBases) {
        long[] sinSurBaseEntIds = DB.genLongIds((String)"t_hcsi_sinsurbaseent", (int)(sinSurFileBases.size() * 2));
        long[] sinSurBaseIds = DB.genLongIds((String)"hcsi_sinsurbase", (int)sinSurFileBases.size());
        int sinSurBaseIdIndex = 0;
        int sinSurBaseEntIdIndex = 0;
        block2: for (SinSurFileBase sinSurFileBase : sinSurFileBases) {
            for (SinSurBase sinSurBase : sinSurFileBase.getSinSurBases()) {
                DynamicObject insuredSinSurBaseFile;
                DynamicObject sinSurFile = sinSurBase.getSinSurFile();
                DynamicObject welfareType = sinSurBase.getWelfareType();
                DynamicObject sinSurFileBaseVersion = sinSurBase.getSinSurFileBaseVersion();
                sinSurBase.setBsled(sinSurFileBaseVersion.getDate("bsled"));
                long welfareTypeId = welfareType.getLong("id");
                if (sinSurBase.isInsured().booleanValue() && !this.insurTypeIdsAllowedPayInMultipleArea.contains(welfareTypeId) && (insuredSinSurBaseFile = SinSurFileStdServiceHelper.validateWelfareTypeInsuredFile(sinSurBase.getBsed(), sinSurFile, this.personIndexSinSurBases, welfareTypeId, sinSurBase.getBsled())) != null) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.REPEAT_INSURED, sinSurFile.getString("number"), welfareType.getString("name"), insuredSinSurBaseFile.getString("number"));
                    continue;
                }
                sinSurBase.setPkValue(sinSurBaseIds[sinSurBaseIdIndex]);
                sinSurBase.setBoId(sinSurFileBaseVersion.getLong("boid"));
                sinSurBase.setSinSurFileStd(sinSurFileBaseVersion.getDynamicObject("sinsurfilestd"));
                ++sinSurBaseIdIndex;
                sinSurBaseEntIdIndex = this.setItemEntityBoId(sinSurBaseEntIds[sinSurBaseEntIdIndex], sinSurBaseEntIdIndex, sinSurBase);
                try {
                    DynamicObject sinSurBaseDynamicObject = this.generateSinSurBaseDynamicObjects(sinSurBase);
                    SinSurFileBaseAddAttributeEvent sinSurFileBaseAddAttributeEvent = new SinSurFileBaseAddAttributeEvent(sinSurBaseDynamicObject, sinSurBase.getAttribute());
                    SinSurFileStdServiceHelper.addImportAttribute(sinSurFileBaseAddAttributeEvent);
                    if (!sinSurFileBaseAddAttributeEvent.isStatus()) {
                        this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.EXT_PARAMS_EXCEPTION, sinSurFile.getString("number"), sinSurFileBaseAddAttributeEvent.getMessage());
                        continue block2;
                    }
                    this.hisChangeSinSurBases.add(sinSurBaseDynamicObject);
                }
                catch (Exception exception) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, exception.getMessage(), SinSurBaseErrorResultEnum.EXCEPTION.getErrorCode());
                }
            }
            successSinSurFileBases.add(sinSurFileBase);
        }
    }

    private int setItemEntityBoId(long sinSurBaseEntId, int sinSurBaseEntIdIndex, SinSurBase sinSurBase) {
        for (InsuranceItemEntry insuranceItemEntry : sinSurBase.getInsuranceItemEntries()) {
            insuranceItemEntry.setEntryBoId(sinSurBaseEntId);
            ++sinSurBaseEntIdIndex;
        }
        return sinSurBaseEntIdIndex;
    }
}

