/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file.attach;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.file.SinSurFileStdImportServiceHelper;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.hcsi.business.file.attach.FailSinSurFileBase;
import kd.sit.hcsi.business.file.attach.InsuranceItemEntry;
import kd.sit.hcsi.business.file.attach.SinSurBase;
import kd.sit.hcsi.business.file.attach.SinSurBaseErrorResultEnum;
import kd.sit.hcsi.business.file.attach.SinSurFileBase;
import kd.sit.hcsi.business.file.attach.SinSurFileBaseParamService;
import kd.sit.hcsi.business.file.attach.SinSurFileBaseResult;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.enums.TruncationEnum;
import kd.sit.sitbp.common.util.BaseResult;

public abstract class SinSurFileBaseAbstract
implements SITBaseConstants {
    private static final Log LOGGER = LogFactory.getLog(SinSurFileBaseAbstract.class);
    SinSurFileBaseParamService sinSurFileBaseParamService;
    public static final String UNIQUE_CODE = "uniqueCode";
    public static final String ERROR_CODE = "errorCode";
    public static final String MESSAGE = "message";
    public static final String FILE_NUMBER = "fileNumber";
    public static final String DATA_INDEX = "dataIndex";
    protected List<SinSurFileBase> successSinSurFileBases;
    protected SinSurFileBaseResult sinSurFileBaseResult = new SinSurFileBaseResult();
    protected Map<Long, Map<Long, Boolean>> welfareTypeInsuranceTypeAttrMap = Maps.newHashMapWithExpectedSize((int)16);
    protected List<DynamicObject> sinSurFiles = Lists.newArrayListWithCapacity((int)10);
    protected Set<DynamicObject> sinSurStds = Sets.newHashSetWithExpectedSize((int)16);
    protected Set<DynamicObject> welfareTypes = Sets.newHashSetWithExpectedSize((int)16);
    protected Map<Long, Map<Long, DynamicObject>> insuranceItemMap = Maps.newHashMapWithExpectedSize((int)16);

    protected abstract void parseDynamicObject(List<SinSurFileBase> var1);

    protected void beforedoInvokeOp() {
    }

    protected abstract void doInvokeOp();

    protected abstract Map<String, Object> dealResult(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> invokeOp(List<Map<String, Object>> params) {
        try {
            long startTime = System.currentTimeMillis();
            List<SinSurFileBase> sinSurFileBases = this.sinSurFileBaseParamService.paramConvert(params);
            SinSurFileBaseResult sinSurFileBaseResult = this.sinSurFileBaseParamService.checkParam(sinSurFileBases);
            long paramEndTime = System.currentTimeMillis();
            LOGGER.info("param parse cost time :{}", (Object)(paramEndTime - startTime));
            this.sinSurFileBaseResult.addFailSinSurFileBases(sinSurFileBaseResult.getFailSinSurFileBases());
            List<SinSurFileBase> successSinSurFileBases = sinSurFileBaseResult.getSuccessSinSurFileBases();
            if (successSinSurFileBases == null) {
                Map<String, Object> map = this.dealResult(params.size());
                return map;
            }
            this.parseDynamicObject(successSinSurFileBases);
            long parseDynamicObjectEndTime = System.currentTimeMillis();
            LOGGER.info("parseDynamicObject cost time :{}", (Object)(parseDynamicObjectEndTime - paramEndTime));
            this.beforedoInvokeOp();
            this.doInvokeOp();
            long invokeOpEndTime = System.currentTimeMillis();
            LOGGER.info("doInvokeOp cost time :{}", (Object)(invokeOpEndTime - parseDynamicObjectEndTime));
            Map<String, Object> result = this.dealResult(params.size());
            long endTime = System.currentTimeMillis();
            LOGGER.info("SinSurFileBaseAbstract#invokeOp cost time :{}", (Object)(endTime - startTime));
            Map<String, Object> map = result;
            return map;
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            Map map = BaseResult.packageResult((boolean)false, (int)SinSurBaseErrorResultEnum.EXCEPTION.getErrorCode(), (String)exception.getMessage(), Collections.emptyList());
            return map;
        }
        finally {
            this.sinSurFileBaseParamService.removeMutex();
        }
    }

    protected OperationResult saveDynamicObject(Collection<DynamicObject> newDynamicObject, String status) {
        if (newDynamicObject.size() <= 0) {
            return null;
        }
        DynamicObject[] arraySinSurBase = new DynamicObject[newDynamicObject.size()];
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        if (HRStringUtils.isNotEmpty((String)status)) {
            operateOption.setVariableValue("status", status);
        }
        return opImpl.localInvokeOperation("save", newDynamicObject.toArray(arraySinSurBase), operateOption);
    }

    protected OperationResult hisChangeSinSurBase(List<DynamicObject> hisChangeDynamicObject) {
        if (hisChangeDynamicObject.size() <= 0) {
            return null;
        }
        DynamicObject[] arraySinSurBase = new DynamicObject[hisChangeDynamicObject.size()];
        return this.hisChangeSinSurBase(hisChangeDynamicObject.toArray(arraySinSurBase));
    }

    protected OperationResult hisChangeSinSurBase(DynamicObject[] dynamicObjects) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        return opImpl.localInvokeOperation("saveafteraudit", dynamicObjects, operateOption);
    }

    protected DynamicObject generateSinSurFileStdDynamicObject(SinSurFileBase sinSurFileBase) {
        DynamicObject sinSurFileStd;
        DynamicObject DBSinSurFileStdVersion = sinSurFileBase.getSinSurFileStd();
        HRBaseServiceHelper sinSurFileStdServiceHelper = new HRBaseServiceHelper("hcsi_sinsurfilestd");
        if (DBSinSurFileStdVersion == null) {
            sinSurFileStd = sinSurFileStdServiceHelper.generateEmptyDynamicObject();
            this.setCreateBaseFiled(sinSurFileStd);
        } else {
            sinSurFileStd = SinSurFileStdServiceHelper.createChangedDynamicObject(sinSurFileStdServiceHelper, DBSinSurFileStdVersion);
            this.setUpdateBaseFiled(sinSurFileStd);
        }
        long sinSurFileStdId = DB.genLongId((String)"t_hcsi_sinsurfilestd");
        sinSurFileBase.setPkValue(sinSurFileStdId);
        sinSurFileStd.set("id", (Object)sinSurFileStdId);
        if (this.generateSinSurFileStdDynamicObject(sinSurFileBase, sinSurFileStd)) {
            return null;
        }
        return sinSurFileStd;
    }

    protected boolean generateSinSurFileStdDynamicObject(SinSurFileBase sinSurFileBase, DynamicObject sinSurFileStd) {
        sinSurFileStd.set("bsed", (Object)sinSurFileBase.getBsed());
        sinSurFileStd.set("bsled", (Object)sinSurFileBase.getBsled());
        sinSurFileStd.set("sinsurfile", (Object)sinSurFileBase.getSinSurFile());
        sinSurFileStd.set("sinsurstd", (Object)sinSurFileBase.getSinSurStd());
        try {
            this.setExtparams(sinSurFileStd, sinSurFileBase.getSinSurFileStdExtParams());
        }
        catch (Exception exception) {
            LOGGER.error("setExtparams exception\uff1a", (Throwable)exception);
            this.setErrorSinSurFileBaseResult(sinSurFileBase, exception.getMessage(), SinSurBaseErrorResultEnum.EXCEPTION.getErrorCode());
            return true;
        }
        sinSurFileBase.setSinSurFileStd(sinSurFileStd);
        return false;
    }

    protected DynamicObject generateSinSurBaseDynamicObjects(SinSurBase sinSurBase) {
        HRBaseServiceHelper sinSurBaseServiceHelper = new HRBaseServiceHelper("hcsi_sinsurbase");
        DynamicObject sinSurFile = sinSurBase.getSinSurFile();
        DynamicObject sinSurStd = sinSurBase.getSinSurStd();
        DynamicObject sinSurFileStd = sinSurBase.getSinSurFileStd();
        DynamicObject welfareType = sinSurBase.getWelfareType();
        Long welfareTypeId = welfareType.getLong("id");
        DynamicObject sinSurBaseDynamicObject = sinSurBaseServiceHelper.generateEmptyDynamicObject();
        this.setCreateBaseFiled(sinSurBaseDynamicObject);
        sinSurBaseDynamicObject.set("sinsurstd", (Object)sinSurStd);
        sinSurBaseDynamicObject.set("sinsurfile", (Object)sinSurFile);
        sinSurBaseDynamicObject.set("sinsurfilestd", (Object)sinSurFileStd);
        sinSurBaseDynamicObject.set("bsed", (Object)sinSurBase.getBsed());
        sinSurBaseDynamicObject.set("bsled", (Object)(sinSurBase.getBsled() == null ? SinSurFileStdServiceHelper.generateBsledDate() : sinSurBase.getBsled()));
        sinSurBaseDynamicObject.set("welfaretype", (Object)welfareType);
        sinSurBaseDynamicObject.set("insured", (Object)sinSurBase.isInsured());
        sinSurBaseDynamicObject.set("description", (Object)sinSurBase.getDescription());
        if (!this.longIsEmpty(sinSurBase.getBoId())) {
            sinSurBaseDynamicObject.set("boid", (Object)sinSurBase.getBoId());
        }
        if (!this.longIsEmpty(sinSurBase.getPkValue())) {
            sinSurBaseDynamicObject.set("id", (Object)sinSurBase.getPkValue());
        }
        this.setExtparams(sinSurBaseDynamicObject, sinSurBase.getSinSurFileBaseExtParams());
        DynamicObjectCollection sinSurBaseEntries = sinSurBaseDynamicObject.getDynamicObjectCollection("entryentity");
        List<InsuranceItemEntry> insuranceItemEntries = sinSurBase.getInsuranceItemEntries();
        for (InsuranceItemEntry insuranceItemEntry : insuranceItemEntries) {
            String insurancePropValue;
            Long insuranceTypeId = insuranceItemEntry.getInsurancePropId();
            DynamicObject sinSurBaseEntry = sinSurBaseServiceHelper.generateEmptyEntryDynamicObject("entryentity");
            DynamicObject insuranceItem = insuranceItemEntry.getInsuranceItem();
            sinSurBaseEntry.set("insuranceitem", (Object)insuranceItem);
            Map<Long, Boolean> insuranceTypeAttr = this.welfareTypeInsuranceTypeAttrMap.get(welfareTypeId);
            if (sinSurBase.isInsured().booleanValue() && insuranceTypeAttr.get(insuranceTypeId).booleanValue() && HRStringUtils.isNotEmpty((String)(insurancePropValue = insuranceItemEntry.getInsurancePropValue()))) {
                String truncationCode = insuranceItemEntry.getTruncationCode();
                if (HRStringUtils.isNotEmpty((String)truncationCode)) {
                    BigDecimal bigDecimalValue = TruncationEnum.getBigDecimalValue((BigDecimal)new BigDecimal(insurancePropValue), (String)truncationCode);
                    sinSurBaseEntry.set("numvalue", (Object)bigDecimalValue);
                } else {
                    sinSurBaseEntry.set("numvalue", (Object)insurancePropValue);
                }
            }
            sinSurBaseEntry.set("insuranceprop", (Object)insuranceTypeId);
            if (!this.longIsEmpty(insuranceItemEntry.getEntryBoId())) {
                sinSurBaseEntry.set("entryboid", (Object)insuranceItemEntry.getEntryBoId());
            }
            sinSurBaseEntries.add((Object)sinSurBaseEntry);
        }
        sinSurBaseDynamicObject.set("entryentity", (Object)sinSurBaseEntries);
        return sinSurBaseDynamicObject;
    }

    protected List<DynamicObject> generateSinSurBaseDynamicObjects(SinSurFileBase sinSurFileBase, List<SinSurBase> sinSurBases) {
        ArrayList<DynamicObject> saveSinSurBases = new ArrayList<DynamicObject>(sinSurBases.size());
        for (SinSurBase sinSurBase : sinSurBases) {
            try {
                DynamicObject sinSurBaseDynamicObject = this.generateSinSurBaseDynamicObjects(sinSurBase);
                saveSinSurBases.add(sinSurBaseDynamicObject);
            }
            catch (Exception exception) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, exception.getMessage(), SinSurBaseErrorResultEnum.EXCEPTION.getErrorCode());
                return null;
            }
        }
        return saveSinSurBases;
    }

    protected void setCreateBaseFiled(DynamicObject dynamicObject) {
        long currUserId = RequestContext.get().getCurrUserId();
        dynamicObject.set("creator", (Object)currUserId);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("modifier", (Object)currUserId);
        dynamicObject.set("modifytime", (Object)new Date());
    }

    protected void setUpdateBaseFiled(DynamicObject dynamicObject) {
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("modifytime", (Object)new Date());
    }

    protected void setExtparams(DynamicObject dynamicObject, Map<String, Object> extParams) {
        if (extParams != null) {
            DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
            for (Map.Entry<String, Object> extParamEntry : extParams.entrySet()) {
                for (IDataEntityProperty property : properties) {
                    if (!property.getName().equals(extParamEntry.getKey())) continue;
                    if (property instanceof BasedataProp) {
                        String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(baseEntityId);
                        DynamicObject extDynamicObject = baseServiceHelper.generateEmptyDynamicObject();
                        extDynamicObject.set("id", extParamEntry.getValue());
                        dynamicObject.set(extParamEntry.getKey(), (Object)extDynamicObject);
                        continue;
                    }
                    dynamicObject.set(extParamEntry.getKey(), extParamEntry.getValue());
                }
            }
        }
    }

    protected String validateWelfareTypeInsuredFile(SinSurFileBase sinSurFileBase, Date bsledDate, Map<Long, Map<String, List<DynamicObject>>> personIndexSinSurBases, Set<Long> insurTypeIdsAllowedPayInMultipleArea) {
        Date bsed = sinSurFileBase.getBsed();
        DynamicObject sinSurFile = sinSurFileBase.getSinSurFile();
        String sinSurFileNumber = sinSurFile.getString("number");
        List<SinSurBase> sinSurBases = sinSurFileBase.getSinSurBases();
        for (SinSurBase sinSurBase : sinSurBases) {
            DynamicObject insuredSinSurBase;
            if (!sinSurBase.isInsured().booleanValue() || insurTypeIdsAllowedPayInMultipleArea.contains(sinSurBase.getWelfareTypeId()) || (insuredSinSurBase = SinSurFileStdServiceHelper.validateWelfareTypeInsuredFile(bsed, sinSurFile, personIndexSinSurBases, sinSurBase.getWelfareTypeId(), bsledDate)) == null) continue;
            this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.REPEAT_INSURED, sinSurFileNumber, sinSurBase.getWelfareType().getString("name"), insuredSinSurBase.getString("number"));
            return insuredSinSurBase.getString("number");
        }
        return null;
    }

    protected Map<Long, Map<String, List<DynamicObject>>> queryPersonIndexSinSurBases(Map<Long, List<SinSurFileBase>> sinSurStdSinSurFileMap, Map<Object, DynamicObject> sinSurStdMap) {
        HashMap<Long, Map<String, List<DynamicObject>>> result = new HashMap<Long, Map<String, List<DynamicObject>>>(sinSurStdSinSurFileMap.size());
        for (Map.Entry<Long, List<SinSurFileBase>> entrySet : sinSurStdSinSurFileMap.entrySet()) {
            Long sinSurStdId = entrySet.getKey();
            DynamicObject sinSurStd = sinSurStdMap.get(sinSurStdId);
            ArrayList<Long> welfareTypeIds = new ArrayList<Long>(10);
            DynamicObjectCollection stdEntryEntity = sinSurStd.getDynamicObjectCollection("stdentryentity");
            for (DynamicObject dynamicObject : stdEntryEntity) {
                welfareTypeIds.add(dynamicObject.getLong("insurtype.id"));
            }
            ArrayList<DynamicObject> sinSurFiles = new ArrayList<DynamicObject>(entrySet.getValue().size());
            for (SinSurFileBase sinSurFileBase : entrySet.getValue()) {
                sinSurFiles.add(sinSurFileBase.getSinSurFile());
            }
            result.putAll(SinSurFileStdImportServiceHelper.queryPersonIndexSinSurBases(sinSurFiles, welfareTypeIds));
        }
        return result;
    }

    protected Set<Long> getSinSurStdWelfareTypeId(Set<DynamicObject> sinSurStds) {
        HashSet<Long> allWelfareTypeIds = new HashSet<Long>(16);
        for (DynamicObject sinSurStd : sinSurStds) {
            DynamicObjectCollection stdentryentity = sinSurStd.getDynamicObjectCollection("stdentryentity");
            for (DynamicObject dynamicObject : stdentryentity) {
                allWelfareTypeIds.add(dynamicObject.getLong("insurtype.id"));
            }
        }
        return allWelfareTypeIds;
    }

    protected Set<DynamicObject> queryWelfareTypesByIds(Set<Long> welfareTypeIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("sitbs_welfaretype");
        QFilter welfareTypeIdFilter = new QFilter("id", "in", welfareTypeIds);
        QFilter sinSurStdStatusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] welfareTypes = hrBaseServiceHelper.query(new QFilter[]{welfareTypeIdFilter, sinSurStdStatusFilter, enableFilter});
        return new HashSet<DynamicObject>(Arrays.asList(welfareTypes));
    }

    protected void setErrorSinSurFileBaseResult(SinSurFileBase sinSurFileBase, String errorMsg, int errorCode) {
        FailSinSurFileBase failSinSurFileBase = new FailSinSurFileBase(sinSurFileBase, errorMsg, errorCode);
        this.sinSurFileBaseResult.addFailSinSurFileBase(failSinSurFileBase);
    }

    protected void setErrorSinSurFileBaseResult(SinSurFileBase sinSurFileBase, SinSurBaseErrorResultEnum sinSurBaseErrorResultEnum, Object ... values) {
        this.setErrorSinSurFileBaseResult(sinSurFileBase, MessageFormat.format(sinSurBaseErrorResultEnum.getErrorMessage().loadKDString(), values), sinSurBaseErrorResultEnum.getErrorCode());
    }

    protected boolean longIsEmpty(Long param) {
        return param == null || param == 0L;
    }
}

