/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file.attach;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.file.SinSurFileStdImportServiceHelper;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.hcsi.business.file.SinsurBaseImportService;
import kd.sit.hcsi.business.file.attach.HisChangeSinSurBaseParamExcelImpl;
import kd.sit.hcsi.business.file.attach.HisChangeSinSurBaseParamInterfaceImpl;
import kd.sit.hcsi.business.file.attach.HisChangeSinSurBaseServiceImpl;
import kd.sit.hcsi.business.file.attach.HisChangeSinSurFileBaseServiceImpl;
import kd.sit.hcsi.business.file.attach.SinSurBaseErrorResultEnum;
import kd.sit.hcsi.business.file.attach.SinSurFileStdAndBaseParamExcelImpl;
import kd.sit.hcsi.business.file.attach.SinSurFileStdAndBaseParamInterfaceImpl;
import kd.sit.hcsi.business.file.attach.SinSurFileStdAndBaseServiceImpl;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.constants.SITEntityConstants;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class SinSurFileBaseHelper
implements SITBaseConstants,
SITEntityConstants {
    private static final Log LOGGER = LogFactory.getLog(SinSurFileBaseHelper.class);
    private static final String UNIQUE_CODE = "uniqueCode";
    private static final String ERROR_CODE = "errorCode";
    private static final String MESSAGE = "message";
    private static final String SIN_SUR_FILE_ID = "sinSurFileId";
    private static final int SIZE = 200;

    public static List<Map<String, String>> importStdAndBases(Object logId, List<Map<String, Object>> params) {
        ISITAppCache isitAppCache = SITAppCache.get((String)SinSurFileBaseHelper.getAppCacheKey(logId));
        ArrayList errDataLists = Lists.newArrayListWithCapacity((int)10);
        SinsurBaseImportService importService = new SinsurBaseImportService();
        HashSet<String> groupByFileNumberMap = new HashSet<String>(params.size());
        Iterator<Map<String, Object>> iterator = params.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> param = iterator.next();
            String sinSurFileNumber = (String)BaseDataConverter.convert((Object)param.get("sinsurfile.number"), String.class);
            if (groupByFileNumberMap.add(sinSurFileNumber)) continue;
            Integer failCount = (Integer)isitAppCache.get("failCount", Integer.class);
            failCount = failCount == null ? Integer.valueOf(1) : Integer.valueOf(failCount + 1);
            isitAppCache.put("failCount", (Object)failCount);
            errDataLists.add(importService.assembleErrMap((Integer)BaseDataConverter.convert((Object)param.get("index"), Integer.class), false, sinSurFileNumber, SinSurBaseErrorResultEnum.REPEAT_SIN_SUR_FILE.getErrorMessage().loadKDString()));
            iterator.remove();
        }
        List partitions = Lists.partition(params, (int)200);
        for (List partition : partitions) {
            List<Map<String, String>> errDataList = SinSurFileBaseHelper.batchSaveSinSurFileStdAndBases(partition);
            errDataLists.addAll(errDataList);
            Integer failCount = (Integer)isitAppCache.get("failCount", Integer.class);
            failCount = failCount == null ? Integer.valueOf(errDataList.size()) : Integer.valueOf(failCount + errDataList.size());
            isitAppCache.put("failCount", (Object)failCount);
            Integer successCount = (Integer)isitAppCache.get("successCount", Integer.class);
            successCount = successCount == null ? Integer.valueOf(partition.size() - errDataList.size()) : Integer.valueOf(successCount + partition.size() - errDataList.size());
            isitAppCache.put("successCount", (Object)successCount);
            SinSurFileBaseHelper.feedBackProgress(logId, isitAppCache, failCount, successCount);
        }
        return errDataLists;
    }

    public static List<Map<String, String>> importSinSurBase(Object logId, List<Map<String, Object>> params) {
        ISITAppCache isitAppCache = SITAppCache.get((String)SinSurFileBaseHelper.getAppCacheKey(logId));
        HashMap<String, Set> sinSurFileWelfareTypes = new HashMap<String, Set>(params.size());
        ArrayList errDataLists = Lists.newArrayListWithCapacity((int)10);
        SinsurBaseImportService importService = new SinsurBaseImportService();
        Iterator<Map<String, Object>> iterator = params.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> param = iterator.next();
            String sinSurFileNumber = (String)BaseDataConverter.convert((Object)param.get("sinsurfile.number"), String.class);
            Set sinSurFileWelfareTypeIds = sinSurFileWelfareTypes.getOrDefault(sinSurFileNumber, new HashSet(16));
            if (!sinSurFileWelfareTypeIds.add(BaseDataConverter.convert((Object)param.get("welfaretype.name"), String.class))) {
                errDataLists.add(importService.assembleErrMap((Integer)BaseDataConverter.convert((Object)param.get("index"), Integer.class), false, sinSurFileNumber, SinSurBaseErrorResultEnum.FILE_REPEAT_WELFARE_TYPE.getErrorMessage().loadKDString()));
                iterator.remove();
                Integer failCount = (Integer)isitAppCache.get("failCount", Integer.class);
                failCount = failCount == null ? Integer.valueOf(1) : Integer.valueOf(failCount + 1);
                isitAppCache.put("failCount", (Object)failCount);
            }
            sinSurFileWelfareTypes.put(sinSurFileNumber, sinSurFileWelfareTypeIds);
        }
        List partitions = Lists.partition(params, (int)200);
        for (List partition : partitions) {
            List<Map<String, String>> errDataList = SinSurFileBaseHelper.batchHisChangeSinSurBases(partition);
            errDataLists.addAll(errDataList);
            Integer failCount = (Integer)isitAppCache.get("failCount", Integer.class);
            failCount = failCount == null ? Integer.valueOf(errDataList.size()) : Integer.valueOf(failCount + errDataList.size());
            isitAppCache.put("failCount", (Object)failCount);
            Integer successCount = (Integer)isitAppCache.get("successCount", Integer.class);
            successCount = successCount == null ? Integer.valueOf(partition.size() - errDataList.size()) : Integer.valueOf(successCount + partition.size() - errDataList.size());
            isitAppCache.put("successCount", (Object)successCount);
            SinSurFileBaseHelper.feedBackProgress(logId, isitAppCache, failCount, successCount);
        }
        return errDataLists;
    }

    public static Map<String, Object> saveSinSurFileStdAndBases(List<Map<String, Object>> params) {
        return SinSurFileBaseHelper.saveBatchSinSurFileStdAndBases(params, "saveSinSurFileStdAndBases");
    }

    public static Map<String, Object> hisChangeSinSurFileStdAndBases(List<Map<String, Object>> params) {
        return SinSurFileBaseHelper.saveBatchSinSurFileStdAndBases(params, "hisChangeSinSurFileStdAndBases");
    }

    public static Map<String, Object> hisChangeSinSurBases(List<Map<String, Object>> params) {
        HashMap<Long, Set> sinSurFileWelfareTypes = new HashMap<Long, Set>(params.size());
        ArrayList<Map<Object, Object>> failResults = new ArrayList<Map<Object, Object>>(params.size());
        Iterator<Map<String, Object>> iterator = params.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> param = iterator.next();
            Map sinSurFileBase = (Map)BaseDataConverter.convert((Object)param.get("sinSurFileBase"), Map.class);
            if (sinSurFileBase == null) continue;
            Long sinSurFileId = (Long)BaseDataConverter.convert(sinSurFileBase.get(SIN_SUR_FILE_ID), Long.class);
            Long welfareTypeId = (Long)BaseDataConverter.convert(sinSurFileBase.get("welfareTypeId"), Long.class);
            Set sinSurFileWelfareTypeIds = sinSurFileWelfareTypes.getOrDefault(sinSurFileId, new HashSet(16));
            if (!sinSurFileWelfareTypeIds.add(welfareTypeId)) {
                HashMap<String, Object> result = new HashMap<String, Object>(16);
                result.put(UNIQUE_CODE, param.get(UNIQUE_CODE));
                result.put(MESSAGE, SinSurBaseErrorResultEnum.FILE_REPEAT_WELFARE_TYPE.getErrorMessage().loadKDString());
                result.put(ERROR_CODE, SinSurBaseErrorResultEnum.FILE_REPEAT_WELFARE_TYPE.getErrorCode());
                failResults.add(result);
                iterator.remove();
            }
            sinSurFileWelfareTypes.put(sinSurFileId, sinSurFileWelfareTypeIds);
        }
        List partitions = Lists.partition(params, (int)200);
        for (List partition : partitions) {
            HisChangeSinSurBaseServiceImpl hisChangeSinSurBaseService = new HisChangeSinSurBaseServiceImpl();
            Map<String, Object> failResult = hisChangeSinSurBaseService.hisChangeSinSurBases(new HisChangeSinSurBaseParamInterfaceImpl(), partition);
            failResults.addAll(SinSurFileBaseHelper.dealInterfaceResult(failResult, partition));
        }
        return BaseResult.packageResult((boolean)true, (int)ResultStatusEnum.INFO.getCode(), (String)(failResults.size() == 0 ? "success" : "fail"), failResults);
    }

    public static Map<String, Object> hisChangeSinSurFileBases(List<Map<String, Object>> params) {
        HisChangeSinSurFileBaseServiceImpl hisChangeSinSurBaseService = new HisChangeSinSurFileBaseServiceImpl();
        return hisChangeSinSurBaseService.hisChangeSinSurBases(new HisChangeSinSurBaseParamInterfaceImpl(), params);
    }

    public static Map<String, Object> hisChangeSinSurFileStds(List<Map<String, Object>> params) {
        ArrayList<Map<Object, Object>> results = new ArrayList<Map<Object, Object>>(params.size());
        HashSet<Object> sinSurFileIds = new HashSet<Object>(params.size());
        for (int index = params.size() - 1; index >= 0; --index) {
            Map<String, Object> param = params.get(index);
            param.put("success", Boolean.FALSE);
            HashMap<Object, Object> result = new HashMap<Object, Object>(16);
            Object uniqueCode = param.get(UNIQUE_CODE);
            Object sinSurFileId = param.get(SIN_SUR_FILE_ID);
            if (sinSurFileId == null) {
                SinSurFileBaseHelper.setErrorInfo(result, uniqueCode, SinSurBaseErrorResultEnum.SIN_SUR_FILE_ID.getErrorMessage().loadKDString(), SinSurBaseErrorResultEnum.SIN_SUR_FILE_ID.getErrorCode());
                results.add(result);
                continue;
            }
            if (!sinSurFileIds.add(sinSurFileId)) {
                SinSurFileBaseHelper.setErrorInfo(result, uniqueCode, SinSurBaseErrorResultEnum.REPEAT_SIN_SUR_FILE.getErrorMessage().loadKDString(), SinSurBaseErrorResultEnum.REPEAT_SIN_SUR_FILE.getErrorCode());
                results.add(result);
                continue;
            }
            param.put("success", Boolean.TRUE);
        }
        QFilter sinSurFileIdFilter = new QFilter("id", "in", sinSurFileIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter sinSurFileStatusFilter = new QFilter("status", "=", (Object)"C");
        HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
        DynamicObject[] sinSurFiles = fileHelper.query("id,personindexid,number,welfarepayer,person", new QFilter[]{sinSurFileIdFilter, enableFilter, sinSurFileStatusFilter});
        Map<Object, DynamicObject> sinSurFileMap = Arrays.stream(sinSurFiles).collect(Collectors.toMap(DataEntityBase::getPkValue, DynamicObject2 -> DynamicObject2));
        Map<String, Map<Boolean, List<DynamicObject>>> allSinSurFileStds = SinSurFileStdImportServiceHelper.querySinSurFileStds(sinSurFileMap.values());
        for (Map<String, Object> param : params) {
            if (!((Boolean)param.get("success")).booleanValue()) continue;
            param.put("success", Boolean.FALSE);
            Object v = param.get(UNIQUE_CODE);
            HashMap<Object, Object> result = new HashMap<Object, Object>(16);
            Object sinSurFileId = param.get(SIN_SUR_FILE_ID);
            DynamicObject sinSurFile = sinSurFileMap.get(sinSurFileId);
            if (sinSurFile == null) {
                SinSurFileBaseHelper.setErrorInfo(result, v, SinSurBaseErrorResultEnum.SIN_SUR_FILE_NO_STATUS.getErrorMessage().loadKDString(), SinSurBaseErrorResultEnum.SIN_SUR_FILE_NO_STATUS.getErrorCode());
                results.add(result);
                continue;
            }
            Map<Boolean, List<DynamicObject>> sinSurStds = allSinSurFileStds.get(sinSurFile.getString("number"));
            if (sinSurStds == null || sinSurStds.size() == 0) {
                SinSurFileBaseHelper.setErrorInfo(result, v, SinSurBaseErrorResultEnum.DATA_NOT_EXISTS_EXCEPTION.getErrorMessage().loadKDString(), SinSurBaseErrorResultEnum.DATA_NOT_EXISTS_EXCEPTION.getErrorCode());
                results.add(result);
                continue;
            }
            param.put("success", Boolean.TRUE);
        }
        int size = 0;
        for (Map map : params) {
            if (!((Boolean)map.get("success")).booleanValue()) continue;
            ++size;
        }
        ArrayList<DynamicObject> hisChangeSinSurFileStds = new ArrayList<DynamicObject>(10);
        HRBaseServiceHelper hRBaseServiceHelper = new HRBaseServiceHelper("hcsi_sinsurfilestd");
        long[] sinSurFileStdIds = DB.genLongIds((String)"t_hcsi_sinsurfilestd", (int)size);
        int index = 0;
        for (Map<String, Object> param : params) {
            if (!((Boolean)param.get("success")).booleanValue()) continue;
            Object uniqueCode = param.get(UNIQUE_CODE);
            HashMap<Object, Object> result = new HashMap<Object, Object>(16);
            Object sinSurFileId = param.get(SIN_SUR_FILE_ID);
            DynamicObject sinSurFile = sinSurFileMap.get(sinSurFileId);
            Map<Boolean, List<DynamicObject>> sinSurStds = allSinSurFileStds.get(sinSurFile.getString("number"));
            List<DynamicObject> dynamicObjects = sinSurStds.get(Boolean.TRUE);
            DynamicObject currentSinSurFileStd = dynamicObjects.get(0);
            DynamicObject sinSurFileStdDynamicObject = SinSurFileStdServiceHelper.createChangedDynamicObject(hRBaseServiceHelper, currentSinSurFileStd);
            sinSurFileStdDynamicObject.set("bsed", (Object)currentSinSurFileStd.getDate("bsed"));
            try {
                for (Map.Entry<String, Object> entrySet : param.entrySet()) {
                    String key = entrySet.getKey();
                    if (HRStringUtils.equals((String)key, (String)"bsed") || HRStringUtils.equals((String)key, (String)"sinsurstd") || HRStringUtils.equals((String)key, (String)"success") || HRStringUtils.equals((String)key, (String)SIN_SUR_FILE_ID) || HRStringUtils.equals((String)key, (String)UNIQUE_CODE)) continue;
                    DataEntityPropertyCollection properties = sinSurFileStdDynamicObject.getDataEntityType().getProperties();
                    properties.forEach(property -> {
                        if (property.getName().equals(entrySet.getKey())) {
                            if (property instanceof BasedataProp) {
                                String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                                HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(baseEntityId);
                                DynamicObject extDynamicObject = baseServiceHelper.generateEmptyDynamicObject();
                                extDynamicObject.set("id", entrySet.getValue());
                            } else {
                                sinSurFileStdDynamicObject.set(key, entrySet.getValue());
                            }
                        }
                    });
                }
                sinSurFileStdDynamicObject.set("id", (Object)sinSurFileStdIds[index++]);
                hisChangeSinSurFileStds.add(sinSurFileStdDynamicObject);
                param.put("PkValue", sinSurFileStdDynamicObject.getLong("id"));
            }
            catch (Exception exception) {
                SinSurFileBaseHelper.setErrorInfo(result, uniqueCode, exception.getMessage(), 500);
                results.add(result);
            }
        }
        SinSurFileBaseHelper.excuteHisTransaction(params, results, hisChangeSinSurFileStds);
        return BaseResult.packageResult((boolean)true, (int)ResultStatusEnum.INFO.getCode(), (String)"success", results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void excuteHisTransaction(List<Map<String, Object>> params, List<Map<Object, Object>> results, List<DynamicObject> hisChangeSinSurFileStds) {
        try (TXHandle txHandle = TX.required();){
            SinSurFileBaseHelper.dealOperationResult(params, results, SinSurFileStdServiceHelper.hisChangeSinSurBase(hisChangeSinSurFileStds));
            txHandle.commit();
        }
    }

    private static void dealOperationResult(List<Map<String, Object>> params, List<Map<Object, Object>> results, OperationResult operationResult) {
        HashMap<Long, Map<String, Object>> paramsMap = new HashMap<Long, Map<String, Object>>(params.size());
        for (Map<String, Object> param : params) {
            paramsMap.put((Long)param.get("PkValue"), param);
        }
        if (operationResult != null && !operationResult.isSuccess()) {
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                Map param = (Map)paramsMap.get(iOperateInfo.getPkValue());
                if (!((Boolean)param.get("success")).booleanValue()) continue;
                HashMap<Object, Object> result = new HashMap<Object, Object>(16);
                Object uniqueCode = param.get(UNIQUE_CODE);
                SinSurFileBaseHelper.setErrorInfo(result, uniqueCode, iOperateInfo.getMessage(), 500);
                results.add(result);
            }
        }
    }

    private static void setErrorInfo(Map<Object, Object> result, Object uniqueCode, String message, int errorCode) {
        result.put(UNIQUE_CODE, uniqueCode);
        result.put(MESSAGE, message);
        result.put(ERROR_CODE, errorCode);
    }

    private static List<Map<String, String>> dealExcelResult(Map<String, Object> failResult) {
        SinsurBaseImportService importService = new SinsurBaseImportService();
        ArrayList errDataList = Lists.newArrayListWithCapacity((int)10);
        if (SinSurBaseErrorResultEnum.EXCEPTION.getErrorCode() == ((Integer)failResult.get("status")).intValue()) {
            String message = (String)BaseDataConverter.convert((Object)failResult.get(MESSAGE), String.class);
            errDataList.add(importService.assembleErrMap(0, true, "", message));
            return errDataList;
        }
        List failResults = (List)BaseDataConverter.convert((Object)failResult.get("data"), List.class);
        for (Map result : failResults) {
            String fileNumber = (String)BaseDataConverter.convert(result.get("fileNumber"), String.class);
            String message = (String)BaseDataConverter.convert(result.get(MESSAGE), String.class);
            int dataIndex = (Integer)BaseDataConverter.convert(result.get("dataIndex"), Integer.class);
            errDataList.add(importService.assembleErrMap(dataIndex, false, fileNumber, message));
        }
        return errDataList;
    }

    private static Map<String, Object> saveBatchSinSurFileStdAndBases(List<Map<String, Object>> params, String hisSinSurFileStdBases) {
        ArrayList<Map<Object, Object>> failResults = new ArrayList<Map<Object, Object>>(params.size());
        HashSet<Object> groupByFileIdMap = new HashSet<Object>(params.size());
        Iterator<Map<String, Object>> iterator = params.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> param = iterator.next();
            Map sinSurFileStd = (Map)param.get("sinSurFileStd");
            if (sinSurFileStd == null || groupByFileIdMap.add(BaseDataConverter.convert(sinSurFileStd.get(SIN_SUR_FILE_ID), Long.class))) continue;
            HashMap<String, Object> result = new HashMap<String, Object>(16);
            result.put(UNIQUE_CODE, param.get(UNIQUE_CODE));
            result.put(MESSAGE, SinSurBaseErrorResultEnum.REPEAT_SIN_SUR_FILE.getErrorMessage().loadKDString());
            result.put(ERROR_CODE, SinSurBaseErrorResultEnum.REPEAT_SIN_SUR_FILE.getErrorCode());
            failResults.add(result);
            iterator.remove();
        }
        List partitions = Lists.partition(params, (int)200);
        for (List partition : partitions) {
            List<Map<Object, Object>> results = SinSurFileBaseHelper.batchSaveSinSurFileStdAndBases(hisSinSurFileStdBases, partition);
            failResults.addAll(results);
        }
        return BaseResult.packageResult((boolean)true, (int)ResultStatusEnum.INFO.getCode(), (String)(failResults.size() == 0 ? "success" : "fail"), failResults);
    }

    private static List<Map<Object, Object>> batchSaveSinSurFileStdAndBases(String hisSinSurFileStdBases, List<Map<String, Object>> partition) {
        SinSurFileStdAndBaseServiceImpl sinSurFileStdAndBaseService = new SinSurFileStdAndBaseServiceImpl();
        SinSurFileStdAndBaseParamInterfaceImpl sinSurFileStdAndBaseParamInterface = new SinSurFileStdAndBaseParamInterfaceImpl(hisSinSurFileStdBases);
        Map<String, Object> failResult = sinSurFileStdAndBaseService.saveSinSurFileStdAndBases(sinSurFileStdAndBaseParamInterface, partition);
        return SinSurFileBaseHelper.dealInterfaceResult(failResult, partition);
    }

    private static List<Map<String, String>> batchHisChangeSinSurBases(List<Map<String, Object>> partition) {
        HisChangeSinSurBaseServiceImpl hisChangeSinSurBaseService = new HisChangeSinSurBaseServiceImpl();
        Map<String, Object> failResult = hisChangeSinSurBaseService.hisChangeSinSurBases(new HisChangeSinSurBaseParamExcelImpl(), partition);
        return SinSurFileBaseHelper.dealExcelResult(failResult);
    }

    private static List<Map<String, String>> batchSaveSinSurFileStdAndBases(List<Map<String, Object>> partition) {
        SinSurFileStdAndBaseServiceImpl sinSurFileStdAndBaseService = new SinSurFileStdAndBaseServiceImpl();
        SinSurFileStdAndBaseParamExcelImpl sinSurFileStdAndBaseParamExcel = new SinSurFileStdAndBaseParamExcelImpl();
        Map<String, Object> failResult = sinSurFileStdAndBaseService.saveSinSurFileStdAndBases(sinSurFileStdAndBaseParamExcel, partition);
        return SinSurFileBaseHelper.dealExcelResult(failResult);
    }

    private static List<Map<Object, Object>> dealInterfaceResult(Map<String, Object> failResult, List<Map<String, Object>> params) {
        if (SinSurBaseErrorResultEnum.EXCEPTION.getErrorCode() == ((Integer)failResult.get("status")).intValue()) {
            ArrayList errDataList = Lists.newArrayListWithCapacity((int)params.size());
            for (Map<String, Object> param : params) {
                HashMap<String, Object> result = new HashMap<String, Object>(16);
                result.put(UNIQUE_CODE, BaseDataConverter.convert((Object)param.get(UNIQUE_CODE), String.class));
                result.put(MESSAGE, BaseDataConverter.convert((Object)failResult.get(MESSAGE), String.class));
                result.put(ERROR_CODE, SinSurBaseErrorResultEnum.EXCEPTION.getErrorCode());
                errDataList.add(result);
            }
            return errDataList;
        }
        return (List)BaseDataConverter.convert((Object)failResult.get("data"), List.class);
    }

    private static void feedBackProgress(Object logId, ISITAppCache isitAppCache, Integer failCount, Integer successCount) {
        Integer total = (Integer)isitAppCache.get("totalCount", Integer.class);
        String floatingTaskId = (String)isitAppCache.get("floatingTaskId", String.class);
        if (HRStringUtils.isNotEmpty((String)floatingTaskId)) {
            HashMap<String, Object> floatingTaskParams = new HashMap<String, Object>(16);
            floatingTaskParams.put("logId", logId);
            try {
                HRBackgroundTaskHelper.getInstance().feedbackProgress(floatingTaskId, (successCount + failCount) * 100 / total, "", floatingTaskParams);
            }
            catch (Exception exp) {
                LOGGER.error("importSinSurBase, HRBackgroundTaskHelper.feedbackProgress error, ", (Throwable)exp);
            }
            if (total <= successCount + failCount) {
                try {
                    HRBackgroundTaskHelper.getInstance().feedbackStatus(floatingTaskId, "COMPLETED", "", floatingTaskParams);
                }
                catch (Exception exp) {
                    LOGGER.error("DclService.handleProgress, HRBackgroundTaskHelper.feedbackStatus error, ", (Throwable)exp);
                }
            }
        }
    }

    public static String getAppCacheKey(Object logId) {
        return "hcsi_sinsurbase_import" + logId;
    }
}

