/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file.attach;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.hcsi.business.file.attach.FailSinSurFileBase;
import kd.sit.hcsi.business.file.attach.InsuranceItemEntry;
import kd.sit.hcsi.business.file.attach.SinSurBase;
import kd.sit.hcsi.business.file.attach.SinSurBaseErrorResultEnum;
import kd.sit.hcsi.business.file.attach.SinSurFileBase;
import kd.sit.hcsi.business.file.attach.SinSurFileBaseAbstract;
import kd.sit.hcsi.business.file.attach.SinSurFileBaseParamService;
import kd.sit.hcsi.business.file.attach.SinSurFileBaseResult;
import kd.sit.sitbp.business.basecal.BaseCalMutexUtils;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.enums.TruncationEnum;
import kd.sit.sitbp.common.util.SITStringUtils;

public abstract class SinSurFileBaseParamAbstract
implements SinSurFileBaseParamService,
SITBaseConstants {
    private static final Log LOGGER = LogFactory.getLog(SinSurFileBaseAbstract.class);
    public static final Map<String, Long> COLUMN_INSURANCE_TYPE_ATTR_MAP = new HashMap<String, Long>(16);
    protected List<SinSurFileBase> successSinSurFileBases;
    protected SinSurFileBaseResult sinSurFileBaseResult = new SinSurFileBaseResult();
    protected Map<Long, Map<Long, Boolean>> welfareTypeInsuranceTypeAttrMap;
    protected List<DynamicObject> sinSurFiles;
    protected Map<Long, Map<Long, List<DynamicObject>>> personVersions;
    protected List<DynamicObject> sinSurStds;
    protected Map<Long, List<DynamicObject>> sinSurStdVersions;
    protected List<DynamicObject> welfareTypes;
    protected Map<Long, Long> placeOfWelfareIds;
    protected Map<Long, List<DynamicObject>> welfarePayerSinSurStd;
    protected Map<Long, Map<Long, DynamicObject>> insuranceItemMap;
    private Collection<Long> personindexids;

    @Override
    public SinSurFileBaseResult checkParam(List<SinSurFileBase> sinSurFileBases) {
        this.validateMustInput(sinSurFileBases);
        this.extractParam();
        this.validateBusiness();
        this.checkMutex();
        this.sinSurFileBaseResult.addSuccessSinSurFileBasess(this.successSinSurFileBases);
        return this.sinSurFileBaseResult;
    }

    private void checkMutex() {
        if (!SITStringUtils.equals((String)this.getSourceType(), (String)"import")) {
            return;
        }
        List<DynamicObject> files = this.getFileObjs();
        HashMap errMap = new HashMap(files.size());
        this.personindexids = BaseCalMutexUtils.addCalMutexData(files, errMap, (String)"import", (long)0L);
        ArrayList<SinSurFileBase> successSinSurFileBases = new ArrayList<SinSurFileBase>(this.successSinSurFileBases.size());
        for (SinSurFileBase sinSurFileBase : this.successSinSurFileBases) {
            String errMsg;
            Long fileId = sinSurFileBase.getSinSurFileId();
            if (fileId == null || fileId == 0L) {
                fileId = sinSurFileBase.getSinSurBases().get(0).getSinSurFileId();
            }
            if ((errMsg = (String)errMap.get(fileId)) != null) {
                FailSinSurFileBase failSinSurFileBase = new FailSinSurFileBase(sinSurFileBase, errMsg, SinSurBaseErrorResultEnum.BASE_CAL_MUTEX.getErrorCode());
                this.sinSurFileBaseResult.addFailSinSurFileBase(failSinSurFileBase);
                continue;
            }
            successSinSurFileBases.add(sinSurFileBase);
        }
        this.successSinSurFileBases = successSinSurFileBases;
    }

    protected abstract List<DynamicObject> getFileObjs();

    protected abstract void validateBusiness();

    protected abstract void validateMustInput(List<SinSurFileBase> var1);

    protected abstract void extractParam();

    protected boolean validateSinSurStd(Date bsed, Long sinSurStdId, long welfarePayerId, Map<Long, List<DynamicObject>> welfarePayerSinSurStd) {
        List<DynamicObject> coandDimRefVersions = welfarePayerSinSurStd.get(welfarePayerId);
        if (coandDimRefVersions == null) {
            return false;
        }
        for (DynamicObject coandDimRefVersion : coandDimRefVersions) {
            if (bsed.compareTo(coandDimRefVersion.getDate("bsed")) < 0 || bsed.compareTo(coandDimRefVersion.getDate("bsled")) > 0) continue;
            DynamicObjectCollection mulSinSurStds = coandDimRefVersion.getDynamicObjectCollection("mulsinsurstd");
            ArrayList<Long> sinSurStdIds = new ArrayList<Long>(mulSinSurStds.size());
            for (DynamicObject mulSinSurStd : mulSinSurStds) {
                sinSurStdIds.add(mulSinSurStd.getLong("fbasedataid.id"));
            }
            return sinSurStdIds.contains(sinSurStdId);
        }
        return false;
    }

    protected boolean validateInSurAnceProp(SinSurBase sinSurBase, SinSurFileBase sinSurFileBase) {
        Map<Long, Boolean> insuranceTypeAttr = this.welfareTypeInsuranceTypeAttrMap.get(sinSurBase.getWelfareTypeId());
        List<InsuranceItemEntry> insuranceItemEntries = sinSurBase.getInsuranceItemEntries();
        for (Map.Entry<String, Long> entrySet : SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.entrySet()) {
            Long insurancePropId = entrySet.getValue();
            if (!insuranceTypeAttr.get(insurancePropId).booleanValue()) continue;
            boolean flag = false;
            for (InsuranceItemEntry insuranceItemEntry : insuranceItemEntries) {
                if (!insurancePropId.equals(insuranceItemEntry.getInsurancePropId())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.PARAMS_DEFICIENCY);
            return true;
        }
        return false;
    }

    protected boolean validateMustInputInSurAnceProp(SinSurBase sinSurBase, SinSurFileBase sinSurFileBase) {
        Map<Long, Boolean> insuranceTypeAttr = this.welfareTypeInsuranceTypeAttrMap.get(sinSurBase.getWelfareTypeId());
        List<InsuranceItemEntry> insuranceItemEntries = sinSurBase.getInsuranceItemEntries();
        for (InsuranceItemEntry insuranceItemEntry : insuranceItemEntries) {
            Long insurancePropId = insuranceItemEntry.getInsurancePropId();
            if (!sinSurBase.isInsured().booleanValue() || !insuranceTypeAttr.get(insurancePropId).booleanValue() || !HRStringUtils.isEmpty((String)insuranceItemEntry.getInsurancePropValue())) continue;
            String insuranceTypeName = insurancePropId == 1010L ? ResManager.loadKDString((String)"\u4e2a\u4eba\u7f34\u8d39\u57fa\u6570", (String)"SinSurFileBaseParamAbstract_0", (String)"sit-hcsi-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5355\u4f4d\u7f34\u8d39\u57fa\u6570", (String)"SinSurFileBaseParamAbstract_1", (String)"sit-hcsi-business", (Object[])new Object[0]);
            this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.INSURANCE_PROP_MUST_INPUT, sinSurBase.getWelfareTypeName(), insuranceTypeName);
            return true;
        }
        return false;
    }

    protected boolean getHisSinSurBaseTruncationCode(SinSurBase sinSurBase, SinSurFileBase sinSurFileBase) {
        DynamicObject sinSurFile = sinSurBase.getSinSurFile();
        Date bsed = sinSurBase.getBsed();
        return this.getTruncationCode(sinSurBase, sinSurFileBase, sinSurBase.getSinSurStd(), sinSurFile, bsed);
    }

    protected boolean getTruncationCode(SinSurBase sinSurBase, SinSurFileBase sinSurFileBase) {
        DynamicObject sinSurFile = sinSurFileBase.getSinSurFile();
        Date bsed = sinSurFileBase.getBsed();
        return this.getTruncationCode(sinSurBase, sinSurFileBase, sinSurFileBase.getSinSurStd(), sinSurFile, bsed);
    }

    private boolean getTruncationCode(SinSurBase sinSurBase, SinSurFileBase sinSurFileBase, DynamicObject sinSurStd, DynamicObject sinSurFile, Date bsed) {
        DynamicObject sinSurStdVersion = this.getSinSurStdVersion(sinSurStd, bsed);
        long welfarePayerId = sinSurFile.getLong("welfarepayer.id");
        Long placeOfWelfareId = this.placeOfWelfareIds.get(welfarePayerId);
        DynamicObject sinSurPersonVersion = this.getSinSurPersonVersion(bsed, placeOfWelfareId, this.personVersions.get(sinSurFile.getLong("person.id")));
        Long welfareTypeId = sinSurBase.getWelfareTypeId();
        List<InsuranceItemEntry> insuranceItemEntries = sinSurBase.getInsuranceItemEntries();
        for (InsuranceItemEntry insuranceItemEntry : insuranceItemEntries) {
            Long insuranceItemId;
            Long insuranceTypeId = insuranceItemEntry.getInsurancePropId();
            Map<Long, DynamicObject> insuranceItemMaps = this.insuranceItemMap.get(welfareTypeId);
            DynamicObject insuranceItemDynamicObject = null;
            if (insuranceItemMaps != null) {
                insuranceItemDynamicObject = insuranceItemMaps.get(insuranceTypeId);
            }
            String truncationCode = null;
            if (insuranceItemDynamicObject != null && SinSurFileStdServiceHelper.isContainsTruncation(sinSurStdVersion, welfareTypeId, insuranceItemId = Long.valueOf(insuranceItemDynamicObject.getLong("id")))) {
                if (SinSurFileStdServiceHelper.isStdDim(sinSurStdVersion, welfareTypeId)) {
                    if (sinSurPersonVersion == null) {
                        LOGGER.error("\u627e\u4e0d\u5230\u793e\u4fdd\u4eba\u5458\u4fe1\u606f\u7248\u672c");
                        this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.NOT_UNIQUENESS, sinSurFile.getString("number"), sinSurBase.getWelfareTypeName());
                        return true;
                    }
                    truncationCode = SinSurFileStdServiceHelper.getTruncationCode(sinSurPersonVersion, sinSurStdVersion, true, welfareTypeId, insuranceItemId);
                    if (HRStringUtils.isEmpty((String)truncationCode)) {
                        this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.NOT_UNIQUENESS, sinSurFile.getString("number"), sinSurBase.getWelfareTypeName());
                        return true;
                    }
                } else {
                    truncationCode = SinSurFileStdServiceHelper.getTruncationCode(sinSurPersonVersion, sinSurStdVersion, false, welfareTypeId, insuranceItemId);
                }
            }
            insuranceItemEntry.setTruncationCode(truncationCode);
        }
        return false;
    }

    protected boolean validateInsurancePropValueLength(SinSurBase sinSurBase, SinSurFileBase sinSurFileBase) {
        if (sinSurBase.isInsured().booleanValue()) {
            DynamicObject welfareType = sinSurBase.getWelfareType();
            List<InsuranceItemEntry> insuranceItemEntries = sinSurBase.getInsuranceItemEntries();
            for (InsuranceItemEntry insuranceItemEntry : insuranceItemEntries) {
                String[] split;
                BigDecimal bigDecimalValue;
                Long insuranceTypeId = insuranceItemEntry.getInsurancePropId();
                String truncationCode = insuranceItemEntry.getTruncationCode();
                String insurancePropValue = insuranceItemEntry.getInsurancePropValue();
                if (HRStringUtils.isEmpty((String)insurancePropValue)) continue;
                try {
                    bigDecimalValue = new BigDecimal(insurancePropValue);
                }
                catch (Exception exception) {
                    LOGGER.error("NUMBER_FORMAT_EXCEPTION\uff1a{}", (Object)insurancePropValue);
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.NUMBER_FORMAT_EXCEPTION);
                    return true;
                }
                if (bigDecimalValue.compareTo(BigDecimal.ZERO) < 0) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.NUMBER_LARGE_ZERO);
                    return true;
                }
                if (HRStringUtils.isNotEmpty((String)truncationCode)) {
                    bigDecimalValue = TruncationEnum.getBigDecimalValue((BigDecimal)bigDecimalValue, (String)truncationCode);
                }
                if ((split = bigDecimalValue.toString().split("\\."))[0].length() <= 11) continue;
                String insuranceTypeName = insuranceTypeId == 1010L ? ResManager.loadKDString((String)"\u4e2a\u4eba\u7f34\u8d39\u57fa\u6570", (String)"SinSurFileBaseHelper_9", (String)"sit-hcsi-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5355\u4f4d\u7f34\u8d39\u57fa\u6570", (String)"SinSurFileBaseHelper_10", (String)"sit-hcsi-business", (Object[])new Object[0]);
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.INSURANCE_PROP_VALUE_OVER_SIZE, welfareType.getString("name"), insuranceTypeName);
                return true;
            }
        }
        return false;
    }

    protected List<DynamicObject> querySinSurFileByIds(Set<Long> sinSurFileIds) {
        QFilter sinSurFileIdFilter = new QFilter("id", "in", sinSurFileIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        return this.querySinSurFiles(new QFilter[]{sinSurFileIdFilter, enableFilter, statusFilter});
    }

    protected List<DynamicObject> querySinSurFileByNumbers(Set<String> sinSurFileNumbers) {
        return this.querySinSurFileByNumbers(sinSurFileNumbers, null);
    }

    protected List<DynamicObject> querySinSurFileByNumbers(Set<String> sinSurFileNumbers, QFilter welfarePayerIdFilter) {
        List authorizedDataRuleQFilters;
        QFilter sinSurFileNumberFilter = new QFilter("number", "in", sinSurFileNumbers);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        sinSurFileNumberFilter.and(enableFilter);
        sinSurFileNumberFilter.and(versionFilter);
        sinSurFileNumberFilter.and(statusFilter);
        if (welfarePayerIdFilter != null) {
            sinSurFileNumberFilter.and(welfarePayerIdFilter);
        }
        if ((authorizedDataRuleQFilters = SITPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"hcsi", (String)"hcsi_sinsurfile", (String)"47150e89000000ac")) == null) {
            return Lists.newArrayListWithCapacity((int)10);
        }
        if (authorizedDataRuleQFilters.size() > 0) {
            for (QFilter filter : authorizedDataRuleQFilters) {
                if (filter == null) continue;
                sinSurFileNumberFilter.and(filter);
            }
        }
        return this.querySinSurFiles(new QFilter[]{sinSurFileNumberFilter});
    }

    protected List<DynamicObject> querySinSurFiles(QFilter[] qFilters) {
        HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
        DynamicObject[] sinSurFiles = fileHelper.query("id,number,person,personindexid,empgroup,welfarepayer,sinsurstatus,boid,bsed,bsled,iscurrentversion,status", qFilters);
        return Arrays.asList(sinSurFiles);
    }

    protected List<DynamicObject> querySinSurStdByIds(Set<Long> sinSurStdIds) {
        QFilter sinSurStdIdFilter = new QFilter("id", "in", sinSurStdIds);
        QFilter sinSurStdStatusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        HRBaseServiceHelper sinSurStdHelper = new HRBaseServiceHelper("sitbs_sinsurstd");
        DynamicObject[] sinSurStds = sinSurStdHelper.query("bsed,stdentryentity,stdentryentity.insurtype", new QFilter[]{sinSurStdIdFilter, sinSurStdStatusFilter, enableFilter});
        return Arrays.asList(sinSurStds);
    }

    protected List<DynamicObject> queryCoandDimrefByIds(Set<Long> coandDimrefIds) {
        QFilter coandDimrefIdFilter = new QFilter("id", "in", coandDimrefIds);
        HRBaseServiceHelper coandDimrefHelper = new HRBaseServiceHelper("sitbs_coanddimref");
        DynamicObject[] coandDimrefs = coandDimrefHelper.query("id,bsed,bsled", new QFilter[]{coandDimrefIdFilter});
        return Arrays.asList(coandDimrefs);
    }

    protected List<DynamicObject> queryWelfareTypesByIds(Set<Long> welfareTypeIds) {
        QFilter welfareTypeIdFilter = new QFilter("id", "in", welfareTypeIds);
        QFilter sinSurStdStatusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return this.queryWelfareTypes(new QFilter[]{welfareTypeIdFilter, sinSurStdStatusFilter, enableFilter});
    }

    protected List<DynamicObject> queryWelfareTypesByNames(Set<String> welfareTypeNames) {
        QFilter welfareTypeNameFilter = new QFilter("name", "in", welfareTypeNames);
        QFilter sinSurStdStatusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return this.queryWelfareTypes(new QFilter[]{welfareTypeNameFilter, sinSurStdStatusFilter, enableFilter});
    }

    protected List<DynamicObject> queryWelfareTypes(QFilter[] qFilters) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("sitbs_welfaretype");
        DynamicObject[] welfareTypes = hrBaseServiceHelper.query(qFilters);
        return Arrays.asList(welfareTypes);
    }

    protected Map<Long, Map<Long, List<DynamicObject>>> querySinSurPersonVersions(Set<Long> personIds) {
        Collection<Long> placeIds = this.placeOfWelfareIds.values();
        if (CollectionUtils.isEmpty(placeIds)) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        return this.querySinSurPersonVersions(personIds, placeIds);
    }

    protected Map<Long, Map<Long, List<DynamicObject>>> querySinSurPersonVersions(Set<Long> personIds, Collection<Long> placeIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hcsi_sinsurperson");
        QFilter personIdFilter = new QFilter("person", "in", personIds);
        QFilter placeOfWelfareIdFilter = new QFilter("placeofwelfare", "in", placeIds);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SITBaseConstants.getEffectStatus());
        personIdFilter.and(dataStatusFilter);
        personIdFilter.and(placeOfWelfareIdFilter);
        DynamicObject[] query = hrBaseServiceHelper.query("person.id,placeofwelfare,bsed,bsled,registertype,category", new QFilter[]{personIdFilter});
        return Arrays.stream(query).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("person.id"), Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("placeofwelfare.id"))));
    }

    protected Set<Long> getSinSurStdWelfareTypeId(List<DynamicObject> sinSurStds) {
        HashSet<Long> allWelfareTypeIds = new HashSet<Long>(16);
        for (DynamicObject sinSurStd : sinSurStds) {
            DynamicObjectCollection stdentryentity = sinSurStd.getDynamicObjectCollection("stdentryentity");
            for (DynamicObject dynamicObject : stdentryentity) {
                allWelfareTypeIds.add(dynamicObject.getLong("insurtype.id"));
            }
        }
        return allWelfareTypeIds;
    }

    protected DynamicObject getSinSurStdVersion(DynamicObject sinSurStd, Date bsed) {
        List<DynamicObject> dynamicObjects = this.sinSurStdVersions.get(sinSurStd.getLong("id"));
        return this.getDynamicObjectVersion(dynamicObjects, bsed);
    }

    protected DynamicObject getSinSurPersonVersion(Date bsed, Long placeOfWelfareId, Map<Long, List<DynamicObject>> personVersions) {
        List<DynamicObject> dynamicObjects = personVersions.get(placeOfWelfareId);
        return this.getDynamicObjectVersion(dynamicObjects, bsed);
    }

    protected DynamicObject getDynamicObjectVersion(List<DynamicObject> dynamicObjects, Date bsed) {
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                Date sinSurPersonBsed = dynamicObject.getDate("bsed");
                Date sinSurPersonBsled = dynamicObject.getDate("bsled");
                if (sinSurPersonBsed.compareTo(bsed) > 0 || sinSurPersonBsled.compareTo(bsed) < 0) continue;
                return dynamicObject;
            }
        }
        return null;
    }

    protected DynamicObject getSinSurBase(Long welfareTypeId, List<DynamicObject> currentSinSurFileBases) {
        for (DynamicObject currentSinSurFileBase : currentSinSurFileBases) {
            if (currentSinSurFileBase.getLong("welfaretype.id") != welfareTypeId.longValue()) continue;
            return currentSinSurFileBase;
        }
        return null;
    }

    protected void setErrorSinSurFileBaseResult(SinSurFileBase sinSurFileBase, String errorMsg, int errorCode) {
        FailSinSurFileBase failSinSurFileBase = new FailSinSurFileBase(sinSurFileBase, errorMsg, errorCode);
        this.sinSurFileBaseResult.addFailSinSurFileBase(failSinSurFileBase);
    }

    protected void setErrorSinSurFileBaseResult(SinSurFileBase sinSurFileBase, SinSurBaseErrorResultEnum sinSurBaseErrorResultEnum) {
        this.setErrorSinSurFileBaseResult(sinSurFileBase, sinSurBaseErrorResultEnum.getErrorMessage().loadKDString(), sinSurBaseErrorResultEnum.getErrorCode());
    }

    protected void setErrorSinSurFileBaseResult(SinSurFileBase sinSurFileBase, SinSurBaseErrorResultEnum sinSurBaseErrorResultEnum, Object ... values) {
        this.setErrorSinSurFileBaseResult(sinSurFileBase, MessageFormat.format(sinSurBaseErrorResultEnum.getErrorMessage().loadKDString(), values), sinSurBaseErrorResultEnum.getErrorCode());
    }

    protected boolean longIsEmpty(Long param) {
        return param == null || param == 0L;
    }

    @Override
    public void removeMutex() {
        BaseCalMutexUtils.deleteCalMutexData(this.personindexids);
    }

    static {
        COLUMN_INSURANCE_TYPE_ATTR_MAP.put("personalcontribution", 1010L);
        COLUMN_INSURANCE_TYPE_ATTR_MAP.put("companycontribution", 1020L);
    }
}

