/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file.attach;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.hcsi.business.file.attach.FailSinSurFileBase;
import kd.sit.hcsi.business.file.attach.InsuranceItemEntry;
import kd.sit.hcsi.business.file.attach.SinSurBase;
import kd.sit.hcsi.business.file.attach.SinSurBaseErrorResultEnum;
import kd.sit.hcsi.business.file.attach.SinSurFileBase;
import kd.sit.hcsi.business.file.attach.SinSurFileBaseAbstract;
import kd.sit.hcsi.business.file.attach.SinSurFileBaseParamService;
import kd.sit.hcsi.business.file.attach.SinSurFileStdAndBaseService;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.util.BaseResult;

public abstract class SinSurFileStdAndBaseAbstract
extends SinSurFileBaseAbstract
implements SinSurFileStdAndBaseService {
    private static final Log LOGGER = LogFactory.getLog(SinSurFileStdAndBaseAbstract.class);

    @Override
    public Map<String, Object> saveSinSurFileStdAndBases(SinSurFileBaseParamService sinSurFileBaseParamService, List<Map<String, Object>> params) {
        this.sinSurFileBaseParamService = sinSurFileBaseParamService;
        return this.invokeOp(params);
    }

    @Override
    protected Map<String, Object> dealResult(int totalParam) {
        List<FailSinSurFileBase> failSinSurFileBases = this.sinSurFileBaseResult.getFailSinSurFileBases();
        ArrayList results = new ArrayList(totalParam);
        if (CollectionUtils.isNotEmpty(failSinSurFileBases)) {
            for (FailSinSurFileBase failSinSurFileBase : failSinSurFileBases) {
                HashMap<String, Object> result = new HashMap<String, Object>(16);
                result.put("uniqueCode", failSinSurFileBase.getSinSurFileBase().getUniqueCode());
                result.put("message", failSinSurFileBase.getErrorMsg());
                result.put("errorCode", failSinSurFileBase.getErrorCode());
                result.put("fileNumber", failSinSurFileBase.getSinSurFileBase().getSinSurFileNumber());
                result.put("dataIndex", String.valueOf(failSinSurFileBase.getSinSurFileBase().getRowIndex()));
                results.add(result);
            }
            return BaseResult.packageResult((boolean)true, (int)ResultStatusEnum.INFO.getCode(), (String)(failSinSurFileBases.size() == 0 ? "success" : "fail"), results);
        }
        return BaseResult.packageResult((boolean)true, (int)ResultStatusEnum.INFO.getCode(), (String)"success", results);
    }

    protected void dealOperationResult(List<SinSurFileBase> sinSurFileBases, OperationResult operationResult) {
        if (operationResult != null && !operationResult.isSuccess()) {
            Map<Object, SinSurFileBase> paramsMap = sinSurFileBases.stream().collect(Collectors.toMap(SinSurFileBase::getPkValue, SinSurFileBase2 -> SinSurFileBase2));
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                SinSurFileBase sinSurFileBase = paramsMap.get(iOperateInfo.getPkValue());
                this.setErrorSinSurFileBaseResult(sinSurFileBase, iOperateInfo.getMessage(), SinSurBaseErrorResultEnum.EXCEPTION.getErrorCode());
            }
        }
    }

    protected void createDefaultSinSurBases(SinSurFileBase sinSurFileBase) {
        DynamicObject sinSurFile = sinSurFileBase.getSinSurFile();
        DynamicObject sinSurFileStd = sinSurFileBase.getSinSurFileStd();
        DynamicObject sinSurStd = sinSurFileBase.getSinSurStd();
        List<SinSurBase> sinSurBases = sinSurFileBase.getSinSurBases();
        Set<Long> sinSurStdWelfareTypeIds = this.getReduceWelfareTypeIds(sinSurFileBase, sinSurFileBase.getSinSurStd());
        Map<Object, DynamicObject> welfareTypeMap = this.welfareTypes.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, DynamicObject2 -> DynamicObject2));
        for (Long sinSurStdWelfareTypeId : sinSurStdWelfareTypeIds) {
            SinSurBase sinSurBase = new SinSurBase();
            sinSurBase.setSinSurFile(sinSurFile);
            sinSurBase.setSinSurStd(sinSurStd);
            sinSurBase.setSinSurFileStd(sinSurFileStd);
            sinSurBase.setWelfareType(welfareTypeMap.get(sinSurStdWelfareTypeId));
            sinSurBase.setBsled(sinSurFileBase.getBsled());
            sinSurBase.setBsed(sinSurFileBase.getBsed());
            sinSurBase.setInsured(Boolean.FALSE);
            ArrayList insuranceItemEntries = Lists.newArrayListWithCapacity((int)10);
            for (Map.Entry<String, Long> entrySet : SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.entrySet()) {
                DynamicObject insuranceItem;
                Long insuranceTypeId = entrySet.getValue();
                InsuranceItemEntry insuranceItemEntry = sinSurBase.getInsuranceItemEntry();
                insuranceItemEntry.setInsurancePropId(insuranceTypeId);
                Map insuranceItems = (Map)this.insuranceItemMap.get(sinSurStdWelfareTypeId);
                if (insuranceItems != null && (insuranceItem = (DynamicObject)insuranceItems.get(insuranceTypeId)) != null) {
                    insuranceItemEntry.setInsuranceItem(insuranceItem);
                }
                insuranceItemEntries.add(insuranceItemEntry);
            }
            sinSurBase.setInsuranceItemEntries(insuranceItemEntries);
            sinSurBases.add(sinSurBase);
        }
    }

    protected void updateDBSinSurBases(Map<String, Map<Boolean, List<DynamicObject>>> allSinSurFileBases, SinSurFileBase sinSurFileBase) {
        List<SinSurBase> sinSurBases = sinSurFileBase.getSinSurBases();
        Set<Long> sinSurStdWelfareTypeIds = this.getReduceWelfareTypeIds(sinSurFileBase, sinSurFileBase.getSinSurStd());
        List<DynamicObject> dynamicObjects = allSinSurFileBases.get(sinSurFileBase.getSinSurFile().getString("number")).get(Boolean.TRUE);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long welfareTypeId = dynamicObject.getLong("welfaretype.id");
            if (!sinSurStdWelfareTypeIds.contains(welfareTypeId)) continue;
            SinSurBase sinSurBase = new SinSurBase();
            sinSurBase.setSinSurFile(dynamicObject.getDynamicObject("sinsurfile"));
            sinSurBase.setSinSurStd(dynamicObject.getDynamicObject("sinsurstd"));
            sinSurBase.setSinSurFileStd(dynamicObject.getDynamicObject("sinsurfilestd"));
            sinSurBase.setWelfareType(dynamicObject.getDynamicObject("welfaretype"));
            sinSurBase.setBsed(sinSurFileBase.getBsed());
            sinSurBase.setBsled(dynamicObject.getDate("bsled"));
            sinSurBase.setInsured(dynamicObject.getBoolean("insured"));
            sinSurBase.setDescription(dynamicObject.getString("description"));
            ArrayList<InsuranceItemEntry> insuranceItemEntries = new ArrayList<InsuranceItemEntry>(10);
            for (DynamicObject object : dynamicObject.getDynamicObjectCollection("entryentity")) {
                InsuranceItemEntry insuranceItemEntry = sinSurBase.getInsuranceItemEntry();
                insuranceItemEntry.setInsurancePropId(object.getLong("insuranceprop.id"));
                insuranceItemEntry.setInsurancePropValue(object.getString("numvalue"));
                insuranceItemEntry.setInsuranceItem(object.getDynamicObject("insuranceitem"));
                insuranceItemEntries.add(insuranceItemEntry);
            }
            sinSurBase.setInsuranceItemEntries(insuranceItemEntries);
            sinSurBases.add(sinSurBase);
        }
    }

    protected Set<Long> getReduceWelfareTypeIds(SinSurFileBase sinSurFileBase, DynamicObject sinSurStd) {
        DynamicObjectCollection stdentryentity = sinSurStd.getDynamicObjectCollection("stdentryentity");
        HashSet<Long> sinSurStdWelfareTypeIds = new HashSet<Long>(stdentryentity.size());
        for (DynamicObject dynamicObject : stdentryentity) {
            sinSurStdWelfareTypeIds.add(dynamicObject.getLong("insurtype.id"));
        }
        List<SinSurBase> sinSurBases = sinSurFileBase.getSinSurBases();
        HashSet<Long> welfareTypeIds = new HashSet<Long>(sinSurBases.size());
        for (SinSurBase sinSurBase : sinSurBases) {
            welfareTypeIds.add(sinSurBase.getWelfareType().getLong("id"));
        }
        sinSurStdWelfareTypeIds.removeAll(welfareTypeIds);
        return sinSurStdWelfareTypeIds;
    }

    protected Set<Long> getReduceWelfareTypeIds(SinSurFileBase sinSurFileBase, List<DynamicObject> sinSurFileBases) {
        HashSet<Long> sinSurStdWelfareTypeIds = new HashSet<Long>(sinSurFileBases.size());
        for (DynamicObject dynamicObject : sinSurFileBases) {
            sinSurStdWelfareTypeIds.add(dynamicObject.getLong("welfaretype.id"));
        }
        List<SinSurBase> sinSurBases = sinSurFileBase.getSinSurBases();
        HashSet<Long> welfareTypeIds = new HashSet<Long>(sinSurBases.size());
        for (SinSurBase sinSurBase : sinSurBases) {
            welfareTypeIds.add(sinSurBase.getWelfareTypeId());
        }
        sinSurStdWelfareTypeIds.removeAll(welfareTypeIds);
        return sinSurStdWelfareTypeIds;
    }
}

