/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file.attach;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.hcsi.business.file.attach.SinSurBase;
import kd.sit.hcsi.business.file.attach.SinSurBaseErrorResultEnum;
import kd.sit.hcsi.business.file.attach.SinSurFileBase;
import kd.sit.hcsi.business.file.attach.SinSurFileBaseParamAbstract;

public abstract class SinSurFileStdAndBaseParamAbstract
extends SinSurFileBaseParamAbstract {
    @Override
    public void validateBusiness() {
        ArrayList<SinSurFileBase> successSinSurFileBases = new ArrayList<SinSurFileBase>(this.successSinSurFileBases.size());
        HashSet<Long> groupByFileMap = new HashSet<Long>(this.successSinSurFileBases.size());
        block0: for (SinSurFileBase sinSurFileBase : this.successSinSurFileBases) {
            if (!groupByFileMap.add(sinSurFileBase.getSinSurFileId())) continue;
            DynamicObject sinSurFile = sinSurFileBase.getSinSurFile();
            if (sinSurFile == null) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.SIN_SUR_FILE_NOT_EXISTS);
                continue;
            }
            DynamicObject sinSurStd = sinSurFileBase.getSinSurStd();
            if (sinSurStd == null) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.SIN_SUR_STD_NOT_EXISTS);
                continue;
            }
            if (sinSurFileBase.getBsed().after(SinSurFileStdServiceHelper.generateBsledDate())) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.BSED_EXCEED);
                continue;
            }
            if (!this.validateSinSurStd(sinSurFileBase.getBsed(), sinSurFileBase.getSinSurStdId(), sinSurFile.getLong("welfarepayer.id"), this.welfarePayerSinSurStd)) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.MIS_MATCH_SIN_SUR_STD);
                continue;
            }
            DynamicObjectCollection stdentryentity = sinSurStd.getDynamicObjectCollection("stdentryentity");
            HashSet<Long> sinSurStdWelfareTypeIds = new HashSet<Long>(stdentryentity.size());
            for (DynamicObject dynamicObject : stdentryentity) {
                sinSurStdWelfareTypeIds.add(dynamicObject.getLong("insurtype.id"));
            }
            HashSet<Long> welfareTypeIds = new HashSet<Long>(sinSurFileBase.getSinSurBases().size());
            for (SinSurBase sinSurBase : sinSurFileBase.getSinSurBases()) {
                DynamicObject welfareTypeDynamicObject = sinSurBase.getWelfareType();
                if (welfareTypeDynamicObject == null) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.WELFARE_TYPE_NOT_EXISTS);
                    continue block0;
                }
                Long welfareTypeId = sinSurBase.getWelfareTypeId();
                if (sinSurBase.getBsed().after(SinSurFileStdServiceHelper.generateBsledDate())) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.BSED_EXCEED);
                    continue block0;
                }
                if (!sinSurStdWelfareTypeIds.contains(welfareTypeId)) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.NOT_CONTAINS_WELFARE_TYPE);
                    continue block0;
                }
                if (!welfareTypeIds.add(welfareTypeId)) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.REPEAT_WELFARE_TYPE);
                    continue block0;
                }
                Date sinSurFileBaseBsed = sinSurBase.getBsed();
                if (!sinSurFileBase.getBsed().equals(sinSurFileBaseBsed)) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.SAME_BSED);
                    continue block0;
                }
                String description = sinSurBase.getDescription();
                if (HRStringUtils.isNotEmpty((String)description) && description.trim().length() > 100) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.DESCRIPTION_OVER_SIZE);
                    continue block0;
                }
                if (!this.validateInSurAnceProp(sinSurBase, sinSurFileBase) && !this.validateMustInputInSurAnceProp(sinSurBase, sinSurFileBase) && !this.getTruncationCode(sinSurBase, sinSurFileBase) && !this.validateInsurancePropValueLength(sinSurBase, sinSurFileBase)) continue;
                continue block0;
            }
            successSinSurFileBases.add(sinSurFileBase);
        }
        this.successSinSurFileBases = successSinSurFileBases;
    }

    @Override
    protected List<DynamicObject> getFileObjs() {
        if (this.successSinSurFileBases == null) {
            return Collections.emptyList();
        }
        return this.successSinSurFileBases.stream().map(SinSurFileBase::getSinSurFile).collect(Collectors.toList());
    }
}

