/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file.attach;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.file.SinSurFileStdImportServiceHelper;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.hcsi.business.file.attach.InsuranceItemEntry;
import kd.sit.hcsi.business.file.attach.SinSurBase;
import kd.sit.hcsi.business.file.attach.SinSurBaseErrorResultEnum;
import kd.sit.hcsi.business.file.attach.SinSurFileBase;
import kd.sit.hcsi.business.file.attach.SinSurFileBaseExcelService;
import kd.sit.hcsi.business.file.attach.SinSurFileStdAndBaseParamAbstract;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class SinSurFileStdAndBaseParamExcelImpl
extends SinSurFileStdAndBaseParamAbstract
implements SinSurFileBaseExcelService {
    private static final Log LOGGER = LogFactory.getLog(SinSurFileStdAndBaseParamExcelImpl.class);
    private Set<Long> welfarePayerIds = Sets.newHashSetWithExpectedSize((int)16);

    @Override
    public String getSourceType() {
        return "import";
    }

    @Override
    public List<SinSurFileBase> paramConvert(List<Map<String, Object>> params) {
        ArrayList sinSurFileBases = Lists.newArrayListWithCapacity((int)10);
        for (Map<String, Object> param : params) {
            SinSurFileBase sinSurFileBase = new SinSurFileBase();
            sinSurFileBase.setRowIndex((Integer)BaseDataConverter.convert((Object)param.get("index"), Integer.class));
            sinSurFileBase.setSinSurFileNumber((String)BaseDataConverter.convert((Object)param.get("sinsurfile.number"), String.class));
            sinSurFileBase.setBsed((Date)BaseDataConverter.convert((Object)param.get("bsed"), Date.class));
            sinSurFileBase.setSinSurStdId((Long)BaseDataConverter.convert((Object)param.get("sinsurstd"), Long.class));
            sinSurFileBase.setCoandDimrefId((Long)BaseDataConverter.convert((Object)param.get("coandDimref"), Long.class));
            List<SinSurBase> sinSurBases = this.convertSinSurBase(param);
            sinSurFileBase.setSinSurBases(sinSurBases);
            sinSurFileBases.add(sinSurFileBase);
            this.welfarePayerIds.add((Long)BaseDataConverter.convert((Object)param.get("welfarepayer"), Long.class));
        }
        LOGGER.info("paramConvert success");
        return sinSurFileBases;
    }

    @Override
    public void validateMustInput(List<SinSurFileBase> sinSurFileBases) {
        ArrayList<SinSurFileBase> successSinSurFileBases = new ArrayList<SinSurFileBase>(sinSurFileBases.size());
        block0: for (SinSurFileBase sinSurFileBase : sinSurFileBases) {
            if (HRStringUtils.isEmpty((String)sinSurFileBase.getSinSurFileNumber())) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.SIN_SUR_FILE_NUMBER_EMPTY);
                continue;
            }
            if (sinSurFileBase.getBsed() == null) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.BSED);
                continue;
            }
            List<SinSurBase> sinSurBases = sinSurFileBase.getSinSurBases();
            if (CollectionUtils.isEmpty(sinSurBases)) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.SIN_SUR_FILE_BASES);
                continue;
            }
            for (SinSurBase sinSurBase : sinSurBases) {
                if (sinSurBase.isInsured() != null) continue;
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.INSURED);
                continue block0;
            }
            successSinSurFileBases.add(sinSurFileBase);
        }
        this.successSinSurFileBases = successSinSurFileBases;
        LOGGER.info("validateMustInput success");
    }

    @Override
    public void validateBusiness() {
        super.validateBusiness();
        ArrayList<SinSurFileBase> successSinSurFileBases = new ArrayList<SinSurFileBase>(this.successSinSurFileBases.size());
        for (SinSurFileBase sinSurFileBase : this.successSinSurFileBases) {
            DynamicObject coanddimRef = sinSurFileBase.getCoandDimref();
            if (coanddimRef != null) {
                Date coanddimRefBsed = coanddimRef.getDate("bsed");
                Date coanddimRefBsled = coanddimRef.getDate("bsled");
                Date bsed = sinSurFileBase.getBsed();
                if (bsed.compareTo(coanddimRefBsed) < 0 || bsed.compareTo(coanddimRefBsled) > 0) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.BSED_EXCEED_BUSINESS, sinSurFileBase.getSinSurFileNumber(), HRDateTimeUtils.format((Date)coanddimRefBsed, (String)"yyyy-MM-dd"), HRDateTimeUtils.format((Date)coanddimRefBsled, (String)"yyyy-MM-dd"));
                    continue;
                }
            }
            successSinSurFileBases.add(sinSurFileBase);
        }
        this.successSinSurFileBases = successSinSurFileBases;
        LOGGER.info("validateBusiness success");
    }

    @Override
    public void extractParam() {
        long startTime = System.currentTimeMillis();
        HashSet sinSurFileNumbers = Sets.newHashSetWithExpectedSize((int)16);
        HashSet sinSurStdIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet coandDimrefIds = Sets.newHashSetWithExpectedSize((int)16);
        for (SinSurFileBase sinSurFileBase : this.successSinSurFileBases) {
            sinSurFileNumbers.add(sinSurFileBase.getSinSurFileNumber());
            sinSurStdIds.add(sinSurFileBase.getSinSurStdId());
            coandDimrefIds.add(sinSurFileBase.getCoandDimrefId());
        }
        QFilter welfarePayerIdFilter = new QFilter("welfarepayer", "in", this.welfarePayerIds);
        this.sinSurFiles = this.querySinSurFileByNumbers(sinSurFileNumbers, welfarePayerIdFilter);
        this.sinSurStds = this.querySinSurStdByIds(sinSurStdIds);
        List<DynamicObject> coandDimrefs = this.queryCoandDimrefByIds(coandDimrefIds);
        Set<Long> welfareTypeIds = this.getSinSurStdWelfareTypeId(this.sinSurStds);
        this.welfareTypes = this.queryWelfareTypesByIds(welfareTypeIds);
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject sinSurFile : this.sinSurFiles) {
            personIds.add(sinSurFile.getLong("person.id"));
        }
        this.welfarePayerSinSurStd = SinSurFileStdServiceHelper.queryWelfarePayerSinSurStd(this.welfarePayerIds);
        this.placeOfWelfareIds = SinSurFileStdServiceHelper.queryPlaceOfWelfareIds(this.welfarePayerIds);
        this.welfareTypeInsuranceTypeAttrMap = SinSurFileStdServiceHelper.queryInsuranceTypeAttrSetting(welfareTypeIds, SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.values());
        this.insuranceItemMap = SinSurFileStdImportServiceHelper.queryInsuranceItem(welfareTypeIds);
        this.sinSurStdVersions = SinSurFileStdServiceHelper.querySinSurStdVersions(sinSurStdIds);
        this.personVersions = this.querySinSurPersonVersions(personIds);
        Map<String, DynamicObject> sinSurFileByNumberMap = this.sinSurFiles.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), DynamicObject2 -> DynamicObject2));
        Map<String, DynamicObject> welfareTypeByNumberMap = this.welfareTypes.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), DynamicObject2 -> DynamicObject2));
        Map<Object, DynamicObject> sinSurStdMap = this.sinSurStds.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, DynamicObject2 -> DynamicObject2));
        Map<Object, DynamicObject> coandDimrefMap = coandDimrefs.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, DynamicObject2 -> DynamicObject2));
        for (SinSurFileBase sinSurFileBase : this.successSinSurFileBases) {
            sinSurFileBase.setSinSurFile(sinSurFileByNumberMap.get(sinSurFileBase.getSinSurFileNumber()));
            sinSurFileBase.setSinSurStd(sinSurStdMap.get(sinSurFileBase.getSinSurStdId()));
            sinSurFileBase.setCoandDimref(coandDimrefMap.get(sinSurFileBase.getCoandDimrefId()));
            for (SinSurBase sinSurBase : sinSurFileBase.getSinSurBases()) {
                sinSurBase.setWelfareType(welfareTypeByNumberMap.get(sinSurBase.getWelfareTypeNumber()));
            }
        }
        long endTime = System.currentTimeMillis();
        LOGGER.info("extractParam success cost time :{}", (Object)(endTime - startTime));
    }

    private List<SinSurBase> convertSinSurBase(Map<String, Object> param) {
        HashMap welfareTypeParams = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            String key = (String)BaseDataConverter.convert((Object)entry.getKey(), String.class);
            if (!key.contains("insured") && !key.contains("personalcontribution") && !key.contains("companycontribution") && !key.contains("remarks")) continue;
            String[] split = key.split("\\.");
            Map objectObjectMap = (Map)welfareTypeParams.get(split[0]);
            if (objectObjectMap == null) {
                objectObjectMap = Maps.newHashMapWithExpectedSize((int)16);
            }
            objectObjectMap.put(split[1], entry.getValue());
            welfareTypeParams.put(split[0], objectObjectMap);
        }
        ArrayList<SinSurBase> sinSurBases = new ArrayList<SinSurBase>(welfareTypeParams.size());
        for (Map.Entry entry : welfareTypeParams.entrySet()) {
            String key = (String)entry.getKey();
            Map value = (Map)entry.getValue();
            SinSurBase sinSurBase = new SinSurBase();
            sinSurBase.setWelfareTypeNumber(key);
            sinSurBase.setBsed((Date)BaseDataConverter.convert((Object)param.get("bsed"), Date.class));
            String insured = (String)BaseDataConverter.convert(value.get("insured"), String.class);
            sinSurBase.setInsured(HRStringUtils.isEmpty((String)insured) ? null : (HRStringUtils.equals((String)insured, (String)ResManager.loadKDString((String)"\u662f", (String)"SinsurBaseImportService_15", (String)"sit-hcsi-business", (Object[])new Object[0])) ? Boolean.TRUE : Boolean.FALSE));
            sinSurBase.setDescription((String)BaseDataConverter.convert(value.get("remarks"), String.class));
            ArrayList insuranceItemEntry = Lists.newArrayListWithCapacity((int)10);
            for (Map.Entry insuranceType : COLUMN_INSURANCE_TYPE_ATTR_MAP.entrySet()) {
                InsuranceItemEntry insuranceItemTemp = sinSurBase.getInsuranceItemEntry();
                insuranceItemTemp.setInsurancePropId((Long)insuranceType.getValue());
                insuranceItemTemp.setInsurancePropValue((String)BaseDataConverter.convert(value.get(insuranceType.getKey()), String.class));
                insuranceItemEntry.add(insuranceItemTemp);
            }
            sinSurBase.setInsuranceItemEntries(insuranceItemEntry);
            sinSurBases.add(sinSurBase);
        }
        return sinSurBases;
    }
}

