/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file.attach;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.file.SinSurFileStdImportServiceHelper;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.hcsi.business.file.attach.InsuranceItemEntry;
import kd.sit.hcsi.business.file.attach.SinSurBase;
import kd.sit.hcsi.business.file.attach.SinSurBaseErrorResultEnum;
import kd.sit.hcsi.business.file.attach.SinSurFileBase;
import kd.sit.hcsi.business.file.attach.SinSurFileBaseInterfaceService;
import kd.sit.hcsi.business.file.attach.SinSurFileStdAndBaseParamAbstract;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class SinSurFileStdAndBaseParamInterfaceImpl
extends SinSurFileStdAndBaseParamAbstract
implements SinSurFileBaseInterfaceService {
    private static final Log LOGGER = LogFactory.getLog(SinSurFileStdAndBaseParamInterfaceImpl.class);
    public static final String SAVE_SIN_SUR_FILE_STD_BASES = "saveSinSurFileStdAndBases";
    public static final String HIS_SIN_SUR_FILE_STD_BASES = "hisChangeSinSurFileStdAndBases";
    private String method;

    @Override
    public String getSourceType() {
        return "interface";
    }

    public SinSurFileStdAndBaseParamInterfaceImpl(String method) {
        this.method = method;
    }

    @Override
    public List<SinSurFileBase> paramConvert(List<Map<String, Object>> params) {
        ArrayList<SinSurFileBase> sinSurFileBases = new ArrayList<SinSurFileBase>(10);
        for (Map<String, Object> param : params) {
            this.detailParamConvert(sinSurFileBases, param);
        }
        LOGGER.info("paramConvert success");
        return sinSurFileBases;
    }

    private void detailParamConvert(List<SinSurFileBase> sinSurFileBases, Map<String, Object> param) {
        List sinSurFileBaseParams;
        SinSurFileBase sinSurFileBase = new SinSurFileBase();
        sinSurFileBase.setUniqueCode(param.get("uniqueCode"));
        Map sinSurFileStd = (Map)param.get("sinSurFileStd");
        if (sinSurFileStd != null) {
            sinSurFileBase.setSinSurFileId((Long)BaseDataConverter.convert(sinSurFileStd.get("sinSurFileId"), Long.class));
            sinSurFileBase.setBsed((Date)BaseDataConverter.convert(sinSurFileStd.get("bsed"), Date.class));
            sinSurFileBase.setSinSurStdId((Long)BaseDataConverter.convert(sinSurFileStd.get("sinSurStdId"), Long.class));
            sinSurFileBase.setSinSurFileStdExtParams((Map)sinSurFileStd.get("sinSurFileStdExtparams"));
        }
        if ((sinSurFileBaseParams = (List)param.get("sinSurFileBases")) != null) {
            ArrayList<SinSurBase> sinSurBases = new ArrayList<SinSurBase>(sinSurFileBaseParams.size());
            for (Map sinSurFileBaseParam : sinSurFileBaseParams) {
                SinSurBase sinSurBase = new SinSurBase();
                sinSurBase.setWelfareTypeId((Long)BaseDataConverter.convert(sinSurFileBaseParam.get("welfareTypeId"), Long.class));
                sinSurBase.setBsed((Date)BaseDataConverter.convert(sinSurFileBaseParam.get("bsed"), Date.class));
                sinSurBase.setInsured((Boolean)BaseDataConverter.convert(sinSurFileBaseParam.get("insured"), Boolean.class));
                sinSurBase.setDescription((String)BaseDataConverter.convert(sinSurFileBaseParam.get("description"), String.class));
                sinSurBase.setSinSurFileBaseExtParams((Map)BaseDataConverter.convert(sinSurFileBaseParam.get("sinSurFileBaseExtparams"), Map.class));
                List insuranceItemParams = (List)sinSurFileBaseParam.get("insuranceItem");
                if (insuranceItemParams != null) {
                    ArrayList<InsuranceItemEntry> insuranceItemEntry = new ArrayList<InsuranceItemEntry>(insuranceItemParams.size());
                    for (Map insuranceItem : insuranceItemParams) {
                        InsuranceItemEntry insuranceItemTemp = sinSurBase.getInsuranceItemEntry();
                        insuranceItemTemp.setInsurancePropId((Long)BaseDataConverter.convert(insuranceItem.get("insurancePropId"), Long.class));
                        insuranceItemTemp.setInsurancePropValue((String)BaseDataConverter.convert(insuranceItem.get("insurancePropValue"), String.class));
                        insuranceItemEntry.add(insuranceItemTemp);
                    }
                    sinSurBase.setInsuranceItemEntries(insuranceItemEntry);
                }
                sinSurBases.add(sinSurBase);
            }
            sinSurFileBase.setSinSurBases(sinSurBases);
        }
        sinSurFileBases.add(sinSurFileBase);
    }

    @Override
    public void validateMustInput(List<SinSurFileBase> sinSurFileBases) {
        ArrayList<SinSurFileBase> successSinSurFileBases = new ArrayList<SinSurFileBase>(sinSurFileBases.size());
        block0: for (SinSurFileBase sinSurFileBase : sinSurFileBases) {
            if (this.longIsEmpty(sinSurFileBase.getSinSurFileId())) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.SIN_SUR_FILE_ID);
                continue;
            }
            if (this.longIsEmpty(sinSurFileBase.getSinSurStdId())) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.SIN_SUR_STD_ID);
                continue;
            }
            if (sinSurFileBase.getBsed() == null) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.BSED);
                continue;
            }
            List<SinSurBase> sinSurBases = sinSurFileBase.getSinSurBases();
            if (CollectionUtils.isEmpty(sinSurBases)) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.SIN_SUR_FILE_BASES);
                continue;
            }
            for (SinSurBase sinSurBase : sinSurBases) {
                if (this.longIsEmpty(sinSurBase.getWelfareTypeId())) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.WELFARE_TYPE_ID);
                    continue block0;
                }
                if (sinSurBase.getBsed() == null) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.BSED);
                    continue block0;
                }
                if (sinSurBase.isInsured() == null) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.INSURED);
                    continue block0;
                }
                List<InsuranceItemEntry> insuranceItemEntries = sinSurBase.getInsuranceItemEntries();
                if (CollectionUtils.isEmpty(insuranceItemEntries)) {
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.INSURANCE_ITEM);
                    continue block0;
                }
                if (!this.checkInsuranceItemEntry(sinSurFileBase, insuranceItemEntries)) continue;
                continue block0;
            }
            successSinSurFileBases.add(sinSurFileBase);
        }
        this.successSinSurFileBases = successSinSurFileBases;
        LOGGER.info("validateMustInput success");
    }

    private boolean checkInsuranceItemEntry(SinSurFileBase sinSurFileBase, List<InsuranceItemEntry> insuranceItemEntries) {
        for (InsuranceItemEntry insuranceItem : insuranceItemEntries) {
            if (!this.longIsEmpty(insuranceItem.getInsurancePropId())) continue;
            this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.IN_SUR_ANCE_PROP_ID);
            return true;
        }
        return false;
    }

    @Override
    public void extractParam() {
        long startTime = System.currentTimeMillis();
        HashSet sinSurFileIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet sinSurStdIds = Sets.newHashSetWithExpectedSize((int)16);
        for (SinSurFileBase sinSurFileBase : this.successSinSurFileBases) {
            sinSurFileIds.add(sinSurFileBase.getSinSurFileId());
            sinSurStdIds.add(sinSurFileBase.getSinSurStdId());
        }
        this.sinSurFiles = this.querySinSurFileByIds(sinSurFileIds);
        this.sinSurStds = this.querySinSurStdByIds(sinSurStdIds);
        Set<Long> welfareTypeIds = this.getSinSurStdWelfareTypeId(this.sinSurStds);
        this.welfareTypes = this.queryWelfareTypesByIds(welfareTypeIds);
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet welfarePayerIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject sinSurFile : this.sinSurFiles) {
            personIds.add(sinSurFile.getLong("person.id"));
            welfarePayerIds.add(sinSurFile.getLong("welfarepayer.id"));
        }
        this.welfarePayerSinSurStd = SinSurFileStdServiceHelper.queryWelfarePayerSinSurStd(welfarePayerIds);
        this.placeOfWelfareIds = SinSurFileStdServiceHelper.queryPlaceOfWelfareIds(welfarePayerIds);
        this.welfareTypeInsuranceTypeAttrMap = SinSurFileStdServiceHelper.queryInsuranceTypeAttrSetting(welfareTypeIds, SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.values());
        this.insuranceItemMap = SinSurFileStdImportServiceHelper.queryInsuranceItem(welfareTypeIds);
        this.sinSurStdVersions = SinSurFileStdServiceHelper.querySinSurStdVersions(sinSurStdIds);
        this.personVersions = this.querySinSurPersonVersions(personIds);
        Map<Object, DynamicObject> sinSurFileByIdMap = this.sinSurFiles.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, DynamicObject2 -> DynamicObject2));
        Map<Object, DynamicObject> welfareTypeMap = this.welfareTypes.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, DynamicObject2 -> DynamicObject2));
        Map<Object, DynamicObject> sinSurStdMap = this.sinSurStds.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, DynamicObject2 -> DynamicObject2));
        for (SinSurFileBase sinSurFileBase : this.successSinSurFileBases) {
            DynamicObject sinSurFile = sinSurFileByIdMap.get(sinSurFileBase.getSinSurFileId());
            sinSurFileBase.setSinSurFile(sinSurFile);
            sinSurFileBase.setSinSurStd(sinSurStdMap.get(sinSurFileBase.getSinSurStdId()));
            for (SinSurBase sinSurBase : sinSurFileBase.getSinSurBases()) {
                Long welfareTypeId = sinSurBase.getWelfareTypeId();
                sinSurBase.setWelfareType(welfareTypeMap.get(welfareTypeId));
            }
        }
        long endTime = System.currentTimeMillis();
        LOGGER.info("extractParam success cost time :{}", (Object)(endTime - startTime));
    }

    @Override
    public void validateBusiness() {
        super.validateBusiness();
        switch (this.method) {
            case "saveSinSurFileStdAndBases": {
                this.validateSinSurFileStatus("A", SinSurBaseErrorResultEnum.SIN_SUR_FILE_NO_SAVE);
                break;
            }
            case "hisChangeSinSurFileStdAndBases": {
                this.validateSinSurFileStatus("C", SinSurBaseErrorResultEnum.SIN_SUR_FILE_NO_STATUS);
                break;
            }
        }
        LOGGER.info("validateBusiness success");
    }

    private void validateSinSurFileStatus(String status, SinSurBaseErrorResultEnum sinSurFileNoSave) {
        ArrayList<SinSurFileBase> successSinSurFileBases = new ArrayList<SinSurFileBase>(this.successSinSurFileBases.size());
        for (SinSurFileBase sinSurFileBase : this.successSinSurFileBases) {
            DynamicObject sinSurFile = sinSurFileBase.getSinSurFile();
            String sinSurFileStatus = sinSurFile.getString("status");
            if (!HRStringUtils.equals((String)status, (String)sinSurFileStatus)) {
                this.setErrorSinSurFileBaseResult(sinSurFileBase, sinSurFileNoSave);
                continue;
            }
            successSinSurFileBases.add(sinSurFileBase);
        }
        this.successSinSurFileBases = successSinSurFileBases;
    }
}

