/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.file.attach;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sit.hcsi.common.entity.sinsurbase.InsuranceItemDto;
import kd.sdk.sit.hcsi.common.entity.sinsurbase.SinSurFileBaseDto;
import kd.sdk.sit.hcsi.common.entity.sinsurbase.SinSurFileBaseEntDto;
import kd.sdk.sit.hcsi.common.events.sinsurfilebase.SinSurFileBaseReplaceNumValueEvent;
import kd.sit.hcsi.business.common.helper.StandardCfgHelper;
import kd.sit.hcsi.business.file.SinSurFileStdImportServiceHelper;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.hcsi.business.file.attach.InsuranceItemEntry;
import kd.sit.hcsi.business.file.attach.SinSurBase;
import kd.sit.hcsi.business.file.attach.SinSurBaseErrorResultEnum;
import kd.sit.hcsi.business.file.attach.SinSurFileBase;
import kd.sit.hcsi.business.file.attach.SinSurFileStdAndBaseAbstract;
import kd.sit.sitbp.common.util.SITDateTimeUtils;

public class SinSurFileStdAndBaseServiceImpl
extends SinSurFileStdAndBaseAbstract {
    private static final Log LOGGER = LogFactory.getLog(SinSurFileStdAndBaseServiceImpl.class);
    private static final String BEFORE = "before";
    private static final String AFTER = "after";
    private static final String SAME = "same";
    private List<DynamicObject> saveSinSurFileStds = Lists.newArrayListWithCapacity((int)10);
    private List<DynamicObject> updateSinSurFileStds = Lists.newArrayListWithCapacity((int)10);
    private List<DynamicObject> saveSinSurBases = Lists.newArrayListWithCapacity((int)10);
    private List<DynamicObject> hisChangeSinSurFileStds = Lists.newArrayListWithCapacity((int)10);
    private List<DynamicObject> hisChangeSinSurBases = Lists.newArrayListWithCapacity((int)10);
    private List<DynamicObject> saveAndAuditSinSurBases = Lists.newArrayListWithCapacity((int)10);
    private Map<String, Map<Boolean, List<DynamicObject>>> allSinSurFileStds;
    private Map<String, Map<Boolean, List<DynamicObject>>> allSinSurFileBases;
    private Map<Long, List<SinSurFileBase>> sinSurStdSinSurFileMap;
    private Map<Object, DynamicObject> sinSurStdMap;
    private Map<Long, Map<String, List<DynamicObject>>> personIndexSinSurBases;
    protected Set<Long> insurTypeIdsAllowedPayInMultipleArea;

    @Override
    protected void parseDynamicObject(List<SinSurFileBase> sinSurFileBases) {
        long startTime = System.currentTimeMillis();
        ArrayList<SinSurFileBase> successSinSurFileBases = new ArrayList<SinSurFileBase>(sinSurFileBases.size());
        for (SinSurFileBase sinSurFileBase : sinSurFileBases) {
            DynamicObject sinSurFile = sinSurFileBase.getSinSurFile();
            this.sinSurFiles.add(sinSurFile);
            this.sinSurStds.add(sinSurFileBase.getSinSurStd());
        }
        Set<Long> welfareTypeIds = this.getSinSurStdWelfareTypeId(this.sinSurStds);
        this.welfareTypeInsuranceTypeAttrMap = SinSurFileStdServiceHelper.queryInsuranceTypeAttrSetting(welfareTypeIds, SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.values());
        this.insuranceItemMap = SinSurFileStdImportServiceHelper.queryInsuranceItem(welfareTypeIds);
        this.welfareTypes = this.queryWelfareTypesByIds(welfareTypeIds);
        this.allSinSurFileStds = SinSurFileStdImportServiceHelper.querySinSurFileStds(this.sinSurFiles);
        this.allSinSurFileBases = SinSurFileStdImportServiceHelper.querySinSurFileBases(this.sinSurFiles);
        this.sinSurStdSinSurFileMap = sinSurFileBases.stream().collect(Collectors.groupingBy(SinSurFileBase::getSinSurStdId));
        this.sinSurStdMap = this.sinSurStds.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, DynamicObject2 -> DynamicObject2));
        this.personIndexSinSurBases = this.queryPersonIndexSinSurBases(this.sinSurStdSinSurFileMap, this.sinSurStdMap);
        this.insurTypeIdsAllowedPayInMultipleArea = StandardCfgHelper.filterInsurTypeIdsInMultipleArea();
        SinSurFileBaseReplaceNumValueEvent saveSinSurFileBaseReplaceNumValueEvent = this.generateSinSurFileBaseChangeValueEvent(sinSurFileBases, "A");
        SinSurFileStdServiceHelper.replaceSinSurBaseNumValue(saveSinSurFileBaseReplaceNumValueEvent);
        List saveSinSurFileBaseDto = saveSinSurFileBaseReplaceNumValueEvent.getSinSurFileBaseDtos();
        Map<Long, SinSurFileBaseDto> sinSurFileBaseDtoByFileId = saveSinSurFileBaseDto.stream().collect(Collectors.toMap(SinSurFileBaseDto::getSinSurFileId, o -> o));
        SinSurFileBaseReplaceNumValueEvent auditSinSurFileBaseReplaceNumValueEvent = this.generateSinSurFileBaseChangeValueEvent(sinSurFileBases, "C");
        SinSurFileStdServiceHelper.replaceSinSurBaseNumValue(auditSinSurFileBaseReplaceNumValueEvent);
        List auditSinSurFileBaseDto = auditSinSurFileBaseReplaceNumValueEvent.getSinSurFileBaseDtos();
        Map<Long, SinSurFileBaseDto> auditSinSurFileBaseDtoByFileId = auditSinSurFileBaseDto.stream().collect(Collectors.toMap(SinSurFileBaseDto::getSinSurFileId, o -> o));
        for (SinSurFileBase sinSurFileBase : sinSurFileBases) {
            DynamicObject sinSurFile = sinSurFileBase.getSinSurFile();
            String sinSurFileStatus = sinSurFile.getString("status");
            if (HRStringUtils.equals((String)"A", (String)sinSurFileStatus)) {
                this.dealSaveSinSurBase(successSinSurFileBases, sinSurFileBase, sinSurFileBaseDtoByFileId);
                continue;
            }
            if (!HRStringUtils.equals((String)"C", (String)sinSurFileStatus)) continue;
            this.dealAuditSinSurBase(successSinSurFileBases, sinSurFileBase, auditSinSurFileBaseDtoByFileId);
        }
        this.validateCurrentParamsInsuredFile(successSinSurFileBases);
        this.successSinSurFileBases = successSinSurFileBases;
        long endTime = System.currentTimeMillis();
        LOGGER.info("parseDynamicObject success cost time :{}", (Object)(endTime - startTime));
    }

    @Override
    protected void doInvokeOp() {
        try (TXHandle txHandle = TX.required();){
            this.dealOperationResult(this.successSinSurFileBases, this.saveDynamicObject(this.saveSinSurFileStds, null));
            this.dealOperationResult(this.successSinSurFileBases, this.saveDynamicObject(this.updateSinSurFileStds, null));
            this.saveDynamicObject(this.saveSinSurBases, null);
            this.saveDynamicObject(this.saveAndAuditSinSurBases, "C");
            this.dealOperationResult(this.successSinSurFileBases, this.hisChangeSinSurBase(this.hisChangeSinSurFileStds));
            this.hisChangeSinSurBase(this.hisChangeSinSurBases);
            txHandle.commit();
        }
    }

    private void dealAuditSinSurBase(List<SinSurFileBase> successSinSurFileBases, SinSurFileBase sinSurFileBase, Map<Long, SinSurFileBaseDto> auditSinSurFileBaseDtoByFileId) {
        DynamicObject sinSurFile = sinSurFileBase.getSinSurFile();
        DynamicObject sinSurStd = sinSurFileBase.getSinSurStd();
        Date bsed = sinSurFileBase.getBsed();
        String sinSurFileNumber = sinSurFile.getString("number");
        Map<Boolean, List<DynamicObject>> sinSurFileStdMap = this.allSinSurFileStds.get(sinSurFileNumber);
        Map<Boolean, List<DynamicObject>> sinSurFileBaseMap = this.allSinSurFileBases.get(sinSurFileNumber);
        if (sinSurFileStdMap == null || sinSurFileBaseMap == null || sinSurFileStdMap.get(Boolean.FALSE) == null || sinSurFileBaseMap.get(Boolean.FALSE) == null) {
            LOGGER.error("\u6863\u6848\u7f16\u7801{}\uff1a\u53d8\u66f4\u65f6\u6570\u636e\u4e22\u5931", (Object)sinSurFileNumber);
            this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.DATA_EXCEPTION, sinSurFileNumber);
            return;
        }
        boolean isChanged = this.isChanged(bsed, sinSurFileStdMap, sinSurFileBase.getSinSurStd());
        if (!isChanged) {
            this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.EXISTS_VERSION, sinSurFileNumber, HRDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd"), sinSurStd.get("name"));
            return;
        }
        List<DynamicObject> sinSurFileBases = sinSurFileBaseMap.get(Boolean.FALSE);
        List<DynamicObject> sinSurFileStdVersions = sinSurFileStdMap.get(Boolean.FALSE);
        DynamicObject DBSinSurFileStdVersion = SinSurFileStdServiceHelper.getSourceVersion(bsed, sinSurFileStdVersions);
        if (DBSinSurFileStdVersion == null) {
            LOGGER.error("\u6863\u6848\u7f16\u7801{}\uff1a\u53d8\u66f4\u65f6\u6570\u636e\u4e22\u5931", (Object)sinSurFileNumber);
            this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.DATA_EXCEPTION, sinSurFileNumber, sinSurFileNumber);
            return;
        }
        String changeType = bsed.before(DBSinSurFileStdVersion.getDate("bsed")) ? BEFORE : (bsed.after(DBSinSurFileStdVersion.getDate("bsed")) ? AFTER : SAME);
        Date sinSurFileStdBsled = sinSurFileBase.getBsled() == null ? this.getBsled(changeType, sinSurStd, DBSinSurFileStdVersion) : sinSurFileBase.getBsled();
        String insuredSinSurFileNumber = this.validateWelfareTypeInsuredFile(sinSurFileBase, sinSurFileStdBsled, this.personIndexSinSurBases, this.insurTypeIdsAllowedPayInMultipleArea);
        if (HRStringUtils.isNotEmpty((String)insuredSinSurFileNumber)) {
            return;
        }
        this.parseSinSurFileBaseEntEvent(sinSurFileBase, auditSinSurFileBaseDtoByFileId, sinSurFile);
        sinSurFileBase.setSinSurFileStd(DBSinSurFileStdVersion);
        sinSurFileBase.setBsled(sinSurFileStdBsled);
        DynamicObject sinSurFileStd = this.generateSinSurFileStdDynamicObject(sinSurFileBase);
        if (sinSurFileStd == null) {
            return;
        }
        sinSurFileBase.setSinSurFileStd(sinSurFileStd);
        switch (changeType) {
            case "before": {
                if (!this.createBeforeBsedSinSurBase(sinSurFileBase, sinSurFileBases, DBSinSurFileStdVersion)) break;
                this.hisChangeSinSurFileStds.add(sinSurFileStd);
                successSinSurFileBases.add(sinSurFileBase);
                break;
            }
            case "after": 
            case "same": {
                if (!this.createAfterBsedSinSurBase(sinSurFileBase, sinSurFileBases)) break;
                this.hisChangeSinSurFileStds.add(sinSurFileStd);
                successSinSurFileBases.add(sinSurFileBase);
                break;
            }
        }
    }

    private boolean createAfterBsedSinSurBase(SinSurFileBase sinSurFileBase, List<DynamicObject> sinSurFileBases) {
        List<SinSurBase> hisChangeSinSurBases = this.createAfterBsedReduceSinSurBase(sinSurFileBase, sinSurFileBases);
        List<SinSurBase> sinSurBases = sinSurFileBase.getSinSurBases();
        ArrayList saveAndAuditSinSurBasesTemp = Lists.newArrayListWithCapacity((int)10);
        long[] sinSurBaseIds = DB.genLongIds((String)"t_hcsi_sinsurbase", (int)(sinSurBases.size() * 2));
        long[] sinSurBaseEntIds = DB.genLongIds((String)"t_hcsi_sinsurbaseent", (int)(sinSurBases.size() * 4));
        int sinSurBaseIdIndex = 0;
        int sinSurBaseEntIdIndex = 0;
        for (SinSurBase sinSurBase : sinSurBases) {
            sinSurBase.setSinSurStd(sinSurFileBase.getSinSurStd());
            sinSurBase.setSinSurFile(sinSurFileBase.getSinSurFile());
            sinSurBase.setSinSurFileStd(sinSurFileBase.getSinSurFileStd());
            sinSurBase.setBsled(sinSurFileBase.getBsled());
            DynamicObject DBSinSurBaseVersion = SinSurFileStdImportServiceHelper.getDBSinSurBaseVersion(sinSurBase.getBsed(), sinSurFileBases, sinSurBase.getWelfareTypeId());
            if (DBSinSurBaseVersion == null) {
                sinSurBase.setPkValue(sinSurBaseIds[sinSurBaseIdIndex]);
                ++sinSurBaseIdIndex;
                if (sinSurFileBase.getBsled().compareTo(SinSurFileStdServiceHelper.generateBsledDate()) != 0) {
                    SinSurBase hisChangeSinSurBase = new SinSurBase();
                    hisChangeSinSurBase.setSinSurFile(sinSurFileBase.getSinSurFile());
                    hisChangeSinSurBase.setSinSurFileStd(sinSurFileBase.getSinSurFileStd());
                    hisChangeSinSurBase.setSinSurStd(null);
                    hisChangeSinSurBase.setBsed(SITDateTimeUtils.addDay((Date)sinSurFileBase.getBsled(), (long)1L));
                    hisChangeSinSurBase.setBsled(SinSurFileStdServiceHelper.generateBsledDate());
                    hisChangeSinSurBase.setInsured(Boolean.FALSE);
                    hisChangeSinSurBase.setWelfareType(sinSurBase.getWelfareType());
                    hisChangeSinSurBase.setBoId(sinSurBase.getPkValue());
                    hisChangeSinSurBase.setDescription(SinSurBaseErrorResultEnum.SIN_SUR_STR_NOT_EXISTS_WELFARE_TYPE.getErrorMessage().loadKDString());
                    ArrayList insuranceItemEntries = Lists.newArrayListWithCapacity((int)10);
                    for (InsuranceItemEntry insuranceItemEntrySource : sinSurBase.getInsuranceItemEntries()) {
                        InsuranceItemEntry insuranceItemEntry = sinSurBase.getInsuranceItemEntry();
                        insuranceItemEntry.setInsuranceItem(insuranceItemEntrySource.getInsuranceItem());
                        insuranceItemEntry.setInsurancePropValue(null);
                        insuranceItemEntry.setInsurancePropId(insuranceItemEntrySource.getInsurancePropId());
                        insuranceItemEntry.setEntryBoId(sinSurBaseEntIds[sinSurBaseEntIdIndex]);
                        ++sinSurBaseEntIdIndex;
                        insuranceItemEntries.add(insuranceItemEntry);
                    }
                    hisChangeSinSurBase.setInsuranceItemEntries(insuranceItemEntries);
                    hisChangeSinSurBases.add(hisChangeSinSurBase);
                }
                saveAndAuditSinSurBasesTemp.add(sinSurBase);
                continue;
            }
            sinSurBase.setBoId(DBSinSurBaseVersion.getLong("boid"));
            for (InsuranceItemEntry insuranceItemEntrySource : sinSurBase.getInsuranceItemEntries()) {
                insuranceItemEntrySource.setEntryBoId(sinSurBaseEntIds[sinSurBaseEntIdIndex]);
                ++sinSurBaseEntIdIndex;
            }
            hisChangeSinSurBases.add(sinSurBase);
        }
        List<DynamicObject> hisChangeSinSurBaseDynamicObjects = this.generateSinSurBaseDynamicObjects(sinSurFileBase, hisChangeSinSurBases);
        if (hisChangeSinSurBaseDynamicObjects == null) {
            return false;
        }
        List<DynamicObject> saveAndAuditSinSurBasesDynamicObjects = this.generateSinSurBaseDynamicObjects(sinSurFileBase, saveAndAuditSinSurBasesTemp);
        if (saveAndAuditSinSurBasesDynamicObjects == null) {
            return false;
        }
        this.hisChangeSinSurBases.addAll(hisChangeSinSurBaseDynamicObjects);
        this.saveAndAuditSinSurBases.addAll(saveAndAuditSinSurBasesDynamicObjects);
        return true;
    }

    private List<SinSurBase> createAfterBsedReduceSinSurBase(SinSurFileBase sinSurFileBase, List<DynamicObject> sinSurFileBases) {
        Set<Long> sinSurStdWelfareTypeIds = this.getReduceWelfareTypeIds(sinSurFileBase, sinSurFileBases);
        ArrayList sinSurBases = Lists.newArrayListWithCapacity((int)10);
        long[] sinSurBaseEntIds = DB.genLongIds((String)"t_hcsi_sinsurbaseent", (int)(sinSurStdWelfareTypeIds.size() * 2));
        int index = 0;
        for (Long welfareTypeId : sinSurStdWelfareTypeIds) {
            DynamicObject DBSinSurBaseVersion = SinSurFileStdImportServiceHelper.getDBSinSurBaseVersion(sinSurFileBase.getBsed(), sinSurFileBases, welfareTypeId);
            if (DBSinSurBaseVersion == null) continue;
            SinSurBase sinSurBase = new SinSurBase();
            sinSurBase.setBoId(DBSinSurBaseVersion.getLong("boid"));
            sinSurBase.setSinSurFile(DBSinSurBaseVersion.getDynamicObject("sinsurfile"));
            sinSurBase.setSinSurStd(null);
            sinSurBase.setSinSurFileStd(DBSinSurBaseVersion.getDynamicObject("sinsurfilestd"));
            sinSurBase.setWelfareType(DBSinSurBaseVersion.getDynamicObject("welfaretype"));
            sinSurBase.setBsed(sinSurFileBase.getBsed());
            sinSurBase.setBsled(sinSurFileBase.getBsled());
            sinSurBase.setInsured(Boolean.FALSE);
            sinSurBase.setDescription(SinSurBaseErrorResultEnum.SIN_SUR_STR_NOT_EXISTS_WELFARE_TYPE.getErrorMessage().loadKDString());
            ArrayList<InsuranceItemEntry> insuranceItemEntries = new ArrayList<InsuranceItemEntry>(10);
            for (DynamicObject object : DBSinSurBaseVersion.getDynamicObjectCollection("entryentity")) {
                InsuranceItemEntry insuranceItemEntry = sinSurBase.getInsuranceItemEntry();
                insuranceItemEntry.setInsurancePropId(object.getLong("insuranceprop.id"));
                insuranceItemEntry.setInsuranceItem(object.getDynamicObject("insuranceitem"));
                insuranceItemEntry.setEntryBoId(sinSurBaseEntIds[index]);
                insuranceItemEntries.add(insuranceItemEntry);
                ++index;
            }
            sinSurBase.setInsuranceItemEntries(insuranceItemEntries);
            sinSurBases.add(sinSurBase);
        }
        return sinSurBases;
    }

    private boolean createBeforeBsedSinSurBase(SinSurFileBase sinSurFileBase, List<DynamicObject> sinSurFileBases, DynamicObject dbSinSurFileStdVersion) {
        List<SinSurBase> sinSurBases = sinSurFileBase.getSinSurBases();
        ArrayList saveAndAuditSinSurBasesTemp = Lists.newArrayListWithCapacity((int)10);
        ArrayList hisChangeSinSurBases = Lists.newArrayListWithCapacity((int)10);
        long[] sinSurBaseIds = DB.genLongIds((String)"t_hcsi_sinsurbase", (int)(sinSurBases.size() * 2));
        long[] sinSurBaseEntIds = DB.genLongIds((String)"t_hcsi_sinsurbaseent", (int)(sinSurBases.size() * 4));
        int sinSurBaseIdIndex = 0;
        int sinSurBaseEntIdIndex = 0;
        for (SinSurBase sinSurBase : sinSurBases) {
            InsuranceItemEntry insuranceItemEntry;
            ArrayList insuranceItemEntries;
            SinSurBase hisChangeSinSurBase;
            sinSurBase.setSinSurStd(sinSurFileBase.getSinSurStd());
            sinSurBase.setSinSurFile(sinSurFileBase.getSinSurFile());
            sinSurBase.setSinSurFileStd(sinSurFileBase.getSinSurFileStd());
            sinSurBase.setBsled(sinSurFileBase.getBsled());
            DynamicObject DBSinSurBaseVersion = SinSurFileStdImportServiceHelper.getDBSinSurBaseVersion(sinSurBase.getBsed(), sinSurFileBases, sinSurBase.getWelfareTypeId());
            if (DBSinSurBaseVersion != null) {
                sinSurBase.setBoId(DBSinSurBaseVersion.getLong("boid"));
                for (InsuranceItemEntry insuranceItemEntrySource : sinSurBase.getInsuranceItemEntries()) {
                    insuranceItemEntrySource.setEntryBoId(sinSurBaseEntIds[sinSurBaseEntIdIndex]);
                    ++sinSurBaseEntIdIndex;
                }
                hisChangeSinSurBases.add(sinSurBase);
                if (SinSurFileStdServiceHelper.generateBsledDate().compareTo(sinSurFileBase.getBsled()) == 0 || sinSurFileBase.getBsled().compareTo(SITDateTimeUtils.addDay((Date)DBSinSurBaseVersion.getDate("bsed"), (long)-1L)) == 0) continue;
                hisChangeSinSurBase = new SinSurBase();
                hisChangeSinSurBase.setSinSurFile(sinSurFileBase.getSinSurFile());
                hisChangeSinSurBase.setSinSurFileStd(sinSurFileBase.getSinSurFileStd());
                hisChangeSinSurBase.setSinSurStd(null);
                hisChangeSinSurBase.setBsed(SITDateTimeUtils.addDay((Date)sinSurFileBase.getBsled(), (long)1L));
                if (DBSinSurBaseVersion.getDynamicObject("sinsurstd") == null) {
                    hisChangeSinSurBase.setBsled(DBSinSurBaseVersion.getDate("bsled"));
                } else {
                    hisChangeSinSurBase.setBsled(SITDateTimeUtils.addDay((Date)DBSinSurBaseVersion.getDate("bsed"), (long)-1L));
                }
                hisChangeSinSurBase.setInsured(Boolean.FALSE);
                hisChangeSinSurBase.setWelfareType(sinSurBase.getWelfareType());
                hisChangeSinSurBase.setBoId(DBSinSurBaseVersion.getLong("boid"));
                hisChangeSinSurBase.setDescription(SinSurBaseErrorResultEnum.SIN_SUR_STR_NOT_EXISTS_WELFARE_TYPE.getErrorMessage().loadKDString());
                insuranceItemEntries = Lists.newArrayListWithCapacity((int)10);
                for (InsuranceItemEntry insuranceItemEntrySource : sinSurBase.getInsuranceItemEntries()) {
                    insuranceItemEntry = sinSurBase.getInsuranceItemEntry();
                    insuranceItemEntry.setInsuranceItem(insuranceItemEntrySource.getInsuranceItem());
                    insuranceItemEntry.setInsurancePropValue(null);
                    insuranceItemEntry.setInsurancePropId(insuranceItemEntrySource.getInsurancePropId());
                    insuranceItemEntry.setEntryBoId(sinSurBaseEntIds[sinSurBaseEntIdIndex]);
                    ++sinSurBaseEntIdIndex;
                    insuranceItemEntries.add(insuranceItemEntry);
                }
                hisChangeSinSurBase.setInsuranceItemEntries(insuranceItemEntries);
                hisChangeSinSurBases.add(hisChangeSinSurBase);
                continue;
            }
            sinSurBase.setPkValue(sinSurBaseIds[sinSurBaseIdIndex]);
            ++sinSurBaseIdIndex;
            saveAndAuditSinSurBasesTemp.add(sinSurBase);
            hisChangeSinSurBase = new SinSurBase();
            hisChangeSinSurBase.setSinSurFile(sinSurFileBase.getSinSurFile());
            hisChangeSinSurBase.setSinSurFileStd(sinSurFileBase.getSinSurFileStd());
            hisChangeSinSurBase.setSinSurStd(null);
            hisChangeSinSurBase.setBsed(dbSinSurFileStdVersion.getDate("bsed"));
            hisChangeSinSurBase.setBsled(SinSurFileStdServiceHelper.generateBsledDate());
            hisChangeSinSurBase.setInsured(Boolean.FALSE);
            hisChangeSinSurBase.setWelfareType(sinSurBase.getWelfareType());
            hisChangeSinSurBase.setBoId(sinSurBase.getPkValue());
            hisChangeSinSurBase.setDescription(SinSurBaseErrorResultEnum.SIN_SUR_STR_NOT_EXISTS_WELFARE_TYPE.getErrorMessage().loadKDString());
            insuranceItemEntries = Lists.newArrayListWithCapacity((int)10);
            for (InsuranceItemEntry insuranceItemEntrySource : sinSurBase.getInsuranceItemEntries()) {
                insuranceItemEntry = sinSurBase.getInsuranceItemEntry();
                insuranceItemEntry.setInsuranceItem(insuranceItemEntrySource.getInsuranceItem());
                insuranceItemEntry.setInsurancePropValue(null);
                insuranceItemEntry.setInsurancePropId(insuranceItemEntrySource.getInsurancePropId());
                insuranceItemEntry.setEntryBoId(sinSurBaseEntIds[sinSurBaseEntIdIndex]);
                ++sinSurBaseEntIdIndex;
                insuranceItemEntries.add(insuranceItemEntry);
            }
            hisChangeSinSurBase.setInsuranceItemEntries(insuranceItemEntries);
            hisChangeSinSurBases.add(hisChangeSinSurBase);
        }
        List<DynamicObject> hisChangeSinSurBaseDynamicObjects = this.generateSinSurBaseDynamicObjects(sinSurFileBase, hisChangeSinSurBases);
        if (hisChangeSinSurBaseDynamicObjects == null) {
            return false;
        }
        List<DynamicObject> saveAndAuditSinSurBasesDynamicObjectTemp = this.generateSinSurBaseDynamicObjects(sinSurFileBase, saveAndAuditSinSurBasesTemp);
        if (saveAndAuditSinSurBasesDynamicObjectTemp == null) {
            return false;
        }
        this.hisChangeSinSurBases.addAll(hisChangeSinSurBaseDynamicObjects);
        this.saveAndAuditSinSurBases.addAll(saveAndAuditSinSurBasesDynamicObjectTemp);
        return true;
    }

    private void dealSaveSinSurBase(List<SinSurFileBase> successSinSurFileBases, SinSurFileBase sinSurFileBase, Map<Long, SinSurFileBaseDto> sinSurFileBaseDtoByFileId) {
        DynamicObject sinSurFile = sinSurFileBase.getSinSurFile();
        Date bsledDate = SinSurFileStdServiceHelper.generateBsledDate();
        String insuredSinSurFileNumber = this.validateWelfareTypeInsuredFile(sinSurFileBase, bsledDate, this.personIndexSinSurBases, this.insurTypeIdsAllowedPayInMultipleArea);
        if (HRStringUtils.isNotEmpty((String)insuredSinSurFileNumber)) {
            return;
        }
        this.parseSinSurFileBaseEntEvent(sinSurFileBase, sinSurFileBaseDtoByFileId, sinSurFile);
        sinSurFileBase.setBsled(bsledDate);
        Map<Boolean, List<DynamicObject>> sinSurFileStdMap = this.allSinSurFileStds.get(sinSurFile.getString("number"));
        if (sinSurFileStdMap == null || sinSurFileStdMap.get(Boolean.TRUE) == null) {
            DynamicObject sinSurFileStd = this.generateSinSurFileStdDynamicObject(sinSurFileBase);
            if (sinSurFileStd == null) {
                return;
            }
            for (SinSurBase sinSurBase : sinSurFileBase.getSinSurBases()) {
                sinSurBase.setSinSurFile(sinSurFileBase.getSinSurFile());
                sinSurBase.setSinSurStd(sinSurFileBase.getSinSurStd());
                sinSurBase.setSinSurFileStd(sinSurFileBase.getSinSurFileStd());
            }
            this.createDefaultSinSurBases(sinSurFileBase);
            List<DynamicObject> sinSurBaseDynamicObjects = this.generateSinSurBaseDynamicObjects(sinSurFileBase, sinSurFileBase.getSinSurBases());
            if (sinSurBaseDynamicObjects == null) {
                return;
            }
            this.saveSinSurBases.addAll(sinSurBaseDynamicObjects);
            this.saveSinSurFileStds.add(sinSurFileStd);
        } else {
            List<DynamicObject> sinSurFileStds = sinSurFileStdMap.get(Boolean.TRUE);
            DynamicObject sinSurFileStd = sinSurFileStds.get(0);
            if (this.generateSinSurFileStdDynamicObject(sinSurFileBase, sinSurFileStd)) {
                return;
            }
            for (SinSurBase sinSurBase : sinSurFileBase.getSinSurBases()) {
                sinSurBase.setSinSurFile(sinSurFileBase.getSinSurFile());
                sinSurBase.setSinSurStd(sinSurFileBase.getSinSurStd());
                sinSurBase.setSinSurFileStd(sinSurFileBase.getSinSurFileStd());
            }
            if (!HRDateTimeUtils.format((Date)sinSurFileBase.getBsed(), (String)"yyyy-MM-dd").equals(HRDateTimeUtils.format((Date)sinSurFileStd.getDate("bsed"), (String)"yyyy-MM-dd")) || sinSurFileStd.getLong("sinsurstd.id") != sinSurFileBase.getSinSurStdId().longValue()) {
                this.createDefaultSinSurBases(sinSurFileBase);
            } else {
                this.updateDBSinSurBases(this.allSinSurFileBases, sinSurFileBase);
            }
            List<DynamicObject> sinSurBaseDynamicObjects = this.generateSinSurBaseDynamicObjects(sinSurFileBase, sinSurFileBase.getSinSurBases());
            if (sinSurBaseDynamicObjects == null) {
                return;
            }
            sinSurFileBase.setPkValue(sinSurFileStd.getPkValue());
            this.saveSinSurBases.addAll(sinSurBaseDynamicObjects);
            this.updateSinSurFileStds.add(sinSurFileStd);
        }
        successSinSurFileBases.add(sinSurFileBase);
    }

    private SinSurFileBaseReplaceNumValueEvent generateSinSurFileBaseChangeValueEvent(List<SinSurFileBase> sinSurFileBases, String sinSurFileStatus) {
        ArrayList<SinSurFileBaseDto> sinSurFileBaseDtos = new ArrayList<SinSurFileBaseDto>(10);
        for (SinSurFileBase sinSurFileBase : sinSurFileBases) {
            DynamicObject sinSurFile = sinSurFileBase.getSinSurFile();
            Long sinSurStdId = sinSurFileBase.getSinSurStdId();
            if (!HRStringUtils.equals((String)sinSurFileStatus, (String)sinSurFile.getString("status"))) continue;
            List<SinSurBase> sinSurBases = sinSurFileBase.getSinSurBases();
            ArrayList<SinSurFileBaseEntDto> sinSurFileBaseEntDtos = new ArrayList<SinSurFileBaseEntDto>(sinSurBases.size());
            for (SinSurBase sinSurBase : sinSurBases) {
                ArrayList<InsuranceItemDto> insuranceItemDtos = new ArrayList<InsuranceItemDto>(10);
                Map insuranceTypeAttrMap = (Map)this.welfareTypeInsuranceTypeAttrMap.get(sinSurBase.getWelfareTypeId());
                List<InsuranceItemEntry> insuranceItemEntries = sinSurBase.getInsuranceItemEntries();
                for (InsuranceItemEntry insuranceItemEntry : insuranceItemEntries) {
                    if (!((Boolean)insuranceTypeAttrMap.get(insuranceItemEntry.getInsurancePropId())).booleanValue()) continue;
                    InsuranceItemDto insuranceItemDto = new InsuranceItemDto(insuranceItemEntry.getInsurancePropId());
                    insuranceItemDto.setInsurancePropValue(insuranceItemEntry.getInsurancePropValue());
                    insuranceItemDtos.add(insuranceItemDto);
                }
                SinSurFileBaseEntDto sinSurFileBaseEntDto = new SinSurFileBaseEntDto(sinSurBase.getWelfareTypeId(), sinSurBase.isInsured(), sinSurBase.getBsed(), insuranceItemDtos);
                sinSurFileBaseEntDtos.add(sinSurFileBaseEntDto);
            }
            SinSurFileBaseDto sinSurFileBaseDto = new SinSurFileBaseDto(Long.valueOf(sinSurFile.getLong("id")), sinSurStdId, sinSurFileBaseEntDtos);
            sinSurFileBaseDtos.add(sinSurFileBaseDto);
        }
        String operationType = "";
        if (HRStringUtils.equals((String)sinSurFileStatus, (String)"A")) {
            operationType = "save";
        } else if (HRStringUtils.equals((String)sinSurFileStatus, (String)"C")) {
            operationType = "saveafteraudit";
        }
        return new SinSurFileBaseReplaceNumValueEvent(sinSurFileBaseDtos, this.sinSurFileBaseParamService.getSourceType(), operationType);
    }

    private void parseSinSurFileBaseEntEvent(SinSurFileBase sinSurFileBase, Map<Long, SinSurFileBaseDto> sinSurFileBaseDtoByFileId, DynamicObject sinSurFile) {
        List changeSurFileBaseEntDtos;
        SinSurFileBaseDto changeSinSurFileBaseDto = sinSurFileBaseDtoByFileId.get(sinSurFile.getLong("id"));
        Map<Long, SinSurFileBaseEntDto> changeSinSurFileBaseEntDto = null;
        if (changeSinSurFileBaseDto != null && CollectionUtils.isNotEmpty((Collection)(changeSurFileBaseEntDtos = changeSinSurFileBaseDto.getSinSurFileBaseEntDtos()))) {
            changeSinSurFileBaseEntDto = changeSurFileBaseEntDtos.stream().collect(Collectors.toMap(SinSurFileBaseEntDto::getWelfareTypeId, o -> o));
        }
        if (changeSinSurFileBaseEntDto != null) {
            List<SinSurBase> sinSurBases = sinSurFileBase.getSinSurBases();
            for (SinSurBase sinSurBase : sinSurBases) {
                List<InsuranceItemEntry> insuranceItemEntries = sinSurBase.getInsuranceItemEntries();
                for (InsuranceItemEntry insuranceItemEntry : insuranceItemEntries) {
                    insuranceItemEntry.setInsurancePropValue(SinSurFileStdServiceHelper.parseSinSurFileBaseEntEvent(changeSinSurFileBaseEntDto, sinSurBase.getWelfareTypeId(), sinSurBase.isInsured(), insuranceItemEntry.getInsurancePropId(), this.welfareTypeInsuranceTypeAttrMap));
                }
            }
        }
    }

    private void validateCurrentParamsInsuredFile(List<SinSurFileBase> sinSurFileBases) {
        Map<Object, DynamicObject> sinSurFileMap = this.sinSurFiles.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, DynamicObject2 -> DynamicObject2));
        this.personIndexSinSurBases.clear();
        HashMap<Long, List> sinSurFileByPersonIndexId = new HashMap<Long, List>();
        for (DynamicObject dynamicObject : this.saveSinSurFileStds) {
            List list = sinSurFileByPersonIndexId.computeIfAbsent(dynamicObject.getLong("sinsurfile.personindexid"), key -> new ArrayList());
            list.add(sinSurFileMap.get(dynamicObject.getLong("sinsurfile.id")));
        }
        HashMap<Long, List> sinSurBaseMaps = new HashMap<Long, List>(this.saveSinSurBases.size());
        for (DynamicObject dynamicObject : this.saveSinSurBases) {
            List list = sinSurBaseMaps.computeIfAbsent(dynamicObject.getLong("sinsurfile.id"), key -> new ArrayList());
            list.add(dynamicObject);
        }
        HashMap<Long, List> hashMap = new HashMap<Long, List>(this.saveSinSurFileStds.size());
        for (DynamicObject dynamicObject : this.saveSinSurFileStds) {
            List sinSurFileStds = hashMap.computeIfAbsent(dynamicObject.getLong("sinsurfile.id"), key -> new ArrayList());
            sinSurFileStds.add(dynamicObject);
        }
        for (Map.Entry entry : sinSurFileByPersonIndexId.entrySet()) {
            Long personIndexId = (Long)entry.getKey();
            HashMap<String, List> map = new HashMap<String, List>();
            List sinSurFilesTemp = (List)entry.getValue();
            if (sinSurFilesTemp != null) {
                for (DynamicObject dynamicObject : sinSurFilesTemp) {
                    if (!dynamicObject.getBoolean("iscurrentversion")) continue;
                    ArrayList sinSurBases = (ArrayList)sinSurBaseMaps.get(dynamicObject.getLong("boid"));
                    if (sinSurBases == null) {
                        sinSurBases = new ArrayList(10);
                    }
                    List allSinSurFileSinSurBases = map.computeIfAbsent("hcsi_sinsurbase", key -> new ArrayList());
                    allSinSurFileSinSurBases.addAll(sinSurBases);
                }
                map.put("hcsi_sinsurfile", sinSurFilesTemp);
            }
            this.personIndexSinSurBases.put(personIndexId, map);
        }
        Iterator iterator = sinSurBaseMaps.entrySet().iterator();
        Iterator<SinSurFileBase> iterator2 = sinSurFileBases.iterator();
        block5: while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            List value = (List)next.getValue();
            for (DynamicObject dynamicObject : value) {
                DynamicObject insuredSinSurBase;
                Date bsed = dynamicObject.getDate("bsed");
                Date bsled = dynamicObject.getDate("bsled");
                long insurTypeId = dynamicObject.getLong("welfaretype.id");
                boolean isAllowedPayInMultipleArea = this.insurTypeIdsAllowedPayInMultipleArea.contains(insurTypeId);
                if (isAllowedPayInMultipleArea || !dynamicObject.getBoolean("insured") || (insuredSinSurBase = SinSurFileStdServiceHelper.validateWelfareTypeInsuredFile(bsed, dynamicObject.getDynamicObject("sinsurfile"), this.personIndexSinSurBases, insurTypeId, bsled)) == null) continue;
                iterator.remove();
                hashMap.remove(next.getKey());
                while (iterator2.hasNext()) {
                    SinSurFileBase sinSurFileBase = iterator2.next();
                    Long sinSurFileId = sinSurFileBase.getSinSurFileId();
                    if (!sinSurFileId.equals(next.getKey())) continue;
                    iterator2.remove();
                    this.setErrorSinSurFileBaseResult(sinSurFileBase, SinSurBaseErrorResultEnum.PARAM_REPEAT_INSURED, sinSurFileBase.getSinSurFileNumber(), dynamicObject.getString("welfaretype.name"), insuredSinSurBase.getString("number"));
                    continue block5;
                }
                continue block5;
            }
        }
        this.saveSinSurFileStds.clear();
        this.saveSinSurBases.clear();
        for (List value : hashMap.values()) {
            this.saveSinSurFileStds.addAll(value);
        }
        for (List value : sinSurBaseMaps.values()) {
            this.saveSinSurBases.addAll(value);
        }
    }

    private boolean isChanged(Date bsed, Map<Boolean, List<DynamicObject>> sinSurFileStdMap, DynamicObject sinSurStd) {
        List<DynamicObject> sinSurFileStdVersions = sinSurFileStdMap.get(Boolean.FALSE);
        for (DynamicObject sinSurFileStdVersion : sinSurFileStdVersions) {
            if (bsed.compareTo(sinSurFileStdVersion.getDate("bsed")) < 0 || bsed.compareTo(sinSurFileStdVersion.getDate("bsled")) > 0 || sinSurFileStdVersion.getLong("sinsurstd.id") != sinSurStd.getLong("id")) continue;
            return false;
        }
        return true;
    }

    private Date getBsled(String changeType, DynamicObject sinSurStd, DynamicObject DBDynamicObject) {
        Date bsled;
        switch (changeType) {
            case "before": {
                if (sinSurStd.getLong("id") == DBDynamicObject.getLong("sinsurstd.id")) {
                    bsled = DBDynamicObject.getDate("bsled");
                    break;
                }
                bsled = SITDateTimeUtils.addDay((Date)DBDynamicObject.getDate("bsed"), (long)-1L);
                break;
            }
            case "after": {
                bsled = DBDynamicObject.getDate("bsled");
                break;
            }
            case "same": {
                bsled = DBDynamicObject.getDate("bsled");
                break;
            }
            default: {
                bsled = DBDynamicObject.getDate("bsled");
            }
        }
        return bsled;
    }
}

