/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.push;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sit.hcsi.business.extpoint.IInsuranceDataSynExtService;
import kd.sdk.sit.hcsi.common.events.insurancedata.AfterInsuranceDataListEvent;
import kd.sit.hcsi.business.cal.errInfo.CalApiResultErrInfoEnum;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.insurancedata.service.InsuranceDataSynExtService;
import kd.sit.hcsi.business.sdk.KDSocInsuranceSdkHelper;
import kd.sit.hcsi.common.enums.SocialOperationEnum;
import kd.sit.sitbp.business.coderule.CodeRuleHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.cache.SITAppCache;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITStringUtils;
import org.apache.commons.collections.map.HashedMap;

public class CalResultPushHelper {
    private static final Log log = LogFactory.getLog(CalResultPushHelper.class);

    public static List<Map<String, Object>> getCalPersonByIds(List<Long> ids) {
        DynamicObject[] dynamicObjects;
        List<Map<String, Object>> results = new ArrayList<Map<String, Object>>(ids.size());
        if (ids.size() == 0) {
            return results;
        }
        HashSet<String> selectFieldSet = new HashSet(16);
        AfterInsuranceDataListEvent buildSelectFieldEvent = new AfterInsuranceDataListEvent(selectFieldSet, null, null);
        CalResultPushHelper.invokeBeforeSelectFields(buildSelectFieldEvent);
        selectFieldSet = buildSelectFieldEvent.getSelectFieldSet();
        HRBaseServiceHelper calpersonHelper = new HRBaseServiceHelper("hcsi_calperson");
        String fields = "id,sinsurfilev.number,employee.id,employee.person.id,sinsurperiod.number,sinsurperiod.perioddate,batchid,entryentity,entryentity.seq,entryentity.insuranceitem,entryentity.numvalue,entryentity.amountvalue,entryentity.isnull,entryentity.currency,entryentity.storagetype";
        String queryField = CalResultPushHelper.buildSelectFields(fields, selectFieldSet);
        for (DynamicObject dynamicObject : dynamicObjects = calpersonHelper.query(queryField, new QFilter("id", "in", ids).toArray())) {
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put("id", dynamicObject.getLong("id"));
            data.put("filenumber", dynamicObject.getString("sinsurfilev.number"));
            data.put("employee", dynamicObject.getLong("employee.id"));
            data.put("person", dynamicObject.getLong("employee.person.id"));
            data.put("sinsurperiodnumber", dynamicObject.get("sinsurperiod.number"));
            data.put("perioddate", dynamicObject.getDate("sinsurperiod.perioddate"));
            data.put("batchid", dynamicObject.getString("batchid"));
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            ArrayList entryentityList = new ArrayList(10);
            data.put("entryentity", entryentityList);
            for (DynamicObject entry : entryentity) {
                HashMap<String, Object> entrydata = new HashMap<String, Object>(16);
                entrydata.put("seq", entry.getInt("seq"));
                entrydata.put("insuranceitem", entry.getLong("insuranceitem.id"));
                entrydata.put("numvalue", entry.getBigDecimal("numvalue"));
                entrydata.put("amountvalue", entry.getBigDecimal("amountvalue"));
                entrydata.put("isnull", entry.getBoolean("isnull"));
                entrydata.put("currency", entry.getLong("currency.id"));
                entrydata.put("storagetype", entry.getString("storagetype"));
                entryentityList.add(entrydata);
            }
            results.add(data);
        }
        AfterInsuranceDataListEvent afterInsuranceDataListEvent = new AfterInsuranceDataListEvent(null, results, dynamicObjects);
        CalResultPushHelper.invokeAfterInsuranceDataList(afterInsuranceDataListEvent);
        results = afterInsuranceDataListEvent.getInsuranceDataList();
        return results;
    }

    private static String buildSelectFields(String fields, Set<String> selectFieldSet) {
        if (selectFieldSet == null || selectFieldSet.size() == 0) {
            return fields;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(fields);
        for (String fieldStr : selectFieldSet) {
            sb.append(',').append(fieldStr);
        }
        return sb.toString();
    }

    private static void invokeBeforeSelectFields(AfterInsuranceDataListEvent args) {
        InsuranceDataSynExtService ExtService = new InsuranceDataSynExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)ExtService, IInsuranceDataSynExtService.class, (String)"kd.sdk.sit.hcsi.business.extpoint.IInsuranceDataSynExtService#beforeBuildSelectFields", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.beforeBuildSelectFields(args);
            return null;
        });
    }

    private static void invokeAfterInsuranceDataList(AfterInsuranceDataListEvent args) {
        InsuranceDataSynExtService ExtService = new InsuranceDataSynExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)ExtService, IInsuranceDataSynExtService.class, (String)"kd.sdk.sit.hcsi.business.extpoint.IInsuranceDataSynExtService#afterInsuranceDataList", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterInsuranceDataList(args);
            return null;
        });
    }

    public static void sendPushMsg(List<Long> ids, String type, Long logId, String withholdtype, String withholddate) {
        ThreadPools.executeOnce((String)"INSURANCE_CALRESULT_PUSHMSG_POOL_ASYNC", () -> {
            List subList = Lists.partition((List)ids, (int)500);
            MessagePublisher publisher = MQFactory.get().createSimplePublisher("swc", "hsas_insurancedata_queue");
            for (List batchIds : subList) {
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                params.put("ids", batchIds);
                params.put("type", type);
                params.put("logId", logId);
                params.put("withholdtype", withholdtype);
                params.put("withholddate", withholddate);
                publisher.publish(params);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLog(String pushType, List<Long> successIds, Map<Long, String> failReasonMap, Long logId) {
        block17: {
            String lockKey = String.format(Locale.ROOT, "update_hcsi_pushlog_%s", logId);
            try (DLock lock = DLock.create((String)lockKey);){
                if (lock.tryLock(300000L)) {
                    HRBaseServiceHelper logHelper = new HRBaseServiceHelper("hcsi_insurpushlog");
                    DynamicObject pushLog = logHelper.queryOne((Object)logId);
                    CalResultPushHelper.updateLogField(successIds, failReasonMap, pushLog);
                    HRBaseServiceHelper calpersonHelper = new HRBaseServiceHelper("hcsi_calperson");
                    ArrayList<Long> calpersonIds = new ArrayList<Long>(successIds);
                    if (failReasonMap != null && failReasonMap.size() > 0) {
                        calpersonIds.addAll(failReasonMap.keySet());
                    }
                    DynamicObject[] calpersons = CalResultPushHelper.getCalpersonInfoForLogEntry(calpersonHelper, calpersonIds);
                    CalResultPushHelper.addLogEntry(pushType, successIds, failReasonMap, pushLog, calpersonHelper, calpersons);
                    try (TXHandle txHandle = TX.requiresNew();){
                        logHelper.updateOne(pushLog);
                        calpersonHelper.update(calpersons);
                    }
                    int total = pushLog.getInt("total");
                    int success = pushLog.getInt("success");
                    int fail = pushLog.getInt("fail");
                    if (total == success + fail) {
                        List taskIds = (List)SITAppCache.get((String)"hcsi").get(String.format(Locale.ROOT, "log_with_tasks_cache_%s", logId), List.class);
                        CalResultPushHelper.updateInsurTaskPushStatusAndCount(taskIds);
                        if (taskIds != null) {
                            for (Object taskId : taskIds) {
                                if (SITStringUtils.equals((String)pushType, (String)"1")) {
                                    MutexHelper.release((String)"hcsi_sinsurtask", (String)"donothing_push", (String)String.valueOf(taskId));
                                    continue;
                                }
                                MutexHelper.release((String)"hcsi_sinsurtask", (String)"donothing_unpush", (String)String.valueOf(taskId));
                            }
                        }
                    }
                    break block17;
                }
                log.error("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u8d85\u65f6");
            }
        }
    }

    private static void updateInsurTaskPushStatusAndCount(Collection<Long> sinsurTaskIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_calperson");
        QFilter filter = new QFilter("sinsurtask", "in", sinsurTaskIds);
        DynamicObjectCollection calPersons = helper.queryOriginalCollection("sinsurtask.id,pushstatus", new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Collection)calPersons)) {
            return;
        }
        HashedMap sinsurTaskIdToPushStatusSetMap = new HashedMap(sinsurTaskIds.size());
        HashedMap sinsurTaskIdToPushCountMap = new HashedMap(sinsurTaskIds.size());
        for (DynamicObject calPerson : calPersons) {
            String pushStatus = calPerson.getString("pushstatus");
            Long sinsurTaskId = calPerson.getLong("sinsurtask.id");
            Set pushStatusSet = sinsurTaskIdToPushStatusSetMap.computeIfAbsent(sinsurTaskId, key -> new HashSet(3));
            pushStatusSet.add(pushStatus);
            if (!"pushed".equals(pushStatus)) continue;
            sinsurTaskIdToPushCountMap.put(sinsurTaskId, sinsurTaskIdToPushCountMap.getOrDefault(sinsurTaskId, 0) + 1);
        }
        helper.setEntityName("hcsi_sinsurtask");
        DynamicObject[] sinsurTasks = helper.query("id,pushstatus,pushcount", new QFilter[]{new QFilter("id", "in", sinsurTaskIds)});
        if (sinsurTasks == null || sinsurTasks.length == 0) {
            return;
        }
        for (DynamicObject sinsurTask : sinsurTasks) {
            Long sinsurTaskId = sinsurTask.getLong("id");
            sinsurTask.set("pushcount", (Object)sinsurTaskIdToPushCountMap.getOrDefault(sinsurTaskId, 0));
            Set pushStatusSet = sinsurTaskIdToPushStatusSetMap.getOrDefault(sinsurTaskId, new HashSet(0));
            if (pushStatusSet.size() == 0 || pushStatusSet.size() == 1 && pushStatusSet.contains("notpush")) {
                sinsurTask.set("pushstatus", (Object)"0");
                continue;
            }
            if (pushStatusSet.size() == 1 && pushStatusSet.contains("pushed")) {
                sinsurTask.set("pushstatus", (Object)"2");
                continue;
            }
            sinsurTask.set("pushstatus", (Object)"1");
        }
        helper.save(sinsurTasks);
    }

    private static void updateLogField(List<Long> successIds, Map<Long, String> failReasonMap, DynamicObject pushLog) {
        int total = pushLog.getInt("total");
        int success = pushLog.getInt("success");
        int fail = pushLog.getInt("fail");
        success = successIds.size() + success;
        if (failReasonMap != null) {
            fail += failReasonMap.size();
        }
        pushLog.set("total", (Object)total);
        pushLog.set("success", (Object)success);
        pushLog.set("fail", (Object)fail);
        pushLog.set("modifytime", (Object)new Date());
        if (total == success + fail) {
            pushLog.set("endtime", (Object)new Date());
            pushLog.set("pushstatus", (Object)"1");
        }
    }

    private static void addLogEntry(String type, List<Long> successIds, Map<Long, String> failReasonMap, DynamicObject pushLog, HRBaseServiceHelper calpersonHelper, DynamicObject[] calpersons) {
        MainEntityType metatype = EntityMetadataCache.getDataEntityType((String)"hcsi_insurpushlog");
        switch (type) {
            case "1": {
                EntityType entityType = (EntityType)metatype.getAllEntities().get("pushfailentity");
                DynamicObjectCollection pushfailentity = pushLog.getDynamicObjectCollection("pushfailentity");
                for (DynamicObject calperson : calpersons) {
                    long id = calperson.getLong("id");
                    if (failReasonMap != null && failReasonMap.size() > 0) {
                        DynamicObject instance = (DynamicObject)entityType.createInstance();
                        instance.set("pushfailsinsurfile", (Object)calperson.getLong("sinsurfilev.id"));
                        instance.set("pushfailemployee", (Object)calperson.getLong("employee.id"));
                        instance.set("pushfailsinsurperiod", (Object)calperson.getLong("sinsurperiod.id"));
                        instance.set("pushfailcalperson", (Object)calperson.getLong("id"));
                        instance.set("pushfailstatus", (Object)"0");
                        instance.set("pushfailreason", (Object)failReasonMap.get(calperson.getLong("id")));
                        instance.set("pushfailbatchid", (Object)calperson.getString("batchid"));
                        calperson.set("pushstatus", (Object)"notpush");
                        calperson.set("batchid", null);
                        pushfailentity.add((Object)instance);
                        continue;
                    }
                    calperson.set("pushstatus", (Object)"pushed");
                }
                break;
            }
            case "2": {
                EntityType calllentityType = (EntityType)metatype.getAllEntities().get("calllentity");
                EntityType callfailentityType = (EntityType)metatype.getAllEntities().get("callfailentity");
                DynamicObjectCollection calllentity = pushLog.getDynamicObjectCollection("calllentity");
                DynamicObjectCollection callfailentity = pushLog.getDynamicObjectCollection("callfailentity");
                for (DynamicObject calperson : calpersons) {
                    DynamicObject instance;
                    String errMSg;
                    long id = calperson.getLong("id");
                    String string = errMSg = failReasonMap == null ? null : failReasonMap.get(id);
                    if (errMSg != null) {
                        instance = (DynamicObject)callfailentityType.createInstance();
                        instance.set("callfailsinsurfile", (Object)calperson.getLong("sinsurfilev.id"));
                        instance.set("callfailemployee", (Object)calperson.getLong("employee.id"));
                        instance.set("callfailsinsurperiod", (Object)calperson.getLong("sinsurperiod.id"));
                        instance.set("callfailcalperson", (Object)calperson.getLong("id"));
                        instance.set("callfailstatus", (Object)"0");
                        instance.set("callfailreason", (Object)errMSg);
                        instance.set("callfailbatchid", (Object)calperson.getString("batchid"));
                        callfailentity.add((Object)instance);
                        calperson.set("pushstatus", (Object)"pushed");
                        continue;
                    }
                    instance = (DynamicObject)calllentityType.createInstance();
                    instance.set("callsinsurfile", (Object)calperson.getLong("sinsurfilev.id"));
                    instance.set("callemployee", (Object)calperson.getLong("employee.id"));
                    instance.set("callsinsurperiod", (Object)calperson.getLong("sinsurperiod.id"));
                    instance.set("callcalperson", (Object)calperson.getLong("id"));
                    instance.set("callstatus", (Object)"1");
                    instance.set("callbatchid", (Object)calperson.getString("batchid"));
                    calllentity.add((Object)instance);
                    calperson.set("pushstatus", (Object)"notpush");
                    calperson.set("batchid", null);
                }
                break;
            }
        }
    }

    private static DynamicObject[] getCalpersonInfoForLogEntry(HRBaseServiceHelper calpersonHelper, Collection<Long> ids) {
        return calpersonHelper.query("id,sinsurfilev.id,employee.id,sinsurperiod.id,batchid,pushstatus", new QFilter("id", "in", ids).toArray());
    }

    private static String getStringDate() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static void generatePushRecordAndUpdatePersons(String pushType, DynamicObject[] socInsurancePersonDys, Collection<Long> socInsuranceCalIds, String withholdtype, String withholddate) {
        HRBaseServiceHelper pushLogHelper = new HRBaseServiceHelper("hcsi_insurpushlog");
        DynamicObject pushLogDy = pushLogHelper.generateEmptyDynamicObject();
        long logId = DB.genGlobalLongId();
        String batchId = CodeRuleHelper.getNumber((DynamicObject)pushLogDy, null);
        CalResultPushHelper.initPushLog(pushLogDy, logId, pushType, batchId, socInsurancePersonDys.length, withholdtype, withholddate);
        CalResultPushHelper.updateInsurancePersonPushStatus(socInsurancePersonDys, pushType, pushLogDy.getLong("id"), batchId);
        try (TXHandle txHandle = TX.requiresNew();){
            pushLogHelper.saveOne(pushLogDy);
            HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hcsi_calperson");
            personHelper.update(socInsurancePersonDys);
            SITAppCache.get((String)"hcsi").put(String.format(Locale.ROOT, "log_with_tasks_cache_%s", logId), socInsuranceCalIds);
        }
        List<Long> personIds = Arrays.stream(socInsurancePersonDys).map(period -> period.getLong("id")).collect(Collectors.toList());
        CalResultPushHelper.sendPushMsg(personIds, pushType, logId, withholdtype, withholddate);
    }

    private static void updateInsurancePersonPushStatus(DynamicObject[] socInsurancePersonDys, String pushType, long pushLogId, String batchId) {
        for (DynamicObject socInsurancePersonDy : socInsurancePersonDys) {
            if (SITStringUtils.equals((String)pushType, (String)"1")) {
                socInsurancePersonDy.set("pushstatus", (Object)"pushing");
                socInsurancePersonDy.set("batchid", (Object)batchId);
            } else {
                socInsurancePersonDy.set("pushstatus", (Object)"recalling");
            }
            socInsurancePersonDy.set("pushlog", (Object)pushLogId);
        }
    }

    private static void initPushLog(DynamicObject pushLogDy, long logId, String pushType, String batchId, int personAccount, String withholdtype, String withholddateStr) {
        long currUserId = RequestContext.get().getCurrUserId();
        Date currentDate = new Date();
        if (SITStringUtils.equals((String)pushType, (String)"1")) {
            pushLogDy.set("number", (Object)("P" + batchId));
        } else if (SITStringUtils.equals((String)pushType, (String)"2")) {
            pushLogDy.set("number", (Object)("R" + batchId));
        }
        pushLogDy.set("id", (Object)logId);
        pushLogDy.set("pushtype", (Object)pushType);
        pushLogDy.set("pushstatus", (Object)"0");
        pushLogDy.set("total", (Object)personAccount);
        pushLogDy.set("success", (Object)0);
        pushLogDy.set("fail", (Object)0);
        pushLogDy.set("creator", (Object)currUserId);
        pushLogDy.set("starttime", (Object)currentDate);
        pushLogDy.set("batchid", (Object)batchId);
        pushLogDy.set("modifier", (Object)currUserId);
        pushLogDy.set("modifytime", (Object)currentDate);
        pushLogDy.set("createtime", (Object)currentDate);
        pushLogDy.set("withholdtype", (Object)withholdtype);
        Date withholddate = null;
        if (SITStringUtils.isNotEmpty((String)withholddateStr)) {
            try {
                withholddate = SITDateTimeUtils.parseDate((String)withholddateStr, (String)"yyyy-MM");
            }
            catch (ParseException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        pushLogDy.set("withholddate", withholddate);
        pushLogDy.set("repushnum", (Object)0);
    }

    public static ApiResult checkPushedCalPersonDys(Collection<Long> calPersonIds, String pushType, List<DynamicObject> couldPushedCalPersonDys, String entityNumber) {
        ApiResult apiResult = new ApiResult();
        JSONObject errInfoJson = new JSONObject();
        apiResult.setData((Object)errInfoJson);
        ArrayList<String> errorList = new ArrayList<String>(10);
        ArrayList<Long> errCalPeronIds = new ArrayList<Long>(10);
        errInfoJson.put("errInfo", errorList);
        errInfoJson.put("errCalPeronIds", errCalPeronIds);
        HRBaseServiceHelper calPersonHelper = new HRBaseServiceHelper("hcsi_calperson");
        QFilter filter = new QFilter("id", "in", calPersonIds);
        DynamicObject[] personDys = calPersonHelper.query("id,sinsurfilev.number,pushstatus,pushlog,batchid,calstatus,sinsurtask.id", filter.toArray());
        String operateKey = null;
        if ("1".equals(pushType)) {
            operateKey = "donothing_push";
        } else if ("2".equals(pushType)) {
            operateKey = "donothing_unpush";
        }
        List authorizedDataRuleQFilters = SITPermissionServiceHelper.getAuthorizedDataRuleQFilterByOpKey((String)"2AXKDRPJUQ77", (String)"hcsi_calperson", (String)operateKey);
        if (authorizedDataRuleQFilters != null) {
            authorizedDataRuleQFilters.forEach(arg_0 -> ((QFilter)filter).and(arg_0));
        } else {
            filter.and(new QFilter("1", "!=", (Object)1));
        }
        DynamicObjectCollection hasPermDatas = calPersonHelper.queryOriginalCollection("id", filter.toArray());
        Set hasPermIds = hasPermDatas.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        if (personDys == null || personDys.length == 0 || !KDSocInsuranceSdkHelper.PUSH_AND_RECALL_TYPE_SET.contains(pushType) || HRStringUtils.isEmpty((String)entityNumber)) {
            apiResult.setSuccess(false);
            apiResult.setMessage(CalApiResultErrInfoEnum.CAL_PERSON_PUSH_PARAMS_ERROR.getErrInfo());
            apiResult.setErrorCode(CalApiResultErrInfoEnum.CAL_PERSON_PUSH_PARAMS_ERROR.getErrCode());
            return apiResult;
        }
        for (DynamicObject personDy : personDys) {
            String pushStatusInDb = personDy.getString("pushstatus");
            String calStatusInDb = personDy.getString("calstatus");
            String sinsurFileNumber = personDy.getString("sinsurfilev.number");
            Long calPersonId = personDy.getLong("id");
            if (SITStringUtils.equals((String)pushType, (String)"1")) {
                if (!SITStringUtils.equals((String)pushStatusInDb, (String)"notpush") || !SITStringUtils.equals((String)calStatusInDb, (String)"2")) {
                    errorList.add(HCSIErrInfoEnum.CAL_PERSON_COULD_PUSH_SALARY_CONDITION.getErrInfo(sinsurFileNumber));
                    errCalPeronIds.add(calPersonId);
                    continue;
                }
            } else if (SITStringUtils.equals((String)pushType, (String)"2") && !SITStringUtils.equals((String)pushStatusInDb, (String)"pushed")) {
                errorList.add(HCSIErrInfoEnum.CAL_PERSON_COULD_CANCEL_PUSH_SALARY_CONDITION.getErrInfo(sinsurFileNumber));
                errCalPeronIds.add(calPersonId);
                continue;
            }
            if (!hasPermIds.contains(personDy.getLong("id"))) {
                if (SITStringUtils.equals((String)pushType, (String)"2")) {
                    errorList.add(HCSIErrInfoEnum.NO_PERM_DATA_TO_UNPUSH.getErrInfo(sinsurFileNumber));
                } else {
                    errorList.add(HCSIErrInfoEnum.NO_PERM_DATA_TO_PUSH.getErrInfo(sinsurFileNumber));
                }
                errCalPeronIds.add(calPersonId);
                continue;
            }
            couldPushedCalPersonDys.add(personDy);
        }
        if (errorList.size() > 0) {
            String errorCode = SITStringUtils.equals((String)pushType, (String)"1") ? HCSIErrInfoEnum.CAL_PERSON_COULD_PUSH_SALARY_CONDITION.getErrCode() : HCSIErrInfoEnum.CAL_PERSON_COULD_CANCEL_PUSH_SALARY_CONDITION.getErrCode();
            apiResult.setSuccess(false);
            apiResult.setMessage("");
            apiResult.setErrorCode(errorCode);
            return apiResult;
        }
        return ApiResult.success((Object)errInfoJson);
    }

    public static void addPushOperateLog(String pushType, String entityName) {
        AppLogInfo log = new AppLogInfo();
        log.setBizAppID("2AXKDRPJUQ77");
        log.setBizObjID(entityName);
        if (SITStringUtils.equals((String)pushType, (String)"1")) {
            log.setOpName(SocialOperationEnum.OP_PUSH.getOperationName());
            log.setOpDescription(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u53d1\u8d77\u63a8\u9001", (String)"CalResultPushHelper_0", (String)"sit-hcsi-business", (Object[])new Object[0]));
        } else {
            log.setOpName(SocialOperationEnum.OP_UNPUSH.getOperationName());
            log.setOpDescription(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u53d1\u8d77\u64a4\u56de", (String)"CalResultPushHelper_1", (String)"sit-hcsi-business", (Object[])new Object[0]));
        }
        LogServiceHelper.addLog((AppLogInfo)log);
    }

    public static ListShowParameter getPushLogListForm() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setBillFormId("hcsi_insurpushlog");
        listShowParameter.setFormId("bos_list");
        listShowParameter.setHasRight(true);
        return listShowParameter;
    }

    public static FormShowParameter getPushStartForm(List<Long> dataIds) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("hcsi_pushstart");
        parameter.setCloseCallBack(new CloseCallBack("kd.sit.hcsi.formplugin.web.cal.task.SocialInsuranceTaskList", "hcsi_pushstart"));
        parameter.setCustomParam("dataIds", (Object)JSON.toJSONString(dataIds));
        return parameter;
    }

    public static void rePushFailedLog() {
        DynamicObject[] failLogs;
        HRBaseServiceHelper logHelper = new HRBaseServiceHelper("hcsi_insurpushlog");
        QFilter qFilter = new QFilter("pushstatus", "=", (Object)"0");
        Date date = new Date(System.currentTimeMillis() - 180000L);
        qFilter.and(new QFilter("modifytime", "<", (Object)date));
        qFilter.and(new QFilter("repushnum", "<=", (Object)5));
        for (DynamicObject failLog : failLogs = logHelper.query("id,pushtype,repushnum,withholddate,withholdtype", qFilter.toArray())) {
            int repushnum = failLog.getInt("repushnum");
            if (repushnum < 5) {
                CalResultPushHelper.resendLogMsg(failLog);
                continue;
            }
            CalResultPushHelper.setLogFail(failLog);
        }
    }

    private static void setLogFail(DynamicObject failLog) {
        HRBaseServiceHelper calpersonHelper = new HRBaseServiceHelper("hcsi_calperson");
        long logId = failLog.getLong("id");
        QFilter filter = new QFilter("pushlog", "=", (Object)logId);
        filter.and("pushstatus", "in", Arrays.asList("pushing", "recalling"));
        DynamicObject[] pushDatas = calpersonHelper.query("pushstatus", filter.toArray());
        String pushType = failLog.getString("pushtype");
        String errMsg = ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"CalResultPushHelper_2", (String)"sit-hcsi-business", (Object[])new Object[0]);
        Map<Long, String> errMap = Arrays.stream(pushDatas).collect(Collectors.toMap(pushData -> pushData.getLong("id"), pushData -> errMsg, (oldVal, newVal) -> oldVal));
        CalResultPushHelper.updateLog(pushType, new ArrayList<Long>(10), errMap, logId);
    }

    private static void resendLogMsg(DynamicObject failLog) {
        HRBaseServiceHelper logHelper = new HRBaseServiceHelper("hcsi_insurpushlog");
        HRBaseServiceHelper calpersonHelper = new HRBaseServiceHelper("hcsi_calperson");
        long logId = failLog.getLong("id");
        QFilter filter = new QFilter("pushlog", "=", (Object)logId);
        filter.and("pushstatus", "in", Arrays.asList("pushing", "recalling"));
        DynamicObject[] pushDatas = calpersonHelper.query("id", filter.toArray());
        List<Long> personIds = Arrays.stream(pushDatas).map(pushData -> pushData.getLong("id")).collect(Collectors.toList());
        failLog.set("repushnum", (Object)(failLog.getInt("repushnum") + 1));
        logHelper.saveOne(failLog);
        String withholdtype = failLog.getString("withholdtype");
        Date withholddate = failLog.getDate("withholddate");
        CalResultPushHelper.sendPushMsg(personIds, failLog.getString("pushtype"), logId, withholdtype, SITDateTimeUtils.format((Date)withholddate, (String)"yyyy-MM"));
    }
}

