/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.scheme.helper;

import java.util.Collection;
import java.util.List;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BasedataEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.scheme.constants.RptDisplayConstants;

public abstract class AbsDisplayScmHelper
implements RptDisplayConstants {
    public static final QFilter DEFAULT_QFILTER = new QFilter("1", "=", (Object)1);

    public static DynamicObject[] queryPersonalScheme(String rptDisplayFormId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(rptDisplayFormId);
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] personalSchemeObj = serviceHelper.query("id, name, isdefaultscheme, isshowinbase", filter.toArray(), "isdefaultscheme desc,createtime desc");
        return personalSchemeObj;
    }

    public static DynamicObject querySchemeByFilter(String entityName, QFilter filter) {
        return AbsDisplayScmHelper.querySchemeByFilter(entityName, filter, "id,isdefaultscheme,issyspreset");
    }

    public static DynamicObject querySchemeByFilter(String entityName, QFilter filter, String selectFields) {
        filter = filter != null ? filter : DEFAULT_QFILTER;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        return serviceHelper.queryOne(selectFields, filter.toArray());
    }

    public static QFilter getDefaultScmWithoutCurrScmId(Object currNodeId) {
        Long currScmId = AbsDisplayScmHelper.getScmId(currNodeId);
        QFilter filter = new QFilter("isdefaultscheme", "=", (Object)Boolean.TRUE);
        filter.and("boid", "!=", currNodeId);
        return filter;
    }

    public static Long getScmId(Object currNodeId) {
        Long currScmId = currNodeId instanceof String ? Long.valueOf(Long.parseLong((String)currNodeId)) : (currNodeId instanceof Long ? (Long)currNodeId : Long.valueOf(0L));
        return currScmId;
    }

    public static DynamicObject queryDisplayScheme(String currentDisplayFormId, Long pkId, boolean isOpenHistoryDetailView) {
        QFilter filter;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(currentDisplayFormId);
        if (isOpenHistoryDetailView) {
            filter = new QFilter("iscurrentversion", "=", (Object)"0");
            filter.and("id", "=", (Object)pkId);
        } else {
            filter = new QFilter("iscurrentversion", "=", (Object)"1");
            filter.and("boid", "=", (Object)pkId);
        }
        return serviceHelper.queryOne("id,name,isdefaultscheme", filter.toArray());
    }

    public static void deleteRptDisplaySchemeById(String currentDisplayFormId, Long pkId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(currentDisplayFormId);
        QFilter filter = new QFilter("boid", "=", (Object)pkId);
        serviceHelper.deleteByFilter(filter.toArray());
    }

    public static void cancelOtherDefaultScheme(String reportFormId, QFilter filter) {
        DynamicObject[] dynamicObjects;
        QFilter qFilter = new QFilter("isdefaultscheme", "=", (Object)"1");
        qFilter.and(filter);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(reportFormId);
        for (DynamicObject dyObj : dynamicObjects = serviceHelper.query("id, isdefaultscheme", new QFilter[]{qFilter})) {
            dyObj.set("isdefaultscheme", (Object)0);
        }
        serviceHelper.update(dynamicObjects);
    }

    public static void cancelOtherDefaultScheme(String reportFormId, Long pkId) {
        DynamicObject[] dynamicObjects;
        AbsDisplayScmHelper.cancelOtherDefaultScheme(reportFormId, new QFilter("boid", "!=", (Object)pkId));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(reportFormId);
        QFilter qFilter = new QFilter("boid", "=", (Object)pkId);
        for (DynamicObject dyObj : dynamicObjects = serviceHelper.query("id, isdefaultscheme", new QFilter[]{qFilter})) {
            dyObj.set("isdefaultscheme", (Object)1);
        }
        serviceHelper.update(dynamicObjects);
    }

    public static boolean isDisplayScmInDb(String entityName, Long id) {
        if (HRStringUtils.isEmpty((String)entityName) || id == null) {
            return false;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        return helper.isExists(new QFilter("boid", "=", (Object)id).toArray());
    }

    public static boolean isRef(BasedataEntityType baseDataEntityType, long pkId) {
        QFilter filter = new QFilter("boid", "=", (Object)pkId);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(baseDataEntityType.getName());
        DynamicObjectCollection entityDys = helper.queryOriginalCollection("id", filter.toArray());
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        for (DynamicObject entityDy : entityDys) {
            List allRefsForCurrBaseData = checker.getAllRefs(baseDataEntityType, (Object)entityDy.getLong("id"));
            if (CollectionUtils.isEmpty((Collection)allRefsForCurrBaseData)) continue;
            return true;
        }
        return false;
    }
}

