/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.scheme.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.scheme.dto.RptDisplayColumnEntity;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.util.SITListUtil;

public class DisplaySchemeHelper {
    private static final String SYSTEM_TYPE = "sit-hcsi-business";

    public static List<RptDisplayColumnEntity> queryItemNodeList(Long orgId) {
        ArrayList<RptDisplayColumnEntity> itemNodeList = new ArrayList<RptDisplayColumnEntity>(2);
        List<RptDisplayColumnEntity> insuranceItemList = DisplaySchemeHelper.queryInsuranceItemList();
        List<RptDisplayColumnEntity> sumItemList = DisplaySchemeHelper.querySumItemList(orgId);
        RptDisplayColumnEntity insuranceItem = new RptDisplayColumnEntity();
        insuranceItem.setFieldValue("insuranceitem");
        insuranceItem.setFieldTreeNodeText(ResManager.loadKDString((String)"\u9669\u79cd\u9879\u76ee", (String)"DisplaySchemeHelper_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        insuranceItem.setChildren(insuranceItemList);
        RptDisplayColumnEntity sumItem = new RptDisplayColumnEntity();
        sumItem.setFieldValue("sumitem");
        sumItem.setFieldTreeNodeText(ResManager.loadKDString((String)"\u5408\u8ba1\u9879\u76ee", (String)"DisplaySchemeHelper_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        sumItem.setChildren(sumItemList);
        itemNodeList.add(insuranceItem);
        itemNodeList.add(sumItem);
        return itemNodeList;
    }

    public static List<RptDisplayColumnEntity> querySumItemList(Long orgId) {
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)"sitbs_sumitem", (String[])new String[]{"number", "name"});
        QFilter filter = new QFilter("areatype", "=", (Object)"1");
        filter.or("country", "=", (Object)1000001L);
        QFilter useOrgFilter = SITPermissionServiceHelper.getBaseDataFilter((String)"sitbs_sumitem", (Long)orgId);
        if (useOrgFilter != null) {
            filter.and(useOrgFilter);
        }
        QFilter validFilter = new QFilter("status", "=", (Object)"C");
        validFilter.and("enable", "=", (Object)"1");
        validFilter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
        DynamicObject[] sumItemObjs = SitDataServiceHelper.commonQuery((PropertiesQueryInfo)info, (QFilter[])new QFilter[]{filter, validFilter});
        if (sumItemObjs == null || sumItemObjs.length == 0) {
            return new ArrayList<RptDisplayColumnEntity>(0);
        }
        ArrayList<RptDisplayColumnEntity> sumItemList = new ArrayList<RptDisplayColumnEntity>(sumItemObjs.length);
        for (DynamicObject sumItemObj : sumItemObjs) {
            RptDisplayColumnEntity singleEntity = new RptDisplayColumnEntity();
            singleEntity.setFieldValue(sumItemObj.getString("number"));
            singleEntity.setFieldTreeNodeText(sumItemObj.getString("name"));
            singleEntity.setFieldSourceType("4");
            sumItemList.add(singleEntity);
        }
        return sumItemList;
    }

    public static List<String> querySumitemNumberList(Long orgId) {
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)"sitbs_sumitem", (String[])new String[]{"number", "name"});
        QFilter filter = new QFilter("areatype", "=", (Object)"1");
        filter.or("country", "=", (Object)1000001L);
        QFilter useOrgFilter = SITPermissionServiceHelper.getBaseDataFilter((String)"sitbs_sumitem", (Long)orgId);
        if (useOrgFilter != null) {
            filter.and(useOrgFilter);
        }
        QFilter validFilter = new QFilter("status", "=", (Object)"C");
        validFilter.and("enable", "=", (Object)"1");
        validFilter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
        DynamicObject[] sumItemObjs = SitDataServiceHelper.commonQuery((PropertiesQueryInfo)info, (QFilter[])new QFilter[]{filter, validFilter});
        if (sumItemObjs == null || sumItemObjs.length == 0) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> sumItemNumberList = new ArrayList<String>(sumItemObjs.length);
        for (DynamicObject sumItemObj : sumItemObjs) {
            sumItemNumberList.add(sumItemObj.getString("number"));
        }
        return sumItemNumberList;
    }

    public static List<RptDisplayColumnEntity> queryInsuranceItemList() {
        QFilter filter = new QFilter("country", "=", (Object)1000001L);
        QFilter validFilter = new QFilter("status", "=", (Object)"C");
        validFilter.and("enable", "=", (Object)"1");
        PropertiesQueryInfo welfaretype = PropertiesQueryInfo.special((String)"sitbs_welfaretype", (String[])new String[]{"number", "name", "id"});
        DynamicObject[] welfareTypeObjs = SitDataServiceHelper.commonQuery((PropertiesQueryInfo)welfaretype, (QFilter[])new QFilter[]{filter, validFilter}, (String)"number asc");
        if (welfareTypeObjs == null || welfareTypeObjs.length == 0) {
            return new ArrayList<RptDisplayColumnEntity>(0);
        }
        PropertiesQueryInfo itemInfo = PropertiesQueryInfo.special((String)"sitbs_insuranceitem", (String[])new String[]{"number", "name", "group"});
        DynamicObject[] itemObjs = SitDataServiceHelper.commonQuery((PropertiesQueryInfo)itemInfo, (QFilter[])new QFilter[]{filter, validFilter}, (String)"number asc");
        if (itemObjs == null || itemObjs.length == 0) {
            return new ArrayList<RptDisplayColumnEntity>(0);
        }
        Map<Long, List<DynamicObject>> itemMap = Arrays.stream(itemObjs).collect(Collectors.groupingBy(single -> single.getLong("group.id")));
        ArrayList<RptDisplayColumnEntity> insuranceItemList = new ArrayList<RptDisplayColumnEntity>(welfareTypeObjs.length);
        for (DynamicObject typeObj : welfareTypeObjs) {
            RptDisplayColumnEntity typeEntity = new RptDisplayColumnEntity();
            typeEntity.setFieldValue("type_" + typeObj.getString("number"));
            typeEntity.setFieldTreeNodeText(typeObj.getString("name"));
            List<DynamicObject> itemList = itemMap.get(typeObj.getLong("id"));
            if (SITListUtil.isEmpty(itemList)) continue;
            ArrayList<RptDisplayColumnEntity> itemChildList = new ArrayList<RptDisplayColumnEntity>(itemList.size());
            for (DynamicObject itemObj : itemList) {
                RptDisplayColumnEntity itemEntity = new RptDisplayColumnEntity();
                itemEntity.setFieldValue(itemObj.getString("number"));
                itemEntity.setFieldTreeNodeText(itemObj.getString("name"));
                itemEntity.setFieldSourceType("3");
                itemChildList.add(itemEntity);
            }
            typeEntity.setChildren(itemChildList);
            insuranceItemList.add(typeEntity);
        }
        return insuranceItemList;
    }

    public static int countDefaultTpl(Long id, String number, long orgId, List<Long> welfareIdList) {
        List<QFilter> filters = DisplaySchemeHelper.getQueryDefaultTplFilter(id, number, orgId, welfareIdList);
        int count = SitDataServiceHelper.count((String)"hcsi_displayscheme", filters, (String[])new String[]{"id"});
        return count;
    }

    public static void cleanDefaultTpl(Long id, String number, Long orgId, List<Long> welfareIdList) {
        List<QFilter> filters;
        PropertiesQueryInfo queryInfo = PropertiesQueryInfo.special((String)"hcsi_displayscheme", (String[])new String[]{"id", "isdefaulttpl"});
        DynamicObject[] displaySchemeObjs = SitDataServiceHelper.commonQuery((PropertiesQueryInfo)queryInfo, (QFilter[])(filters = DisplaySchemeHelper.getQueryDefaultTplFilter(id, number, orgId, welfareIdList)).toArray(new QFilter[0]));
        if (displaySchemeObjs != null && displaySchemeObjs.length > 0) {
            for (DynamicObject displaySchemeObj : displaySchemeObjs) {
                displaySchemeObj.set("isdefaulttpl", (Object)Boolean.FALSE);
            }
            HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"hcsi_displayscheme");
            helper.save(displaySchemeObjs);
        }
    }

    private static List<QFilter> getQueryDefaultTplFilter(Long id, String number, long orgId, List<Long> welfareIdList) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("welfarepayer.fbasedataid_id", "in", welfareIdList);
        filter.and("isdefaulttpl", "=", (Object)Boolean.TRUE);
        if (id != null) {
            filter.and("id", "!=", (Object)id);
        } else {
            filter.and("number", "!=", (Object)number);
        }
        return Collections.singletonList(filter);
    }
}

