/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.scheme.service;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.scheme.constants.RptDisplayConstants;
import kd.sit.hcsi.business.scheme.helper.DclScmHelper;
import kd.sit.sitbp.common.cache.SITPageCache;

public abstract class AbsDisplayScmService
implements RptDisplayConstants {
    public static void searchTreeNode(String searchText, IFormView iFormView, boolean isSelected) {
        List<Object> treeNodes;
        boolean flag;
        SITPageCache SITPageCache2 = new SITPageCache(iFormView);
        String rootNode = (String)SITPageCache2.get("CACHE_ROOT_NODE", String.class);
        if (rootNode == null) {
            return;
        }
        List rootNodes = (List)SerializationUtils.deSerializeFromBase64((String)rootNode);
        IPageCache pageCache = (IPageCache)iFormView.getService(IPageCache.class);
        String searchNodesCacheKey = iFormView.getPageId() + "_searchNodes";
        String matchNodesCacheKey = iFormView.getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = iFormView.getPageId() + "_oldSearchText";
        String searchIndexCacheKey = iFormView.getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        boolean bl = flag = (oldSearchText == null || oldSearchText.equals(searchText)) && !HRStringUtils.isEmpty((String)matchNodesCache);
        if (flag) {
            String treeViewNode = pageCache.get(searchNodesCacheKey);
            treeNodes = HRStringUtils.isEmpty((String)treeViewNode) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)treeViewNode, TreeNode.class);
        } else {
            treeNodes = AbsDisplayScmService.getNodes(rootNodes, searchText);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        }
        TreeView treeView = (TreeView)iFormView.getControl("treeviewap");
        if (treeNodes.isEmpty()) {
            treeNodes = AbsDisplayScmService.getNodes(rootNodes, searchText);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            iFormView.showTipNotification(HCSIErrInfoEnum.COMMON_SEARCH_COMPLETE_WITHOUT_RESULT.getErrInfo());
        } else {
            if (HRStringUtils.isNotEmpty((String)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    TreeNode treeNode = treeNodes.get(indexCache);
                    if (isSelected) {
                        AbsDisplayScmService.keyWordSearchSelected(treeView, iFormView, pageCache, searchIndexCacheKey, indexCache, treeNode);
                    }
                } else {
                    iFormView.showTipNotification(HCSIErrInfoEnum.COMMON_SEARCH_COMPLETE.getErrInfo());
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
            } else {
                treeView.showNode(treeNodes.get(0).getParentid());
                treeView.focusNode(treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
        }
    }

    private static List<TreeNode> getNodes(List<TreeNode> rootNodes, String searchText) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        for (TreeNode rootNode : rootNodes) {
            nodes.addAll(rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16));
        }
        return nodes;
    }

    private static void keyWordSearchSelected(TreeView treeView, IFormView iFormView, IPageCache pageCache, String searchIndexCacheKey, int indexCache, TreeNode treeNode) {
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        TreeView tree = (TreeView)iFormView.getControl("treeviewap");
        List checkedNodeIds = tree.getTreeState().getCheckedNodeIds();
        treeView.uncheckNodes(checkedNodeIds);
        treeView.checkNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
        pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
    }

    public static void searchFieldName(String searchText, IFormView iFormView, String entryEntityName, String fieldNameKey) {
        if (searchText.isEmpty() || HRStringUtils.isEmpty((String)entryEntityName) || HRStringUtils.isEmpty((String)fieldNameKey)) {
            return;
        }
        int[] selectRows = iFormView.getModel().getEntryEntity(entryEntityName).stream().filter(entry -> entry.getString(fieldNameKey) != null).filter(entry -> entry.getString(fieldNameKey).contains(searchText)).mapToInt(dyObj -> dyObj.getInt("seq") - 1).toArray();
        if (selectRows.length == 0) {
            iFormView.showTipNotification(HCSIErrInfoEnum.COMMON_SEARCH_COMPLETE_WITHOUT_RESULT.getErrInfo());
            ((EntryGrid)iFormView.getControl(entryEntityName)).selectRows(-1, false);
            return;
        }
        ((EntryGrid)iFormView.getControl(entryEntityName)).selectRows(selectRows, selectRows[0]);
    }

    public static <T> void forEach(Iterable<? extends T> elements, BiConsumer<Integer, ? super T> action) {
        Objects.requireNonNull(elements);
        Objects.requireNonNull(action);
        int index = 0;
        for (T element : elements) {
            action.accept(index, (Integer)element);
            ++index;
        }
    }

    public static Map<String, Integer> geTreeNodeBindTableRowMap(IFormView formView) {
        HashMap treeNodeTableRowMap = Maps.newHashMapWithExpectedSize((int)16);
        treeNodeTableRowMap.clear();
        DynamicObjectCollection entity = formView.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entity.size(); ++i) {
            DynamicObject obj = (DynamicObject)entity.get(i);
            String nodeid = obj.getString("fieldvalue");
            treeNodeTableRowMap.put(nodeid, i);
        }
        return treeNodeTableRowMap;
    }

    public static void removeColumn(IFormView formView, Set<String> defaultSelectedNodes) {
        EntryGrid entryGrid = (EntryGrid)formView.getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            formView.showTipNotification(HCSIErrInfoEnum.COMMON_MUST_SELECT_ONE_ROW.getErrInfo());
            return;
        }
        ArrayList<String> unRemoveNameList = new ArrayList<String>();
        LinkedHashSet<Integer> rowSet = new LinkedHashSet<Integer>(rows.length);
        ArrayList<String> unNeedCheckNodes = new ArrayList<String>(10);
        for (int i = 0; i < rows.length; ++i) {
            DynamicObject rowEntity = formView.getModel().getEntryRowEntity("entryentity", rows[i]);
            if (rowEntity == null) continue;
            String fieldValue = rowEntity.getString("fieldvalue");
            if (defaultSelectedNodes.contains(fieldValue)) {
                unRemoveNameList.add(rowEntity.getString("fieldname"));
                continue;
            }
            if (!HRStringUtils.isNotEmpty((String)fieldValue)) continue;
            unNeedCheckNodes.add(fieldValue);
            rowSet.add(rowEntity.getInt("seq") - 1);
        }
        if (unRemoveNameList.size() > 0) {
            formView.showTipNotification(HCSIErrInfoEnum.DECLARE_DISPLAY_SCM_ROW_CAN_NOT_REMOVE.getErrInfo(unRemoveNameList.stream().collect(Collectors.joining(HCSIErrInfoEnum.COMMON_CHINA_COMMA.getErrInfo()))));
        }
        if (rowSet.size() > 0) {
            rows = rowSet.stream().mapToInt(Integer::intValue).toArray();
            formView.getModel().deleteEntryRows("entryentity", rows);
            formView.updateView("entryentity");
            TreeView treeView = (TreeView)formView.getControl("treeviewap");
            treeView.uncheckNodes(unNeedCheckNodes);
        }
    }

    public static Map<String, String> getFieldValAndNameMap(String entityName, String number) {
        DynamicObject schemeColumnInfo = DclScmHelper.querySchemeColumnInfo(entityName, number);
        if (!HRObjectUtils.isEmpty((Object)schemeColumnInfo)) {
            DynamicObjectCollection entryEntity = schemeColumnInfo.getDynamicObjectCollection("entryentity");
            HashMap<String, String> fieldValAndNameMap = new HashMap<String, String>(entryEntity.size());
            for (DynamicObject entry : entryEntity) {
                fieldValAndNameMap.put(entry.getString("fieldvalue"), entry.getString("nodename"));
            }
            return fieldValAndNameMap;
        }
        return new HashMap<String, String>(0);
    }
}

