/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.sdk;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.cal.errInfo.CalApiResultErrInfoEnum;
import kd.sit.hcsi.business.cal.service.ICalService;
import kd.sit.hcsi.business.cal.service.SocialDetailResultService;
import kd.sit.hcsi.business.cal.service.SocialInsuranceCalService;
import kd.sit.hcsi.business.push.CalResultPushHelper;

public class KDSocInsuranceSdkHelper {
    public static final Set<String> PUSH_AND_RECALL_TYPE_SET = Sets.newHashSet((Object[])new String[]{"1", "2"});
    private static final Set<String> CAL_TYPE_SET = Sets.newHashSet((Object[])new String[]{"1", "3"});

    private KDSocInsuranceSdkHelper() {
    }

    public static ApiResult getSocInsurancePersons(Collection<Long> periodIds, Collection<Long> sinsurFileIds, String selectFields) {
        return SocialDetailResultService.getInstance().getSocInsurancePersons(periodIds, sinsurFileIds, selectFields);
    }

    public static ApiResult updateSocInsurancePersonAndCal(Long periodId, Collection<Long> insuredCompanyIds, String calType, Map<String, Object> extendParams) {
        HashSet<Long> insuredCompanyIdSet;
        Set<Long> set = insuredCompanyIdSet = insuredCompanyIds == null ? new HashSet<Long>(0) : (Set)insuredCompanyIds.stream().filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        if (insuredCompanyIdSet.isEmpty() || periodId == null || !CAL_TYPE_SET.contains(calType)) {
            return ApiResult.fail((String)CalApiResultErrInfoEnum.PARAMS_ERROR_OF_UPDATE_PERSON.getErrInfo());
        }
        ICalService calService = SocialInsuranceCalService.calServiceFactory(null, Sets.newHashSet((Object[])new Long[]{periodId}), insuredCompanyIdSet, calType, null, extendParams);
        ApiResult apiResult = calService != null ? calService.updatePersonAndCal() : ApiResult.fail((String)CalApiResultErrInfoEnum.PARAMS_ERROR_OF_UPDATE_PERSON.getErrInfo());
        return apiResult;
    }

    public static void pushSocInsuranceToSalary(Collection<Long> socInsuranceTaskIds, DynamicObject[] socInsurancePersons, String pushType, String entityNumber, String withholdtype, String withholddate) {
        if (CollectionUtils.isEmpty(socInsuranceTaskIds) || ArrayUtils.isEmpty((Object[])socInsurancePersons) || !PUSH_AND_RECALL_TYPE_SET.contains(pushType) || HRStringUtils.isEmpty((String)entityNumber)) {
            return;
        }
        CalResultPushHelper.generatePushRecordAndUpdatePersons(pushType, socInsurancePersons, socInsuranceTaskIds, withholdtype, withholddate);
        CalResultPushHelper.addPushOperateLog(pushType, entityNumber);
    }
}

