/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class SinsurCalPersonFieldDataUpdateTask
extends AbstractTask {
    private static final int batchSize = 500;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_calperson");
        String props = "sinsurfilev.number,employee.person.name,employee.empnumber,namedb,filenumberdb,empnumberdb";
        QFilter filter = QFilter.isNull((String)"namedb").or(new QFilter("namedb", "=", (Object)" ")).or(new QFilter("namedb", "=", (Object)""));
        filter.or(QFilter.isNull((String)"filenumberdb")).or(new QFilter("filenumberdb", "=", (Object)" ")).or(new QFilter("filenumberdb", "=", (Object)""));
        filter.or(QFilter.isNull((String)"empnumberdb")).or(new QFilter("empnumberdb", "=", (Object)" ")).or(new QFilter("empnumberdb", "=", (Object)""));
        DynamicObject[] allCalPersonDys = new HRBaseServiceHelper("hcsi_calperson").queryOriginalArray("id", new QFilter[]{filter});
        if (allCalPersonDys == null || allCalPersonDys.length <= 0) {
            return;
        }
        List<List<Long>> batchLists = this.getBatchLists(allCalPersonDys);
        for (List<Long> batchList : batchLists) {
            DynamicObject[] calPersonDys;
            QFilter idFilter = new QFilter("id", "in", batchList);
            for (DynamicObject calPersonDy : calPersonDys = helper.query(props, idFilter.toArray())) {
                calPersonDy.set("filenumberdb", calPersonDy.get("sinsurfilev.number"));
                calPersonDy.set("namedb", calPersonDy.get("employee.person.name"));
                calPersonDy.set("empnumberdb", calPersonDy.get("employee.empnumber"));
            }
            helper.save(calPersonDys);
        }
        this.disableJob();
    }

    public void disableJob() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }

    public List<List<Long>> getBatchLists(DynamicObject[] allCalPersonDys) {
        ArrayList boBatchList = Lists.newArrayListWithExpectedSize((int)500);
        List boBatch = null;
        for (DynamicObject allDecideIdDy : allCalPersonDys) {
            long decideId = allDecideIdDy.getLong("id");
            if (boBatch == null) {
                boBatch = Lists.newArrayListWithExpectedSize((int)500);
            }
            boBatch.add(decideId);
            if (boBatch.size() != 500) continue;
            boBatchList.add(boBatch);
            boBatch = Lists.newArrayListWithExpectedSize((int)500);
        }
        if (boBatch != null && boBatch.size() > 0) {
            boBatchList.add(boBatch);
        }
        return boBatchList;
    }
}

