/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.task;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.task.UpgradeTaskHelper;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.enums.CalDataTypeEnum;
import kd.sit.sitbp.common.util.SITListUtil;

public class SinsurCalPersonResultUpdateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SinsurCalPersonResultUpdateTask.class);
    private static final int SPLIT_SIZE = 1000;
    private static final HRBaseServiceHelper CAL_PERSON_HELPER = HRBaseServiceHelper.create((String)"hcsi_calperson");
    private static final Set<String> FETCH_DATA_SRC = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("T", "P", "U")));

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"hcsi_sinsurtask");
        DynamicObjectCollection insurTaskDys = helper.queryOriginalCollection("id", new QFilter("1", "=", (Object)1).toArray());
        if (insurTaskDys == null || insurTaskDys.isEmpty()) {
            logger.info("SinsurCalPersonResultUpdateTask.execute: insurTaskDys is empty.");
            UpgradeTaskHelper.disableTask(this.taskId);
            return;
        }
        Map<Long, ItemPropDto> itemPropMap = this.getItemPropMap();
        for (DynamicObject insurTaskDy : insurTaskDys) {
            this.updateCalPersonResult(insurTaskDy, itemPropMap);
        }
        logger.info("SinsurCalPersonResultUpdateTask.execute: update successfully.");
        UpgradeTaskHelper.disableTask(this.taskId);
    }

    private void updateCalPersonResult(DynamicObject insurTaskDy, Map<Long, ItemPropDto> itemPropMap) {
        QFilter filter = new QFilter("sinsurtask.id", "=", (Object)insurTaskDy.getLong("id"));
        DynamicObjectCollection calPersonDys = CAL_PERSON_HELPER.queryOriginalCollection("id", filter.toArray());
        if (calPersonDys == null || calPersonDys.isEmpty()) {
            return;
        }
        List calPersonIds = calPersonDys.stream().map(calPersonDy -> calPersonDy.getLong("id")).collect(Collectors.toList());
        List subCalPersonIdsList = SITListUtil.split(calPersonIds, (int)1000);
        for (List subCalPersonIds : subCalPersonIdsList) {
            this.updateData(subCalPersonIds, itemPropMap);
        }
    }

    private Map<Long, ItemPropDto> getItemPropMap() {
        HashMap<Long, ItemPropDto> itemPropMap = new HashMap<Long, ItemPropDto>(64);
        String selectSql = "SELECT T1.FDATATYPEID datatype, T1.FID id, T2.FDATASRC datasrc FROM T_SITBS_INSURANCEITEM T1 INNER JOIN T_SITBS_INSURANCEPROP T2 ON T1.FINSURANCETYPEATTRID = T2.FID";
        try (DataSet dataSet = HRDBUtil.queryDataSet((String)"SinsurCalPersonResultUpdateTask", (DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)selectSql, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong("id");
                if (Long.valueOf(0L).equals(id)) continue;
                Long dataType = row.getLong("datatype");
                String dataSrc = row.getString("datasrc");
                ItemPropDto itemPropDto = new ItemPropDto(id, dataType, dataSrc);
                itemPropMap.put(id, itemPropDto);
            }
        }
        return itemPropMap;
    }

    private void updateData(List<Long> subCalPersonIds, Map<Long, ItemPropDto> itemPropMap) {
        QFilter filter = new QFilter("id", "in", subCalPersonIds);
        DynamicObject[] calPersonDys = CAL_PERSON_HELPER.query("id,insuranceitem.id,entryentity.isnull,entryentity.storagetype,entryentity.numvalue,entryentity.amountvalue,entryentity.datasrc,", filter.toArray());
        if (calPersonDys == null || calPersonDys.length == 0) {
            return;
        }
        HashMap<Long, HashSet<Long>> calPersonIdAndInvalidItemIds = new HashMap<Long, HashSet<Long>>(16);
        for (DynamicObject calPersonDy : calPersonDys) {
            DynamicObjectCollection entryEntity = calPersonDy.getDynamicObjectCollection("entryentity");
            HashSet<Long> invalidItemIds = new HashSet<Long>(16);
            this.handleEntityData(entryEntity, itemPropMap, invalidItemIds);
            if (invalidItemIds.isEmpty()) continue;
            calPersonIdAndInvalidItemIds.put(calPersonDy.getLong("id"), invalidItemIds);
        }
        try (TXHandle txHandle = TX.requiresNew();){
            CAL_PERSON_HELPER.save(calPersonDys);
        }
        if (!calPersonIdAndInvalidItemIds.isEmpty()) {
            logger.error("SinsurCalPersonResultUpdateTask.updateData error, calPersonIdAndInvalidItemIds: {}", (Object)JSONObject.toJSONString(calPersonIdAndInvalidItemIds));
        }
    }

    private void handleEntityData(DynamicObjectCollection entryEntity, Map<Long, ItemPropDto> itemPropMap, Set<Long> invalidItemIds) {
        for (DynamicObject entity : entryEntity) {
            BigDecimal lastValue;
            String storageType;
            long insuranceItemId = entity.getLong("insuranceitem.id");
            ItemPropDto itemPropDto = itemPropMap.get(insuranceItemId);
            if (itemPropDto == null) continue;
            String dataSrc = entity.getString("datasrc");
            if ("F".equals(dataSrc) && FETCH_DATA_SRC.contains(itemPropDto.getDataSrc())) {
                entity.set("datasrc", (Object)itemPropDto.getDataSrc());
            }
            if (!HRStringUtils.isEmpty((String)(storageType = entity.getString("storagetype")))) continue;
            boolean isNumber = Long.valueOf(CalDataTypeEnum.NUMBER.getId()).equals(itemPropDto.getDataTypeId());
            boolean isAmount = Long.valueOf(CalDataTypeEnum.AMOUNT.getId()).equals(itemPropDto.getDataTypeId());
            if (!isNumber && !isAmount) {
                invalidItemIds.add(insuranceItemId);
                continue;
            }
            String lastStorageType = isNumber ? "number" : "amount";
            entity.set("storagetype", (Object)lastStorageType);
            BigDecimal amountValue = entity.getBigDecimal("amountvalue");
            BigDecimal numValue = entity.getBigDecimal("numvalue");
            BigDecimal bigDecimal = amountValue.compareTo(BigDecimal.ZERO) != 0 ? amountValue : (lastValue = numValue.compareTo(BigDecimal.ZERO) != 0 ? numValue : BigDecimal.ZERO);
            if (isNumber) {
                entity.set("numvalue", (Object)lastValue);
                entity.set("amountvalue", (Object)BigDecimal.ZERO);
            } else {
                entity.set("amountvalue", (Object)lastValue);
                entity.set("numvalue", (Object)BigDecimal.ZERO);
            }
            if (lastValue.compareTo(BigDecimal.ZERO) == 0) continue;
            entity.set("isnull", (Object)Boolean.FALSE);
        }
    }

    static class ItemPropDto {
        private Long itemId;
        private Long dataTypeId;
        private String dataSrc;

        public ItemPropDto() {
        }

        public ItemPropDto(Long itemId, Long dataTypeId, String dataSrc) {
            this.itemId = itemId;
            this.dataTypeId = dataTypeId;
            this.dataSrc = dataSrc;
        }

        public Long getItemId() {
            return this.itemId;
        }

        public void setItemId(Long itemId) {
            this.itemId = itemId;
        }

        public Long getDataTypeId() {
            return this.dataTypeId;
        }

        public void setDataTypeId(Long dataTypeId) {
            this.dataTypeId = dataTypeId;
        }

        public String getDataSrc() {
            return this.dataSrc;
        }

        public void setDataSrc(String dataSrc) {
            this.dataSrc = dataSrc;
        }
    }
}

