/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.task;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.constants.SITConstants;

public class SinsurFilePersonIndexIdUpdateTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(SinsurFilePersonIndexIdUpdateTask.class);
    private static final int batchSize = 5000;
    private static final String tableName = "t_hcsi_sinsurfile";
    private static final String sql = "select fid, fpersonid from t_hcsi_sinsurfile where fpersonindexid = 0 or fpersonindexid is null";
    private DataSet rows = null;
    private int queryBatch = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        try {
            boolean flag = true;
            while (flag) {
                flag = this.updateSinsurFilePersonIndexId();
            }
        }
        catch (Exception e) {
            LOG.error("SinsurFilePersonIndexIdUpdateTask execute error:", (Throwable)e);
        }
        finally {
            this.disableTask();
        }
        LOG.info("SinsurFilePersonIndexIdUpdateTask total use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private boolean updateSinsurFilePersonIndexId() {
        LOG.info("start to deal sinsurfile \uff1a{}", (Object)tableName);
        long startTimeMillis = System.currentTimeMillis();
        if (this.rows == null) {
            this.rows = DB.queryDataSet((String)"querySinsurFileSQl", (DBRoute)SITConstants.SIT_ROUTE, (String)sql);
        }
        if (this.queryBatch >= 1000) {
            this.rows.close();
            this.rows = DB.queryDataSet((String)"querySinsurFileSQl", (DBRoute)SITConstants.SIT_ROUTE, (String)sql);
            this.queryBatch = 0;
            LOG.info("\u5b8c\u62101000\u6279\u6b21\u67e5\u8be2\u540e,dataset\u8fdb\u884c\u91cd\u7f6e,\u9632\u6b62\u8d85\u65f6!");
        }
        if (!this.rows.hasNext()) {
            return false;
        }
        HashSet<Long> personSet = new HashSet<Long>(10);
        HashMap personToSinsurFileMap = Maps.newHashMapWithExpectedSize((int)5000);
        int count = 0;
        while (this.rows.hasNext()) {
            Row row = this.rows.next();
            Long id = row.getLong("fid");
            Long personId = row.getLong("fpersonid");
            personSet.add(personId);
            List sinsurFileId = personToSinsurFileMap.getOrDefault(personId, new ArrayList());
            sinsurFileId.add(id);
            personToSinsurFileMap.put(personId, sinsurFileId);
            if (++count < 5000) continue;
            ++this.queryBatch;
            break;
        }
        long endTimeMillis = System.currentTimeMillis();
        LOG.info(" execute query sinsurfile used : {}", (Object)(endTimeMillis - startTimeMillis));
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hrpi_person");
        String selectProperties = "id,personindexid";
        DynamicObject[] personColl = personHelper.queryOriginalArray(selectProperties, new QFilter[]{new QFilter("id", "in", personSet)});
        HashMap<Long, DynamicObject> personIdToObjMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject person : personColl) {
            personIdToObjMap.put(person.getLong("id"), person);
        }
        long queryPersonEndTime = System.currentTimeMillis();
        LOG.info(" execute query sinsurfile used : {}", (Object)(queryPersonEndTime - endTimeMillis));
        this.updateSinsurFilePersonIndexId(personToSinsurFileMap, personIdToObjMap);
        LOG.info(" execute update sinsurfile used : {}", (Object)(System.currentTimeMillis() - queryPersonEndTime));
        return true;
    }

    private void updateSinsurFilePersonIndexId(Map<Long, List<Long>> personToSinsurFileMap, Map<Long, DynamicObject> personIdToObjMap) {
        String updateSql = "update t_hcsi_sinsurfile set fpersonindexid = ? where fid = ?";
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(10);
        for (Map.Entry<Long, List<Long>> entry : personToSinsurFileMap.entrySet()) {
            Object[] obj;
            LOG.info("salaryFileIdToObjMap size\uff1a {}", (Object)personIdToObjMap.size());
            Long personID = entry.getKey();
            List<Long> sinSurFileIDs = entry.getValue();
            DynamicObject person = personIdToObjMap.get(personID);
            if (person == null) {
                LOG.error("person id {} not query", (Object)personID);
                for (Long sinsurFileId : sinSurFileIDs) {
                    obj = new Object[]{-1L, sinsurFileId};
                    updateList.add(obj);
                }
                continue;
            }
            for (Long sinsurFileId : sinSurFileIDs) {
                obj = new Object[]{person.getLong("personindexid"), sinsurFileId};
                updateList.add(obj);
            }
        }
        DB.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)updateSql, updateList);
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

