/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.task;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.sit.hcsi.business.task.UpgradeTaskHelper;
import kd.sit.sitbp.common.constants.SITBaseConstants;

public class SinsurTaskInsuranceItemUpdateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SinsurTaskInsuranceItemUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Serializable taskId;
        HashMap<Long, Set> taskAndRefItemIdsMap = new HashMap<Long, Set>(16);
        String selectSql = "SELECT FID FROM T_HCSI_SINSURTASK";
        try (DataSet dataSet = HRDBUtil.queryDataSet((String)"SinsurTaskInsuranceItemUpdateTask", (DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)selectSql, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                taskId = row.getLong("FID");
                if (Long.valueOf(0L).equals(taskId)) continue;
                taskAndRefItemIdsMap.computeIfAbsent((Long)taskId, key -> new HashSet(16));
            }
        }
        for (Long taskId2 : taskAndRefItemIdsMap.keySet()) {
            selectSql = "SELECT DISTINCT T1.FINSURANCEITEMID ITEMID FROM T_HCSI_CALPERSONENTRY T1 INNER JOIN T_HCSI_CALPERSON T2 ON T1.FID = T2.FID AND T2.FSINSURTASKID = ?;";
            DataSet dataSet = HRDBUtil.queryDataSet((String)"SinsurTaskInsuranceItemUpdateTask", (DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)selectSql, (Object[])new Object[]{taskId2});
            taskId = null;
            try {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long itemId2 = row.getLong("ITEMID");
                    if (Long.valueOf(0L).equals(itemId2)) continue;
                    taskAndRefItemIdsMap.computeIfAbsent(taskId2, key -> new HashSet(16)).add(itemId2);
                }
            }
            catch (Throwable throwable) {
                taskId = throwable;
                throw throwable;
            }
            finally {
                if (dataSet == null) continue;
                if (taskId != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)taskId).addSuppressed(throwable);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        var6_6 = null;
        try (TXHandle txHandle = TX.requiresNew();){
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsurtask");
            DynamicObject[] taskDys = helper.loadDynamicObjectArray((Object[])taskAndRefItemIdsMap.keySet().toArray(new Long[0]));
            if (taskDys == null || taskDys.length == 0) {
                logger.error("SinsurTaskInsuranceItemUpdateTask.execute error, taskDys is empty.");
                UpgradeTaskHelper.disableTask(this.taskId);
                return;
            }
            try {
                for (DynamicObject taskDy : taskDys) {
                    Set itemIds = (Set)taskAndRefItemIdsMap.get(taskDy.getLong("id"));
                    if (itemIds != null) {
                        itemIds.remove(null);
                    }
                    if (itemIds == null || itemIds.size() == 0) continue;
                    DynamicObjectCollection mulInsuranceItemDy = taskDy.getDynamicObjectCollection("mulinsuranceitem");
                    mulInsuranceItemDy.clear();
                    itemIds.forEach(itemId -> mulInsuranceItemDy.addNew().set("fbasedataid_id", itemId));
                }
                helper.save(taskDys);
            }
            catch (Exception ex) {
                logger.error("SinsurTaskInsuranceItemUpdateTask.execute taskAndRefItemIdsMap are {}: ", (Object)JSONObject.toJSONString(taskAndRefItemIdsMap));
                logger.error("SinsurTaskInsuranceItemUpdateTask.execute error, info: ", (Throwable)ex);
                txHandle.markRollback();
                throw new KDBizException((Throwable)ex, new ErrorCode("", ex.toString()), new Object[0]);
            }
            logger.error("SinsurTaskInsuranceItemUpdateTask.execute error, upgrade successfully.");
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        UpgradeTaskHelper.disableTask(this.taskId);
    }
}

