/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.opplugin.validator.cal;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class SocialInsuranceCloseValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        if ("donothing_close".equals(this.getOperateKey())) {
            this.checkClose();
        } else if ("donothing_cancel".equals(this.getOperateKey())) {
            this.checkCancelClose();
        }
    }

    private void checkClose() {
        long taskId;
        HashSet<Long> taskIds = new HashSet<Long>(16);
        HashSet<Long> shotDownTaskIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if ("1".equals(dataEntity.getDataEntity().getString("taskstatus"))) {
                String msg = ResManager.loadKDString((String)"%s\uff1a\u793e\u4fdd\u4efb\u52a1\u5df2\u5173\u95ed\u3002", (String)"SocialInsuranceCloseValidator_0", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, msg, dataEntity.getDataEntity().getString("number")));
                shotDownTaskIds.add(dataEntity.getDataEntity().getLong("id"));
                continue;
            }
            taskIds.add(dataEntity.getDataEntity().getLong("id"));
        }
        if (taskIds.isEmpty()) {
            return;
        }
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("hcsi_calperson");
        QFilter detailFilter = new QFilter("sinsurtask.id", "in", taskIds);
        DynamicObject[] detailDysArr = detailHelper.query("sinsurtask.id,calstatus", detailFilter.toArray());
        HashSet errorTaskIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet hasDetailTaskIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : detailDysArr) {
            taskId = dynamicObject.getLong("sinsurtask.id");
            String calStatus = dynamicObject.getString("calstatus");
            if (!"2".equals(calStatus)) {
                errorTaskIds.add(taskId);
            }
            hasDetailTaskIds.add(taskId);
        }
        for (DynamicObject dynamicObject : this.dataEntities) {
            String msg;
            taskId = dynamicObject.getDataEntity().getLong("id");
            if (errorTaskIds.contains(taskId)) {
                msg = ResManager.loadKDString((String)"%s\uff1a\u6240\u6709\u6838\u7b97\u8bb0\u5f55\u90fd\u5df2\u5ba1\u6838\u7684\u793e\u4fdd\u4efb\u52a1\u624d\u80fd\u8fdb\u884c\u5173\u95ed\u64cd\u4f5c\u3002", (String)"SocialInsuranceCloseValidator_1", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
                this.addErrorMessage((ExtendedDataEntity)dynamicObject, String.format(Locale.ROOT, msg, dynamicObject.getDataEntity().getString("number")));
            }
            if (hasDetailTaskIds.contains(taskId) || shotDownTaskIds.contains(taskId)) continue;
            msg = ResManager.loadKDString((String)"%s\uff1a\u793e\u4fdd\u660e\u7ec6\u6570\u636e\u4e3a\u7a7a\u4e0d\u5141\u8bb8\u5173\u95ed\u3002", (String)"SocialInsuranceCloseValidator_2", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
            this.addErrorMessage((ExtendedDataEntity)dynamicObject, String.format(Locale.ROOT, msg, dynamicObject.getDataEntity().getString("number")));
        }
    }

    private void checkCancelClose() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if ("1".equals(dataEntity.getDataEntity().getString("taskstatus"))) continue;
            String msg = ResManager.loadKDString((String)"%s\uff1a\u8ba1\u7b97\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5173\u95ed\u624d\u80fd\u64a4\u9500\u5173\u95ed\u3002", (String)"SocialInsuranceCloseValidator_3", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, String.format(Locale.ROOT, msg, dataEntity.getDataEntity().getString("number")), ErrorLevel.Error);
        }
    }
}

