/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.opplugin.validator.declare.dclperson;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.common.constants.SocialInsuranceDeclareConstants;

public class DclPersonDeclaredValidator
extends AbstractValidator
implements SocialInsuranceDeclareConstants {
    private boolean isDeclare;

    public DclPersonDeclaredValidator(boolean isDeclare) {
        this.isDeclare = isDeclare;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length != 0) {
            long dclRecordId = dataEntities[0].getDataEntity().getLong("dclrecord.id");
            DynamicObject dclRecordDy = HRBaseServiceHelper.create((String)"hcsi_dclrecord").loadSingle((Object)dclRecordId);
            String dclRecordDclStatus = dclRecordDy.getString("dclstatus");
            String dclRecordLockedStatus = dclRecordDy.getString("lockstatus");
            for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                String dclStatus = dataEntity.getString("dclstatus");
                if (this.isDeclare) {
                    if ("D".equals(dclRecordDclStatus)) {
                        this.addErrorMessage(extendedDataEntity, HCSIErrInfoEnum.DCL_PERSON_MARK_ABANDONMENT_RECORD.getErrInfo());
                        continue;
                    }
                    if (!"C".equals(dclStatus)) {
                        this.addErrorMessage(extendedDataEntity, HCSIErrInfoEnum.DCL_PERSON_MARK_DECLARED_ERROR.getErrInfo());
                        continue;
                    }
                }
                if (this.isDeclare || "A".equals(dclStatus) && "0".equals(dclRecordLockedStatus)) continue;
                this.addErrorMessage(extendedDataEntity, HCSIErrInfoEnum.DCL_PERSON_CANCEL_DECLARED_ERROR.getErrInfo());
            }
        }
    }
}

