/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.opplugin.validator.declare.dclrecord;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.common.constants.SocialInsuranceDeclareConstants;
import kd.sit.hcsi.opplugin.validator.declare.DclAbstractValidator;

public class DclRecordDiscardValidator
extends DclAbstractValidator
implements SocialInsuranceDeclareConstants {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length != 0) {
            HashSet dclRecordIds = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
            for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                if ("D".equals(dataEntity.getString("dclstatus"))) {
                    this.addErrorMessage(extendedDataEntity, HCSIErrInfoEnum.DCL_RECORD_DISCARD_CHECKED_ERROR_3.getErrInfo());
                    continue;
                }
                if ("1".equals(dataEntity.getString("lockstatus"))) {
                    this.addErrorMessage(extendedDataEntity, HCSIErrInfoEnum.DCL_RECORD_DISCARD_CHECKED_ERROR_1.getErrInfo());
                    continue;
                }
                dclRecordIds.add(dataEntity.getLong("id"));
            }
            Map<Long, Integer> dclRecordIdCountMap = this.queryDclPerson(dclRecordIds);
            for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                long dclRecordId = dataEntity.getLong("id");
                Integer integer = dclRecordIdCountMap.get(dclRecordId);
                if (integer == null || integer <= 0) continue;
                this.addErrorMessage(extendedDataEntity, HCSIErrInfoEnum.DCL_RECORD_DISCARD_CHECKED_ERROR_2.getErrInfo());
            }
        }
    }

    private Map<Long, Integer> queryDclPerson(Set<Long> dclRecordIds) {
        HashMap recordMap = Maps.newHashMapWithExpectedSize((int)dclRecordIds.size());
        for (Long dclRecordId : dclRecordIds) {
            recordMap.put(dclRecordId, 0);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_dclperson");
        QFilter qFilter = new QFilter("dclrecord", "in", dclRecordIds);
        qFilter.and("dclstatus", "!=", (Object)"C");
        DynamicObject[] dclPersonDys = helper.queryOriginalArray("id,dclrecord.id", qFilter.toArray());
        if (dclPersonDys != null && dclPersonDys.length > 0) {
            for (DynamicObject dclPersonDy : dclPersonDys) {
                long dclRecordId = dclPersonDy.getLong("dclrecord.id");
                Integer integer = (Integer)recordMap.get(dclRecordId);
                if (integer == null) continue;
                recordMap.put(dclRecordId, integer + 1);
            }
        }
        return recordMap;
    }
}

