/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.opplugin.validator.declare.rule;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.declare.enums.DclModifyTypeEnum;
import kd.sit.hcsi.common.constants.SocialInsuranceDeclareConstants;
import kd.sit.sitbp.business.helper.mandatory.MandatoryHelper;
import kd.sit.sitbp.common.enums.SInsuranceInfoEnum;
import kd.sit.sitbp.common.util.SITStringUtils;

public class DclRuleSaveValidator
extends AbstractValidator
implements SocialInsuranceDeclareConstants {
    private static final List<String> MANDATORY_FIELDS = Arrays.asList("number", "name", "country");

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        Set<Long> existsDclScmIds = this.getExistsDclScmIds(dataEntities);
        Set<Long> existsInsurTypeIds = this.getExistsInsurTypeIds(dataEntities);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject ruleDy = dataEntity.getDataEntity();
            StringJoiner errMsgSj = MandatoryHelper.checkMandatoryField((DynamicObject)ruleDy, MANDATORY_FIELDS);
            if (errMsgSj.length() != 0) {
                this.addErrorMessage(dataEntity, HCSIErrInfoEnum.COMMON_PROP_FIELD_IS_NULL.getErrInfo(new Object[]{errMsgSj.toString()}));
                continue;
            }
            LinkedHashMap modifyTypeAndHasWelfareTypeSetMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
            HashMap modifyTypeAndWelfareTypeIdSetMap = Maps.newHashMapWithExpectedSize((int)16);
            LinkedHashSet repeatModifyTypeSet = Sets.newLinkedHashSetWithExpectedSize((int)16);
            DynamicObjectCollection ruleEntries = ruleDy.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < ruleEntries.size(); ++i) {
                DynamicObject ruleEntry = (DynamicObject)ruleEntries.get(i);
                String dclBizName = ruleEntry.getString("dclbusinessname");
                if (dclBizName != null) {
                    ruleEntry.set("dclbusinessname", (Object)dclBizName.trim());
                }
                String modifyType = ruleEntry.getString("modifytype");
                String hasWelfareType2 = ruleEntry.getString("haswelfaretype");
                if (!existsDclScmIds.contains(ruleEntry.getLong("dcldisplayscm.id"))) {
                    this.addFatalErrorMessage(dataEntity, HCSIErrInfoEnum.DCL_RULE_ENT_SCM_NOT_EXISTS.getErrInfo(new Object[]{i + 1}));
                }
                DataEntityPropertyCollection properties = ruleEntry.getDataEntityType().getProperties();
                if (!SITStringUtils.isNotEmpty((String)modifyType)) continue;
                if (SITStringUtils.isNotEmpty((String)hasWelfareType2)) {
                    modifyTypeAndHasWelfareTypeSetMap.computeIfAbsent(modifyType, key -> new ArrayList(16)).add(hasWelfareType2);
                }
                if (!SITStringUtils.equals((String)"1", (String)hasWelfareType2)) continue;
                DynamicObjectCollection welfareTypeMul = ruleEntry.getDynamicObjectCollection("welfaretypemul");
                if (CollectionUtils.isEmpty((Collection)welfareTypeMul)) {
                    String errField = SInsuranceInfoEnum.COMMON_QUOTES.getErrInfo(new Object[]{((IDataEntityProperty)properties.get((Object)"welfaretypemul")).getDisplayName().getLocaleValue()});
                    this.addFatalErrorMessage(dataEntity, HCSIErrInfoEnum.DCL_RULE_ENT_MUST_INPUT.getErrInfo(new Object[]{i + 1, errField}));
                    continue;
                }
                Set currInsurTypeIds = welfareTypeMul.stream().map(welfareTypeDy -> welfareTypeDy.getLong("fbasedataid.id")).collect(Collectors.toSet());
                if (!existsInsurTypeIds.containsAll(currInsurTypeIds)) {
                    this.addFatalErrorMessage(dataEntity, HCSIErrInfoEnum.DCL_RULE_ENT_INSURTYPE_NOT_EXISTS.getErrInfo(new Object[]{i + 1}));
                }
                Set welfareTypeIdSet = modifyTypeAndWelfareTypeIdSetMap.computeIfAbsent(modifyType, key -> new HashSet(16));
                welfareTypeMul.forEach(welfareType -> {
                    long welfareTypeId = welfareType.getLong("fbasedataid.id");
                    if (welfareTypeIdSet.contains(welfareTypeId)) {
                        repeatModifyTypeSet.add(modifyType);
                    }
                    welfareTypeIdSet.add(welfareTypeId);
                });
            }
            Map codeAndDescMap = DclModifyTypeEnum.getCodeAndDescMap();
            for (Map.Entry entry : modifyTypeAndHasWelfareTypeSetMap.entrySet()) {
                String errField;
                List hasWelfareTypeList = (List)entry.getValue();
                HashSet hasWelfareTypeSet = new HashSet(hasWelfareTypeList);
                String string = errField = codeAndDescMap.get(entry.getKey()) != null ? ((HCSIErrInfoEnum)codeAndDescMap.get(entry.getKey())).getErrInfo() : null;
                if (hasWelfareTypeSet.size() > 1) {
                    this.addFatalErrorMessage(dataEntity, HCSIErrInfoEnum.DCL_RULE_ENT_POINT_INSUR_TYPE_ERROR.getErrInfo(new Object[]{errField}));
                }
                if (hasWelfareTypeList.stream().filter(hasWelfareType -> !"1".equals(hasWelfareType)).count() <= 1L) continue;
                this.addFatalErrorMessage(dataEntity, HCSIErrInfoEnum.DCL_RULE_ENT_NOT_POINT_INSUR_TYPE_MORE_THAN_ONE.getErrInfo(new Object[]{errField}));
            }
            repeatModifyTypeSet.forEach(repeatModifyType -> {
                String errMsg = codeAndDescMap.get(repeatModifyType) != null ? ((HCSIErrInfoEnum)codeAndDescMap.get(repeatModifyType)).getErrInfo() : null;
                this.addFatalErrorMessage(dataEntity, HCSIErrInfoEnum.DCL_RULE_ENT_POINT_INSUR_TYPE_REPEATED.getErrInfo(new Object[]{errMsg}));
            });
        }
    }

    private Set<Long> getExistsDclScmIds(ExtendedDataEntity[] dataEntities) {
        Set<Long> dclScmIds = Arrays.stream(dataEntities).flatMap(dataEntity -> dataEntity.getDataEntity().getDynamicObjectCollection("entryentity").stream()).map(ruleEntry -> ruleEntry.getLong("dcldisplayscm.id")).collect(Collectors.toSet());
        return this.getExistsEntityIdsInDb("hcsi_dcldisplayscm", dclScmIds);
    }

    private Set<Long> getExistsInsurTypeIds(ExtendedDataEntity[] dataEntities) {
        Set<Long> insurTypeIds = Arrays.stream(dataEntities).flatMap(dataEntity -> dataEntity.getDataEntity().getDynamicObjectCollection("entryentity").stream()).flatMap(ruleEntry -> ruleEntry.getDynamicObjectCollection("welfaretypemul").stream()).map(welfareType -> welfareType.getLong("fbasedataid.id")).collect(Collectors.toSet());
        return this.getExistsEntityIdsInDb("sitbs_welfaretype", insurTypeIds);
    }

    private Set<Long> getExistsEntityIdsInDb(String entityName, Set<Long> dclScmIds) {
        DynamicObjectCollection entityDys = HRBaseServiceHelper.create((String)entityName).queryOriginalCollection("id", new QFilter("id", "in", dclScmIds).toArray());
        return entityDys.stream().map(dclScmDy -> dclScmDy.getLong("id")).collect(Collectors.toSet());
    }
}

