/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.opplugin.validator.file;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SinsurFileAbandonValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(SinsurFileAbandonValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<Long> personIdList = new ArrayList<Long>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            personIdList.add(dataEntity.getDataEntity().getLong("person.id"));
        }
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hrpi_person");
        QFilter idFilter = new QFilter("id", "in", personIdList);
        idFilter.and("datastatus", "=", (Object)"-1");
        DynamicObjectCollection personObjs = personHelper.queryOriginalCollection("id,name,number", new QFilter[]{idFilter});
        Map<Long, DynamicObject> personMap = personObjs.stream().collect(Collectors.toMap(person -> person.getLong("id"), person -> person, (oldVal, newVal) -> oldVal));
        String msg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\u7684\u5165\u804c\u5df2\u88ab\u64a4\u9500\uff0c\u4e0d\u5141\u8bb8{2}\u6863\u6848\u3002", (String)"SinsurFileAbandonValidator_0", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        if (SITStringUtils.equals((String)this.getEntityKey(), (String)"hcsi_sinsurperson")) {
            msg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\u7684\u5165\u804c\u5df2\u88ab\u64a4\u9500\uff0c\u4e0d\u5141\u8bb8{2}\u793e\u4fdd\u4eba\u5458\u4fe1\u606f\u3002", (String)"SinsurFileAbandonValidator_1", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        }
        String opName = this.getOperationName();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject fileDy = dataEntity.getDataEntity();
            Long personId = fileDy.getLong("person.id");
            DynamicObject person2 = personMap.get(personId);
            if (person2 == null) continue;
            this.addErrorMessage(dataEntity, MessageFormat.format(msg, person2.getString("name"), person2.getString("number"), opName));
        }
    }
}

