/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.opplugin.validator.file;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.file.SinsurFileServiceHelper;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITStringUtils;
import kd.sit.sitbp.common.util.SitDateUtil;

public class SinsurFileBsedValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        if (SinsurFileServiceHelper.isNotValidator()) {
            this.validateBsedWithoutEndDate(dataEntities);
        } else {
            this.validateBsed(dataEntities);
        }
    }

    private void validateBsed(ExtendedDataEntity[] dataEntities) {
        String changeSinSurStatus = this.getOption().getVariableValue("changeSinsurStatus", null);
        String dataSrc = this.getOption().getVariableValue("dataSrc", null);
        HashMap needUpdateEmployeeMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        String msgTplWithDate = ResManager.loadKDString((String)"\u201c\u53c2\u4fdd\u72b6\u6001=\u6b63\u5e38\u7f34\u7eb3\u201d\u65f6\uff0c\u6863\u6848\u751f\u6548\u65e5\u671f\u5e94\u5728\u4eba\u5458\u7684[\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u02dc\u7528\u5de5\u7ed3\u675f\u65e5\u671f]\u8303\u56f4\u5185\uff0c\u901a\u8fc7\u67e5\u627e\u8be5\u4eba\u5458\u7684\u804c\u4e1a\u4fe1\u606f\uff0c\u6863\u6848\u751f\u6548\u65e5\u671f\u53ef\u586b\u5165\u7684\u503c\u8303\u56f4\u662f\u201c[{0} ~ {1}]\u201d\u3002", (String)"SinsurFileBsedValidator_24", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject dataEntity = entity.getDataEntity();
            Date effectDate = dataEntity.getDate("bsed");
            if (effectDate == null) {
                this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SinsurFileSaveValidator_4", (String)"sit-hcsi-opplugin", (Object[])new Object[0]));
                continue;
            }
            Date startDate = dataEntity.getDate("employee.startdate");
            Date endDate = dataEntity.getDate("employee.enddate");
            String sinSurStatus = dataEntity.getString("sinsurstatus");
            if ("normal".equals(sinSurStatus)) {
                boolean needUpdate;
                if (SitDateUtil.isCover((Date)effectDate, (Date)startDate, (Date)endDate)) continue;
                boolean bl = needUpdate = "PAGE".equals(dataSrc) || "IMPORT".equals(dataSrc) || "API".equals(dataSrc) || "SYNC".equals(dataSrc);
                if (needUpdate) {
                    needUpdateEmployeeMap.put(entity, dataEntity.getLong("person.id"));
                    continue;
                }
                this.addFatalErrorMessage(entity, MessageFormat.format(msgTplWithDate, SITDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"), SITDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd")));
                continue;
            }
            if (!SITDateTimeUtils.dayBefore((Date)effectDate, (Date)startDate)) continue;
            if (changeSinSurStatus != null) {
                this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u7528\u5de5\u5f00\u59cb\u65e5\u671f\uff1a{0}\u3002", (String)"SinsurFileSaveValidator_5", (String)"sit-hcsi-opplugin", (Object[])new Object[]{SITDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd")}));
                continue;
            }
            this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u6863\u6848\u57fa\u672c\u4fe1\u606f\u7684\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u7528\u5de5\u5f00\u59cb\u65e5\u671f\uff1a{0}\u3002", (String)"SinsurFileSaveValidator_0", (String)"sit-hcsi-opplugin", (Object[])new Object[]{SITDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd")}));
        }
        if (CollectionUtils.isEmpty((Map)needUpdateEmployeeMap)) {
            return;
        }
        HashSet personIds = Sets.newHashSet(needUpdateEmployeeMap.values());
        HRBaseServiceHelper employeeServiceHelper = new HRBaseServiceHelper("hrpi_employee");
        QFilter personFilter = new QFilter("person.id", "in", (Object)personIds);
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.YES.getCode());
        DynamicObject[] query = employeeServiceHelper.query("id,startdate,enddate,person.id", new QFilter[]{personFilter, currentFilter});
        Map<Long, List<DynamicObject>> employeeMap = Arrays.stream(query).collect(Collectors.groupingBy(ele -> ele.getLong("person.id")));
        String msgTplWithoutEmp = ResManager.loadKDString((String)"\u5728\u6863\u6848\u751f\u6548\u65e5\u671f{0}\u672a\u627e\u5230\u6709\u6548\u7684\u4eba\u5458\uff0c\u8bf7\u68c0\u67e5\u793e\u4fdd\u6863\u6848\u751f\u6548\u65e5\u671f\u3001\u4eba\u5458\u6863\u6848\u4e2d\u7684\u804c\u4e1a\u4fe1\u606f\u4e2d\u7684[\u7528\u5de5\u5f00\u59cb\u65e5\u671f,\u7528\u5de5\u7ed3\u675f\u65e5\u671f]\u662f\u5426\u6b63\u786e", (String)"SinsurFileBsedValidator_21", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        String msgTplWithEmp = ResManager.loadKDString((String)"\u201c\u53c2\u4fdd\u72b6\u6001=\u6b63\u5e38\u7f34\u7eb3\u201d\u65f6\uff0c\u6863\u6848\u751f\u6548\u65e5\u671f\u5e94\u5728\u4eba\u5458\u7684[\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u02dc\u7528\u5de5\u7ed3\u675f\u65e5\u671f]\u8303\u56f4\u5185\uff0c\u901a\u8fc7\u67e5\u627e\u8be5\u4eba\u5458\u7684\u804c\u4e1a\u4fe1\u606f\uff0c\u6863\u6848\u751f\u6548\u65e5\u671f\u53ef\u586b\u5165\u7684\u503c\u8303\u56f4\u662f\u201c{0}\u201d\u3002", (String)"SinsurFileBsedValidator_22", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        for (Map.Entry entry : needUpdateEmployeeMap.entrySet()) {
            Long personId = (Long)entry.getValue();
            ExtendedDataEntity entity = (ExtendedDataEntity)entry.getKey();
            DynamicObject dataEntity = entity.getDataEntity();
            Date effectDate = dataEntity.getDate("bsed");
            List<DynamicObject> employees = employeeMap.get(personId);
            if (CollectionUtils.isEmpty(employees)) {
                this.addFatalErrorMessage(entity, MessageFormat.format(msgTplWithoutEmp, SITDateTimeUtils.format((Date)effectDate, (String)"yyyy-MM-dd")));
                continue;
            }
            BaseResult result = SinsurFileServiceHelper.matchEmployee((DynamicObject)dataEntity, employees, (boolean)false, (String)dataSrc);
            if (result.isSuccess()) continue;
            if (dataEntity.getDataEntityState().getFromDatabase() && "PAGE".equals(dataSrc) || "IMPORT".equals(dataSrc)) {
                this.addFatalErrorMessage(entity, MessageFormat.format(msgTplWithEmp, result.getMessage()));
                continue;
            }
            Date startDate = dataEntity.getDate("employee.startdate");
            Date endDate = dataEntity.getDate("employee.enddate");
            this.addFatalErrorMessage(entity, MessageFormat.format(msgTplWithDate, SITDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"), SITDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd")));
        }
    }

    private void validateBsedWithoutEndDate(ExtendedDataEntity[] dataEntities) {
        String changeSinSurStatus = this.getOption().getVariableValue("changeSinsurStatus", null);
        String dataSrc = this.getOption().getVariableValue("dataSrc", null);
        HashMap needUpdateEmployeeMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        String msgTplWithDate = ResManager.loadKDString((String)"\u201c\u53c2\u4fdd\u72b6\u6001=\u6b63\u5e38\u7f34\u7eb3\u201d\u65f6\uff0c\u6863\u6848\u751f\u6548\u65e5\u671f\u5e94\u5728\u4eba\u5458\u7684[\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u02dc\u7528\u5de5\u7ed3\u675f\u65e5\u671f]\u8303\u56f4\u5185\uff0c\u901a\u8fc7\u67e5\u627e\u8be5\u4eba\u5458\u7684\u804c\u4e1a\u4fe1\u606f\uff0c\u6863\u6848\u751f\u6548\u65e5\u671f\u53ef\u586b\u5165\u7684\u503c\u8303\u56f4\u662f\u201c[{0} ~ {1}]\u201d\u3002", (String)"SinsurFileBsedValidator_24", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject dataEntity = entity.getDataEntity();
            Date effectDate = dataEntity.getDate("bsed");
            if (effectDate == null) {
                this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SinsurFileSaveValidator_4", (String)"sit-hcsi-opplugin", (Object[])new Object[0]));
                continue;
            }
            Date startDate = dataEntity.getDate("employee.startdate");
            Date endDate = dataEntity.getDate("employee.enddate");
            String sinSurStatus = dataEntity.getString("sinsurstatus");
            if ("normal".equals(sinSurStatus)) {
                boolean needUpdate;
                if (SitDateUtil.isCover((Date)effectDate, (Date)startDate, (Date)endDate)) continue;
                boolean bl = needUpdate = "PAGE".equals(dataSrc) || "IMPORT".equals(dataSrc) || "API".equals(dataSrc) || "SYNC".equals(dataSrc);
                if (needUpdate) {
                    needUpdateEmployeeMap.put(entity, dataEntity.getLong("person.id"));
                    continue;
                }
                this.addFatalErrorMessage(entity, MessageFormat.format(msgTplWithDate, SITDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"), SITDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd")));
                continue;
            }
            if (!SITDateTimeUtils.dayBefore((Date)effectDate, (Date)startDate)) continue;
            if (changeSinSurStatus != null) {
                this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u7528\u5de5\u5f00\u59cb\u65e5\u671f\uff1a{0}\u3002", (String)"SinsurFileSaveValidator_5", (String)"sit-hcsi-opplugin", (Object[])new Object[]{SITDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd")}));
                continue;
            }
            this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u6863\u6848\u57fa\u672c\u4fe1\u606f\u7684\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u7528\u5de5\u5f00\u59cb\u65e5\u671f\uff1a{0}\u3002", (String)"SinsurFileSaveValidator_0", (String)"sit-hcsi-opplugin", (Object[])new Object[]{SITDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd")}));
        }
        if (CollectionUtils.isEmpty((Map)needUpdateEmployeeMap)) {
            return;
        }
        HashSet personIds = Sets.newHashSet(needUpdateEmployeeMap.values());
        HRBaseServiceHelper employeeServiceHelper = new HRBaseServiceHelper("hrpi_employee");
        QFilter personFilter = new QFilter("person.id", "in", (Object)personIds);
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.YES.getCode());
        DynamicObject[] query = employeeServiceHelper.query("id,startdate,enddate,person.id", new QFilter[]{personFilter, currentFilter});
        Map<Long, List<DynamicObject>> employeeMap = Arrays.stream(query).collect(Collectors.groupingBy(ele -> ele.getLong("person.id")));
        String msgTplWithoutEmp = ResManager.loadKDString((String)"\u5728\u6863\u6848\u751f\u6548\u65e5\u671f{0}\u672a\u627e\u5230\u6709\u6548\u7684\u4eba\u5458\uff0c\u8bf7\u68c0\u67e5\u793e\u4fdd\u6863\u6848\u751f\u6548\u65e5\u671f\u3001\u4eba\u5458\u6863\u6848\u4e2d\u7684\u804c\u4e1a\u4fe1\u606f\u4e2d\u7684[\u7528\u5de5\u5f00\u59cb\u65e5\u671f,\u7528\u5de5\u7ed3\u675f\u65e5\u671f]\u662f\u5426\u6b63\u786e", (String)"SinsurFileBsedValidator_21", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        String msgTplWithEmp = ResManager.loadKDString((String)"\u201c\u53c2\u4fdd\u72b6\u6001=\u6b63\u5e38\u7f34\u7eb3\u201d\u65f6\uff0c\u6863\u6848\u751f\u6548\u65e5\u671f\u5e94\u5728\u4eba\u5458\u7684[\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u02dc\u7528\u5de5\u7ed3\u675f\u65e5\u671f]\u8303\u56f4\u5185\uff0c\u901a\u8fc7\u67e5\u627e\u8be5\u4eba\u5458\u7684\u804c\u4e1a\u4fe1\u606f\uff0c\u6863\u6848\u751f\u6548\u65e5\u671f\u53ef\u586b\u5165\u7684\u503c\u8303\u56f4\u662f\u201c{0}\u201d\u3002", (String)"SinsurFileBsedValidator_22", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        for (Map.Entry entry : needUpdateEmployeeMap.entrySet()) {
            Long personId = (Long)entry.getValue();
            ExtendedDataEntity entity = (ExtendedDataEntity)entry.getKey();
            DynamicObject dataEntity = entity.getDataEntity();
            Date effectDate = dataEntity.getDate("bsed");
            List<DynamicObject> employees = employeeMap.get(personId);
            if (CollectionUtils.isEmpty(employees)) {
                this.addFatalErrorMessage(entity, MessageFormat.format(msgTplWithoutEmp, SITDateTimeUtils.format((Date)effectDate, (String)"yyyy-MM-dd")));
                continue;
            }
            Date firstStartDate = null;
            for (DynamicObject employee : employees) {
                Date startdate = employee.getDate("startdate");
                if (firstStartDate != null && !startdate.before(firstStartDate)) continue;
                firstStartDate = startdate;
            }
            BaseResult result = SinsurFileServiceHelper.matchEmployee((DynamicObject)dataEntity, employees, (boolean)false, (String)dataSrc);
            if (result.isSuccess()) continue;
            if ((SITStringUtils.equals((String)this.getOperateKey(), (String)"save") || SITStringUtils.equals((String)this.getOperateKey(), (String)"donothing_savevalidator")) && !dataEntity.getDataEntityState().getFromDatabase()) {
                if (SITStringUtils.isNotEmpty((String)result.getMessage())) {
                    this.addFatalErrorMessage(entity, MessageFormat.format(msgTplWithEmp, result.getMessage()));
                    continue;
                }
                Date startDate = dataEntity.getDate("employee.startdate");
                Date endDate = dataEntity.getDate("employee.enddate");
                this.addFatalErrorMessage(entity, MessageFormat.format(msgTplWithDate, SITDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"), SITDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd")));
                continue;
            }
            if (firstStartDate == null || !SITDateTimeUtils.dayBefore((Date)effectDate, (Date)firstStartDate)) continue;
            this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u6863\u6848\u57fa\u672c\u4fe1\u606f\u7684\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u7528\u5de5\u5f00\u59cb\u65e5\u671f\uff1a{0}\u3002", (String)"SinsurFileSaveValidator_0", (String)"sit-hcsi-opplugin", (Object[])new Object[]{SITDateTimeUtils.format((Date)firstStartDate, (String)"yyyy-MM-dd")}));
        }
    }
}

