/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.opplugin.validator.file;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.sit.hcsi.business.file.SinsurFileServiceHelper;
import kd.sit.hcsi.common.constants.SinsurFileConstants;

public class SinsurFileChangeStatusValidator
extends AbstractValidator
implements SinsurFileConstants {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        this.validateFileNumber(dataEntities);
    }

    private void validateFileNumber(ExtendedDataEntity[] dataEntities) {
        int i;
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        ArrayList<Long> fileIds = new ArrayList<Long>(dataEntities.length);
        for (int i2 = 0; i2 < dataEntities.length; ++i2) {
            ExtendedDataEntity extendedDataEntity = dataEntities[i2];
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            fileIds.add(dataEntity.getLong("id"));
        }
        DynamicObject[] queryResult = SinsurFileServiceHelper.queryFile(fileIds);
        if (queryResult == null || queryResult.length == 0) {
            return;
        }
        HashMap<Long, DynamicObject> dbFileMap = new HashMap<Long, DynamicObject>(queryResult.length);
        for (i = 0; i < queryResult.length; ++i) {
            DynamicObject dynamicObject = queryResult[i];
            dbFileMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        for (i = 0; i < dataEntities.length; ++i) {
            ExtendedDataEntity extendedDataEntity = dataEntities[i];
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Long key = dataEntity.getLong("id");
            DynamicObject dbFileDy = (DynamicObject)dbFileMap.get(key);
            if (dbFileDy == null || !dbFileDy.getString("sinsurstatus").equals(dataEntity.getString("sinsurstatus"))) continue;
            this.addFatalErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8c03\u6574\u540e\u53c2\u4fdd\u72b6\u6001\u4e0d\u80fd\u7b49\u4e8e\u5f53\u524d\u53c2\u4fdd\u72b6\u6001\u3010{0}\u3011\u3002", (String)"SinsurFileChangeStatusValidator_0", (String)"sit-hcsi-opplugin", (Object[])new Object[]{this.getSinsurStatusDesc(dataEntity.getString("sinsurstatus"))}));
        }
    }

    private String getSinsurStatusDesc(String sinsurStatus) {
        switch (sinsurStatus) {
            case "normal": {
                return ResManager.loadKDString((String)"\u6b63\u5e38\u7f34\u7eb3", (String)"SinsurFileChangeStatusValidator_1", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
            }
            case "seal": {
                return ResManager.loadKDString((String)"\u505c\u6b62\u7f34\u7eb3", (String)"SinsurFileChangeStatusValidator_2", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
            }
        }
        return sinsurStatus;
    }
}

