/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.opplugin.validator.file;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.history.model.SITHisBaseConstants;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SinsurFileEmployeeValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length > 0 && (SITStringUtils.equals((String)this.getOperateKey(), (String)"save") || SITStringUtils.equals((String)this.getOperateKey(), (String)"donothing_savevalidator")) && !dataEntities[0].getDataEntity().getDataEntityState().getFromDatabase()) {
            Set employeeIds = Arrays.stream(dataEntities).map(o -> o.getDataEntity().getLong("employee.id")).collect(Collectors.toSet());
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrpi_empposorgrel");
            QFilter qFilter = new QFilter("employee.id", "in", employeeIds);
            qFilter.and("isprimary", "=", (Object)"1");
            qFilter.and("iscurrentversion", "=", (Object)"1");
            qFilter.and("datastatus", "in", (Object)SITHisBaseConstants.getValidStatus());
            DynamicObjectCollection empposorgrelColl = helper.queryOriginalCollection("employee.id,businessstatus,islatestrecord", qFilter.toArray());
            Map<Long, List<DynamicObject>> empposorgrelMap = empposorgrelColl.stream().collect(Collectors.groupingBy(o -> o.getLong("employee.id")));
            for (ExtendedDataEntity dataEntity : dataEntities) {
                long employeeId = dataEntity.getDataEntity().getLong("employee.id");
                List<DynamicObject> empposorgrels = empposorgrelMap.get(employeeId);
                boolean hasPrimaryRel = false;
                if (empposorgrels != null) {
                    for (DynamicObject empposorgrel : empposorgrels) {
                        String businessstatus = empposorgrel.getString("businessstatus");
                        boolean islatestrecord = empposorgrel.getBoolean("islatestrecord");
                        if (!SITStringUtils.equals((String)businessstatus, (String)"1") && (!islatestrecord || !SITStringUtils.equals((String)businessstatus, (String)"2"))) continue;
                        hasPrimaryRel = true;
                        break;
                    }
                }
                if (hasPrimaryRel) continue;
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4eba\u5458\u65e0\u4e3b\u4efb\u804c\uff0c\u8bf7\u68c0\u67e5\u4eba\u5458\u4fe1\u606f\u3002", (String)"SinsurFileEmployeeValidator_1", (String)"sit-hcsi-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

