/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.opplugin.validator.file;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.common.util.SITMServiceUtils;

public class SinsurFilePersonSaveValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(SinsurFilePersonSaveValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        this.validateAbandonOrCertificateNumber(dataEntities);
        this.validateEmployeeAndPlaceOfWelfare(dataEntities);
    }

    private void validateAbandonOrCertificateNumber(ExtendedDataEntity[] dataEntities) {
        String msg = ResManager.loadKDString((String)"\u4eba\u5458\u65e0\u8bc1\u4ef6\u53f7\u7801\u3002", (String)"SinsurFileSaveValidator_6", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        ArrayList<Long> personIds = new ArrayList<Long>(dataEntities.length);
        for (int i = 0; i < dataEntities.length; ++i) {
            personIds.add(dataEntities[i].getDataEntity().getLong("person.id"));
        }
        String selectProps = "person.id,number,ismajor";
        QFilter qFilter = BaseDataHisHelper.getHisCurrFilter();
        String attachEntityName = "hrpi_percre";
        List pmList = (List)SITMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listBatchPropPersonAttachs", (Object[])new Object[]{personIds, selectProps, qFilter, attachEntityName});
        Map<Object, Object> pMap = null;
        if (!CollectionUtils.isEmpty((Collection)pmList)) {
            pMap = pmList.stream().filter(map -> (Boolean)map.get("ismajor")).collect(Collectors.toMap(pm -> pm.get("person.id"), pm -> pm.get("number"), (k1, k2) -> k2));
        }
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hrpi_person");
        QFilter idFilter = new QFilter("id", "in", personIds);
        idFilter.and("datastatus", "=", (Object)"-1");
        DynamicObjectCollection personObjs = personHelper.queryOriginalCollection("id,name,number", new QFilter[]{idFilter});
        Map<Long, DynamicObject> personMap = personObjs.stream().collect(Collectors.toMap(person -> person.getLong("id"), person -> person, (oldVal, newVal) -> oldVal));
        String abandMsg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\u7684\u5165\u804c\u5df2\u88ab\u64a4\u9500\uff0c\u4e0d\u5141\u8bb8{2}\u793e\u4fdd\u4eba\u5458\u4fe1\u606f\u3002", (String)"SinsurFileAbandonValidator_1", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        String opName = this.getOperationName();
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject fileDy = extendedDataEntity.getDataEntity();
            Long personId = fileDy.getLong("person.id");
            DynamicObject person2 = personMap.get(personId);
            if (person2 != null) {
                this.addErrorMessage(extendedDataEntity, MessageFormat.format(abandMsg, person2.getString("name"), person2.getString("number"), opName));
                continue;
            }
            if (null != pMap && pMap.containsKey(personId)) continue;
            this.addFatalErrorMessage(extendedDataEntity, msg);
        }
    }

    private void validateEmployeeAndPlaceOfWelfare(ExtendedDataEntity[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        String personId = this.getOption().getVariableValue("personId", null);
        String placeOfWelfareId = this.getOption().getVariableValue("placeofwelfare", null);
        if (personId == null || placeOfWelfareId == null) {
            return;
        }
        HRBaseServiceHelper salaryFileOrm = new HRBaseServiceHelper("hcsi_sinsurperson");
        QFilter employeeFilter = new QFilter("person", "=", (Object)Long.parseLong(personId));
        QFilter welfarePayerFilter = new QFilter("placeofwelfare", "=", (Object)Long.parseLong(placeOfWelfareId));
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        BaseDataHisHelper.addHisCurrFilter((QFilter)employeeFilter);
        DynamicObject[] queryResult = salaryFileOrm.query("id,employee,employee.person.name,placeofwelfare,placeofwelfare.name", new QFilter[]{employeeFilter, welfarePayerFilter, enableFilter, statusFilter});
        if (queryResult != null && queryResult.length != 0) {
            this.addFatalErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u793e\u4fdd\u4eba\u5458\u4fe1\u606f\u5df2\u66f4\u65b0\u3002", (String)"SinsurFileSaveValidator_3", (String)"sit-hcsi-opplugin", (Object[])new Object[0]));
        }
    }
}

