/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.opplugin.validator.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.common.constants.SinsurFileConstants;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SinsurFileSaveValidator
extends AbstractValidator
implements SinsurFileConstants {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        if (SITStringUtils.equals((String)"save", (String)this.getOperateKey())) {
            this.validateExistsCodeRule(dataEntities);
        }
        this.validateWelfarePayer(dataEntities);
        this.validateFileNumber(dataEntities);
        this.validateEmployeeAndWelfarepayer(dataEntities);
        this.validateWelfarePayerOrgAndCountry(dataEntities);
    }

    private void validateWelfarePayerOrgAndCountry(ExtendedDataEntity[] dataEntities) {
        Set welfarepayerIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("welfarepayer.id")).collect(Collectors.toSet());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_welfarepayer");
        DynamicObjectCollection welfarepayers = helper.queryOriginalCollection("id,org.id,country.id", new QFilter("id", "in", welfarepayerIds).toArray());
        Map<Long, DynamicObject> welfarepayerIdMap = welfarepayers.stream().collect(Collectors.toMap(dataEntity -> dataEntity.getLong("id"), dataEntity -> dataEntity, (oldVal, newVal) -> oldVal));
        for (ExtendedDataEntity dataEntity2 : dataEntities) {
            long welfarepayerId = dataEntity2.getDataEntity().getLong("welfarepayer.id");
            DynamicObject welfarepayer = welfarepayerIdMap.get(welfarepayerId);
            long welOrgId = welfarepayer.getLong("org.id");
            long welCountryID = welfarepayer.getLong("country.id");
            long orgId = dataEntity2.getDataEntity().getLong("org.id");
            long manageregionId = dataEntity2.getDataEntity().getLong("manageregion.id");
            if (orgId != welOrgId) {
                this.addFatalErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u6863\u6848\u7684\u793e\u4fdd\u516c\u79ef\u91d1\u7ba1\u7406\u7ec4\u7ec7\u4e0e\u5b9e\u9645\u53c2\u4fdd\u5355\u4f4d\u7684\u793e\u4fdd\u516c\u79ef\u91d1\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574\u3002", (String)"SinsurFileSaveValidator_12", (String)"sit-hcsi-opplugin", (Object[])new Object[0]));
            }
            if (welCountryID == manageregionId) continue;
            this.addFatalErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u6863\u6848\u7684\u793e\u4fdd\u7ba1\u7406\u5c5e\u5730\u4e0e\u5b9e\u9645\u53c2\u4fdd\u5355\u4f4d\u7684\u56fd\u5bb6/\u5730\u533a\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574\u3002", (String)"SinsurFileSaveValidator_13", (String)"sit-hcsi-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateExistsCodeRule(ExtendedDataEntity[] dataEntities) {
        String errorMsg = ResManager.loadKDString((String)"\u4eba\u5458\u793e\u4fdd\u6863\u6848\u65e0\u53ef\u7528\u7684\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u201c\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u201d\u3002", (String)"SinsurFileBsedValidator_27", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)"hcsi_sinsurfile", (DynamicObject)dataEntities[0].getDataEntity(), null);
        if (codeRule == null) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.addErrorMessage(dataEntity, errorMsg);
            }
        }
    }

    private void validateWelfarePayer(ExtendedDataEntity[] dataEntities) {
        String msg = ResManager.loadKDString((String)"\u4ee3\u7ba1\u5458\u5de5\u5fc5\u987b\u586b\u5199\u201c\u7406\u8bba\u53c2\u4fdd\u5355\u4f4d\u201d\u3002", (String)"SinsurFileSaveValidator_9", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        String msgNotEqual = ResManager.loadKDString((String)"\u4ee3\u7ba1\u5458\u5de5\u7684\u7406\u8bba\u53c2\u4fdd\u5355\u4f4d\u4e0d\u80fd\u7b49\u4e8e\u5b9e\u9645\u53c2\u4fdd\u5355\u4f4d\u3002", (String)"SinsurFileSaveValidator_10", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        String msgEqual = ResManager.loadKDString((String)"\u975e\u4ee3\u7ba1\u5458\u5de5\u7684\u7406\u8bba\u53c2\u4fdd\u5355\u4f4d\u5e94\u7b49\u4e8e\u5b9e\u9645\u53c2\u4fdd\u5355\u4f4d\u3002", (String)"SinsurFileSaveValidator_11", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        for (int i = 0; i < dataEntities.length; ++i) {
            ExtendedDataEntity extendedDataEntity = dataEntities[i];
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if (dataEntity.getBoolean("isescrowstaff")) {
                Long welfarepayertheoryId = dataEntity.getLong("welfarepayertheory.id");
                if (welfarepayertheoryId == 0L) {
                    this.addFatalErrorMessage(extendedDataEntity, msg);
                    continue;
                }
                if (welfarepayertheoryId.longValue() != dataEntity.getLong("welfarepayer.id")) continue;
                this.addFatalErrorMessage(extendedDataEntity, msgNotEqual);
                continue;
            }
            if (!dataEntity.getBoolean("isescrowstaff") || dataEntity.getLong("welfarepayertheory.id") != dataEntity.getLong("welfarepayer.id")) continue;
            this.addFatalErrorMessage(extendedDataEntity, msgEqual);
        }
    }

    private void validateFileNumber(ExtendedDataEntity[] dataEntities) {
        int i;
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        HRBaseServiceHelper salaryFileOrm = new HRBaseServiceHelper("hcsi_sinsurfile");
        ArrayList<String> fileNumbers = new ArrayList<String>(dataEntities.length);
        for (int i2 = 0; i2 < dataEntities.length; ++i2) {
            ExtendedDataEntity extendedDataEntity = dataEntities[i2];
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String fileNumber = dataEntity.getString("number");
            if (!SITStringUtils.isNotEmpty((String)fileNumber)) continue;
            fileNumbers.add(fileNumber);
        }
        QFilter fileNumberFilter = new QFilter("number", "in", fileNumbers);
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        BaseDataHisHelper.addHisCurrFilter((QFilter)fileNumberFilter);
        DynamicObject[] queryResult = salaryFileOrm.query("boid,number", new QFilter[]{fileNumberFilter, statusFilter});
        if (queryResult == null || queryResult.length == 0) {
            return;
        }
        HashMap<String, Long> existKeys = new HashMap<String, Long>(queryResult.length);
        for (i = 0; i < queryResult.length; ++i) {
            DynamicObject dynamicObject = queryResult[i];
            existKeys.put(dynamicObject.getString("number"), dynamicObject.getLong("boid"));
        }
        for (i = 0; i < dataEntities.length; ++i) {
            ExtendedDataEntity extendedDataEntity = dataEntities[i];
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String key = dataEntity.getString("number");
            Long fileBoId = dataEntity.getLong("boid");
            Long dbFileBoId = (Long)existKeys.get(key);
            if (dbFileBoId == null || dbFileBoId == 0L || dbFileBoId.compareTo(fileBoId) == 0) continue;
            this.addFatalErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u3010{0}\u3011\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa\u3002", (String)"SinsurFileSaveValidator_1", (String)"sit-hcsi-opplugin", (Object[])new Object[]{key}));
        }
    }

    private void validateEmployeeAndWelfarepayer(ExtendedDataEntity[] dataEntities) {
        String isimport = this.getOption().getVariableValue("isimport", "");
        boolean isImport = SITStringUtils.equals((String)isimport, (String)"1");
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        HRBaseServiceHelper salaryFileOrm = new HRBaseServiceHelper("hcsi_sinsurfile");
        ArrayList<Long> personIds = new ArrayList<Long>(dataEntities.length);
        ArrayList<Long> welfarePayerIds = new ArrayList<Long>(dataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            personIds.add(dataEntity.getLong("person.id"));
            welfarePayerIds.add(dataEntity.getLong("welfarepayer.id"));
        }
        QFilter employeeFilter = new QFilter("person.id", "in", personIds);
        QFilter welfarepayerFilter = new QFilter("welfarepayer", "in", welfarePayerIds);
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        BaseDataHisHelper.addHisCurrFilter((QFilter)employeeFilter);
        DynamicObject[] queryResult = salaryFileOrm.query("boid,person,welfarepayer,welfarepayer.name", new QFilter[]{employeeFilter, welfarepayerFilter, enableFilter, statusFilter});
        if (queryResult == null || queryResult.length == 0) {
            return;
        }
        HashMap<String, Long> existKeys = new HashMap<String, Long>(queryResult.length);
        for (DynamicObject dynamicObject : queryResult) {
            String key = dynamicObject.getString("person.id") + "_" + dynamicObject.getString("welfarepayer.id");
            existKeys.put(key, dynamicObject.getLong("boid"));
        }
        for (DynamicObject dynamicObject : dataEntities) {
            DynamicObject dataEntity = dynamicObject.getDataEntity();
            String key = dataEntity.getString("person.id") + "_" + dataEntity.getString("welfarepayer.id");
            Long fileBoId = dataEntity.getLong("boid");
            Long dbFileBoId = (Long)existKeys.get(key);
            if (dbFileBoId == null || dbFileBoId == 0L || dbFileBoId.compareTo(fileBoId) == 0) continue;
            if (isImport) {
                this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u4eba\u5458\u3010{0}\u3011\u5728\u53c2\u4fdd\u5355\u4f4d\u3010{1}\u3011\u5df2\u5b58\u5728\u793e\u4fdd\u6863\u6848\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa\uff0c\u82e5\u9700\u8981\u66f4\u65b0\u8be5\u6863\u6848\uff0c\u8bf7\u5728\u5bfc\u5165\u6a21\u677f\u4e2d\u586b\u5165\u6863\u6848\u7f16\u53f7\u3002", (String)"SinsurFileSaveValidator_2", (String)"sit-hcsi-opplugin", (Object[])new Object[]{dataEntity.getString("employee.empnumber"), dataEntity.getString("welfarepayer.name")}));
                continue;
            }
            this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u4eba\u5458\u3010{0}\u3011\u5728\u53c2\u4fdd\u5355\u4f4d\u3010{1}\u3011\u5df2\u5b58\u5728\u793e\u4fdd\u6863\u6848\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa\u3002", (String)"SinsurFileSaveValidator_14", (String)"sit-hcsi-opplugin", (Object[])new Object[]{dataEntity.getString("employee.empnumber"), dataEntity.getString("welfarepayer.name")}));
        }
    }
}

