/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.opplugin.validator.file;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.sitbp.business.history.BaseDataHisHelper;

public class SinsurFileSinSurBaseValidator
extends AbstractValidator {
    public void validate() {
        List sinSurFileDys = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        String operateKey = this.getOperateKey();
        if (HRStringUtils.equals((String)"do_changesinsurstatusconfirm", (String)operateKey)) {
            for (DynamicObject sinSurFileDy : sinSurFileDys) {
                sinSurFileDy.set("bsled", (Object)BaseDataHisHelper.getMaxBsled());
            }
        }
        sinSurFileDys.removeIf(this::isAuditOpAndAuditStatus);
        Map errorSinSurFiles = SinSurFileStdServiceHelper.validateWelfareTypeInsuredFile(sinSurFileDys);
        if (errorSinSurFiles == null) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Map errorSinSurFile;
            DynamicObject sinSurFile = dataEntity.getDataEntity();
            if (this.isAuditOpAndAuditStatus(sinSurFile) || (errorSinSurFile = (Map)errorSinSurFiles.get(sinSurFile.getLong("boid"))) == null) continue;
            Date bsled = sinSurFile.getDate("bsled");
            if (bsled == null) {
                bsled = SinSurFileStdServiceHelper.generateBsledDate();
            }
            String bsedStr = HRInteDateTimeUtil.formatDate((String)"hcsi_sinsurfile", (String)"bsed", (Date)sinSurFile.getDate("bsed"));
            String bsledStr = HRInteDateTimeUtil.formatDate((String)"hcsi_sinsurfile", (String)"bsled", (Date)bsled);
            this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5728{0}~{1}\u65f6\u95f4\u6bb5\u5185\uff0c{2}\u5728\u6863\u6848{3}\u4e2d\u5df2\u53c2\u4fdd\uff0c\u540c\u4e00\u9669\u79cd\u5728\u76f8\u540c\u65f6\u95f4\u6bb5\u5185\u53ea\u80fd\u5728\u4e00\u4efd\u6b63\u5e38\u7f34\u7eb3\u7684\u6863\u6848\u4e2d\u53c2\u4fdd\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"SinsurFileSinSurBaseValidator_0", (String)"sit-hcsi-opplugin", (Object[])new Object[0]), bsedStr, bsledStr, ((DynamicObject)errorSinSurFile.get("hcsi_sinsurbase")).getString("welfaretype.name"), ((DynamicObject)errorSinSurFile.get("hcsi_sinsurfile")).getString("number")));
        }
    }

    private boolean isAuditOpAndAuditStatus(DynamicObject sinSurFileDy) {
        return "audit".equals(this.getOperateKey()) && "C".equals(sinSurFileDy.getString("status"));
    }
}

