/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.opplugin.validator.file;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.hcsi.business.file.SinSurPersonCertCommonHelper;

public class SinsurPersonCertValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(SinsurPersonCertValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        this.validateSinSurSalaryFileImportCert(dataEntities);
    }

    private void validateSinSurSalaryFileImportCert(ExtendedDataEntity[] dataEntities) {
        ArrayList<DynamicObject> files = new ArrayList<DynamicObject>(dataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            files.add(data);
        }
        Map veryfiResult = SinSurPersonCertCommonHelper.verifyCert(files);
        Set failList = (Set)veryfiResult.get("failList");
        String message = (String)veryfiResult.get("message");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Long pid = dataEntity.getDataEntity().getLong("person.personindexid");
            if (!failList.contains(pid)) continue;
            LOGGER.info("[cert]:validateSinSurSalaryFileImportCert cert fail,pid={}", (Object)pid);
            this.addFatalErrorMessage(dataEntity, message);
        }
        Map map = (Map)veryfiResult.get("msg");
        LOGGER.info("SinsurPersonCertValidator sinSurVerifyCertForApply: {}", (Object)JSON.toJSONString((Object)map));
        String showMessageType = (String)map.get("showMessageType");
        if ("true".equals(map.get("showMessage"))) {
            this.getOption().setVariableValue("showWarningTip", (String)map.get("message"));
        }
    }
}

