/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.opplugin.validator.file;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.hcsi.business.file.SinSurPersonCertCommonHelper;

public class SinsurSalaryFileImportSaveValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(SinsurSalaryFileImportSaveValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        this.validateSinSurSalaryFileImportCert(dataEntities);
    }

    private void validateSinSurSalaryFileImportCert(ExtendedDataEntity[] dataEntities) {
        ArrayList<DynamicObject> files = new ArrayList<DynamicObject>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            if (!"C".equals(data.getString("status"))) continue;
            files.add(data);
        }
        if (files.isEmpty()) {
            return;
        }
        try {
            Map veryfiResult = SinSurPersonCertCommonHelper.verifyCert(files);
            LOGGER.info("SinsurSalaryFileImportSaveValidator filesize: {}", (Object)files.size());
            LOGGER.info("SinsurSalaryFileImportSaveValidator sinSurImportVerifyCertForApply: {}", (Object)JSON.toJSONString((Object)veryfiResult));
            Set failList = (Set)veryfiResult.get("failList");
            String message = (String)veryfiResult.get("message");
            for (ExtendedDataEntity dataEntity : dataEntities) {
                Long pid = dataEntity.getDataEntity().getLong("person.personindexid");
                if (!failList.contains(pid)) continue;
                LOGGER.info("[cert]:validateSinSurSalaryfileImportCert cert fail,pid={}", (Object)pid);
                this.addFatalErrorMessage(dataEntity, message);
            }
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.addFatalErrorMessage(dataEntity, message);
            }
        }
    }
}

