/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.opplugin.validator.file.attach;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.hcsi.business.common.helper.StandardCfgHelper;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;

public class SinSurFileStdSaveValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(SinSurFileStdSaveValidator.class);

    public void validate() {
        long startTime = System.currentTimeMillis();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        HashSet<Long> welfarePayerIds = new HashSet<Long>(dataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObject sinSurFile = dataEntity.getDynamicObject("sinsurfile");
            welfarePayerIds.add(sinSurFile.getLong("welfarepayer.id"));
        }
        Map welfarePayerSinSurStd = SinSurFileStdServiceHelper.queryWelfarePayerSinSurStd(welfarePayerIds);
        Set insurTypeIdsAllowedPayInMultipleArea = StandardCfgHelper.filterInsurTypeIdsInMultipleArea();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObjectCollection dynamicObjectCollection;
            if (!this.validate(dataEntity, welfarePayerSinSurStd) || (dynamicObjectCollection = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity")) == null || dynamicObjectCollection.size() == 0) continue;
            ArrayList<Long> welfareTypeIds = new ArrayList<Long>(dynamicObjectCollection.size());
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                welfareTypeIds.add(dynamicObject.getLong("welfaretypeid"));
            }
            Map welfareTypeInsuranceTypeAttrMap = SinSurFileStdServiceHelper.queryInsuranceTypeAttrSetting(welfareTypeIds, SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.values());
            DynamicObject sinSurFile = dataEntity.getDataEntity().getDynamicObject("sinsurfile");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                long insurTypeId = dynamicObject.getLong("welfaretypeid");
                if (!dynamicObject.getBoolean("insured")) continue;
                if (!insurTypeIdsAllowedPayInMultipleArea.contains(insurTypeId)) {
                    long personIndexId = sinSurFile.getLong("personindexid");
                    long sinSurFileId = sinSurFile.getLong("id");
                    DynamicObject welfareTypeInsuredFile = SinSurFileStdServiceHelper.welfareTypeInsuredFile((Long)sinSurFileId, (Long)personIndexId, (Long)insurTypeId, (Date)dynamicObject.getDate("entrybsed"), (Date)dynamicObject.getDate("entrybsled"));
                    if (welfareTypeInsuredFile != null) {
                        this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u540c\u65f6\u95f4\u6bb5\u5185\uff0c{0}\u5728\u4eba\u5458\u793e\u4fdd\u6863\u6848\uff1a{1}\u4e2d\u5df2\u53c2\u4fdd\uff0c\u8bf7\u5c06\u53c2\u4fdd\u5f00\u5173\u5173\u95ed\u3002", (String)"SinSurFileStdSaveValidator_0", (String)"sit-hcsi-opplugin", (Object[])new Object[0]), dynamicObject.getString("welfaretype"), welfareTypeInsuredFile.getString("number")));
                        continue;
                    }
                }
                this.validateMustInput(dataEntity, welfareTypeInsuranceTypeAttrMap, dynamicObject);
            }
        }
        long endTime = System.currentTimeMillis();
        log.info("SinSurFileStdSaveValidator Validator cost time :{}", (Object)(endTime - startTime));
    }

    private boolean validate(ExtendedDataEntity extendedDataEntity, Map<Long, List<DynamicObject>> welfarePayerSinSurStd) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        Date bsed = dataEntity.getDate("bsed");
        if (bsed == null) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"SinSurFileStdSaveValidator_2", (String)"sit-hcsi-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (dataEntity.getDate("bsled") != null && dataEntity.getDate("bsed").after(dataEntity.getDate("bsled"))) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65f6\u95f4\u3002", (String)"SinSurFileStdSaveValidator_5", (String)"sit-hcsi-opplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject sinSurStd = dataEntity.getDynamicObject("sinsurstd");
        if (sinSurStd == null) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u53c2\u4fdd\u6807\u51c6\u201d\u3002", (String)"SinSurFileStdSaveValidator_3", (String)"sit-hcsi-opplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject sinSurFile = dataEntity.getDynamicObject("sinsurfile");
        if (!this.validateSinSurStd(bsed, sinSurStd.getLong("id"), sinSurFile.getLong("welfarepayer.id"), welfarePayerSinSurStd)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0e\u53c2\u4fdd\u6807\u51c6\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"SinSurFileStdSaveValidator_4", (String)"sit-hcsi-opplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean validateSinSurStd(Date bsed, Long sinSurStdId, long welfarePayerId, Map<Long, List<DynamicObject>> welfarePayerSinSurStd) {
        List<DynamicObject> coandDimRefVersions = welfarePayerSinSurStd.get(welfarePayerId);
        if (coandDimRefVersions == null) {
            return false;
        }
        for (DynamicObject coandDimRefVersion : coandDimRefVersions) {
            if (bsed.compareTo(coandDimRefVersion.getDate("bsed")) < 0 || bsed.compareTo(coandDimRefVersion.getDate("bsled")) > 0) continue;
            DynamicObjectCollection mulSinSurStds = coandDimRefVersion.getDynamicObjectCollection("mulsinsurstd");
            ArrayList<Long> sinSurStdIds = new ArrayList<Long>(mulSinSurStds.size());
            for (DynamicObject mulSinSurStd : mulSinSurStds) {
                sinSurStdIds.add(mulSinSurStd.getLong("fbasedataid.id"));
            }
            return sinSurStdIds.contains(sinSurStdId);
        }
        return false;
    }

    private void validateMustInput(ExtendedDataEntity dataEntity, Map<Long, Map<Long, Boolean>> welfareTypeInsuranceTypeAttrMap, DynamicObject dynamicObject) {
        long welfareTypeId = dynamicObject.getLong("welfaretypeid");
        DataEntityPropertyCollection entityProperties = dynamicObject.getDynamicObjectType().getProperties();
        Map<Long, Boolean> insuranceTypeAttrMap = welfareTypeInsuranceTypeAttrMap.get(welfareTypeId);
        for (Map.Entry mapEntry : SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.entrySet()) {
            if (!insuranceTypeAttrMap.get(mapEntry.getValue()).booleanValue() || dynamicObject.get((String)mapEntry.getKey()) != null) continue;
            this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"{0}\u7684{1}\u672a\u586b\u5199\u3002", (String)"SinSurFileStdSaveValidator_1", (String)"sit-hcsi-opplugin", (Object[])new Object[0]), dynamicObject.getString("welfaretype"), ((IDataEntityProperty)entityProperties.get(mapEntry.getKey())).getDisplayName().getLocaleValue()));
        }
    }
}

