/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.opplugin.web.file;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.sit.hcsi.business.file.SinSurPersonCertCommonHelper;
import kd.sit.hcsi.business.file.SinsurFileServiceHelper;
import kd.sit.hcsi.opplugin.validator.file.SinsurFileAbandonValidator;
import kd.sit.hcsi.opplugin.validator.file.SinsurFileSinSurBaseValidator;
import kd.sit.hcsi.opplugin.validator.file.SinsurPersonCertValidator;

public class SinsurFileAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("number");
        fieldKeys.add("bsed");
        fieldKeys.add("bsled");
        fieldKeys.add("employee");
        fieldKeys.add("employee.startdate");
        fieldKeys.add("employee.enddate");
        fieldKeys.add("employee.empnumber");
        fieldKeys.add("employee.person.name");
        fieldKeys.add("welfarepayer");
        fieldKeys.add("welfarepayer.name");
        fieldKeys.add("person");
        fieldKeys.add("manageregion.id");
        fieldKeys.add("org.id");
        fieldKeys.add("sinsurstatus");
        fieldKeys.add("number");
        fieldKeys.add("person");
        fieldKeys.add("personindexid");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new SinsurPersonCertValidator());
        args.addValidator((AbstractValidator)new SinsurFileAbandonValidator());
        args.addValidator((AbstractValidator)new SinsurFileSinSurBaseValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        Object[] selectedRows = args.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])selectedRows)) {
            return;
        }
        Map multiEntityPkIds = SinsurFileServiceHelper.getFileMultiEntityPkIds((EndOperationTransactionArgs)args);
        if (!multiEntityPkIds.isEmpty()) {
            for (Map.Entry entrySet : multiEntityPkIds.entrySet()) {
                SinsurFileServiceHelper.auditFileRelatedData((String)((String)entrySet.getKey()), (List)((List)entrySet.getValue()));
            }
        }
        List pIds = Arrays.stream(selectedRows).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        SinSurPersonCertCommonHelper.calPersonCertByPersonId(pIds);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        String showWarningTip = this.getOption().getVariableValue("showWarningTip", null);
        String preMsg = ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"SinsurFileAuditOp_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        DynamicObject[] dataEntities = args.getDataEntities();
        if (showWarningTip != null) {
            this.getOperationResult().setMessage(preMsg + showWarningTip + "sinsurfilecertwarn");
        } else if (dataEntities.length == 1) {
            this.getOperationResult().setMessage(preMsg);
        }
        this.getOperationResult().setShowMessage(true);
    }
}

