/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.opplugin.web.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.file.SinSurPersonCertCommonHelper;
import kd.sit.hcsi.opplugin.validator.file.SinsurFileAbandonValidator;
import kd.sit.hcsi.opplugin.validator.file.SinsurFileBsedValidator;
import kd.sit.hcsi.opplugin.validator.file.SinsurFileChangeStatusValidator;
import kd.sit.hcsi.opplugin.validator.file.SinsurFileSinSurBaseValidator;
import kd.sit.hcsi.opplugin.validator.file.SinsurPersonCertValidator;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.business.servicehelper.SITBaseDataHelper;

public class SinsurFileChangeSinsurStatusOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("bsed");
        fieldKeys.add("bsled");
        fieldKeys.add("sinsurstatus");
        fieldKeys.add("bsed");
        fieldKeys.add("comment");
        fieldKeys.add("person");
        fieldKeys.add("welfarepayer.org.id");
        fieldKeys.add("welfarepayer.country.id");
        fieldKeys.add("employee");
        fieldKeys.add("person");
        fieldKeys.add("sinsurstatus");
        fieldKeys.add("number");
        fieldKeys.add("personindexid");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new SinsurFileChangeStatusValidator());
        args.addValidator((AbstractValidator)new SinsurFileBsedValidator());
        args.addValidator((AbstractValidator)new SinsurPersonCertValidator());
        args.addValidator((AbstractValidator)new SinsurFileSinSurBaseValidator());
        args.addValidator((AbstractValidator)new SinsurFileAbandonValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        Object[] dataEntities = args.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        Date maxBsled = BaseDataHisHelper.getMaxBsled();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(dataEntities[0].getDataEntityType().getName());
        ArrayList<DynamicObject> newHisDys = new ArrayList<DynamicObject>(10);
        DynamicObject hisDyn = null;
        for (Object dynamicObject : dataEntities) {
            hisDyn = serviceHelper.generateEmptyDynamicObject();
            SITBaseDataHelper.transferDynamicObject((DynamicObject)dynamicObject, (DynamicObject)hisDyn, null, null);
            hisDyn.set("createtime", (Object)new Date());
            hisDyn.set("bsled", (Object)maxBsled);
            newHisDys.add(hisDyn);
        }
        HisResponse res = BaseDataHisHelper.saveTimeVersion((DynamicObject[])newHisDys.toArray(new DynamicObject[0]), (boolean)true);
    }

    public void endOperationTransaction(EndOperationTransactionArgs event) {
        super.endOperationTransaction(event);
        Object[] selectedRows = event.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])selectedRows)) {
            return;
        }
        List pIds = Arrays.stream(selectedRows).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        SinSurPersonCertCommonHelper.calPersonCertByPersonId(pIds);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        String showWarningTip = this.getOption().getVariableValue("showWarningTip", null);
        String preMsg = ResManager.loadKDString((String)"\u53d8\u66f4\u53c2\u4fdd\u72b6\u6001\u6210\u529f\u3002", (String)"SinsurFileChangeSinsurStatusOp_0", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        if (showWarningTip != null) {
            this.getOperationResult().setMessage(preMsg + showWarningTip);
        } else {
            this.getOperationResult().setMessage(preMsg);
        }
        this.getOperationResult().setShowMessage(true);
    }
}

