/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.opplugin.web.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.sit.hcsi.business.file.SinSurPersonCertCommonHelper;
import kd.sit.hcsi.business.file.SinsurFileServiceHelper;
import kd.sit.hcsi.opplugin.validator.file.SinsurFileDelValidator;

public class SinsurFileDelOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("status");
        fieldKeys.add("person");
        fieldKeys.add("number");
        fieldKeys.add("employee");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new SinsurFileDelValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        DynamicObject[] selectedRows = args.getDataEntities();
        if (selectedRows == null) {
            return;
        }
        ArrayList<Long> idDelList = new ArrayList<Long>();
        ArrayList<Long> idAbandonList = new ArrayList<Long>();
        ArrayList<Long> abandonPidList = new ArrayList<Long>();
        for (DynamicObject selectedRow : selectedRows) {
            if ("A".equals(selectedRow.getString("status"))) {
                idDelList.add(selectedRow.getLong("id"));
                continue;
            }
            if (!"C".equals(selectedRow.getString("status"))) continue;
            idAbandonList.add(selectedRow.getLong("id"));
            abandonPidList.add(selectedRow.getLong("person.id"));
        }
        if (!idDelList.isEmpty()) {
            SinsurFileServiceHelper.deleteFileAll(idDelList);
        }
        if (!idAbandonList.isEmpty()) {
            SinsurFileServiceHelper.abandonFile(idAbandonList);
            SinSurPersonCertCommonHelper.calPersonCertByPersonId(abandonPidList);
        }
        SinsurFileServiceHelper.recycleNumbers(new ArrayList<DynamicObject>(Arrays.asList(selectedRows)));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        String preMsg = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"SinsurFileDelOp_0", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        this.getOperationResult().setMessage(preMsg);
        this.getOperationResult().setShowMessage(true);
    }
}

