/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.mservice.calresult;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.hcsi.business.cal.errInfo.CalApiResultErrInfoEnum;
import kd.sit.hcsi.business.cal.service.SocialInsuranceCalService;
import kd.sit.hcsi.business.push.CalResultPushHelper;
import kd.sit.hcsi.business.sdk.KDSocInsuranceSdkHelper;
import kd.sit.hcsi.common.enums.SocialOperationEnum;
import kd.sit.hcsi.mservice.api.calresult.ICalResultService;
import kd.sit.sitbp.business.coderule.CodeRuleHelper;
import kd.sit.sitbp.common.util.SITStringUtils;

public class CalResultService
implements ICalResultService {
    private static final Log log = LogFactory.getLog(CalResultService.class);
    private static Pattern pattern = Pattern.compile("^\\d{4}-(0[1-9]|1[0-2])$");

    public List<Map<String, Object>> getCalPersonByIds(List<Long> ids) {
        return CalResultPushHelper.getCalPersonByIds(ids);
    }

    public void updateLog(String type, List<Long> list, Map<Long, String> map, Long logId) {
        CalResultPushHelper.updateLog((String)type, list, map, (Long)logId);
    }

    public Map<String, Object> getSocInsurancePersons(Map<String, Object> params) {
        try {
            Collection periodIds = (Collection)params.get("periodIds");
            Collection sinsurFileIds = (Collection)params.get("sinsurFileIds");
            String selectFields = (String)params.get("selectFields");
            ApiResult apiResult = KDSocInsuranceSdkHelper.getSocInsurancePersons((Collection)periodIds, (Collection)sinsurFileIds, (String)selectFields);
            return ApiResult.toMap((ApiResult)apiResult);
        }
        catch (Exception exception) {
            log.error("CalResultService.getSocInsurancePersons, error info is :", (Throwable)exception);
            ApiResult apiResult = ApiResult.ex((Throwable)exception);
            apiResult.setErrorCode(CalApiResultErrInfoEnum.SYSTEM_ERROR.getErrCode());
            return ApiResult.toMap((ApiResult)apiResult);
        }
    }

    public Map<String, Object> auditOrUnauditSinsurTask(Map<String, Object> params) {
        SocialOperationEnum socialOperationEnum;
        if (params == null) {
            HashMap<String, Object> result = new HashMap<String, Object>(16);
            result.put("success", Boolean.FALSE);
            result.put("message", "params is null");
            result.put("data", null);
            return result;
        }
        List sinSurTaskIds = (List)params.get("sinSurTaskIds");
        String operationKey = (String)params.get("operationKey");
        try {
            socialOperationEnum = SocialOperationEnum.valueOf((String)operationKey);
        }
        catch (Exception exception) {
            HashMap<String, Object> result = new HashMap<String, Object>(16);
            result.put("success", Boolean.FALSE);
            result.put("message", ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u8c03\u6574\u4e3aOP_AUDIT\u6216OP_UNAUDIT", (String)"SocialInsuranceCalService_18", (String)"sit-hcsi-business", (Object[])new Object[0]));
            result.put("data", null);
            return result;
        }
        if (SocialOperationEnum.OP_AUDIT != socialOperationEnum && SocialOperationEnum.OP_UNAUDIT != socialOperationEnum) {
            HashMap<String, Object> result = new HashMap<String, Object>(16);
            result.put("success", Boolean.FALSE);
            result.put("message", ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u8c03\u6574\u4e3aOP_AUDIT\u6216OP_UNAUDIT", (String)"SocialInsuranceCalService_18", (String)"sit-hcsi-business", (Object[])new Object[0]));
            result.put("data", null);
            return result;
        }
        SocialInsuranceCalService socialInsuranceCalService = new SocialInsuranceCalService();
        return socialInsuranceCalService.auditOrUnauditInSinsurTask(sinSurTaskIds, socialOperationEnum);
    }

    public Map<String, Object> updateSocInsurancePersonAndCal(Map<String, Object> params) {
        try {
            Long periodId = (Long)params.get("periodId");
            Collection insuredCompanyIds = (Collection)params.get("insuredCompanyIds");
            String calType = (String)params.get("calType");
            Map extendParams = (Map)params.get("extendParams");
            ApiResult apiResult = KDSocInsuranceSdkHelper.updateSocInsurancePersonAndCal((Long)periodId, (Collection)insuredCompanyIds, (String)calType, (Map)extendParams);
            return ApiResult.toMap((ApiResult)apiResult);
        }
        catch (Exception exception) {
            log.error("CalResultService.updateSocInsurancePersonAndCal, error info is :", (Throwable)exception);
            ApiResult apiResult = ApiResult.ex((Throwable)exception);
            apiResult.setErrorCode(CalApiResultErrInfoEnum.SYSTEM_ERROR.getErrCode());
            return ApiResult.toMap((ApiResult)apiResult);
        }
    }

    public Map<String, Object> pushSocInsuranceToSalary(Map<String, Object> params) {
        ApiResult apiResult;
        try {
            List socInsurancePersonIds = (List)params.get("socInsurancePersonIds");
            String pushType = (String)params.get("pushType");
            String entityNumber = (String)params.get("entityNumber");
            String withholdtype = (String)params.get("withholdtype");
            String withholddate = (String)params.get("withholddate");
            Collection<Object> collection = socInsurancePersonIds = socInsurancePersonIds == null ? Collections.emptyList() : (Collection)socInsurancePersonIds.stream().filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
            if (socInsurancePersonIds.size() > 10000) {
                ApiResult apiResult2 = ApiResult.fail((String)CalApiResultErrInfoEnum.PUSH_ID_OF_CAL_PERSON_MORE_THAN_10000.getErrInfo());
                apiResult2.setErrorCode(CalApiResultErrInfoEnum.PUSH_ID_OF_CAL_PERSON_MORE_THAN_10000.getErrCode());
                return ApiResult.toMap((ApiResult)apiResult2);
            }
            if (SITStringUtils.equals((String)"1", (String)pushType)) {
                if (SITStringUtils.isEmpty((String)withholddate)) {
                    ApiResult apiResult3 = ApiResult.fail((String)CalApiResultErrInfoEnum.WITHHOLDDATE_DATA_ERR.getErrInfo());
                    apiResult3.setErrorCode(CalApiResultErrInfoEnum.WITHHOLDDATE_DATA_ERR.getErrCode());
                    return ApiResult.toMap((ApiResult)apiResult3);
                }
                Matcher matcher = pattern.matcher(withholddate);
                if (!matcher.matches()) {
                    ApiResult apiResult4 = ApiResult.fail((String)CalApiResultErrInfoEnum.WITHHOLDDATE_DATA_ERR.getErrInfo());
                    apiResult4.setErrorCode(CalApiResultErrInfoEnum.WITHHOLDDATE_DATA_ERR.getErrCode());
                    return ApiResult.toMap((ApiResult)apiResult4);
                }
                if (!(SITStringUtils.equals((String)withholdtype, (String)"0") || SITStringUtils.equals((String)withholdtype, (String)"1") || SITStringUtils.equals((String)withholdtype, (String)"2"))) {
                    ApiResult apiResult5 = ApiResult.fail((String)CalApiResultErrInfoEnum.WITHHOLDTYPE_DATA_ERR.getErrInfo());
                    apiResult5.setErrorCode(CalApiResultErrInfoEnum.WITHHOLDTYPE_DATA_ERR.getErrCode());
                    return ApiResult.toMap((ApiResult)apiResult5);
                }
            }
            ArrayList couldPushPersonDys = new ArrayList(socInsurancePersonIds.size());
            apiResult = CalResultPushHelper.checkPushedCalPersonDys(socInsurancePersonIds, (String)pushType, couldPushPersonDys, (String)entityNumber);
            if (couldPushPersonDys.size() > 0) {
                List socInsuranceTaskIds = couldPushPersonDys.stream().map(couldPushPersonDy -> couldPushPersonDy.getLong("sinsurtask.id")).collect(Collectors.toList());
                KDSocInsuranceSdkHelper.pushSocInsuranceToSalary(socInsuranceTaskIds, (DynamicObject[])couldPushPersonDys.toArray(new DynamicObject[0]), (String)pushType, (String)entityNumber, (String)withholdtype, (String)withholddate);
            }
        }
        catch (Exception exception) {
            log.error("CalResultService.pushSocInsuranceToSalary, error info is :", (Throwable)exception);
            String codeRuleInfo = CodeRuleHelper.getCodeRuleExceptionInfo((Exception)exception);
            if (codeRuleInfo != null) {
                apiResult = ApiResult.fail((String)codeRuleInfo);
                apiResult.setErrorCode(CalApiResultErrInfoEnum.CODE_RULE_GEN_ERROR.getErrCode());
            }
            apiResult = ApiResult.ex((Throwable)exception);
            apiResult.setErrorCode(CalApiResultErrInfoEnum.SYSTEM_ERROR.getErrCode());
        }
        return ApiResult.toMap((ApiResult)apiResult);
    }
}

